package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RulesAlertBuilder extends RulesAlertFluentImpl<RulesAlertBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.monitoring.v1.RulesAlert,io.fabric8.openshift.api.model.monitoring.v1.RulesAlertBuilder>{
  public RulesAlertBuilder() {
    this(false);
  }
  public RulesAlertBuilder(Boolean validationEnabled) {
    this(new RulesAlert(), validationEnabled);
  }
  public RulesAlertBuilder(RulesAlertFluent<?> fluent) {
    this(fluent, false);
  }
  public RulesAlertBuilder(io.fabric8.openshift.api.model.monitoring.v1.RulesAlertFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new RulesAlert(), validationEnabled);
  }
  public RulesAlertBuilder(io.fabric8.openshift.api.model.monitoring.v1.RulesAlertFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.RulesAlert instance) {
    this(fluent, instance, false);
  }
  public RulesAlertBuilder(io.fabric8.openshift.api.model.monitoring.v1.RulesAlertFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.RulesAlert instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withForGracePeriod(instance.getForGracePeriod()); 
    fluent.withForOutageTolerance(instance.getForOutageTolerance()); 
    fluent.withResendDelay(instance.getResendDelay()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public RulesAlertBuilder(io.fabric8.openshift.api.model.monitoring.v1.RulesAlert instance) {
    this(instance,false);
  }
  public RulesAlertBuilder(io.fabric8.openshift.api.model.monitoring.v1.RulesAlert instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withForGracePeriod(instance.getForGracePeriod()); 
    this.withForOutageTolerance(instance.getForOutageTolerance()); 
    this.withResendDelay(instance.getResendDelay()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.monitoring.v1.RulesAlertFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.monitoring.v1.RulesAlert build() {
    RulesAlert buildable = new RulesAlert(fluent.getForGracePeriod(),fluent.getForOutageTolerance(),fluent.getResendDelay());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}