package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RuleBuilder extends RuleFluentImpl<RuleBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.monitoring.v1.Rule,RuleBuilder>{
  public RuleBuilder() {
    this(false);
  }
  public RuleBuilder(Boolean validationEnabled) {
    this(new Rule(), validationEnabled);
  }
  public RuleBuilder(io.fabric8.openshift.api.model.monitoring.v1.RuleFluent<?> fluent) {
    this(fluent, false);
  }
  public RuleBuilder(io.fabric8.openshift.api.model.monitoring.v1.RuleFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Rule(), validationEnabled);
  }
  public RuleBuilder(io.fabric8.openshift.api.model.monitoring.v1.RuleFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.Rule instance) {
    this(fluent, instance, false);
  }
  public RuleBuilder(io.fabric8.openshift.api.model.monitoring.v1.RuleFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.Rule instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAlert(instance.getAlert()); 
    fluent.withAnnotations(instance.getAnnotations()); 
    fluent.withExpr(instance.getExpr()); 
    fluent.withFor(instance.getFor()); 
    fluent.withLabels(instance.getLabels()); 
    fluent.withRecord(instance.getRecord()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public RuleBuilder(io.fabric8.openshift.api.model.monitoring.v1.Rule instance) {
    this(instance,false);
  }
  public RuleBuilder(io.fabric8.openshift.api.model.monitoring.v1.Rule instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAlert(instance.getAlert()); 
    this.withAnnotations(instance.getAnnotations()); 
    this.withExpr(instance.getExpr()); 
    this.withFor(instance.getFor()); 
    this.withLabels(instance.getLabels()); 
    this.withRecord(instance.getRecord()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.monitoring.v1.RuleFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.monitoring.v1.Rule build() {
    Rule buildable = new Rule(fluent.getAlert(),fluent.getAnnotations(),fluent.getExpr(),fluent.getFor(),fluent.getLabels(),fluent.getRecord());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}