package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RemoteReadSpecBuilder extends RemoteReadSpecFluentImpl<RemoteReadSpecBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.monitoring.v1.RemoteReadSpec,io.fabric8.openshift.api.model.monitoring.v1.RemoteReadSpecBuilder>{
  public RemoteReadSpecBuilder() {
    this(false);
  }
  public RemoteReadSpecBuilder(Boolean validationEnabled) {
    this(new RemoteReadSpec(), validationEnabled);
  }
  public RemoteReadSpecBuilder(RemoteReadSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public RemoteReadSpecBuilder(io.fabric8.openshift.api.model.monitoring.v1.RemoteReadSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new RemoteReadSpec(), validationEnabled);
  }
  public RemoteReadSpecBuilder(io.fabric8.openshift.api.model.monitoring.v1.RemoteReadSpecFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.RemoteReadSpec instance) {
    this(fluent, instance, false);
  }
  public RemoteReadSpecBuilder(io.fabric8.openshift.api.model.monitoring.v1.RemoteReadSpecFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.RemoteReadSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAuthorization(instance.getAuthorization()); 
    fluent.withBasicAuth(instance.getBasicAuth()); 
    fluent.withBearerToken(instance.getBearerToken()); 
    fluent.withBearerTokenFile(instance.getBearerTokenFile()); 
    fluent.withName(instance.getName()); 
    fluent.withOauth2(instance.getOauth2()); 
    fluent.withProxyUrl(instance.getProxyUrl()); 
    fluent.withReadRecent(instance.getReadRecent()); 
    fluent.withRemoteTimeout(instance.getRemoteTimeout()); 
    fluent.withRequiredMatchers(instance.getRequiredMatchers()); 
    fluent.withTlsConfig(instance.getTlsConfig()); 
    fluent.withUrl(instance.getUrl()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public RemoteReadSpecBuilder(io.fabric8.openshift.api.model.monitoring.v1.RemoteReadSpec instance) {
    this(instance,false);
  }
  public RemoteReadSpecBuilder(io.fabric8.openshift.api.model.monitoring.v1.RemoteReadSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAuthorization(instance.getAuthorization()); 
    this.withBasicAuth(instance.getBasicAuth()); 
    this.withBearerToken(instance.getBearerToken()); 
    this.withBearerTokenFile(instance.getBearerTokenFile()); 
    this.withName(instance.getName()); 
    this.withOauth2(instance.getOauth2()); 
    this.withProxyUrl(instance.getProxyUrl()); 
    this.withReadRecent(instance.getReadRecent()); 
    this.withRemoteTimeout(instance.getRemoteTimeout()); 
    this.withRequiredMatchers(instance.getRequiredMatchers()); 
    this.withTlsConfig(instance.getTlsConfig()); 
    this.withUrl(instance.getUrl()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.monitoring.v1.RemoteReadSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.monitoring.v1.RemoteReadSpec build() {
    RemoteReadSpec buildable = new RemoteReadSpec(fluent.getAuthorization(),fluent.getBasicAuth(),fluent.getBearerToken(),fluent.getBearerTokenFile(),fluent.getName(),fluent.getOauth2(),fluent.getProxyUrl(),fluent.getReadRecent(),fluent.getRemoteTimeout(),fluent.getRequiredMatchers(),fluent.getTlsConfig(),fluent.getUrl());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}