package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class QueueConfigBuilder extends QueueConfigFluentImpl<QueueConfigBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.monitoring.v1.QueueConfig,QueueConfigBuilder>{
  public QueueConfigBuilder() {
    this(false);
  }
  public QueueConfigBuilder(Boolean validationEnabled) {
    this(new QueueConfig(), validationEnabled);
  }
  public QueueConfigBuilder(io.fabric8.openshift.api.model.monitoring.v1.QueueConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public QueueConfigBuilder(io.fabric8.openshift.api.model.monitoring.v1.QueueConfigFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new QueueConfig(), validationEnabled);
  }
  public QueueConfigBuilder(io.fabric8.openshift.api.model.monitoring.v1.QueueConfigFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.QueueConfig instance) {
    this(fluent, instance, false);
  }
  public QueueConfigBuilder(io.fabric8.openshift.api.model.monitoring.v1.QueueConfigFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.QueueConfig instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withBatchSendDeadline(instance.getBatchSendDeadline()); 
    fluent.withCapacity(instance.getCapacity()); 
    fluent.withMaxBackoff(instance.getMaxBackoff()); 
    fluent.withMaxRetries(instance.getMaxRetries()); 
    fluent.withMaxSamplesPerSend(instance.getMaxSamplesPerSend()); 
    fluent.withMaxShards(instance.getMaxShards()); 
    fluent.withMinBackoff(instance.getMinBackoff()); 
    fluent.withMinShards(instance.getMinShards()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public QueueConfigBuilder(io.fabric8.openshift.api.model.monitoring.v1.QueueConfig instance) {
    this(instance,false);
  }
  public QueueConfigBuilder(io.fabric8.openshift.api.model.monitoring.v1.QueueConfig instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withBatchSendDeadline(instance.getBatchSendDeadline()); 
    this.withCapacity(instance.getCapacity()); 
    this.withMaxBackoff(instance.getMaxBackoff()); 
    this.withMaxRetries(instance.getMaxRetries()); 
    this.withMaxSamplesPerSend(instance.getMaxSamplesPerSend()); 
    this.withMaxShards(instance.getMaxShards()); 
    this.withMinBackoff(instance.getMinBackoff()); 
    this.withMinShards(instance.getMinShards()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.monitoring.v1.QueueConfigFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.monitoring.v1.QueueConfig build() {
    QueueConfig buildable = new QueueConfig(fluent.getBatchSendDeadline(),fluent.getCapacity(),fluent.getMaxBackoff(),fluent.getMaxRetries(),fluent.getMaxSamplesPerSend(),fluent.getMaxShards(),fluent.getMinBackoff(),fluent.getMinShards());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}