package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PrometheusStatusBuilder extends PrometheusStatusFluentImpl<PrometheusStatusBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.monitoring.v1.PrometheusStatus,io.fabric8.openshift.api.model.monitoring.v1.PrometheusStatusBuilder>{
  public PrometheusStatusBuilder() {
    this(false);
  }
  public PrometheusStatusBuilder(Boolean validationEnabled) {
    this(new PrometheusStatus(), validationEnabled);
  }
  public PrometheusStatusBuilder(PrometheusStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public PrometheusStatusBuilder(io.fabric8.openshift.api.model.monitoring.v1.PrometheusStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new PrometheusStatus(), validationEnabled);
  }
  public PrometheusStatusBuilder(io.fabric8.openshift.api.model.monitoring.v1.PrometheusStatusFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.PrometheusStatus instance) {
    this(fluent, instance, false);
  }
  public PrometheusStatusBuilder(io.fabric8.openshift.api.model.monitoring.v1.PrometheusStatusFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.PrometheusStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAvailableReplicas(instance.getAvailableReplicas()); 
    fluent.withPaused(instance.getPaused()); 
    fluent.withReplicas(instance.getReplicas()); 
    fluent.withUnavailableReplicas(instance.getUnavailableReplicas()); 
    fluent.withUpdatedReplicas(instance.getUpdatedReplicas()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PrometheusStatusBuilder(io.fabric8.openshift.api.model.monitoring.v1.PrometheusStatus instance) {
    this(instance,false);
  }
  public PrometheusStatusBuilder(io.fabric8.openshift.api.model.monitoring.v1.PrometheusStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAvailableReplicas(instance.getAvailableReplicas()); 
    this.withPaused(instance.getPaused()); 
    this.withReplicas(instance.getReplicas()); 
    this.withUnavailableReplicas(instance.getUnavailableReplicas()); 
    this.withUpdatedReplicas(instance.getUpdatedReplicas()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.monitoring.v1.PrometheusStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.monitoring.v1.PrometheusStatus build() {
    PrometheusStatus buildable = new PrometheusStatus(fluent.getAvailableReplicas(),fluent.getPaused(),fluent.getReplicas(),fluent.getUnavailableReplicas(),fluent.getUpdatedReplicas());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}