package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PrometheusBuilder extends PrometheusFluentImpl<PrometheusBuilder> implements VisitableBuilder<Prometheus,io.fabric8.openshift.api.model.monitoring.v1.PrometheusBuilder>{
  public PrometheusBuilder() {
    this(false);
  }
  public PrometheusBuilder(Boolean validationEnabled) {
    this(new Prometheus(), validationEnabled);
  }
  public PrometheusBuilder(PrometheusFluent<?> fluent) {
    this(fluent, false);
  }
  public PrometheusBuilder(io.fabric8.openshift.api.model.monitoring.v1.PrometheusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Prometheus(), validationEnabled);
  }
  public PrometheusBuilder(io.fabric8.openshift.api.model.monitoring.v1.PrometheusFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.Prometheus instance) {
    this(fluent, instance, false);
  }
  public PrometheusBuilder(io.fabric8.openshift.api.model.monitoring.v1.PrometheusFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.Prometheus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PrometheusBuilder(io.fabric8.openshift.api.model.monitoring.v1.Prometheus instance) {
    this(instance,false);
  }
  public PrometheusBuilder(io.fabric8.openshift.api.model.monitoring.v1.Prometheus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.monitoring.v1.PrometheusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.monitoring.v1.Prometheus build() {
    Prometheus buildable = new Prometheus(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}