package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ProbeTargetsBuilder extends ProbeTargetsFluentImpl<ProbeTargetsBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.monitoring.v1.ProbeTargets,ProbeTargetsBuilder>{
  public ProbeTargetsBuilder() {
    this(false);
  }
  public ProbeTargetsBuilder(Boolean validationEnabled) {
    this(new ProbeTargets(), validationEnabled);
  }
  public ProbeTargetsBuilder(io.fabric8.openshift.api.model.monitoring.v1.ProbeTargetsFluent<?> fluent) {
    this(fluent, false);
  }
  public ProbeTargetsBuilder(io.fabric8.openshift.api.model.monitoring.v1.ProbeTargetsFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ProbeTargets(), validationEnabled);
  }
  public ProbeTargetsBuilder(io.fabric8.openshift.api.model.monitoring.v1.ProbeTargetsFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.ProbeTargets instance) {
    this(fluent, instance, false);
  }
  public ProbeTargetsBuilder(io.fabric8.openshift.api.model.monitoring.v1.ProbeTargetsFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.ProbeTargets instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withIngress(instance.getIngress()); 
    fluent.withStaticConfig(instance.getStaticConfig()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ProbeTargetsBuilder(io.fabric8.openshift.api.model.monitoring.v1.ProbeTargets instance) {
    this(instance,false);
  }
  public ProbeTargetsBuilder(io.fabric8.openshift.api.model.monitoring.v1.ProbeTargets instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withIngress(instance.getIngress()); 
    this.withStaticConfig(instance.getStaticConfig()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.monitoring.v1.ProbeTargetsFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.monitoring.v1.ProbeTargets build() {
    ProbeTargets buildable = new ProbeTargets(fluent.getIngress(),fluent.getStaticConfig());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}