package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ProbeTargetIngressFluentImpl<A extends ProbeTargetIngressFluent<A>> extends BaseFluent<A> implements ProbeTargetIngressFluent<A>{
  public ProbeTargetIngressFluentImpl() {
  }
  public ProbeTargetIngressFluentImpl(io.fabric8.openshift.api.model.monitoring.v1.ProbeTargetIngress instance) {
    this.withNamespaceSelector(instance.getNamespaceSelector()); 
    this.withRelabelingConfigs(instance.getRelabelingConfigs()); 
    this.withSelector(instance.getSelector()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private NamespaceSelectorBuilder namespaceSelector;
  private ArrayList<RelabelConfigBuilder> relabelingConfigs = new java.util.ArrayList<RelabelConfigBuilder>();
  private LabelSelectorBuilder selector;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildNamespaceSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public io.fabric8.openshift.api.model.monitoring.v1.NamespaceSelector getNamespaceSelector() {
    return this.namespaceSelector!=null ?this.namespaceSelector.build():null;
  }
  public io.fabric8.openshift.api.model.monitoring.v1.NamespaceSelector buildNamespaceSelector() {
    return this.namespaceSelector!=null ?this.namespaceSelector.build():null;
  }
  public A withNamespaceSelector(io.fabric8.openshift.api.model.monitoring.v1.NamespaceSelector namespaceSelector) {
    _visitables.get("namespaceSelector").remove(this.namespaceSelector);
    if (namespaceSelector!=null){ this.namespaceSelector= new NamespaceSelectorBuilder(namespaceSelector); _visitables.get("namespaceSelector").add(this.namespaceSelector);} return (A) this;
  }
  public Boolean hasNamespaceSelector() {
    return this.namespaceSelector != null;
  }
  public ProbeTargetIngressFluent.NamespaceSelectorNested<A> withNewNamespaceSelector() {
    return new ProbeTargetIngressFluentImpl.NamespaceSelectorNestedImpl();
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ProbeTargetIngressFluent.NamespaceSelectorNested<A> withNewNamespaceSelectorLike(io.fabric8.openshift.api.model.monitoring.v1.NamespaceSelector item) {
    return new ProbeTargetIngressFluentImpl.NamespaceSelectorNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ProbeTargetIngressFluent.NamespaceSelectorNested<A> editNamespaceSelector() {
    return withNewNamespaceSelectorLike(getNamespaceSelector());
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ProbeTargetIngressFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelector() {
    return withNewNamespaceSelectorLike(getNamespaceSelector() != null ? getNamespaceSelector(): new io.fabric8.openshift.api.model.monitoring.v1.NamespaceSelectorBuilder().build());
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ProbeTargetIngressFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(io.fabric8.openshift.api.model.monitoring.v1.NamespaceSelector item) {
    return withNewNamespaceSelectorLike(getNamespaceSelector() != null ? getNamespaceSelector(): item);
  }
  public A addToRelabelingConfigs(Integer index,io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item) {
    if (this.relabelingConfigs == null) {this.relabelingConfigs = new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder>();}
    io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder(item);_visitables.get("relabelingConfigs").add(index >= 0 ? index : _visitables.get("relabelingConfigs").size(), builder);this.relabelingConfigs.add(index >= 0 ? index : relabelingConfigs.size(), builder); return (A)this;
  }
  public A setToRelabelingConfigs(java.lang.Integer index,io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item) {
    if (this.relabelingConfigs == null) {this.relabelingConfigs = new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder>();}
    io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder(item);
    if (index < 0 || index >= _visitables.get("relabelingConfigs").size()) { _visitables.get("relabelingConfigs").add(builder); } else { _visitables.get("relabelingConfigs").set(index, builder);}
    if (index < 0 || index >= relabelingConfigs.size()) { relabelingConfigs.add(builder); } else { relabelingConfigs.set(index, builder);}
     return (A)this;
  }
  public A addToRelabelingConfigs(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... items) {
    if (this.relabelingConfigs == null) {this.relabelingConfigs = new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder>();}
    for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item : items) {io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder(item);_visitables.get("relabelingConfigs").add(builder);this.relabelingConfigs.add(builder);} return (A)this;
  }
  public A addAllToRelabelingConfigs(Collection<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig> items) {
    if (this.relabelingConfigs == null) {this.relabelingConfigs = new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder>();}
    for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item : items) {io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder(item);_visitables.get("relabelingConfigs").add(builder);this.relabelingConfigs.add(builder);} return (A)this;
  }
  public A removeFromRelabelingConfigs(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... items) {
    for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item : items) {io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder(item);_visitables.get("relabelingConfigs").remove(builder);if (this.relabelingConfigs != null) {this.relabelingConfigs.remove(builder);}} return (A)this;
  }
  public A removeAllFromRelabelingConfigs(java.util.Collection<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig> items) {
    for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item : items) {io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder(item);_visitables.get("relabelingConfigs").remove(builder);if (this.relabelingConfigs != null) {this.relabelingConfigs.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromRelabelingConfigs(Predicate<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder> predicate) {
    if (relabelingConfigs == null) return (A) this;
    final Iterator<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder> each = relabelingConfigs.iterator();
    final List visitables = _visitables.get("relabelingConfigs");
    while (each.hasNext()) {
      io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildRelabelingConfigs instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public List<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig> getRelabelingConfigs() {
    return relabelingConfigs != null ? build(relabelingConfigs) : null;
  }
  public java.util.List<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig> buildRelabelingConfigs() {
    return relabelingConfigs != null ? build(relabelingConfigs) : null;
  }
  public io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig buildRelabelingConfig(java.lang.Integer index) {
    return this.relabelingConfigs.get(index).build();
  }
  public io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig buildFirstRelabelingConfig() {
    return this.relabelingConfigs.get(0).build();
  }
  public io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig buildLastRelabelingConfig() {
    return this.relabelingConfigs.get(relabelingConfigs.size() - 1).build();
  }
  public io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig buildMatchingRelabelingConfig(java.util.function.Predicate<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder> predicate) {
    for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder item: relabelingConfigs) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingRelabelingConfig(java.util.function.Predicate<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder> predicate) {
    for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder item: relabelingConfigs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRelabelingConfigs(java.util.List<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig> relabelingConfigs) {
    if (this.relabelingConfigs != null) { _visitables.get("relabelingConfigs").removeAll(this.relabelingConfigs);}
    if (relabelingConfigs != null) {this.relabelingConfigs = new java.util.ArrayList(); for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item : relabelingConfigs){this.addToRelabelingConfigs(item);}} else { this.relabelingConfigs = null;} return (A) this;
  }
  public A withRelabelingConfigs(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... relabelingConfigs) {
    if (this.relabelingConfigs != null) {this.relabelingConfigs.clear();}
    if (relabelingConfigs != null) {for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item :relabelingConfigs){ this.addToRelabelingConfigs(item);}} return (A) this;
  }
  public java.lang.Boolean hasRelabelingConfigs() {
    return relabelingConfigs != null && !relabelingConfigs.isEmpty();
  }
  public ProbeTargetIngressFluent.RelabelingConfigsNested<A> addNewRelabelingConfig() {
    return new ProbeTargetIngressFluentImpl.RelabelingConfigsNestedImpl();
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ProbeTargetIngressFluent.RelabelingConfigsNested<A> addNewRelabelingConfigLike(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item) {
    return new io.fabric8.openshift.api.model.monitoring.v1.ProbeTargetIngressFluentImpl.RelabelingConfigsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ProbeTargetIngressFluent.RelabelingConfigsNested<A> setNewRelabelingConfigLike(java.lang.Integer index,io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item) {
    return new io.fabric8.openshift.api.model.monitoring.v1.ProbeTargetIngressFluentImpl.RelabelingConfigsNestedImpl(index, item);
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ProbeTargetIngressFluent.RelabelingConfigsNested<A> editRelabelingConfig(java.lang.Integer index) {
    if (relabelingConfigs.size() <= index) throw new RuntimeException("Can't edit relabelingConfigs. Index exceeds size.");
    return setNewRelabelingConfigLike(index, buildRelabelingConfig(index));
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ProbeTargetIngressFluent.RelabelingConfigsNested<A> editFirstRelabelingConfig() {
    if (relabelingConfigs.size() == 0) throw new RuntimeException("Can't edit first relabelingConfigs. The list is empty.");
    return setNewRelabelingConfigLike(0, buildRelabelingConfig(0));
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ProbeTargetIngressFluent.RelabelingConfigsNested<A> editLastRelabelingConfig() {
    int index = relabelingConfigs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last relabelingConfigs. The list is empty.");
    return setNewRelabelingConfigLike(index, buildRelabelingConfig(index));
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ProbeTargetIngressFluent.RelabelingConfigsNested<A> editMatchingRelabelingConfig(java.util.function.Predicate<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<relabelingConfigs.size();i++) { 
    if (predicate.test(relabelingConfigs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching relabelingConfigs. No match found.");
    return setNewRelabelingConfigLike(index, buildRelabelingConfig(index));
  }
  
  /**
   * This method has been deprecated, please use method buildSelector instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public LabelSelector getSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public io.fabric8.kubernetes.api.model.LabelSelector buildSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public A withSelector(io.fabric8.kubernetes.api.model.LabelSelector selector) {
    _visitables.get("selector").remove(this.selector);
    if (selector!=null){ this.selector= new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(selector); _visitables.get("selector").add(this.selector);} return (A) this;
  }
  public java.lang.Boolean hasSelector() {
    return this.selector != null;
  }
  public ProbeTargetIngressFluent.SelectorNested<A> withNewSelector() {
    return new ProbeTargetIngressFluentImpl.SelectorNestedImpl();
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ProbeTargetIngressFluent.SelectorNested<A> withNewSelectorLike(io.fabric8.kubernetes.api.model.LabelSelector item) {
    return new io.fabric8.openshift.api.model.monitoring.v1.ProbeTargetIngressFluentImpl.SelectorNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ProbeTargetIngressFluent.SelectorNested<A> editSelector() {
    return withNewSelectorLike(getSelector());
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ProbeTargetIngressFluent.SelectorNested<A> editOrNewSelector() {
    return withNewSelectorLike(getSelector() != null ? getSelector(): new io.fabric8.kubernetes.api.model.LabelSelectorBuilder().build());
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ProbeTargetIngressFluent.SelectorNested<A> editOrNewSelectorLike(io.fabric8.kubernetes.api.model.LabelSelector item) {
    return withNewSelectorLike(getSelector() != null ? getSelector(): item);
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProbeTargetIngressFluentImpl that = (ProbeTargetIngressFluentImpl) o;
    if (namespaceSelector != null ? !namespaceSelector.equals(that.namespaceSelector) :that.namespaceSelector != null) return false;
    if (relabelingConfigs != null ? !relabelingConfigs.equals(that.relabelingConfigs) :that.relabelingConfigs != null) return false;
    if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(namespaceSelector,  relabelingConfigs,  selector,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (namespaceSelector != null) { sb.append("namespaceSelector:"); sb.append(namespaceSelector + ","); }
    if (relabelingConfigs != null && !relabelingConfigs.isEmpty()) { sb.append("relabelingConfigs:"); sb.append(relabelingConfigs + ","); }
    if (selector != null) { sb.append("selector:"); sb.append(selector + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class NamespaceSelectorNestedImpl<N> extends NamespaceSelectorFluentImpl<ProbeTargetIngressFluent.NamespaceSelectorNested<N>> implements io.fabric8.openshift.api.model.monitoring.v1.ProbeTargetIngressFluent.NamespaceSelectorNested<N>,Nested<N>{
    NamespaceSelectorNestedImpl(NamespaceSelector item) {
      this.builder = new NamespaceSelectorBuilder(this, item);
    }
    NamespaceSelectorNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.monitoring.v1.NamespaceSelectorBuilder(this);
    }
    io.fabric8.openshift.api.model.monitoring.v1.NamespaceSelectorBuilder builder;
    public N and() {
      return (N) ProbeTargetIngressFluentImpl.this.withNamespaceSelector(builder.build());
    }
    public N endNamespaceSelector() {
      return and();
    }
    
  }
  class RelabelingConfigsNestedImpl<N> extends RelabelConfigFluentImpl<ProbeTargetIngressFluent.RelabelingConfigsNested<N>> implements io.fabric8.openshift.api.model.monitoring.v1.ProbeTargetIngressFluent.RelabelingConfigsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    RelabelingConfigsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item) {
      this.index = index;
      this.builder = new RelabelConfigBuilder(this, item);
    }
    RelabelingConfigsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder(this);
    }
    io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) ProbeTargetIngressFluentImpl.this.setToRelabelingConfigs(index,builder.build());
    }
    public N endRelabelingConfig() {
      return and();
    }
    
  }
  class SelectorNestedImpl<N> extends LabelSelectorFluentImpl<ProbeTargetIngressFluent.SelectorNested<N>> implements io.fabric8.openshift.api.model.monitoring.v1.ProbeTargetIngressFluent.SelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    SelectorNestedImpl(io.fabric8.kubernetes.api.model.LabelSelector item) {
      this.builder = new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(this, item);
    }
    SelectorNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(this);
    }
    io.fabric8.kubernetes.api.model.LabelSelectorBuilder builder;
    public N and() {
      return (N) ProbeTargetIngressFluentImpl.this.withSelector(builder.build());
    }
    public N endSelector() {
      return and();
    }
    
  }
  
}