package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ProbeTargetIngressBuilder extends ProbeTargetIngressFluentImpl<ProbeTargetIngressBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.monitoring.v1.ProbeTargetIngress,ProbeTargetIngressBuilder>{
  public ProbeTargetIngressBuilder() {
    this(false);
  }
  public ProbeTargetIngressBuilder(Boolean validationEnabled) {
    this(new ProbeTargetIngress(), validationEnabled);
  }
  public ProbeTargetIngressBuilder(ProbeTargetIngressFluent<?> fluent) {
    this(fluent, false);
  }
  public ProbeTargetIngressBuilder(io.fabric8.openshift.api.model.monitoring.v1.ProbeTargetIngressFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ProbeTargetIngress(), validationEnabled);
  }
  public ProbeTargetIngressBuilder(io.fabric8.openshift.api.model.monitoring.v1.ProbeTargetIngressFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.ProbeTargetIngress instance) {
    this(fluent, instance, false);
  }
  public ProbeTargetIngressBuilder(io.fabric8.openshift.api.model.monitoring.v1.ProbeTargetIngressFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.ProbeTargetIngress instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withNamespaceSelector(instance.getNamespaceSelector()); 
    fluent.withRelabelingConfigs(instance.getRelabelingConfigs()); 
    fluent.withSelector(instance.getSelector()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ProbeTargetIngressBuilder(io.fabric8.openshift.api.model.monitoring.v1.ProbeTargetIngress instance) {
    this(instance,false);
  }
  public ProbeTargetIngressBuilder(io.fabric8.openshift.api.model.monitoring.v1.ProbeTargetIngress instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withNamespaceSelector(instance.getNamespaceSelector()); 
    this.withRelabelingConfigs(instance.getRelabelingConfigs()); 
    this.withSelector(instance.getSelector()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.monitoring.v1.ProbeTargetIngressFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.monitoring.v1.ProbeTargetIngress build() {
    ProbeTargetIngress buildable = new ProbeTargetIngress(fluent.getNamespaceSelector(),fluent.getRelabelingConfigs(),fluent.getSelector());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}