package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.lang.Deprecated;
import java.util.Iterator;
import java.lang.Integer;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ProbeSpecFluentImpl<A extends ProbeSpecFluent<A>> extends BaseFluent<A> implements ProbeSpecFluent<A>{
  public ProbeSpecFluentImpl() {
  }
  public ProbeSpecFluentImpl(io.fabric8.openshift.api.model.monitoring.v1.ProbeSpec instance) {
    this.withAuthorization(instance.getAuthorization()); 
    this.withBasicAuth(instance.getBasicAuth()); 
    this.withBearerTokenSecret(instance.getBearerTokenSecret()); 
    this.withInterval(instance.getInterval()); 
    this.withJobName(instance.getJobName()); 
    this.withLabelLimit(instance.getLabelLimit()); 
    this.withLabelNameLengthLimit(instance.getLabelNameLengthLimit()); 
    this.withLabelValueLengthLimit(instance.getLabelValueLengthLimit()); 
    this.withMetricRelabelings(instance.getMetricRelabelings()); 
    this.withModule(instance.getModule()); 
    this.withOauth2(instance.getOauth2()); 
    this.withProber(instance.getProber()); 
    this.withSampleLimit(instance.getSampleLimit()); 
    this.withScrapeTimeout(instance.getScrapeTimeout()); 
    this.withTargetLimit(instance.getTargetLimit()); 
    this.withTargets(instance.getTargets()); 
    this.withTlsConfig(instance.getTlsConfig()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private SafeAuthorizationBuilder authorization;
  private BasicAuthBuilder basicAuth;
  private SecretKeySelector bearerTokenSecret;
  private String interval;
  private java.lang.String jobName;
  private Long labelLimit;
  private java.lang.Long labelNameLengthLimit;
  private java.lang.Long labelValueLengthLimit;
  private ArrayList<RelabelConfigBuilder> metricRelabelings = new java.util.ArrayList<RelabelConfigBuilder>();
  private java.lang.String module;
  private OAuth2Builder oauth2;
  private ProberSpecBuilder prober;
  private java.lang.Long sampleLimit;
  private java.lang.String scrapeTimeout;
  private java.lang.Long targetLimit;
  private ProbeTargetsBuilder targets;
  private ProbeTLSConfigBuilder tlsConfig;
  private Map<java.lang.String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildAuthorization instead.
   * @return The buildable object.
   */
  @Deprecated
  public io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorization getAuthorization() {
    return this.authorization!=null ?this.authorization.build():null;
  }
  public io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorization buildAuthorization() {
    return this.authorization!=null ?this.authorization.build():null;
  }
  public A withAuthorization(io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorization authorization) {
    _visitables.get("authorization").remove(this.authorization);
    if (authorization!=null){ this.authorization= new SafeAuthorizationBuilder(authorization); _visitables.get("authorization").add(this.authorization);} return (A) this;
  }
  public Boolean hasAuthorization() {
    return this.authorization != null;
  }
  public ProbeSpecFluent.AuthorizationNested<A> withNewAuthorization() {
    return new ProbeSpecFluentImpl.AuthorizationNestedImpl();
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ProbeSpecFluent.AuthorizationNested<A> withNewAuthorizationLike(io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorization item) {
    return new ProbeSpecFluentImpl.AuthorizationNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ProbeSpecFluent.AuthorizationNested<A> editAuthorization() {
    return withNewAuthorizationLike(getAuthorization());
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ProbeSpecFluent.AuthorizationNested<A> editOrNewAuthorization() {
    return withNewAuthorizationLike(getAuthorization() != null ? getAuthorization(): new io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorizationBuilder().build());
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ProbeSpecFluent.AuthorizationNested<A> editOrNewAuthorizationLike(io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorization item) {
    return withNewAuthorizationLike(getAuthorization() != null ? getAuthorization(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildBasicAuth instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public BasicAuth getBasicAuth() {
    return this.basicAuth!=null ?this.basicAuth.build():null;
  }
  public io.fabric8.openshift.api.model.monitoring.v1.BasicAuth buildBasicAuth() {
    return this.basicAuth!=null ?this.basicAuth.build():null;
  }
  public A withBasicAuth(io.fabric8.openshift.api.model.monitoring.v1.BasicAuth basicAuth) {
    _visitables.get("basicAuth").remove(this.basicAuth);
    if (basicAuth!=null){ this.basicAuth= new io.fabric8.openshift.api.model.monitoring.v1.BasicAuthBuilder(basicAuth); _visitables.get("basicAuth").add(this.basicAuth);} return (A) this;
  }
  public java.lang.Boolean hasBasicAuth() {
    return this.basicAuth != null;
  }
  public ProbeSpecFluent.BasicAuthNested<A> withNewBasicAuth() {
    return new ProbeSpecFluentImpl.BasicAuthNestedImpl();
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ProbeSpecFluent.BasicAuthNested<A> withNewBasicAuthLike(io.fabric8.openshift.api.model.monitoring.v1.BasicAuth item) {
    return new io.fabric8.openshift.api.model.monitoring.v1.ProbeSpecFluentImpl.BasicAuthNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ProbeSpecFluent.BasicAuthNested<A> editBasicAuth() {
    return withNewBasicAuthLike(getBasicAuth());
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ProbeSpecFluent.BasicAuthNested<A> editOrNewBasicAuth() {
    return withNewBasicAuthLike(getBasicAuth() != null ? getBasicAuth(): new io.fabric8.openshift.api.model.monitoring.v1.BasicAuthBuilder().build());
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ProbeSpecFluent.BasicAuthNested<A> editOrNewBasicAuthLike(io.fabric8.openshift.api.model.monitoring.v1.BasicAuth item) {
    return withNewBasicAuthLike(getBasicAuth() != null ? getBasicAuth(): item);
  }
  public io.fabric8.kubernetes.api.model.SecretKeySelector getBearerTokenSecret() {
    return this.bearerTokenSecret;
  }
  public A withBearerTokenSecret(io.fabric8.kubernetes.api.model.SecretKeySelector bearerTokenSecret) {
    this.bearerTokenSecret=bearerTokenSecret; return (A) this;
  }
  public java.lang.Boolean hasBearerTokenSecret() {
    return this.bearerTokenSecret != null;
  }
  public A withNewBearerTokenSecret(java.lang.String key,java.lang.String name,java.lang.Boolean optional) {
    return (A)withBearerTokenSecret(new SecretKeySelector(key, name, optional));
  }
  public java.lang.String getInterval() {
    return this.interval;
  }
  public A withInterval(java.lang.String interval) {
    this.interval=interval; return (A) this;
  }
  public java.lang.Boolean hasInterval() {
    return this.interval != null;
  }
  public java.lang.String getJobName() {
    return this.jobName;
  }
  public A withJobName(java.lang.String jobName) {
    this.jobName=jobName; return (A) this;
  }
  public java.lang.Boolean hasJobName() {
    return this.jobName != null;
  }
  public java.lang.Long getLabelLimit() {
    return this.labelLimit;
  }
  public A withLabelLimit(java.lang.Long labelLimit) {
    this.labelLimit=labelLimit; return (A) this;
  }
  public java.lang.Boolean hasLabelLimit() {
    return this.labelLimit != null;
  }
  public java.lang.Long getLabelNameLengthLimit() {
    return this.labelNameLengthLimit;
  }
  public A withLabelNameLengthLimit(java.lang.Long labelNameLengthLimit) {
    this.labelNameLengthLimit=labelNameLengthLimit; return (A) this;
  }
  public java.lang.Boolean hasLabelNameLengthLimit() {
    return this.labelNameLengthLimit != null;
  }
  public java.lang.Long getLabelValueLengthLimit() {
    return this.labelValueLengthLimit;
  }
  public A withLabelValueLengthLimit(java.lang.Long labelValueLengthLimit) {
    this.labelValueLengthLimit=labelValueLengthLimit; return (A) this;
  }
  public java.lang.Boolean hasLabelValueLengthLimit() {
    return this.labelValueLengthLimit != null;
  }
  public A addToMetricRelabelings(Integer index,io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item) {
    if (this.metricRelabelings == null) {this.metricRelabelings = new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder>();}
    io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder(item);_visitables.get("metricRelabelings").add(index >= 0 ? index : _visitables.get("metricRelabelings").size(), builder);this.metricRelabelings.add(index >= 0 ? index : metricRelabelings.size(), builder); return (A)this;
  }
  public A setToMetricRelabelings(java.lang.Integer index,io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item) {
    if (this.metricRelabelings == null) {this.metricRelabelings = new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder>();}
    io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder(item);
    if (index < 0 || index >= _visitables.get("metricRelabelings").size()) { _visitables.get("metricRelabelings").add(builder); } else { _visitables.get("metricRelabelings").set(index, builder);}
    if (index < 0 || index >= metricRelabelings.size()) { metricRelabelings.add(builder); } else { metricRelabelings.set(index, builder);}
     return (A)this;
  }
  public A addToMetricRelabelings(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... items) {
    if (this.metricRelabelings == null) {this.metricRelabelings = new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder>();}
    for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item : items) {io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder(item);_visitables.get("metricRelabelings").add(builder);this.metricRelabelings.add(builder);} return (A)this;
  }
  public A addAllToMetricRelabelings(Collection<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig> items) {
    if (this.metricRelabelings == null) {this.metricRelabelings = new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder>();}
    for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item : items) {io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder(item);_visitables.get("metricRelabelings").add(builder);this.metricRelabelings.add(builder);} return (A)this;
  }
  public A removeFromMetricRelabelings(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... items) {
    for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item : items) {io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder(item);_visitables.get("metricRelabelings").remove(builder);if (this.metricRelabelings != null) {this.metricRelabelings.remove(builder);}} return (A)this;
  }
  public A removeAllFromMetricRelabelings(java.util.Collection<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig> items) {
    for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item : items) {io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder(item);_visitables.get("metricRelabelings").remove(builder);if (this.metricRelabelings != null) {this.metricRelabelings.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromMetricRelabelings(Predicate<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder> predicate) {
    if (metricRelabelings == null) return (A) this;
    final Iterator<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder> each = metricRelabelings.iterator();
    final List visitables = _visitables.get("metricRelabelings");
    while (each.hasNext()) {
      io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildMetricRelabelings instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public List<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig> getMetricRelabelings() {
    return metricRelabelings != null ? build(metricRelabelings) : null;
  }
  public java.util.List<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig> buildMetricRelabelings() {
    return metricRelabelings != null ? build(metricRelabelings) : null;
  }
  public io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig buildMetricRelabeling(java.lang.Integer index) {
    return this.metricRelabelings.get(index).build();
  }
  public io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig buildFirstMetricRelabeling() {
    return this.metricRelabelings.get(0).build();
  }
  public io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig buildLastMetricRelabeling() {
    return this.metricRelabelings.get(metricRelabelings.size() - 1).build();
  }
  public io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig buildMatchingMetricRelabeling(java.util.function.Predicate<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder> predicate) {
    for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder item: metricRelabelings) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingMetricRelabeling(java.util.function.Predicate<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder> predicate) {
    for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder item: metricRelabelings) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withMetricRelabelings(java.util.List<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig> metricRelabelings) {
    if (this.metricRelabelings != null) { _visitables.get("metricRelabelings").removeAll(this.metricRelabelings);}
    if (metricRelabelings != null) {this.metricRelabelings = new java.util.ArrayList(); for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item : metricRelabelings){this.addToMetricRelabelings(item);}} else { this.metricRelabelings = null;} return (A) this;
  }
  public A withMetricRelabelings(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... metricRelabelings) {
    if (this.metricRelabelings != null) {this.metricRelabelings.clear();}
    if (metricRelabelings != null) {for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item :metricRelabelings){ this.addToMetricRelabelings(item);}} return (A) this;
  }
  public java.lang.Boolean hasMetricRelabelings() {
    return metricRelabelings != null && !metricRelabelings.isEmpty();
  }
  public ProbeSpecFluent.MetricRelabelingsNested<A> addNewMetricRelabeling() {
    return new ProbeSpecFluentImpl.MetricRelabelingsNestedImpl();
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ProbeSpecFluent.MetricRelabelingsNested<A> addNewMetricRelabelingLike(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item) {
    return new io.fabric8.openshift.api.model.monitoring.v1.ProbeSpecFluentImpl.MetricRelabelingsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ProbeSpecFluent.MetricRelabelingsNested<A> setNewMetricRelabelingLike(java.lang.Integer index,io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item) {
    return new io.fabric8.openshift.api.model.monitoring.v1.ProbeSpecFluentImpl.MetricRelabelingsNestedImpl(index, item);
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ProbeSpecFluent.MetricRelabelingsNested<A> editMetricRelabeling(java.lang.Integer index) {
    if (metricRelabelings.size() <= index) throw new RuntimeException("Can't edit metricRelabelings. Index exceeds size.");
    return setNewMetricRelabelingLike(index, buildMetricRelabeling(index));
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ProbeSpecFluent.MetricRelabelingsNested<A> editFirstMetricRelabeling() {
    if (metricRelabelings.size() == 0) throw new RuntimeException("Can't edit first metricRelabelings. The list is empty.");
    return setNewMetricRelabelingLike(0, buildMetricRelabeling(0));
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ProbeSpecFluent.MetricRelabelingsNested<A> editLastMetricRelabeling() {
    int index = metricRelabelings.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last metricRelabelings. The list is empty.");
    return setNewMetricRelabelingLike(index, buildMetricRelabeling(index));
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ProbeSpecFluent.MetricRelabelingsNested<A> editMatchingMetricRelabeling(java.util.function.Predicate<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<metricRelabelings.size();i++) { 
    if (predicate.test(metricRelabelings.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching metricRelabelings. No match found.");
    return setNewMetricRelabelingLike(index, buildMetricRelabeling(index));
  }
  public java.lang.String getModule() {
    return this.module;
  }
  public A withModule(java.lang.String module) {
    this.module=module; return (A) this;
  }
  public java.lang.Boolean hasModule() {
    return this.module != null;
  }
  
  /**
   * This method has been deprecated, please use method buildOauth2 instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public OAuth2 getOauth2() {
    return this.oauth2!=null ?this.oauth2.build():null;
  }
  public io.fabric8.openshift.api.model.monitoring.v1.OAuth2 buildOauth2() {
    return this.oauth2!=null ?this.oauth2.build():null;
  }
  public A withOauth2(io.fabric8.openshift.api.model.monitoring.v1.OAuth2 oauth2) {
    _visitables.get("oauth2").remove(this.oauth2);
    if (oauth2!=null){ this.oauth2= new io.fabric8.openshift.api.model.monitoring.v1.OAuth2Builder(oauth2); _visitables.get("oauth2").add(this.oauth2);} return (A) this;
  }
  public java.lang.Boolean hasOauth2() {
    return this.oauth2 != null;
  }
  public ProbeSpecFluent.Oauth2Nested<A> withNewOauth2() {
    return new ProbeSpecFluentImpl.Oauth2NestedImpl();
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ProbeSpecFluent.Oauth2Nested<A> withNewOauth2Like(io.fabric8.openshift.api.model.monitoring.v1.OAuth2 item) {
    return new io.fabric8.openshift.api.model.monitoring.v1.ProbeSpecFluentImpl.Oauth2NestedImpl(item);
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ProbeSpecFluent.Oauth2Nested<A> editOauth2() {
    return withNewOauth2Like(getOauth2());
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ProbeSpecFluent.Oauth2Nested<A> editOrNewOauth2() {
    return withNewOauth2Like(getOauth2() != null ? getOauth2(): new io.fabric8.openshift.api.model.monitoring.v1.OAuth2Builder().build());
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ProbeSpecFluent.Oauth2Nested<A> editOrNewOauth2Like(io.fabric8.openshift.api.model.monitoring.v1.OAuth2 item) {
    return withNewOauth2Like(getOauth2() != null ? getOauth2(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildProber instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public ProberSpec getProber() {
    return this.prober!=null ?this.prober.build():null;
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ProberSpec buildProber() {
    return this.prober!=null ?this.prober.build():null;
  }
  public A withProber(io.fabric8.openshift.api.model.monitoring.v1.ProberSpec prober) {
    _visitables.get("prober").remove(this.prober);
    if (prober!=null){ this.prober= new io.fabric8.openshift.api.model.monitoring.v1.ProberSpecBuilder(prober); _visitables.get("prober").add(this.prober);} return (A) this;
  }
  public java.lang.Boolean hasProber() {
    return this.prober != null;
  }
  public A withNewProber(java.lang.String path,java.lang.String proxyUrl,java.lang.String scheme,java.lang.String url) {
    return (A)withProber(new ProberSpec(path, proxyUrl, scheme, url));
  }
  public ProbeSpecFluent.ProberNested<A> withNewProber() {
    return new ProbeSpecFluentImpl.ProberNestedImpl();
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ProbeSpecFluent.ProberNested<A> withNewProberLike(io.fabric8.openshift.api.model.monitoring.v1.ProberSpec item) {
    return new io.fabric8.openshift.api.model.monitoring.v1.ProbeSpecFluentImpl.ProberNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ProbeSpecFluent.ProberNested<A> editProber() {
    return withNewProberLike(getProber());
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ProbeSpecFluent.ProberNested<A> editOrNewProber() {
    return withNewProberLike(getProber() != null ? getProber(): new io.fabric8.openshift.api.model.monitoring.v1.ProberSpecBuilder().build());
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ProbeSpecFluent.ProberNested<A> editOrNewProberLike(io.fabric8.openshift.api.model.monitoring.v1.ProberSpec item) {
    return withNewProberLike(getProber() != null ? getProber(): item);
  }
  public java.lang.Long getSampleLimit() {
    return this.sampleLimit;
  }
  public A withSampleLimit(java.lang.Long sampleLimit) {
    this.sampleLimit=sampleLimit; return (A) this;
  }
  public java.lang.Boolean hasSampleLimit() {
    return this.sampleLimit != null;
  }
  public java.lang.String getScrapeTimeout() {
    return this.scrapeTimeout;
  }
  public A withScrapeTimeout(java.lang.String scrapeTimeout) {
    this.scrapeTimeout=scrapeTimeout; return (A) this;
  }
  public java.lang.Boolean hasScrapeTimeout() {
    return this.scrapeTimeout != null;
  }
  public java.lang.Long getTargetLimit() {
    return this.targetLimit;
  }
  public A withTargetLimit(java.lang.Long targetLimit) {
    this.targetLimit=targetLimit; return (A) this;
  }
  public java.lang.Boolean hasTargetLimit() {
    return this.targetLimit != null;
  }
  
  /**
   * This method has been deprecated, please use method buildTargets instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public ProbeTargets getTargets() {
    return this.targets!=null ?this.targets.build():null;
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ProbeTargets buildTargets() {
    return this.targets!=null ?this.targets.build():null;
  }
  public A withTargets(io.fabric8.openshift.api.model.monitoring.v1.ProbeTargets targets) {
    _visitables.get("targets").remove(this.targets);
    if (targets!=null){ this.targets= new io.fabric8.openshift.api.model.monitoring.v1.ProbeTargetsBuilder(targets); _visitables.get("targets").add(this.targets);} return (A) this;
  }
  public java.lang.Boolean hasTargets() {
    return this.targets != null;
  }
  public ProbeSpecFluent.TargetsNested<A> withNewTargets() {
    return new ProbeSpecFluentImpl.TargetsNestedImpl();
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ProbeSpecFluent.TargetsNested<A> withNewTargetsLike(io.fabric8.openshift.api.model.monitoring.v1.ProbeTargets item) {
    return new io.fabric8.openshift.api.model.monitoring.v1.ProbeSpecFluentImpl.TargetsNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ProbeSpecFluent.TargetsNested<A> editTargets() {
    return withNewTargetsLike(getTargets());
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ProbeSpecFluent.TargetsNested<A> editOrNewTargets() {
    return withNewTargetsLike(getTargets() != null ? getTargets(): new io.fabric8.openshift.api.model.monitoring.v1.ProbeTargetsBuilder().build());
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ProbeSpecFluent.TargetsNested<A> editOrNewTargetsLike(io.fabric8.openshift.api.model.monitoring.v1.ProbeTargets item) {
    return withNewTargetsLike(getTargets() != null ? getTargets(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildTlsConfig instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.openshift.api.model.monitoring.v1.ProbeTLSConfig getTlsConfig() {
    return this.tlsConfig!=null ?this.tlsConfig.build():null;
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ProbeTLSConfig buildTlsConfig() {
    return this.tlsConfig!=null ?this.tlsConfig.build():null;
  }
  public A withTlsConfig(io.fabric8.openshift.api.model.monitoring.v1.ProbeTLSConfig tlsConfig) {
    _visitables.get("tlsConfig").remove(this.tlsConfig);
    if (tlsConfig!=null){ this.tlsConfig= new ProbeTLSConfigBuilder(tlsConfig); _visitables.get("tlsConfig").add(this.tlsConfig);} return (A) this;
  }
  public java.lang.Boolean hasTlsConfig() {
    return this.tlsConfig != null;
  }
  public ProbeSpecFluent.TlsConfigNested<A> withNewTlsConfig() {
    return new ProbeSpecFluentImpl.TlsConfigNestedImpl();
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ProbeSpecFluent.TlsConfigNested<A> withNewTlsConfigLike(io.fabric8.openshift.api.model.monitoring.v1.ProbeTLSConfig item) {
    return new io.fabric8.openshift.api.model.monitoring.v1.ProbeSpecFluentImpl.TlsConfigNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ProbeSpecFluent.TlsConfigNested<A> editTlsConfig() {
    return withNewTlsConfigLike(getTlsConfig());
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ProbeSpecFluent.TlsConfigNested<A> editOrNewTlsConfig() {
    return withNewTlsConfigLike(getTlsConfig() != null ? getTlsConfig(): new io.fabric8.openshift.api.model.monitoring.v1.ProbeTLSConfigBuilder().build());
  }
  public io.fabric8.openshift.api.model.monitoring.v1.ProbeSpecFluent.TlsConfigNested<A> editOrNewTlsConfigLike(io.fabric8.openshift.api.model.monitoring.v1.ProbeTLSConfig item) {
    return withNewTlsConfigLike(getTlsConfig() != null ? getTlsConfig(): item);
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProbeSpecFluentImpl that = (ProbeSpecFluentImpl) o;
    if (authorization != null ? !authorization.equals(that.authorization) :that.authorization != null) return false;
    if (basicAuth != null ? !basicAuth.equals(that.basicAuth) :that.basicAuth != null) return false;
    if (bearerTokenSecret != null ? !bearerTokenSecret.equals(that.bearerTokenSecret) :that.bearerTokenSecret != null) return false;
    if (interval != null ? !interval.equals(that.interval) :that.interval != null) return false;
    if (jobName != null ? !jobName.equals(that.jobName) :that.jobName != null) return false;
    if (labelLimit != null ? !labelLimit.equals(that.labelLimit) :that.labelLimit != null) return false;
    if (labelNameLengthLimit != null ? !labelNameLengthLimit.equals(that.labelNameLengthLimit) :that.labelNameLengthLimit != null) return false;
    if (labelValueLengthLimit != null ? !labelValueLengthLimit.equals(that.labelValueLengthLimit) :that.labelValueLengthLimit != null) return false;
    if (metricRelabelings != null ? !metricRelabelings.equals(that.metricRelabelings) :that.metricRelabelings != null) return false;
    if (module != null ? !module.equals(that.module) :that.module != null) return false;
    if (oauth2 != null ? !oauth2.equals(that.oauth2) :that.oauth2 != null) return false;
    if (prober != null ? !prober.equals(that.prober) :that.prober != null) return false;
    if (sampleLimit != null ? !sampleLimit.equals(that.sampleLimit) :that.sampleLimit != null) return false;
    if (scrapeTimeout != null ? !scrapeTimeout.equals(that.scrapeTimeout) :that.scrapeTimeout != null) return false;
    if (targetLimit != null ? !targetLimit.equals(that.targetLimit) :that.targetLimit != null) return false;
    if (targets != null ? !targets.equals(that.targets) :that.targets != null) return false;
    if (tlsConfig != null ? !tlsConfig.equals(that.tlsConfig) :that.tlsConfig != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(authorization,  basicAuth,  bearerTokenSecret,  interval,  jobName,  labelLimit,  labelNameLengthLimit,  labelValueLengthLimit,  metricRelabelings,  module,  oauth2,  prober,  sampleLimit,  scrapeTimeout,  targetLimit,  targets,  tlsConfig,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (authorization != null) { sb.append("authorization:"); sb.append(authorization + ","); }
    if (basicAuth != null) { sb.append("basicAuth:"); sb.append(basicAuth + ","); }
    if (bearerTokenSecret != null) { sb.append("bearerTokenSecret:"); sb.append(bearerTokenSecret + ","); }
    if (interval != null) { sb.append("interval:"); sb.append(interval + ","); }
    if (jobName != null) { sb.append("jobName:"); sb.append(jobName + ","); }
    if (labelLimit != null) { sb.append("labelLimit:"); sb.append(labelLimit + ","); }
    if (labelNameLengthLimit != null) { sb.append("labelNameLengthLimit:"); sb.append(labelNameLengthLimit + ","); }
    if (labelValueLengthLimit != null) { sb.append("labelValueLengthLimit:"); sb.append(labelValueLengthLimit + ","); }
    if (metricRelabelings != null && !metricRelabelings.isEmpty()) { sb.append("metricRelabelings:"); sb.append(metricRelabelings + ","); }
    if (module != null) { sb.append("module:"); sb.append(module + ","); }
    if (oauth2 != null) { sb.append("oauth2:"); sb.append(oauth2 + ","); }
    if (prober != null) { sb.append("prober:"); sb.append(prober + ","); }
    if (sampleLimit != null) { sb.append("sampleLimit:"); sb.append(sampleLimit + ","); }
    if (scrapeTimeout != null) { sb.append("scrapeTimeout:"); sb.append(scrapeTimeout + ","); }
    if (targetLimit != null) { sb.append("targetLimit:"); sb.append(targetLimit + ","); }
    if (targets != null) { sb.append("targets:"); sb.append(targets + ","); }
    if (tlsConfig != null) { sb.append("tlsConfig:"); sb.append(tlsConfig + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class AuthorizationNestedImpl<N> extends SafeAuthorizationFluentImpl<ProbeSpecFluent.AuthorizationNested<N>> implements io.fabric8.openshift.api.model.monitoring.v1.ProbeSpecFluent.AuthorizationNested<N>,Nested<N>{
    AuthorizationNestedImpl(io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorization item) {
      this.builder = new SafeAuthorizationBuilder(this, item);
    }
    AuthorizationNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorizationBuilder(this);
    }
    io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorizationBuilder builder;
    public N and() {
      return (N) ProbeSpecFluentImpl.this.withAuthorization(builder.build());
    }
    public N endAuthorization() {
      return and();
    }
    
  }
  class BasicAuthNestedImpl<N> extends BasicAuthFluentImpl<ProbeSpecFluent.BasicAuthNested<N>> implements io.fabric8.openshift.api.model.monitoring.v1.ProbeSpecFluent.BasicAuthNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    BasicAuthNestedImpl(io.fabric8.openshift.api.model.monitoring.v1.BasicAuth item) {
      this.builder = new BasicAuthBuilder(this, item);
    }
    BasicAuthNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.monitoring.v1.BasicAuthBuilder(this);
    }
    io.fabric8.openshift.api.model.monitoring.v1.BasicAuthBuilder builder;
    public N and() {
      return (N) ProbeSpecFluentImpl.this.withBasicAuth(builder.build());
    }
    public N endBasicAuth() {
      return and();
    }
    
  }
  class MetricRelabelingsNestedImpl<N> extends RelabelConfigFluentImpl<ProbeSpecFluent.MetricRelabelingsNested<N>> implements io.fabric8.openshift.api.model.monitoring.v1.ProbeSpecFluent.MetricRelabelingsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    MetricRelabelingsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item) {
      this.index = index;
      this.builder = new RelabelConfigBuilder(this, item);
    }
    MetricRelabelingsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder(this);
    }
    io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) ProbeSpecFluentImpl.this.setToMetricRelabelings(index,builder.build());
    }
    public N endMetricRelabeling() {
      return and();
    }
    
  }
  class Oauth2NestedImpl<N> extends OAuth2FluentImpl<ProbeSpecFluent.Oauth2Nested<N>> implements io.fabric8.openshift.api.model.monitoring.v1.ProbeSpecFluent.Oauth2Nested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    Oauth2NestedImpl(io.fabric8.openshift.api.model.monitoring.v1.OAuth2 item) {
      this.builder = new OAuth2Builder(this, item);
    }
    Oauth2NestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.monitoring.v1.OAuth2Builder(this);
    }
    io.fabric8.openshift.api.model.monitoring.v1.OAuth2Builder builder;
    public N and() {
      return (N) ProbeSpecFluentImpl.this.withOauth2(builder.build());
    }
    public N endOauth2() {
      return and();
    }
    
  }
  class ProberNestedImpl<N> extends ProberSpecFluentImpl<ProbeSpecFluent.ProberNested<N>> implements io.fabric8.openshift.api.model.monitoring.v1.ProbeSpecFluent.ProberNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ProberNestedImpl(io.fabric8.openshift.api.model.monitoring.v1.ProberSpec item) {
      this.builder = new ProberSpecBuilder(this, item);
    }
    ProberNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.monitoring.v1.ProberSpecBuilder(this);
    }
    io.fabric8.openshift.api.model.monitoring.v1.ProberSpecBuilder builder;
    public N and() {
      return (N) ProbeSpecFluentImpl.this.withProber(builder.build());
    }
    public N endProber() {
      return and();
    }
    
  }
  class TargetsNestedImpl<N> extends ProbeTargetsFluentImpl<ProbeSpecFluent.TargetsNested<N>> implements io.fabric8.openshift.api.model.monitoring.v1.ProbeSpecFluent.TargetsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    TargetsNestedImpl(io.fabric8.openshift.api.model.monitoring.v1.ProbeTargets item) {
      this.builder = new ProbeTargetsBuilder(this, item);
    }
    TargetsNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.monitoring.v1.ProbeTargetsBuilder(this);
    }
    io.fabric8.openshift.api.model.monitoring.v1.ProbeTargetsBuilder builder;
    public N and() {
      return (N) ProbeSpecFluentImpl.this.withTargets(builder.build());
    }
    public N endTargets() {
      return and();
    }
    
  }
  class TlsConfigNestedImpl<N> extends ProbeTLSConfigFluentImpl<ProbeSpecFluent.TlsConfigNested<N>> implements io.fabric8.openshift.api.model.monitoring.v1.ProbeSpecFluent.TlsConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    TlsConfigNestedImpl(io.fabric8.openshift.api.model.monitoring.v1.ProbeTLSConfig item) {
      this.builder = new ProbeTLSConfigBuilder(this, item);
    }
    TlsConfigNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.monitoring.v1.ProbeTLSConfigBuilder(this);
    }
    io.fabric8.openshift.api.model.monitoring.v1.ProbeTLSConfigBuilder builder;
    public N and() {
      return (N) ProbeSpecFluentImpl.this.withTlsConfig(builder.build());
    }
    public N endTlsConfig() {
      return and();
    }
    
  }
  
}