package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ProbeListBuilder extends ProbeListFluentImpl<ProbeListBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.monitoring.v1.ProbeList,io.fabric8.openshift.api.model.monitoring.v1.ProbeListBuilder>{
  public ProbeListBuilder() {
    this(false);
  }
  public ProbeListBuilder(Boolean validationEnabled) {
    this(new ProbeList(), validationEnabled);
  }
  public ProbeListBuilder(ProbeListFluent<?> fluent) {
    this(fluent, false);
  }
  public ProbeListBuilder(io.fabric8.openshift.api.model.monitoring.v1.ProbeListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ProbeList(), validationEnabled);
  }
  public ProbeListBuilder(io.fabric8.openshift.api.model.monitoring.v1.ProbeListFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.ProbeList instance) {
    this(fluent, instance, false);
  }
  public ProbeListBuilder(io.fabric8.openshift.api.model.monitoring.v1.ProbeListFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.ProbeList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ProbeListBuilder(io.fabric8.openshift.api.model.monitoring.v1.ProbeList instance) {
    this(instance,false);
  }
  public ProbeListBuilder(io.fabric8.openshift.api.model.monitoring.v1.ProbeList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.monitoring.v1.ProbeListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.monitoring.v1.ProbeList build() {
    ProbeList buildable = new ProbeList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}