package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ProbeBuilder extends ProbeFluentImpl<ProbeBuilder> implements VisitableBuilder<Probe,io.fabric8.openshift.api.model.monitoring.v1.ProbeBuilder>{
  public ProbeBuilder() {
    this(false);
  }
  public ProbeBuilder(Boolean validationEnabled) {
    this(new Probe(), validationEnabled);
  }
  public ProbeBuilder(io.fabric8.openshift.api.model.monitoring.v1.ProbeFluent<?> fluent) {
    this(fluent, false);
  }
  public ProbeBuilder(io.fabric8.openshift.api.model.monitoring.v1.ProbeFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Probe(), validationEnabled);
  }
  public ProbeBuilder(io.fabric8.openshift.api.model.monitoring.v1.ProbeFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.Probe instance) {
    this(fluent, instance, false);
  }
  public ProbeBuilder(io.fabric8.openshift.api.model.monitoring.v1.ProbeFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.Probe instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ProbeBuilder(io.fabric8.openshift.api.model.monitoring.v1.Probe instance) {
    this(instance,false);
  }
  public ProbeBuilder(io.fabric8.openshift.api.model.monitoring.v1.Probe instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.monitoring.v1.ProbeFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.monitoring.v1.Probe build() {
    Probe buildable = new Probe(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}