package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodMonitorBuilder extends PodMonitorFluentImpl<PodMonitorBuilder> implements VisitableBuilder<PodMonitor,io.fabric8.openshift.api.model.monitoring.v1.PodMonitorBuilder>{
  public PodMonitorBuilder() {
    this(false);
  }
  public PodMonitorBuilder(Boolean validationEnabled) {
    this(new PodMonitor(), validationEnabled);
  }
  public PodMonitorBuilder(PodMonitorFluent<?> fluent) {
    this(fluent, false);
  }
  public PodMonitorBuilder(io.fabric8.openshift.api.model.monitoring.v1.PodMonitorFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new PodMonitor(), validationEnabled);
  }
  public PodMonitorBuilder(io.fabric8.openshift.api.model.monitoring.v1.PodMonitorFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.PodMonitor instance) {
    this(fluent, instance, false);
  }
  public PodMonitorBuilder(io.fabric8.openshift.api.model.monitoring.v1.PodMonitorFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.PodMonitor instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PodMonitorBuilder(io.fabric8.openshift.api.model.monitoring.v1.PodMonitor instance) {
    this(instance,false);
  }
  public PodMonitorBuilder(io.fabric8.openshift.api.model.monitoring.v1.PodMonitor instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.monitoring.v1.PodMonitorFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.monitoring.v1.PodMonitor build() {
    PodMonitor buildable = new PodMonitor(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}