package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import io.fabric8.kubernetes.api.model.IntOrString;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import java.lang.Deprecated;
import java.util.Iterator;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.IntOrStringFluentImpl;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PodMetricsEndpointFluentImpl<A extends PodMetricsEndpointFluent<A>> extends BaseFluent<A> implements PodMetricsEndpointFluent<A>{
  public PodMetricsEndpointFluentImpl() {
  }
  public PodMetricsEndpointFluentImpl(io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpoint instance) {
    this.withAuthorization(instance.getAuthorization()); 
    this.withBasicAuth(instance.getBasicAuth()); 
    this.withBearerTokenSecret(instance.getBearerTokenSecret()); 
    this.withHonorLabels(instance.getHonorLabels()); 
    this.withHonorTimestamps(instance.getHonorTimestamps()); 
    this.withInterval(instance.getInterval()); 
    this.withMetricRelabelings(instance.getMetricRelabelings()); 
    this.withOauth2(instance.getOauth2()); 
    this.withParams(instance.getParams()); 
    this.withPath(instance.getPath()); 
    this.withPort(instance.getPort()); 
    this.withProxyUrl(instance.getProxyUrl()); 
    this.withRelabelings(instance.getRelabelings()); 
    this.withScheme(instance.getScheme()); 
    this.withScrapeTimeout(instance.getScrapeTimeout()); 
    this.withTargetPort(instance.getTargetPort()); 
    this.withTlsConfig(instance.getTlsConfig()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private SafeAuthorizationBuilder authorization;
  private BasicAuthBuilder basicAuth;
  private SecretKeySelector bearerTokenSecret;
  private Boolean honorLabels;
  private java.lang.Boolean honorTimestamps;
  private String interval;
  private ArrayList<RelabelConfigBuilder> metricRelabelings = new java.util.ArrayList<RelabelConfigBuilder>();
  private OAuth2Builder oauth2;
  private Map<java.lang.String,java.util.ArrayList<java.lang.String>> params;
  private java.lang.String path;
  private java.lang.String port;
  private java.lang.String proxyUrl;
  private java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder> relabelings = new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder>();
  private java.lang.String scheme;
  private java.lang.String scrapeTimeout;
  private IntOrStringBuilder targetPort;
  private PodMetricsEndpointTLSConfigBuilder tlsConfig;
  private java.util.Map<java.lang.String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildAuthorization instead.
   * @return The buildable object.
   */
  @Deprecated
  public io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorization getAuthorization() {
    return this.authorization!=null ?this.authorization.build():null;
  }
  public io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorization buildAuthorization() {
    return this.authorization!=null ?this.authorization.build():null;
  }
  public A withAuthorization(io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorization authorization) {
    _visitables.get("authorization").remove(this.authorization);
    if (authorization!=null){ this.authorization= new SafeAuthorizationBuilder(authorization); _visitables.get("authorization").add(this.authorization);} return (A) this;
  }
  public java.lang.Boolean hasAuthorization() {
    return this.authorization != null;
  }
  public PodMetricsEndpointFluent.AuthorizationNested<A> withNewAuthorization() {
    return new PodMetricsEndpointFluentImpl.AuthorizationNestedImpl();
  }
  public io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.AuthorizationNested<A> withNewAuthorizationLike(io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorization item) {
    return new PodMetricsEndpointFluentImpl.AuthorizationNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.AuthorizationNested<A> editAuthorization() {
    return withNewAuthorizationLike(getAuthorization());
  }
  public io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.AuthorizationNested<A> editOrNewAuthorization() {
    return withNewAuthorizationLike(getAuthorization() != null ? getAuthorization(): new io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorizationBuilder().build());
  }
  public io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.AuthorizationNested<A> editOrNewAuthorizationLike(io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorization item) {
    return withNewAuthorizationLike(getAuthorization() != null ? getAuthorization(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildBasicAuth instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public BasicAuth getBasicAuth() {
    return this.basicAuth!=null ?this.basicAuth.build():null;
  }
  public io.fabric8.openshift.api.model.monitoring.v1.BasicAuth buildBasicAuth() {
    return this.basicAuth!=null ?this.basicAuth.build():null;
  }
  public A withBasicAuth(io.fabric8.openshift.api.model.monitoring.v1.BasicAuth basicAuth) {
    _visitables.get("basicAuth").remove(this.basicAuth);
    if (basicAuth!=null){ this.basicAuth= new io.fabric8.openshift.api.model.monitoring.v1.BasicAuthBuilder(basicAuth); _visitables.get("basicAuth").add(this.basicAuth);} return (A) this;
  }
  public java.lang.Boolean hasBasicAuth() {
    return this.basicAuth != null;
  }
  public PodMetricsEndpointFluent.BasicAuthNested<A> withNewBasicAuth() {
    return new PodMetricsEndpointFluentImpl.BasicAuthNestedImpl();
  }
  public io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.BasicAuthNested<A> withNewBasicAuthLike(io.fabric8.openshift.api.model.monitoring.v1.BasicAuth item) {
    return new io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluentImpl.BasicAuthNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.BasicAuthNested<A> editBasicAuth() {
    return withNewBasicAuthLike(getBasicAuth());
  }
  public io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.BasicAuthNested<A> editOrNewBasicAuth() {
    return withNewBasicAuthLike(getBasicAuth() != null ? getBasicAuth(): new io.fabric8.openshift.api.model.monitoring.v1.BasicAuthBuilder().build());
  }
  public io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.BasicAuthNested<A> editOrNewBasicAuthLike(io.fabric8.openshift.api.model.monitoring.v1.BasicAuth item) {
    return withNewBasicAuthLike(getBasicAuth() != null ? getBasicAuth(): item);
  }
  public io.fabric8.kubernetes.api.model.SecretKeySelector getBearerTokenSecret() {
    return this.bearerTokenSecret;
  }
  public A withBearerTokenSecret(io.fabric8.kubernetes.api.model.SecretKeySelector bearerTokenSecret) {
    this.bearerTokenSecret=bearerTokenSecret; return (A) this;
  }
  public java.lang.Boolean hasBearerTokenSecret() {
    return this.bearerTokenSecret != null;
  }
  public A withNewBearerTokenSecret(java.lang.String key,java.lang.String name,java.lang.Boolean optional) {
    return (A)withBearerTokenSecret(new SecretKeySelector(key, name, optional));
  }
  public java.lang.Boolean getHonorLabels() {
    return this.honorLabels;
  }
  public A withHonorLabels(java.lang.Boolean honorLabels) {
    this.honorLabels=honorLabels; return (A) this;
  }
  public java.lang.Boolean hasHonorLabels() {
    return this.honorLabels != null;
  }
  public java.lang.Boolean getHonorTimestamps() {
    return this.honorTimestamps;
  }
  public A withHonorTimestamps(java.lang.Boolean honorTimestamps) {
    this.honorTimestamps=honorTimestamps; return (A) this;
  }
  public java.lang.Boolean hasHonorTimestamps() {
    return this.honorTimestamps != null;
  }
  public java.lang.String getInterval() {
    return this.interval;
  }
  public A withInterval(java.lang.String interval) {
    this.interval=interval; return (A) this;
  }
  public java.lang.Boolean hasInterval() {
    return this.interval != null;
  }
  public A addToMetricRelabelings(Integer index,io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item) {
    if (this.metricRelabelings == null) {this.metricRelabelings = new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder>();}
    io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder(item);_visitables.get("metricRelabelings").add(index >= 0 ? index : _visitables.get("metricRelabelings").size(), builder);this.metricRelabelings.add(index >= 0 ? index : metricRelabelings.size(), builder); return (A)this;
  }
  public A setToMetricRelabelings(java.lang.Integer index,io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item) {
    if (this.metricRelabelings == null) {this.metricRelabelings = new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder>();}
    io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder(item);
    if (index < 0 || index >= _visitables.get("metricRelabelings").size()) { _visitables.get("metricRelabelings").add(builder); } else { _visitables.get("metricRelabelings").set(index, builder);}
    if (index < 0 || index >= metricRelabelings.size()) { metricRelabelings.add(builder); } else { metricRelabelings.set(index, builder);}
     return (A)this;
  }
  public A addToMetricRelabelings(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... items) {
    if (this.metricRelabelings == null) {this.metricRelabelings = new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder>();}
    for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item : items) {io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder(item);_visitables.get("metricRelabelings").add(builder);this.metricRelabelings.add(builder);} return (A)this;
  }
  public A addAllToMetricRelabelings(Collection<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig> items) {
    if (this.metricRelabelings == null) {this.metricRelabelings = new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder>();}
    for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item : items) {io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder(item);_visitables.get("metricRelabelings").add(builder);this.metricRelabelings.add(builder);} return (A)this;
  }
  public A removeFromMetricRelabelings(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... items) {
    for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item : items) {io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder(item);_visitables.get("metricRelabelings").remove(builder);if (this.metricRelabelings != null) {this.metricRelabelings.remove(builder);}} return (A)this;
  }
  public A removeAllFromMetricRelabelings(java.util.Collection<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig> items) {
    for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item : items) {io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder(item);_visitables.get("metricRelabelings").remove(builder);if (this.metricRelabelings != null) {this.metricRelabelings.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromMetricRelabelings(Predicate<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder> predicate) {
    if (metricRelabelings == null) return (A) this;
    final Iterator<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder> each = metricRelabelings.iterator();
    final List visitables = _visitables.get("metricRelabelings");
    while (each.hasNext()) {
      io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildMetricRelabelings instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public List<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig> getMetricRelabelings() {
    return metricRelabelings != null ? build(metricRelabelings) : null;
  }
  public java.util.List<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig> buildMetricRelabelings() {
    return metricRelabelings != null ? build(metricRelabelings) : null;
  }
  public io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig buildMetricRelabeling(java.lang.Integer index) {
    return this.metricRelabelings.get(index).build();
  }
  public io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig buildFirstMetricRelabeling() {
    return this.metricRelabelings.get(0).build();
  }
  public io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig buildLastMetricRelabeling() {
    return this.metricRelabelings.get(metricRelabelings.size() - 1).build();
  }
  public io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig buildMatchingMetricRelabeling(java.util.function.Predicate<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder> predicate) {
    for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder item: metricRelabelings) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingMetricRelabeling(java.util.function.Predicate<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder> predicate) {
    for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder item: metricRelabelings) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withMetricRelabelings(java.util.List<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig> metricRelabelings) {
    if (this.metricRelabelings != null) { _visitables.get("metricRelabelings").removeAll(this.metricRelabelings);}
    if (metricRelabelings != null) {this.metricRelabelings = new java.util.ArrayList(); for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item : metricRelabelings){this.addToMetricRelabelings(item);}} else { this.metricRelabelings = null;} return (A) this;
  }
  public A withMetricRelabelings(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... metricRelabelings) {
    if (this.metricRelabelings != null) {this.metricRelabelings.clear();}
    if (metricRelabelings != null) {for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item :metricRelabelings){ this.addToMetricRelabelings(item);}} return (A) this;
  }
  public java.lang.Boolean hasMetricRelabelings() {
    return metricRelabelings != null && !metricRelabelings.isEmpty();
  }
  public PodMetricsEndpointFluent.MetricRelabelingsNested<A> addNewMetricRelabeling() {
    return new PodMetricsEndpointFluentImpl.MetricRelabelingsNestedImpl();
  }
  public io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.MetricRelabelingsNested<A> addNewMetricRelabelingLike(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item) {
    return new io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluentImpl.MetricRelabelingsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.MetricRelabelingsNested<A> setNewMetricRelabelingLike(java.lang.Integer index,io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item) {
    return new io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluentImpl.MetricRelabelingsNestedImpl(index, item);
  }
  public io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.MetricRelabelingsNested<A> editMetricRelabeling(java.lang.Integer index) {
    if (metricRelabelings.size() <= index) throw new RuntimeException("Can't edit metricRelabelings. Index exceeds size.");
    return setNewMetricRelabelingLike(index, buildMetricRelabeling(index));
  }
  public io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.MetricRelabelingsNested<A> editFirstMetricRelabeling() {
    if (metricRelabelings.size() == 0) throw new RuntimeException("Can't edit first metricRelabelings. The list is empty.");
    return setNewMetricRelabelingLike(0, buildMetricRelabeling(0));
  }
  public io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.MetricRelabelingsNested<A> editLastMetricRelabeling() {
    int index = metricRelabelings.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last metricRelabelings. The list is empty.");
    return setNewMetricRelabelingLike(index, buildMetricRelabeling(index));
  }
  public io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.MetricRelabelingsNested<A> editMatchingMetricRelabeling(java.util.function.Predicate<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<metricRelabelings.size();i++) { 
    if (predicate.test(metricRelabelings.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching metricRelabelings. No match found.");
    return setNewMetricRelabelingLike(index, buildMetricRelabeling(index));
  }
  
  /**
   * This method has been deprecated, please use method buildOauth2 instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public OAuth2 getOauth2() {
    return this.oauth2!=null ?this.oauth2.build():null;
  }
  public io.fabric8.openshift.api.model.monitoring.v1.OAuth2 buildOauth2() {
    return this.oauth2!=null ?this.oauth2.build():null;
  }
  public A withOauth2(io.fabric8.openshift.api.model.monitoring.v1.OAuth2 oauth2) {
    _visitables.get("oauth2").remove(this.oauth2);
    if (oauth2!=null){ this.oauth2= new io.fabric8.openshift.api.model.monitoring.v1.OAuth2Builder(oauth2); _visitables.get("oauth2").add(this.oauth2);} return (A) this;
  }
  public java.lang.Boolean hasOauth2() {
    return this.oauth2 != null;
  }
  public PodMetricsEndpointFluent.Oauth2Nested<A> withNewOauth2() {
    return new PodMetricsEndpointFluentImpl.Oauth2NestedImpl();
  }
  public io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.Oauth2Nested<A> withNewOauth2Like(io.fabric8.openshift.api.model.monitoring.v1.OAuth2 item) {
    return new io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluentImpl.Oauth2NestedImpl(item);
  }
  public io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.Oauth2Nested<A> editOauth2() {
    return withNewOauth2Like(getOauth2());
  }
  public io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.Oauth2Nested<A> editOrNewOauth2() {
    return withNewOauth2Like(getOauth2() != null ? getOauth2(): new io.fabric8.openshift.api.model.monitoring.v1.OAuth2Builder().build());
  }
  public io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.Oauth2Nested<A> editOrNewOauth2Like(io.fabric8.openshift.api.model.monitoring.v1.OAuth2 item) {
    return withNewOauth2Like(getOauth2() != null ? getOauth2(): item);
  }
  public A addToParams(java.lang.String key,java.util.ArrayList<java.lang.String> value) {
    if(this.params == null && key != null && value != null) { this.params = new LinkedHashMap(); }
    if(key != null && value != null) {this.params.put(key, value);} return (A)this;
  }
  public A addToParams(java.util.Map<java.lang.String,java.util.ArrayList<java.lang.String>> map) {
    if(this.params == null && map != null) { this.params = new java.util.LinkedHashMap(); }
    if(map != null) { this.params.putAll(map);} return (A)this;
  }
  public A removeFromParams(java.lang.String key) {
    if(this.params == null) { return (A) this; }
    if(key != null && this.params != null) {this.params.remove(key);} return (A)this;
  }
  public A removeFromParams(java.util.Map<java.lang.String,java.util.ArrayList<java.lang.String>> map) {
    if(this.params == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.params != null){this.params.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.util.ArrayList<java.lang.String>> getParams() {
    return this.params;
  }
  public <K,V>A withParams(java.util.Map<java.lang.String,java.util.ArrayList<java.lang.String>> params) {
    if (params == null) { this.params =  null;} else {this.params = new java.util.LinkedHashMap(params);} return (A) this;
  }
  public java.lang.Boolean hasParams() {
    return this.params != null;
  }
  public java.lang.String getPath() {
    return this.path;
  }
  public A withPath(java.lang.String path) {
    this.path=path; return (A) this;
  }
  public java.lang.Boolean hasPath() {
    return this.path != null;
  }
  public java.lang.String getPort() {
    return this.port;
  }
  public A withPort(java.lang.String port) {
    this.port=port; return (A) this;
  }
  public java.lang.Boolean hasPort() {
    return this.port != null;
  }
  public java.lang.String getProxyUrl() {
    return this.proxyUrl;
  }
  public A withProxyUrl(java.lang.String proxyUrl) {
    this.proxyUrl=proxyUrl; return (A) this;
  }
  public java.lang.Boolean hasProxyUrl() {
    return this.proxyUrl != null;
  }
  public A addToRelabelings(java.lang.Integer index,io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item) {
    if (this.relabelings == null) {this.relabelings = new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder>();}
    io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder(item);_visitables.get("relabelings").add(index >= 0 ? index : _visitables.get("relabelings").size(), builder);this.relabelings.add(index >= 0 ? index : relabelings.size(), builder); return (A)this;
  }
  public A setToRelabelings(java.lang.Integer index,io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item) {
    if (this.relabelings == null) {this.relabelings = new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder>();}
    io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder(item);
    if (index < 0 || index >= _visitables.get("relabelings").size()) { _visitables.get("relabelings").add(builder); } else { _visitables.get("relabelings").set(index, builder);}
    if (index < 0 || index >= relabelings.size()) { relabelings.add(builder); } else { relabelings.set(index, builder);}
     return (A)this;
  }
  public A addToRelabelings(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... items) {
    if (this.relabelings == null) {this.relabelings = new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder>();}
    for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item : items) {io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder(item);_visitables.get("relabelings").add(builder);this.relabelings.add(builder);} return (A)this;
  }
  public A addAllToRelabelings(java.util.Collection<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig> items) {
    if (this.relabelings == null) {this.relabelings = new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder>();}
    for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item : items) {io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder(item);_visitables.get("relabelings").add(builder);this.relabelings.add(builder);} return (A)this;
  }
  public A removeFromRelabelings(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... items) {
    for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item : items) {io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder(item);_visitables.get("relabelings").remove(builder);if (this.relabelings != null) {this.relabelings.remove(builder);}} return (A)this;
  }
  public A removeAllFromRelabelings(java.util.Collection<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig> items) {
    for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item : items) {io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder(item);_visitables.get("relabelings").remove(builder);if (this.relabelings != null) {this.relabelings.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromRelabelings(java.util.function.Predicate<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder> predicate) {
    if (relabelings == null) return (A) this;
    final Iterator<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder> each = relabelings.iterator();
    final List visitables = _visitables.get("relabelings");
    while (each.hasNext()) {
      io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildRelabelings instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig> getRelabelings() {
    return relabelings != null ? build(relabelings) : null;
  }
  public java.util.List<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig> buildRelabelings() {
    return relabelings != null ? build(relabelings) : null;
  }
  public io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig buildRelabeling(java.lang.Integer index) {
    return this.relabelings.get(index).build();
  }
  public io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig buildFirstRelabeling() {
    return this.relabelings.get(0).build();
  }
  public io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig buildLastRelabeling() {
    return this.relabelings.get(relabelings.size() - 1).build();
  }
  public io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig buildMatchingRelabeling(java.util.function.Predicate<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder> predicate) {
    for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder item: relabelings) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingRelabeling(java.util.function.Predicate<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder> predicate) {
    for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder item: relabelings) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRelabelings(java.util.List<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig> relabelings) {
    if (this.relabelings != null) { _visitables.get("relabelings").removeAll(this.relabelings);}
    if (relabelings != null) {this.relabelings = new java.util.ArrayList(); for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item : relabelings){this.addToRelabelings(item);}} else { this.relabelings = null;} return (A) this;
  }
  public A withRelabelings(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... relabelings) {
    if (this.relabelings != null) {this.relabelings.clear();}
    if (relabelings != null) {for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item :relabelings){ this.addToRelabelings(item);}} return (A) this;
  }
  public java.lang.Boolean hasRelabelings() {
    return relabelings != null && !relabelings.isEmpty();
  }
  public PodMetricsEndpointFluent.RelabelingsNested<A> addNewRelabeling() {
    return new PodMetricsEndpointFluentImpl.RelabelingsNestedImpl();
  }
  public io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.RelabelingsNested<A> addNewRelabelingLike(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item) {
    return new io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluentImpl.RelabelingsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.RelabelingsNested<A> setNewRelabelingLike(java.lang.Integer index,io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item) {
    return new io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluentImpl.RelabelingsNestedImpl(index, item);
  }
  public io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.RelabelingsNested<A> editRelabeling(java.lang.Integer index) {
    if (relabelings.size() <= index) throw new RuntimeException("Can't edit relabelings. Index exceeds size.");
    return setNewRelabelingLike(index, buildRelabeling(index));
  }
  public io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.RelabelingsNested<A> editFirstRelabeling() {
    if (relabelings.size() == 0) throw new RuntimeException("Can't edit first relabelings. The list is empty.");
    return setNewRelabelingLike(0, buildRelabeling(0));
  }
  public io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.RelabelingsNested<A> editLastRelabeling() {
    int index = relabelings.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last relabelings. The list is empty.");
    return setNewRelabelingLike(index, buildRelabeling(index));
  }
  public io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.RelabelingsNested<A> editMatchingRelabeling(java.util.function.Predicate<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder> predicate) {
    int index = -1;
    for (int i=0;i<relabelings.size();i++) { 
    if (predicate.test(relabelings.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching relabelings. No match found.");
    return setNewRelabelingLike(index, buildRelabeling(index));
  }
  public java.lang.String getScheme() {
    return this.scheme;
  }
  public A withScheme(java.lang.String scheme) {
    this.scheme=scheme; return (A) this;
  }
  public java.lang.Boolean hasScheme() {
    return this.scheme != null;
  }
  public java.lang.String getScrapeTimeout() {
    return this.scrapeTimeout;
  }
  public A withScrapeTimeout(java.lang.String scrapeTimeout) {
    this.scrapeTimeout=scrapeTimeout; return (A) this;
  }
  public java.lang.Boolean hasScrapeTimeout() {
    return this.scrapeTimeout != null;
  }
  
  /**
   * This method has been deprecated, please use method buildTargetPort instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.IntOrString getTargetPort() {
    return this.targetPort!=null ?this.targetPort.build():null;
  }
  public io.fabric8.kubernetes.api.model.IntOrString buildTargetPort() {
    return this.targetPort!=null ?this.targetPort.build():null;
  }
  public A withTargetPort(io.fabric8.kubernetes.api.model.IntOrString targetPort) {
    _visitables.get("targetPort").remove(this.targetPort);
    if (targetPort!=null){ this.targetPort= new IntOrStringBuilder(targetPort); _visitables.get("targetPort").add(this.targetPort);} return (A) this;
  }
  public java.lang.Boolean hasTargetPort() {
    return this.targetPort != null;
  }
  public A withNewTargetPort(java.lang.Object value) {
    return (A)withTargetPort(new IntOrString(value));
  }
  public PodMetricsEndpointFluent.TargetPortNested<A> withNewTargetPort() {
    return new PodMetricsEndpointFluentImpl.TargetPortNestedImpl();
  }
  public io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.TargetPortNested<A> withNewTargetPortLike(io.fabric8.kubernetes.api.model.IntOrString item) {
    return new io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluentImpl.TargetPortNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.TargetPortNested<A> editTargetPort() {
    return withNewTargetPortLike(getTargetPort());
  }
  public io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.TargetPortNested<A> editOrNewTargetPort() {
    return withNewTargetPortLike(getTargetPort() != null ? getTargetPort(): new io.fabric8.kubernetes.api.model.IntOrStringBuilder().build());
  }
  public io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.TargetPortNested<A> editOrNewTargetPortLike(io.fabric8.kubernetes.api.model.IntOrString item) {
    return withNewTargetPortLike(getTargetPort() != null ? getTargetPort(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildTlsConfig instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointTLSConfig getTlsConfig() {
    return this.tlsConfig!=null ?this.tlsConfig.build():null;
  }
  public io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointTLSConfig buildTlsConfig() {
    return this.tlsConfig!=null ?this.tlsConfig.build():null;
  }
  public A withTlsConfig(io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointTLSConfig tlsConfig) {
    _visitables.get("tlsConfig").remove(this.tlsConfig);
    if (tlsConfig!=null){ this.tlsConfig= new PodMetricsEndpointTLSConfigBuilder(tlsConfig); _visitables.get("tlsConfig").add(this.tlsConfig);} return (A) this;
  }
  public java.lang.Boolean hasTlsConfig() {
    return this.tlsConfig != null;
  }
  public PodMetricsEndpointFluent.TlsConfigNested<A> withNewTlsConfig() {
    return new PodMetricsEndpointFluentImpl.TlsConfigNestedImpl();
  }
  public io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.TlsConfigNested<A> withNewTlsConfigLike(io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointTLSConfig item) {
    return new io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluentImpl.TlsConfigNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.TlsConfigNested<A> editTlsConfig() {
    return withNewTlsConfigLike(getTlsConfig());
  }
  public io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.TlsConfigNested<A> editOrNewTlsConfig() {
    return withNewTlsConfigLike(getTlsConfig() != null ? getTlsConfig(): new io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointTLSConfigBuilder().build());
  }
  public io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.TlsConfigNested<A> editOrNewTlsConfigLike(io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointTLSConfig item) {
    return withNewTlsConfigLike(getTlsConfig() != null ? getTlsConfig(): item);
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PodMetricsEndpointFluentImpl that = (PodMetricsEndpointFluentImpl) o;
    if (authorization != null ? !authorization.equals(that.authorization) :that.authorization != null) return false;
    if (basicAuth != null ? !basicAuth.equals(that.basicAuth) :that.basicAuth != null) return false;
    if (bearerTokenSecret != null ? !bearerTokenSecret.equals(that.bearerTokenSecret) :that.bearerTokenSecret != null) return false;
    if (honorLabels != null ? !honorLabels.equals(that.honorLabels) :that.honorLabels != null) return false;
    if (honorTimestamps != null ? !honorTimestamps.equals(that.honorTimestamps) :that.honorTimestamps != null) return false;
    if (interval != null ? !interval.equals(that.interval) :that.interval != null) return false;
    if (metricRelabelings != null ? !metricRelabelings.equals(that.metricRelabelings) :that.metricRelabelings != null) return false;
    if (oauth2 != null ? !oauth2.equals(that.oauth2) :that.oauth2 != null) return false;
    if (params != null ? !params.equals(that.params) :that.params != null) return false;
    if (path != null ? !path.equals(that.path) :that.path != null) return false;
    if (port != null ? !port.equals(that.port) :that.port != null) return false;
    if (proxyUrl != null ? !proxyUrl.equals(that.proxyUrl) :that.proxyUrl != null) return false;
    if (relabelings != null ? !relabelings.equals(that.relabelings) :that.relabelings != null) return false;
    if (scheme != null ? !scheme.equals(that.scheme) :that.scheme != null) return false;
    if (scrapeTimeout != null ? !scrapeTimeout.equals(that.scrapeTimeout) :that.scrapeTimeout != null) return false;
    if (targetPort != null ? !targetPort.equals(that.targetPort) :that.targetPort != null) return false;
    if (tlsConfig != null ? !tlsConfig.equals(that.tlsConfig) :that.tlsConfig != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(authorization,  basicAuth,  bearerTokenSecret,  honorLabels,  honorTimestamps,  interval,  metricRelabelings,  oauth2,  params,  path,  port,  proxyUrl,  relabelings,  scheme,  scrapeTimeout,  targetPort,  tlsConfig,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (authorization != null) { sb.append("authorization:"); sb.append(authorization + ","); }
    if (basicAuth != null) { sb.append("basicAuth:"); sb.append(basicAuth + ","); }
    if (bearerTokenSecret != null) { sb.append("bearerTokenSecret:"); sb.append(bearerTokenSecret + ","); }
    if (honorLabels != null) { sb.append("honorLabels:"); sb.append(honorLabels + ","); }
    if (honorTimestamps != null) { sb.append("honorTimestamps:"); sb.append(honorTimestamps + ","); }
    if (interval != null) { sb.append("interval:"); sb.append(interval + ","); }
    if (metricRelabelings != null && !metricRelabelings.isEmpty()) { sb.append("metricRelabelings:"); sb.append(metricRelabelings + ","); }
    if (oauth2 != null) { sb.append("oauth2:"); sb.append(oauth2 + ","); }
    if (params != null && !params.isEmpty()) { sb.append("params:"); sb.append(params + ","); }
    if (path != null) { sb.append("path:"); sb.append(path + ","); }
    if (port != null) { sb.append("port:"); sb.append(port + ","); }
    if (proxyUrl != null) { sb.append("proxyUrl:"); sb.append(proxyUrl + ","); }
    if (relabelings != null && !relabelings.isEmpty()) { sb.append("relabelings:"); sb.append(relabelings + ","); }
    if (scheme != null) { sb.append("scheme:"); sb.append(scheme + ","); }
    if (scrapeTimeout != null) { sb.append("scrapeTimeout:"); sb.append(scrapeTimeout + ","); }
    if (targetPort != null) { sb.append("targetPort:"); sb.append(targetPort + ","); }
    if (tlsConfig != null) { sb.append("tlsConfig:"); sb.append(tlsConfig + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withHonorLabels() {
    return withHonorLabels(true);
  }
  public A withHonorTimestamps() {
    return withHonorTimestamps(true);
  }
  class AuthorizationNestedImpl<N> extends SafeAuthorizationFluentImpl<PodMetricsEndpointFluent.AuthorizationNested<N>> implements io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.AuthorizationNested<N>,Nested<N>{
    AuthorizationNestedImpl(io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorization item) {
      this.builder = new SafeAuthorizationBuilder(this, item);
    }
    AuthorizationNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorizationBuilder(this);
    }
    io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorizationBuilder builder;
    public N and() {
      return (N) PodMetricsEndpointFluentImpl.this.withAuthorization(builder.build());
    }
    public N endAuthorization() {
      return and();
    }
    
  }
  class BasicAuthNestedImpl<N> extends BasicAuthFluentImpl<PodMetricsEndpointFluent.BasicAuthNested<N>> implements io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.BasicAuthNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    BasicAuthNestedImpl(io.fabric8.openshift.api.model.monitoring.v1.BasicAuth item) {
      this.builder = new BasicAuthBuilder(this, item);
    }
    BasicAuthNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.monitoring.v1.BasicAuthBuilder(this);
    }
    io.fabric8.openshift.api.model.monitoring.v1.BasicAuthBuilder builder;
    public N and() {
      return (N) PodMetricsEndpointFluentImpl.this.withBasicAuth(builder.build());
    }
    public N endBasicAuth() {
      return and();
    }
    
  }
  class MetricRelabelingsNestedImpl<N> extends RelabelConfigFluentImpl<PodMetricsEndpointFluent.MetricRelabelingsNested<N>> implements io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.MetricRelabelingsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    MetricRelabelingsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item) {
      this.index = index;
      this.builder = new RelabelConfigBuilder(this, item);
    }
    MetricRelabelingsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder(this);
    }
    io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) PodMetricsEndpointFluentImpl.this.setToMetricRelabelings(index,builder.build());
    }
    public N endMetricRelabeling() {
      return and();
    }
    
  }
  class Oauth2NestedImpl<N> extends OAuth2FluentImpl<PodMetricsEndpointFluent.Oauth2Nested<N>> implements io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.Oauth2Nested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    Oauth2NestedImpl(io.fabric8.openshift.api.model.monitoring.v1.OAuth2 item) {
      this.builder = new OAuth2Builder(this, item);
    }
    Oauth2NestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.monitoring.v1.OAuth2Builder(this);
    }
    io.fabric8.openshift.api.model.monitoring.v1.OAuth2Builder builder;
    public N and() {
      return (N) PodMetricsEndpointFluentImpl.this.withOauth2(builder.build());
    }
    public N endOauth2() {
      return and();
    }
    
  }
  class RelabelingsNestedImpl<N> extends RelabelConfigFluentImpl<PodMetricsEndpointFluent.RelabelingsNested<N>> implements io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.RelabelingsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    RelabelingsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item) {
      this.index = index;
      this.builder = new RelabelConfigBuilder(this, item);
    }
    RelabelingsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder(this);
    }
    io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) PodMetricsEndpointFluentImpl.this.setToRelabelings(index,builder.build());
    }
    public N endRelabeling() {
      return and();
    }
    
  }
  class TargetPortNestedImpl<N> extends IntOrStringFluentImpl<PodMetricsEndpointFluent.TargetPortNested<N>> implements io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.TargetPortNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    TargetPortNestedImpl(io.fabric8.kubernetes.api.model.IntOrString item) {
      this.builder = new io.fabric8.kubernetes.api.model.IntOrStringBuilder(this, item);
    }
    TargetPortNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.IntOrStringBuilder(this);
    }
    io.fabric8.kubernetes.api.model.IntOrStringBuilder builder;
    public N and() {
      return (N) PodMetricsEndpointFluentImpl.this.withTargetPort(builder.build());
    }
    public N endTargetPort() {
      return and();
    }
    
  }
  class TlsConfigNestedImpl<N> extends PodMetricsEndpointTLSConfigFluentImpl<PodMetricsEndpointFluent.TlsConfigNested<N>> implements io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.TlsConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    TlsConfigNestedImpl(io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointTLSConfig item) {
      this.builder = new PodMetricsEndpointTLSConfigBuilder(this, item);
    }
    TlsConfigNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointTLSConfigBuilder(this);
    }
    io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointTLSConfigBuilder builder;
    public N and() {
      return (N) PodMetricsEndpointFluentImpl.this.withTlsConfig(builder.build());
    }
    public N endTlsConfig() {
      return and();
    }
    
  }
  
}