package io.fabric8.openshift.api.model.monitoring.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class OAuth2FluentImpl<A extends OAuth2Fluent<A>> extends BaseFluent<A> implements OAuth2Fluent<A>{
  public OAuth2FluentImpl() {
  }
  public OAuth2FluentImpl(io.fabric8.openshift.api.model.monitoring.v1.OAuth2 instance) {
    this.withClientId(instance.getClientId()); 
    this.withClientSecret(instance.getClientSecret()); 
    this.withEndpointParams(instance.getEndpointParams()); 
    this.withScopes(instance.getScopes()); 
    this.withTokenUrl(instance.getTokenUrl()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private SecretOrConfigMapBuilder clientId;
  private SecretKeySelector clientSecret;
  private Map<String,java.lang.String> endpointParams;
  private List<java.lang.String> scopes = new ArrayList<java.lang.String>();
  private java.lang.String tokenUrl;
  private java.util.Map<java.lang.String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildClientId instead.
   * @return The buildable object.
   */
  @Deprecated
  public SecretOrConfigMap getClientId() {
    return this.clientId!=null ?this.clientId.build():null;
  }
  public io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMap buildClientId() {
    return this.clientId!=null ?this.clientId.build():null;
  }
  public A withClientId(io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMap clientId) {
    _visitables.get("clientId").remove(this.clientId);
    if (clientId!=null){ this.clientId= new io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMapBuilder(clientId); _visitables.get("clientId").add(this.clientId);} return (A) this;
  }
  public Boolean hasClientId() {
    return this.clientId != null;
  }
  public OAuth2Fluent.ClientIdNested<A> withNewClientId() {
    return new OAuth2FluentImpl.ClientIdNestedImpl();
  }
  public io.fabric8.openshift.api.model.monitoring.v1.OAuth2Fluent.ClientIdNested<A> withNewClientIdLike(io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMap item) {
    return new OAuth2FluentImpl.ClientIdNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.monitoring.v1.OAuth2Fluent.ClientIdNested<A> editClientId() {
    return withNewClientIdLike(getClientId());
  }
  public io.fabric8.openshift.api.model.monitoring.v1.OAuth2Fluent.ClientIdNested<A> editOrNewClientId() {
    return withNewClientIdLike(getClientId() != null ? getClientId(): new io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMapBuilder().build());
  }
  public io.fabric8.openshift.api.model.monitoring.v1.OAuth2Fluent.ClientIdNested<A> editOrNewClientIdLike(io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMap item) {
    return withNewClientIdLike(getClientId() != null ? getClientId(): item);
  }
  public io.fabric8.kubernetes.api.model.SecretKeySelector getClientSecret() {
    return this.clientSecret;
  }
  public A withClientSecret(io.fabric8.kubernetes.api.model.SecretKeySelector clientSecret) {
    this.clientSecret=clientSecret; return (A) this;
  }
  public java.lang.Boolean hasClientSecret() {
    return this.clientSecret != null;
  }
  public A withNewClientSecret(java.lang.String key,java.lang.String name,java.lang.Boolean optional) {
    return (A)withClientSecret(new SecretKeySelector(key, name, optional));
  }
  public A addToEndpointParams(java.lang.String key,java.lang.String value) {
    if(this.endpointParams == null && key != null && value != null) { this.endpointParams = new LinkedHashMap(); }
    if(key != null && value != null) {this.endpointParams.put(key, value);} return (A)this;
  }
  public A addToEndpointParams(java.util.Map<java.lang.String,java.lang.String> map) {
    if(this.endpointParams == null && map != null) { this.endpointParams = new java.util.LinkedHashMap(); }
    if(map != null) { this.endpointParams.putAll(map);} return (A)this;
  }
  public A removeFromEndpointParams(java.lang.String key) {
    if(this.endpointParams == null) { return (A) this; }
    if(key != null && this.endpointParams != null) {this.endpointParams.remove(key);} return (A)this;
  }
  public A removeFromEndpointParams(java.util.Map<java.lang.String,java.lang.String> map) {
    if(this.endpointParams == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.endpointParams != null){this.endpointParams.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.String> getEndpointParams() {
    return this.endpointParams;
  }
  public <K,V>A withEndpointParams(java.util.Map<java.lang.String,java.lang.String> endpointParams) {
    if (endpointParams == null) { this.endpointParams =  null;} else {this.endpointParams = new java.util.LinkedHashMap(endpointParams);} return (A) this;
  }
  public java.lang.Boolean hasEndpointParams() {
    return this.endpointParams != null;
  }
  public A addToScopes(Integer index,java.lang.String item) {
    if (this.scopes == null) {this.scopes = new java.util.ArrayList<java.lang.String>();}
    this.scopes.add(index, item);
    return (A)this;
  }
  public A setToScopes(java.lang.Integer index,java.lang.String item) {
    if (this.scopes == null) {this.scopes = new java.util.ArrayList<java.lang.String>();}
    this.scopes.set(index, item); return (A)this;
  }
  public A addToScopes(java.lang.String... items) {
    if (this.scopes == null) {this.scopes = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.scopes.add(item);} return (A)this;
  }
  public A addAllToScopes(Collection<java.lang.String> items) {
    if (this.scopes == null) {this.scopes = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.scopes.add(item);} return (A)this;
  }
  public A removeFromScopes(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.scopes!= null){ this.scopes.remove(item);}} return (A)this;
  }
  public A removeAllFromScopes(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.scopes!= null){ this.scopes.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getScopes() {
    return this.scopes;
  }
  public java.lang.String getScope(java.lang.Integer index) {
    return this.scopes.get(index);
  }
  public java.lang.String getFirstScope() {
    return this.scopes.get(0);
  }
  public java.lang.String getLastScope() {
    return this.scopes.get(scopes.size() - 1);
  }
  public java.lang.String getMatchingScope(Predicate<java.lang.String> predicate) {
    for (java.lang.String item: scopes) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingScope(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: scopes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withScopes(java.util.List<java.lang.String> scopes) {
    if (scopes != null) {this.scopes = new java.util.ArrayList(); for (java.lang.String item : scopes){this.addToScopes(item);}} else { this.scopes = null;} return (A) this;
  }
  public A withScopes(java.lang.String... scopes) {
    if (this.scopes != null) {this.scopes.clear();}
    if (scopes != null) {for (java.lang.String item :scopes){ this.addToScopes(item);}} return (A) this;
  }
  public java.lang.Boolean hasScopes() {
    return scopes != null && !scopes.isEmpty();
  }
  public java.lang.String getTokenUrl() {
    return this.tokenUrl;
  }
  public A withTokenUrl(java.lang.String tokenUrl) {
    this.tokenUrl=tokenUrl; return (A) this;
  }
  public java.lang.Boolean hasTokenUrl() {
    return this.tokenUrl != null;
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OAuth2FluentImpl that = (OAuth2FluentImpl) o;
    if (clientId != null ? !clientId.equals(that.clientId) :that.clientId != null) return false;
    if (clientSecret != null ? !clientSecret.equals(that.clientSecret) :that.clientSecret != null) return false;
    if (endpointParams != null ? !endpointParams.equals(that.endpointParams) :that.endpointParams != null) return false;
    if (scopes != null ? !scopes.equals(that.scopes) :that.scopes != null) return false;
    if (tokenUrl != null ? !tokenUrl.equals(that.tokenUrl) :that.tokenUrl != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(clientId,  clientSecret,  endpointParams,  scopes,  tokenUrl,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (clientId != null) { sb.append("clientId:"); sb.append(clientId + ","); }
    if (clientSecret != null) { sb.append("clientSecret:"); sb.append(clientSecret + ","); }
    if (endpointParams != null && !endpointParams.isEmpty()) { sb.append("endpointParams:"); sb.append(endpointParams + ","); }
    if (scopes != null && !scopes.isEmpty()) { sb.append("scopes:"); sb.append(scopes + ","); }
    if (tokenUrl != null) { sb.append("tokenUrl:"); sb.append(tokenUrl + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ClientIdNestedImpl<N> extends SecretOrConfigMapFluentImpl<OAuth2Fluent.ClientIdNested<N>> implements io.fabric8.openshift.api.model.monitoring.v1.OAuth2Fluent.ClientIdNested<N>,Nested<N>{
    ClientIdNestedImpl(io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMap item) {
      this.builder = new SecretOrConfigMapBuilder(this, item);
    }
    ClientIdNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMapBuilder(this);
    }
    io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMapBuilder builder;
    public N and() {
      return (N) OAuth2FluentImpl.this.withClientId(builder.build());
    }
    public N endClientId() {
      return and();
    }
    
  }
  
}