package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EndpointBuilder extends EndpointFluentImpl<EndpointBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.monitoring.v1.Endpoint,EndpointBuilder>{
  public EndpointBuilder() {
    this(false);
  }
  public EndpointBuilder(Boolean validationEnabled) {
    this(new Endpoint(), validationEnabled);
  }
  public EndpointBuilder(io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent<?> fluent) {
    this(fluent, false);
  }
  public EndpointBuilder(io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Endpoint(), validationEnabled);
  }
  public EndpointBuilder(io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.Endpoint instance) {
    this(fluent, instance, false);
  }
  public EndpointBuilder(io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.Endpoint instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAuthorization(instance.getAuthorization()); 
    fluent.withBasicAuth(instance.getBasicAuth()); 
    fluent.withBearerTokenFile(instance.getBearerTokenFile()); 
    fluent.withBearerTokenSecret(instance.getBearerTokenSecret()); 
    fluent.withHonorLabels(instance.getHonorLabels()); 
    fluent.withHonorTimestamps(instance.getHonorTimestamps()); 
    fluent.withInterval(instance.getInterval()); 
    fluent.withMetricRelabelings(instance.getMetricRelabelings()); 
    fluent.withOauth2(instance.getOauth2()); 
    fluent.withParams(instance.getParams()); 
    fluent.withPath(instance.getPath()); 
    fluent.withPort(instance.getPort()); 
    fluent.withProxyUrl(instance.getProxyUrl()); 
    fluent.withRelabelings(instance.getRelabelings()); 
    fluent.withScheme(instance.getScheme()); 
    fluent.withScrapeTimeout(instance.getScrapeTimeout()); 
    fluent.withTargetPort(instance.getTargetPort()); 
    fluent.withTlsConfig(instance.getTlsConfig()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public EndpointBuilder(io.fabric8.openshift.api.model.monitoring.v1.Endpoint instance) {
    this(instance,false);
  }
  public EndpointBuilder(io.fabric8.openshift.api.model.monitoring.v1.Endpoint instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAuthorization(instance.getAuthorization()); 
    this.withBasicAuth(instance.getBasicAuth()); 
    this.withBearerTokenFile(instance.getBearerTokenFile()); 
    this.withBearerTokenSecret(instance.getBearerTokenSecret()); 
    this.withHonorLabels(instance.getHonorLabels()); 
    this.withHonorTimestamps(instance.getHonorTimestamps()); 
    this.withInterval(instance.getInterval()); 
    this.withMetricRelabelings(instance.getMetricRelabelings()); 
    this.withOauth2(instance.getOauth2()); 
    this.withParams(instance.getParams()); 
    this.withPath(instance.getPath()); 
    this.withPort(instance.getPort()); 
    this.withProxyUrl(instance.getProxyUrl()); 
    this.withRelabelings(instance.getRelabelings()); 
    this.withScheme(instance.getScheme()); 
    this.withScrapeTimeout(instance.getScrapeTimeout()); 
    this.withTargetPort(instance.getTargetPort()); 
    this.withTlsConfig(instance.getTlsConfig()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.monitoring.v1.Endpoint build() {
    Endpoint buildable = new Endpoint(fluent.getAuthorization(),fluent.getBasicAuth(),fluent.getBearerTokenFile(),fluent.getBearerTokenSecret(),fluent.getHonorLabels(),fluent.getHonorTimestamps(),fluent.getInterval(),fluent.getMetricRelabelings(),fluent.getOauth2(),fluent.getParams(),fluent.getPath(),fluent.getPort(),fluent.getProxyUrl(),fluent.getRelabelings(),fluent.getScheme(),fluent.getScrapeTimeout(),fluent.getTargetPort(),fluent.getTlsConfig());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}