package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BasicAuthBuilder extends BasicAuthFluentImpl<BasicAuthBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.monitoring.v1.BasicAuth,io.fabric8.openshift.api.model.monitoring.v1.BasicAuthBuilder>{
  public BasicAuthBuilder() {
    this(false);
  }
  public BasicAuthBuilder(Boolean validationEnabled) {
    this(new BasicAuth(), validationEnabled);
  }
  public BasicAuthBuilder(BasicAuthFluent<?> fluent) {
    this(fluent, false);
  }
  public BasicAuthBuilder(io.fabric8.openshift.api.model.monitoring.v1.BasicAuthFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new BasicAuth(), validationEnabled);
  }
  public BasicAuthBuilder(io.fabric8.openshift.api.model.monitoring.v1.BasicAuthFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.BasicAuth instance) {
    this(fluent, instance, false);
  }
  public BasicAuthBuilder(io.fabric8.openshift.api.model.monitoring.v1.BasicAuthFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.BasicAuth instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withPassword(instance.getPassword()); 
    fluent.withUsername(instance.getUsername()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public BasicAuthBuilder(io.fabric8.openshift.api.model.monitoring.v1.BasicAuth instance) {
    this(instance,false);
  }
  public BasicAuthBuilder(io.fabric8.openshift.api.model.monitoring.v1.BasicAuth instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withPassword(instance.getPassword()); 
    this.withUsername(instance.getUsername()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.monitoring.v1.BasicAuthFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.monitoring.v1.BasicAuth build() {
    BasicAuth buildable = new BasicAuth(fluent.getPassword(),fluent.getUsername());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}