package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AuthorizationBuilder extends AuthorizationFluentImpl<AuthorizationBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.monitoring.v1.Authorization,io.fabric8.openshift.api.model.monitoring.v1.AuthorizationBuilder>{
  public AuthorizationBuilder() {
    this(false);
  }
  public AuthorizationBuilder(Boolean validationEnabled) {
    this(new Authorization(), validationEnabled);
  }
  public AuthorizationBuilder(AuthorizationFluent<?> fluent) {
    this(fluent, false);
  }
  public AuthorizationBuilder(io.fabric8.openshift.api.model.monitoring.v1.AuthorizationFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Authorization(), validationEnabled);
  }
  public AuthorizationBuilder(io.fabric8.openshift.api.model.monitoring.v1.AuthorizationFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.Authorization instance) {
    this(fluent, instance, false);
  }
  public AuthorizationBuilder(io.fabric8.openshift.api.model.monitoring.v1.AuthorizationFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.Authorization instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCredentials(instance.getCredentials()); 
    fluent.withCredentialsFile(instance.getCredentialsFile()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public AuthorizationBuilder(io.fabric8.openshift.api.model.monitoring.v1.Authorization instance) {
    this(instance,false);
  }
  public AuthorizationBuilder(io.fabric8.openshift.api.model.monitoring.v1.Authorization instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withCredentials(instance.getCredentials()); 
    this.withCredentialsFile(instance.getCredentialsFile()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.monitoring.v1.AuthorizationFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.monitoring.v1.Authorization build() {
    Authorization buildable = new Authorization(fluent.getCredentials(),fluent.getCredentialsFile(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}