package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AlertmanagerStatusBuilder extends AlertmanagerStatusFluentImpl<AlertmanagerStatusBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.monitoring.v1.AlertmanagerStatus,AlertmanagerStatusBuilder>{
  public AlertmanagerStatusBuilder() {
    this(false);
  }
  public AlertmanagerStatusBuilder(Boolean validationEnabled) {
    this(new AlertmanagerStatus(), validationEnabled);
  }
  public AlertmanagerStatusBuilder(io.fabric8.openshift.api.model.monitoring.v1.AlertmanagerStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public AlertmanagerStatusBuilder(io.fabric8.openshift.api.model.monitoring.v1.AlertmanagerStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new AlertmanagerStatus(), validationEnabled);
  }
  public AlertmanagerStatusBuilder(io.fabric8.openshift.api.model.monitoring.v1.AlertmanagerStatusFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.AlertmanagerStatus instance) {
    this(fluent, instance, false);
  }
  public AlertmanagerStatusBuilder(io.fabric8.openshift.api.model.monitoring.v1.AlertmanagerStatusFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.AlertmanagerStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAvailableReplicas(instance.getAvailableReplicas()); 
    fluent.withPaused(instance.getPaused()); 
    fluent.withReplicas(instance.getReplicas()); 
    fluent.withUnavailableReplicas(instance.getUnavailableReplicas()); 
    fluent.withUpdatedReplicas(instance.getUpdatedReplicas()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public AlertmanagerStatusBuilder(io.fabric8.openshift.api.model.monitoring.v1.AlertmanagerStatus instance) {
    this(instance,false);
  }
  public AlertmanagerStatusBuilder(io.fabric8.openshift.api.model.monitoring.v1.AlertmanagerStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAvailableReplicas(instance.getAvailableReplicas()); 
    this.withPaused(instance.getPaused()); 
    this.withReplicas(instance.getReplicas()); 
    this.withUnavailableReplicas(instance.getUnavailableReplicas()); 
    this.withUpdatedReplicas(instance.getUpdatedReplicas()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.monitoring.v1.AlertmanagerStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.monitoring.v1.AlertmanagerStatus build() {
    AlertmanagerStatus buildable = new AlertmanagerStatus(fluent.getAvailableReplicas(),fluent.getPaused(),fluent.getReplicas(),fluent.getUnavailableReplicas(),fluent.getUpdatedReplicas());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}