package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class ThanosRulerStatusBuilder extends io.fabric8.openshift.api.model.monitoring.v1.ThanosRulerStatusFluentImpl<io.fabric8.openshift.api.model.monitoring.v1.ThanosRulerStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.monitoring.v1.ThanosRulerStatus,io.fabric8.openshift.api.model.monitoring.v1.ThanosRulerStatusBuilder>{
  public ThanosRulerStatusBuilder() {
    this(false);
  }
  public ThanosRulerStatusBuilder(java.lang.Boolean validationEnabled) {
    this(new ThanosRulerStatus(), validationEnabled);
  }
  public ThanosRulerStatusBuilder(io.fabric8.openshift.api.model.monitoring.v1.ThanosRulerStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ThanosRulerStatusBuilder(io.fabric8.openshift.api.model.monitoring.v1.ThanosRulerStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ThanosRulerStatus(), validationEnabled);
  }
  public ThanosRulerStatusBuilder(io.fabric8.openshift.api.model.monitoring.v1.ThanosRulerStatusFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.ThanosRulerStatus instance) {
    this(fluent, instance, false);
  }
  public ThanosRulerStatusBuilder(io.fabric8.openshift.api.model.monitoring.v1.ThanosRulerStatusFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.ThanosRulerStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAvailableReplicas(instance.getAvailableReplicas()); 
    fluent.withPaused(instance.getPaused()); 
    fluent.withReplicas(instance.getReplicas()); 
    fluent.withUnavailableReplicas(instance.getUnavailableReplicas()); 
    fluent.withUpdatedReplicas(instance.getUpdatedReplicas()); 
    this.validationEnabled = validationEnabled; 
  }
  public ThanosRulerStatusBuilder(io.fabric8.openshift.api.model.monitoring.v1.ThanosRulerStatus instance) {
    this(instance,false);
  }
  public ThanosRulerStatusBuilder(io.fabric8.openshift.api.model.monitoring.v1.ThanosRulerStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAvailableReplicas(instance.getAvailableReplicas()); 
    this.withPaused(instance.getPaused()); 
    this.withReplicas(instance.getReplicas()); 
    this.withUnavailableReplicas(instance.getUnavailableReplicas()); 
    this.withUpdatedReplicas(instance.getUpdatedReplicas()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.monitoring.v1.ThanosRulerStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.monitoring.v1.ThanosRulerStatus build() {
    ThanosRulerStatus buildable = new ThanosRulerStatus(fluent.getAvailableReplicas(),fluent.getPaused(),fluent.getReplicas(),fluent.getUnavailableReplicas(),fluent.getUpdatedReplicas());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ThanosRulerStatusBuilder that = (ThanosRulerStatusBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}