package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class RuleBuilder extends io.fabric8.openshift.api.model.monitoring.v1.RuleFluentImpl<io.fabric8.openshift.api.model.monitoring.v1.RuleBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.monitoring.v1.Rule,io.fabric8.openshift.api.model.monitoring.v1.RuleBuilder>{
  public RuleBuilder() {
    this(false);
  }
  public RuleBuilder(java.lang.Boolean validationEnabled) {
    this(new Rule(), validationEnabled);
  }
  public RuleBuilder(io.fabric8.openshift.api.model.monitoring.v1.RuleFluent<?> fluent) {
    this(fluent, false);
  }
  public RuleBuilder(io.fabric8.openshift.api.model.monitoring.v1.RuleFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Rule(), validationEnabled);
  }
  public RuleBuilder(io.fabric8.openshift.api.model.monitoring.v1.RuleFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.Rule instance) {
    this(fluent, instance, false);
  }
  public RuleBuilder(io.fabric8.openshift.api.model.monitoring.v1.RuleFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.Rule instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAlert(instance.getAlert()); 
    fluent.withAnnotations(instance.getAnnotations()); 
    fluent.withExpr(instance.getExpr()); 
    fluent.withFor(instance.getFor()); 
    fluent.withLabels(instance.getLabels()); 
    fluent.withRecord(instance.getRecord()); 
    this.validationEnabled = validationEnabled; 
  }
  public RuleBuilder(io.fabric8.openshift.api.model.monitoring.v1.Rule instance) {
    this(instance,false);
  }
  public RuleBuilder(io.fabric8.openshift.api.model.monitoring.v1.Rule instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAlert(instance.getAlert()); 
    this.withAnnotations(instance.getAnnotations()); 
    this.withExpr(instance.getExpr()); 
    this.withFor(instance.getFor()); 
    this.withLabels(instance.getLabels()); 
    this.withRecord(instance.getRecord()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.monitoring.v1.RuleFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.monitoring.v1.Rule build() {
    Rule buildable = new Rule(fluent.getAlert(),fluent.getAnnotations(),fluent.getExpr(),fluent.getFor(),fluent.getLabels(),fluent.getRecord());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    RuleBuilder that = (RuleBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}