package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class EndpointBuilder extends io.fabric8.openshift.api.model.monitoring.v1.EndpointFluentImpl<io.fabric8.openshift.api.model.monitoring.v1.EndpointBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.monitoring.v1.Endpoint,io.fabric8.openshift.api.model.monitoring.v1.EndpointBuilder>{
  public EndpointBuilder() {
    this(false);
  }
  public EndpointBuilder(java.lang.Boolean validationEnabled) {
    this(new Endpoint(), validationEnabled);
  }
  public EndpointBuilder(io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent<?> fluent) {
    this(fluent, false);
  }
  public EndpointBuilder(io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Endpoint(), validationEnabled);
  }
  public EndpointBuilder(io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.Endpoint instance) {
    this(fluent, instance, false);
  }
  public EndpointBuilder(io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.Endpoint instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withBasicAuth(instance.getBasicAuth()); 
    fluent.withBearerTokenFile(instance.getBearerTokenFile()); 
    fluent.withBearerTokenSecret(instance.getBearerTokenSecret()); 
    fluent.withHonorLabels(instance.getHonorLabels()); 
    fluent.withHonorTimestamps(instance.getHonorTimestamps()); 
    fluent.withInterval(instance.getInterval()); 
    fluent.withMetricRelabelings(instance.getMetricRelabelings()); 
    fluent.withParams(instance.getParams()); 
    fluent.withPath(instance.getPath()); 
    fluent.withPort(instance.getPort()); 
    fluent.withProxyUrl(instance.getProxyUrl()); 
    fluent.withRelabelings(instance.getRelabelings()); 
    fluent.withScheme(instance.getScheme()); 
    fluent.withScrapeTimeout(instance.getScrapeTimeout()); 
    fluent.withTargetPort(instance.getTargetPort()); 
    fluent.withTlsConfig(instance.getTlsConfig()); 
    this.validationEnabled = validationEnabled; 
  }
  public EndpointBuilder(io.fabric8.openshift.api.model.monitoring.v1.Endpoint instance) {
    this(instance,false);
  }
  public EndpointBuilder(io.fabric8.openshift.api.model.monitoring.v1.Endpoint instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withBasicAuth(instance.getBasicAuth()); 
    this.withBearerTokenFile(instance.getBearerTokenFile()); 
    this.withBearerTokenSecret(instance.getBearerTokenSecret()); 
    this.withHonorLabels(instance.getHonorLabels()); 
    this.withHonorTimestamps(instance.getHonorTimestamps()); 
    this.withInterval(instance.getInterval()); 
    this.withMetricRelabelings(instance.getMetricRelabelings()); 
    this.withParams(instance.getParams()); 
    this.withPath(instance.getPath()); 
    this.withPort(instance.getPort()); 
    this.withProxyUrl(instance.getProxyUrl()); 
    this.withRelabelings(instance.getRelabelings()); 
    this.withScheme(instance.getScheme()); 
    this.withScrapeTimeout(instance.getScrapeTimeout()); 
    this.withTargetPort(instance.getTargetPort()); 
    this.withTlsConfig(instance.getTlsConfig()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.monitoring.v1.EndpointFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.monitoring.v1.Endpoint build() {
    Endpoint buildable = new Endpoint(fluent.getBasicAuth(),fluent.getBearerTokenFile(),fluent.getBearerTokenSecret(),fluent.getHonorLabels(),fluent.getHonorTimestamps(),fluent.getInterval(),fluent.getMetricRelabelings(),fluent.getParams(),fluent.getPath(),fluent.getPort(),fluent.getProxyUrl(),fluent.getRelabelings(),fluent.getScheme(),fluent.getScrapeTimeout(),fluent.getTargetPort(),fluent.getTlsConfig());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    EndpointBuilder that = (EndpointBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}