package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TLSConfigBuilder extends io.fabric8.openshift.api.model.monitoring.v1.TLSConfigFluentImpl<io.fabric8.openshift.api.model.monitoring.v1.TLSConfigBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.monitoring.v1.TLSConfig,io.fabric8.openshift.api.model.monitoring.v1.TLSConfigBuilder> {

    io.fabric8.openshift.api.model.monitoring.v1.TLSConfigFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public TLSConfigBuilder() {
        this(true);
    }

    public TLSConfigBuilder(java.lang.Boolean validationEnabled) {
        this(new TLSConfig(), validationEnabled);
    }

    public TLSConfigBuilder(io.fabric8.openshift.api.model.monitoring.v1.TLSConfigFluent<?> fluent) {
        this(fluent, true);
    }

    public TLSConfigBuilder(io.fabric8.openshift.api.model.monitoring.v1.TLSConfigFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new TLSConfig(), validationEnabled);
    }

    public TLSConfigBuilder(io.fabric8.openshift.api.model.monitoring.v1.TLSConfigFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.TLSConfig instance) {
        this(fluent, instance, true);
    }

    public TLSConfigBuilder(io.fabric8.openshift.api.model.monitoring.v1.TLSConfigFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.TLSConfig instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withCa(instance.getCa()); 
        fluent.withCaFile(instance.getCaFile()); 
        fluent.withCert(instance.getCert()); 
        fluent.withCertFile(instance.getCertFile()); 
        fluent.withInsecureSkipVerify(instance.getInsecureSkipVerify()); 
        fluent.withKeyFile(instance.getKeyFile()); 
        fluent.withKeySecret(instance.getKeySecret()); 
        fluent.withServerName(instance.getServerName()); 
        this.validationEnabled = validationEnabled; 
    }

    public TLSConfigBuilder(io.fabric8.openshift.api.model.monitoring.v1.TLSConfig instance) {
        this(instance,true);
    }

    public TLSConfigBuilder(io.fabric8.openshift.api.model.monitoring.v1.TLSConfig instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withCa(instance.getCa()); 
        this.withCaFile(instance.getCaFile()); 
        this.withCert(instance.getCert()); 
        this.withCertFile(instance.getCertFile()); 
        this.withInsecureSkipVerify(instance.getInsecureSkipVerify()); 
        this.withKeyFile(instance.getKeyFile()); 
        this.withKeySecret(instance.getKeySecret()); 
        this.withServerName(instance.getServerName()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.monitoring.v1.TLSConfig build() {
        TLSConfig buildable = new TLSConfig(fluent.getCa(),fluent.getCaFile(),fluent.getCert(),fluent.getCertFile(),fluent.getInsecureSkipVerify(),fluent.getKeyFile(),fluent.getKeySecret(),fluent.getServerName());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        TLSConfigBuilder that = (TLSConfigBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
