package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class RuleGroupFluentImpl<A extends io.fabric8.openshift.api.model.monitoring.v1.RuleGroupFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.monitoring.v1.RuleGroupFluent<A> {

    private java.lang.String interval;
    private java.lang.String name;
    private java.lang.String partialResponseStrategy;
    private java.util.List<io.fabric8.openshift.api.model.monitoring.v1.RuleBuilder> rules =  new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1.RuleBuilder>();

    public RuleGroupFluentImpl() {
    }

    public RuleGroupFluentImpl(io.fabric8.openshift.api.model.monitoring.v1.RuleGroup instance) {
        this.withInterval(instance.getInterval()); 
        this.withName(instance.getName()); 
        this.withPartialResponseStrategy(instance.getPartialResponseStrategy()); 
        this.withRules(instance.getRules()); 
    }

    public java.lang.String getInterval() {
        return this.interval;
    }

    public A withInterval(java.lang.String interval) {
        this.interval=interval; return (A) this;
    }

    public java.lang.Boolean hasInterval() {
        return this.interval != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withInterval instead.
     */
        public A withNewInterval(java.lang.String arg0) {
        return (A)withInterval(new String(arg0));
    }

    public java.lang.String getName() {
        return this.name;
    }

    public A withName(java.lang.String name) {
        this.name=name; return (A) this;
    }

    public java.lang.Boolean hasName() {
        return this.name != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withName instead.
     */
        public A withNewName(java.lang.String arg0) {
        return (A)withName(new String(arg0));
    }

    public java.lang.String getPartialResponseStrategy() {
        return this.partialResponseStrategy;
    }

    public A withPartialResponseStrategy(java.lang.String partialResponseStrategy) {
        this.partialResponseStrategy=partialResponseStrategy; return (A) this;
    }

    public java.lang.Boolean hasPartialResponseStrategy() {
        return this.partialResponseStrategy != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withPartialResponseStrategy instead.
     */
        public A withNewPartialResponseStrategy(java.lang.String arg0) {
        return (A)withPartialResponseStrategy(new String(arg0));
    }

    public A addToRules(int index,io.fabric8.openshift.api.model.monitoring.v1.Rule item) {
        if (this.rules == null) {this.rules = new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1.RuleBuilder>();}
        io.fabric8.openshift.api.model.monitoring.v1.RuleBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1.RuleBuilder(item);_visitables.get("rules").add(index >= 0 ? index : _visitables.get("rules").size(), builder);this.rules.add(index >= 0 ? index : rules.size(), builder); return (A)this;
    }

    public A setToRules(int index,io.fabric8.openshift.api.model.monitoring.v1.Rule item) {
        if (this.rules == null) {this.rules = new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1.RuleBuilder>();}
        io.fabric8.openshift.api.model.monitoring.v1.RuleBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1.RuleBuilder(item);
        if (index < 0 || index >= _visitables.get("rules").size()) { _visitables.get("rules").add(builder); } else { _visitables.get("rules").set(index, builder);}
        if (index < 0 || index >= rules.size()) { rules.add(builder); } else { rules.set(index, builder);}
         return (A)this;
    }

    public A addToRules(io.fabric8.openshift.api.model.monitoring.v1.Rule... items) {
        if (this.rules == null) {this.rules = new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1.RuleBuilder>();}
        for (io.fabric8.openshift.api.model.monitoring.v1.Rule item : items) {io.fabric8.openshift.api.model.monitoring.v1.RuleBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1.RuleBuilder(item);_visitables.get("rules").add(builder);this.rules.add(builder);} return (A)this;
    }

    public A addAllToRules(java.util.Collection<io.fabric8.openshift.api.model.monitoring.v1.Rule> items) {
        if (this.rules == null) {this.rules = new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1.RuleBuilder>();}
        for (io.fabric8.openshift.api.model.monitoring.v1.Rule item : items) {io.fabric8.openshift.api.model.monitoring.v1.RuleBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1.RuleBuilder(item);_visitables.get("rules").add(builder);this.rules.add(builder);} return (A)this;
    }

    public A removeFromRules(io.fabric8.openshift.api.model.monitoring.v1.Rule... items) {
        for (io.fabric8.openshift.api.model.monitoring.v1.Rule item : items) {io.fabric8.openshift.api.model.monitoring.v1.RuleBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1.RuleBuilder(item);_visitables.get("rules").remove(builder);if (this.rules != null) {this.rules.remove(builder);}} return (A)this;
    }

    public A removeAllFromRules(java.util.Collection<io.fabric8.openshift.api.model.monitoring.v1.Rule> items) {
        for (io.fabric8.openshift.api.model.monitoring.v1.Rule item : items) {io.fabric8.openshift.api.model.monitoring.v1.RuleBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1.RuleBuilder(item);_visitables.get("rules").remove(builder);if (this.rules != null) {this.rules.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromRules(java.util.function.Predicate<io.fabric8.openshift.api.model.monitoring.v1.RuleBuilder> predicate) {
        if (rules == null) return (A) this;
        final Iterator<io.fabric8.openshift.api.model.monitoring.v1.RuleBuilder> each = rules.iterator();
        final List visitables = _visitables.get("rules");
        while (each.hasNext()) {
          io.fabric8.openshift.api.model.monitoring.v1.RuleBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildRules instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.openshift.api.model.monitoring.v1.Rule> getRules() {
        return build(rules);
    }

    public java.util.List<io.fabric8.openshift.api.model.monitoring.v1.Rule> buildRules() {
        return build(rules);
    }

    public io.fabric8.openshift.api.model.monitoring.v1.Rule buildRule(int index) {
        return this.rules.get(index).build();
    }

    public io.fabric8.openshift.api.model.monitoring.v1.Rule buildFirstRule() {
        return this.rules.get(0).build();
    }

    public io.fabric8.openshift.api.model.monitoring.v1.Rule buildLastRule() {
        return this.rules.get(rules.size() - 1).build();
    }

    public io.fabric8.openshift.api.model.monitoring.v1.Rule buildMatchingRule(java.util.function.Predicate<io.fabric8.openshift.api.model.monitoring.v1.RuleBuilder> predicate) {
        for (io.fabric8.openshift.api.model.monitoring.v1.RuleBuilder item: rules) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingRule(java.util.function.Predicate<io.fabric8.openshift.api.model.monitoring.v1.RuleBuilder> predicate) {
        for (io.fabric8.openshift.api.model.monitoring.v1.RuleBuilder item: rules) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withRules(java.util.List<io.fabric8.openshift.api.model.monitoring.v1.Rule> rules) {
        if (this.rules != null) { _visitables.get("rules").removeAll(this.rules);}
        if (rules != null) {this.rules = new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1.RuleBuilder>(); for (io.fabric8.openshift.api.model.monitoring.v1.Rule item : rules){this.addToRules(item);}} else { this.rules = null;} return (A) this;
    }

    public A withRules(io.fabric8.openshift.api.model.monitoring.v1.Rule... rules) {
        if (this.rules != null) {this.rules.clear();}
        if (rules != null) {for (io.fabric8.openshift.api.model.monitoring.v1.Rule item :rules){ this.addToRules(item);}} return (A) this;
    }

    public java.lang.Boolean hasRules() {
        return rules != null && !rules.isEmpty();
    }

    public io.fabric8.openshift.api.model.monitoring.v1.RuleGroupFluent.RulesNested<A> addNewRule() {
        return new io.fabric8.openshift.api.model.monitoring.v1.RuleGroupFluentImpl.RulesNestedImpl();
    }

    public io.fabric8.openshift.api.model.monitoring.v1.RuleGroupFluent.RulesNested<A> addNewRuleLike(io.fabric8.openshift.api.model.monitoring.v1.Rule item) {
        return new io.fabric8.openshift.api.model.monitoring.v1.RuleGroupFluentImpl.RulesNestedImpl(-1, item);
    }

    public io.fabric8.openshift.api.model.monitoring.v1.RuleGroupFluent.RulesNested<A> setNewRuleLike(int index,io.fabric8.openshift.api.model.monitoring.v1.Rule item) {
        return new io.fabric8.openshift.api.model.monitoring.v1.RuleGroupFluentImpl.RulesNestedImpl(index, item);
    }

    public io.fabric8.openshift.api.model.monitoring.v1.RuleGroupFluent.RulesNested<A> editRule(int index) {
        if (rules.size() <= index) throw new RuntimeException("Can't edit rules. Index exceeds size.");
        return setNewRuleLike(index, buildRule(index));
    }

    public io.fabric8.openshift.api.model.monitoring.v1.RuleGroupFluent.RulesNested<A> editFirstRule() {
        if (rules.size() == 0) throw new RuntimeException("Can't edit first rules. The list is empty.");
        return setNewRuleLike(0, buildRule(0));
    }

    public io.fabric8.openshift.api.model.monitoring.v1.RuleGroupFluent.RulesNested<A> editLastRule() {
        int index = rules.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last rules. The list is empty.");
        return setNewRuleLike(index, buildRule(index));
    }

    public io.fabric8.openshift.api.model.monitoring.v1.RuleGroupFluent.RulesNested<A> editMatchingRule(java.util.function.Predicate<io.fabric8.openshift.api.model.monitoring.v1.RuleBuilder> predicate) {
        int index = -1;
        for (int i=0;i<rules.size();i++) { 
        if (predicate.test(rules.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching rules. No match found.");
        return setNewRuleLike(index, buildRule(index));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        RuleGroupFluentImpl that = (RuleGroupFluentImpl) o;
        if (interval != null ? !interval.equals(that.interval) :that.interval != null) return false;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        if (partialResponseStrategy != null ? !partialResponseStrategy.equals(that.partialResponseStrategy) :that.partialResponseStrategy != null) return false;
        if (rules != null ? !rules.equals(that.rules) :that.rules != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(interval,  name,  partialResponseStrategy,  rules,  super.hashCode());
    }

    public class RulesNestedImpl<N> extends io.fabric8.openshift.api.model.monitoring.v1.RuleFluentImpl<io.fabric8.openshift.api.model.monitoring.v1.RuleGroupFluent.RulesNested<N>> implements io.fabric8.openshift.api.model.monitoring.v1.RuleGroupFluent.RulesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.monitoring.v1.RuleBuilder builder;
        private final int index;

            RulesNestedImpl(int index,io.fabric8.openshift.api.model.monitoring.v1.Rule item) {
                this.index = index;
                this.builder = new io.fabric8.openshift.api.model.monitoring.v1.RuleBuilder(this, item);
                        
            }

            RulesNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.openshift.api.model.monitoring.v1.RuleBuilder(this);
                        
            }

            public N and() {
                return (N) RuleGroupFluentImpl.this.setToRules(index,builder.build());
            }

            public N endRule() {
                return and();
            }
    }


}
