package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfig;
import java.lang.String;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfigFluentImpl;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfigBuilder;
import java.util.Collection;
import java.lang.Object;

public class EmailConfigFluentImpl<A extends io.fabric8.openshift.api.model.monitoring.v1alpha1.EmailConfigFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.monitoring.v1alpha1.EmailConfigFluent<A> {

    private java.lang.String authIdentity;
    private io.fabric8.kubernetes.api.model.SecretKeySelector authPassword;
    private io.fabric8.kubernetes.api.model.SecretKeySelector authSecret;
    private java.lang.String authUsername;
    private java.lang.String from;
    private java.util.List<io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueBuilder> headers =  new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueBuilder>();
    private java.lang.String hello;
    private java.lang.String html;
    private java.lang.Boolean requireTLS;
    private java.lang.Boolean sendResolved;
    private java.lang.String smarthost;
    private java.lang.String text;
    private io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfigBuilder tlsConfig;
    private java.lang.String to;

    public EmailConfigFluentImpl() {
    }

    public EmailConfigFluentImpl(io.fabric8.openshift.api.model.monitoring.v1alpha1.EmailConfig instance) {
        this.withAuthIdentity(instance.getAuthIdentity()); 
        this.withAuthPassword(instance.getAuthPassword()); 
        this.withAuthSecret(instance.getAuthSecret()); 
        this.withAuthUsername(instance.getAuthUsername()); 
        this.withFrom(instance.getFrom()); 
        this.withHeaders(instance.getHeaders()); 
        this.withHello(instance.getHello()); 
        this.withHtml(instance.getHtml()); 
        this.withRequireTLS(instance.getRequireTLS()); 
        this.withSendResolved(instance.getSendResolved()); 
        this.withSmarthost(instance.getSmarthost()); 
        this.withText(instance.getText()); 
        this.withTlsConfig(instance.getTlsConfig()); 
        this.withTo(instance.getTo()); 
    }

    public java.lang.String getAuthIdentity() {
        return this.authIdentity;
    }

    public A withAuthIdentity(java.lang.String authIdentity) {
        this.authIdentity=authIdentity; return (A) this;
    }

    public java.lang.Boolean hasAuthIdentity() {
        return this.authIdentity != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withAuthIdentity instead.
     */
        public A withNewAuthIdentity(java.lang.String arg0) {
        return (A)withAuthIdentity(new String(arg0));
    }

    public io.fabric8.kubernetes.api.model.SecretKeySelector getAuthPassword() {
        return this.authPassword;
    }

    public A withAuthPassword(io.fabric8.kubernetes.api.model.SecretKeySelector authPassword) {
        this.authPassword=authPassword; return (A) this;
    }

    public java.lang.Boolean hasAuthPassword() {
        return this.authPassword != null;
    }

    public A withNewAuthPassword(java.lang.String key,java.lang.String name,java.lang.Boolean optional) {
        return (A)withAuthPassword(new SecretKeySelector(key, name, optional));
    }

    public io.fabric8.kubernetes.api.model.SecretKeySelector getAuthSecret() {
        return this.authSecret;
    }

    public A withAuthSecret(io.fabric8.kubernetes.api.model.SecretKeySelector authSecret) {
        this.authSecret=authSecret; return (A) this;
    }

    public java.lang.Boolean hasAuthSecret() {
        return this.authSecret != null;
    }

    public A withNewAuthSecret(java.lang.String key,java.lang.String name,java.lang.Boolean optional) {
        return (A)withAuthSecret(new SecretKeySelector(key, name, optional));
    }

    public java.lang.String getAuthUsername() {
        return this.authUsername;
    }

    public A withAuthUsername(java.lang.String authUsername) {
        this.authUsername=authUsername; return (A) this;
    }

    public java.lang.Boolean hasAuthUsername() {
        return this.authUsername != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withAuthUsername instead.
     */
        public A withNewAuthUsername(java.lang.String arg0) {
        return (A)withAuthUsername(new String(arg0));
    }

    public java.lang.String getFrom() {
        return this.from;
    }

    public A withFrom(java.lang.String from) {
        this.from=from; return (A) this;
    }

    public java.lang.Boolean hasFrom() {
        return this.from != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withFrom instead.
     */
        public A withNewFrom(java.lang.String arg0) {
        return (A)withFrom(new String(arg0));
    }

    public A addToHeaders(int index,io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue item) {
        if (this.headers == null) {this.headers = new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueBuilder>();}
        io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueBuilder(item);_visitables.get("headers").add(index >= 0 ? index : _visitables.get("headers").size(), builder);this.headers.add(index >= 0 ? index : headers.size(), builder); return (A)this;
    }

    public A setToHeaders(int index,io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue item) {
        if (this.headers == null) {this.headers = new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueBuilder>();}
        io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueBuilder(item);
        if (index < 0 || index >= _visitables.get("headers").size()) { _visitables.get("headers").add(builder); } else { _visitables.get("headers").set(index, builder);}
        if (index < 0 || index >= headers.size()) { headers.add(builder); } else { headers.set(index, builder);}
         return (A)this;
    }

    public A addToHeaders(io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue... items) {
        if (this.headers == null) {this.headers = new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueBuilder>();}
        for (io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue item : items) {io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueBuilder(item);_visitables.get("headers").add(builder);this.headers.add(builder);} return (A)this;
    }

    public A addAllToHeaders(java.util.Collection<io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue> items) {
        if (this.headers == null) {this.headers = new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueBuilder>();}
        for (io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue item : items) {io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueBuilder(item);_visitables.get("headers").add(builder);this.headers.add(builder);} return (A)this;
    }

    public A removeFromHeaders(io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue... items) {
        for (io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue item : items) {io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueBuilder(item);_visitables.get("headers").remove(builder);if (this.headers != null) {this.headers.remove(builder);}} return (A)this;
    }

    public A removeAllFromHeaders(java.util.Collection<io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue> items) {
        for (io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue item : items) {io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueBuilder(item);_visitables.get("headers").remove(builder);if (this.headers != null) {this.headers.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromHeaders(java.util.function.Predicate<io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueBuilder> predicate) {
        if (headers == null) return (A) this;
        final Iterator<io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueBuilder> each = headers.iterator();
        final List visitables = _visitables.get("headers");
        while (each.hasNext()) {
          io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildHeaders instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue> getHeaders() {
        return build(headers);
    }

    public java.util.List<io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue> buildHeaders() {
        return build(headers);
    }

    public io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue buildHeader(int index) {
        return this.headers.get(index).build();
    }

    public io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue buildFirstHeader() {
        return this.headers.get(0).build();
    }

    public io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue buildLastHeader() {
        return this.headers.get(headers.size() - 1).build();
    }

    public io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue buildMatchingHeader(java.util.function.Predicate<io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueBuilder> predicate) {
        for (io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueBuilder item: headers) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingHeader(java.util.function.Predicate<io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueBuilder> predicate) {
        for (io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueBuilder item: headers) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withHeaders(java.util.List<io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue> headers) {
        if (this.headers != null) { _visitables.get("headers").removeAll(this.headers);}
        if (headers != null) {this.headers = new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueBuilder>(); for (io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue item : headers){this.addToHeaders(item);}} else { this.headers = null;} return (A) this;
    }

    public A withHeaders(io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue... headers) {
        if (this.headers != null) {this.headers.clear();}
        if (headers != null) {for (io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue item :headers){ this.addToHeaders(item);}} return (A) this;
    }

    public java.lang.Boolean hasHeaders() {
        return headers != null && !headers.isEmpty();
    }

    public A addNewHeader(java.lang.String key,java.lang.String value) {
        return (A)addToHeaders(new KeyValue(key, value));
    }

    public io.fabric8.openshift.api.model.monitoring.v1alpha1.EmailConfigFluent.HeadersNested<A> addNewHeader() {
        return new io.fabric8.openshift.api.model.monitoring.v1alpha1.EmailConfigFluentImpl.HeadersNestedImpl();
    }

    public io.fabric8.openshift.api.model.monitoring.v1alpha1.EmailConfigFluent.HeadersNested<A> addNewHeaderLike(io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue item) {
        return new io.fabric8.openshift.api.model.monitoring.v1alpha1.EmailConfigFluentImpl.HeadersNestedImpl(-1, item);
    }

    public io.fabric8.openshift.api.model.monitoring.v1alpha1.EmailConfigFluent.HeadersNested<A> setNewHeaderLike(int index,io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue item) {
        return new io.fabric8.openshift.api.model.monitoring.v1alpha1.EmailConfigFluentImpl.HeadersNestedImpl(index, item);
    }

    public io.fabric8.openshift.api.model.monitoring.v1alpha1.EmailConfigFluent.HeadersNested<A> editHeader(int index) {
        if (headers.size() <= index) throw new RuntimeException("Can't edit headers. Index exceeds size.");
        return setNewHeaderLike(index, buildHeader(index));
    }

    public io.fabric8.openshift.api.model.monitoring.v1alpha1.EmailConfigFluent.HeadersNested<A> editFirstHeader() {
        if (headers.size() == 0) throw new RuntimeException("Can't edit first headers. The list is empty.");
        return setNewHeaderLike(0, buildHeader(0));
    }

    public io.fabric8.openshift.api.model.monitoring.v1alpha1.EmailConfigFluent.HeadersNested<A> editLastHeader() {
        int index = headers.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last headers. The list is empty.");
        return setNewHeaderLike(index, buildHeader(index));
    }

    public io.fabric8.openshift.api.model.monitoring.v1alpha1.EmailConfigFluent.HeadersNested<A> editMatchingHeader(java.util.function.Predicate<io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueBuilder> predicate) {
        int index = -1;
        for (int i=0;i<headers.size();i++) { 
        if (predicate.test(headers.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching headers. No match found.");
        return setNewHeaderLike(index, buildHeader(index));
    }

    public java.lang.String getHello() {
        return this.hello;
    }

    public A withHello(java.lang.String hello) {
        this.hello=hello; return (A) this;
    }

    public java.lang.Boolean hasHello() {
        return this.hello != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withHello instead.
     */
        public A withNewHello(java.lang.String arg0) {
        return (A)withHello(new String(arg0));
    }

    public java.lang.String getHtml() {
        return this.html;
    }

    public A withHtml(java.lang.String html) {
        this.html=html; return (A) this;
    }

    public java.lang.Boolean hasHtml() {
        return this.html != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withHtml instead.
     */
        public A withNewHtml(java.lang.String arg0) {
        return (A)withHtml(new String(arg0));
    }

    public java.lang.Boolean getRequireTLS() {
        return this.requireTLS;
    }

    public A withRequireTLS(java.lang.Boolean requireTLS) {
        this.requireTLS=requireTLS; return (A) this;
    }

    public java.lang.Boolean hasRequireTLS() {
        return this.requireTLS != null;
    }

    public java.lang.Boolean getSendResolved() {
        return this.sendResolved;
    }

    public A withSendResolved(java.lang.Boolean sendResolved) {
        this.sendResolved=sendResolved; return (A) this;
    }

    public java.lang.Boolean hasSendResolved() {
        return this.sendResolved != null;
    }

    public java.lang.String getSmarthost() {
        return this.smarthost;
    }

    public A withSmarthost(java.lang.String smarthost) {
        this.smarthost=smarthost; return (A) this;
    }

    public java.lang.Boolean hasSmarthost() {
        return this.smarthost != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withSmarthost instead.
     */
        public A withNewSmarthost(java.lang.String arg0) {
        return (A)withSmarthost(new String(arg0));
    }

    public java.lang.String getText() {
        return this.text;
    }

    public A withText(java.lang.String text) {
        this.text=text; return (A) this;
    }

    public java.lang.Boolean hasText() {
        return this.text != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withText instead.
     */
        public A withNewText(java.lang.String arg0) {
        return (A)withText(new String(arg0));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildTlsConfig instead.
     * @return The buildable object.
     */
        public io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfig getTlsConfig() {
        return this.tlsConfig!=null?this.tlsConfig.build():null;
    }

    public io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfig buildTlsConfig() {
        return this.tlsConfig!=null?this.tlsConfig.build():null;
    }

    public A withTlsConfig(io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfig tlsConfig) {
        _visitables.get("tlsConfig").remove(this.tlsConfig);
        if (tlsConfig!=null){ this.tlsConfig= new io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfigBuilder(tlsConfig); _visitables.get("tlsConfig").add(this.tlsConfig);} return (A) this;
    }

    public java.lang.Boolean hasTlsConfig() {
        return this.tlsConfig != null;
    }

    public io.fabric8.openshift.api.model.monitoring.v1alpha1.EmailConfigFluent.TlsConfigNested<A> withNewTlsConfig() {
        return new io.fabric8.openshift.api.model.monitoring.v1alpha1.EmailConfigFluentImpl.TlsConfigNestedImpl();
    }

    public io.fabric8.openshift.api.model.monitoring.v1alpha1.EmailConfigFluent.TlsConfigNested<A> withNewTlsConfigLike(io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfig item) {
        return new io.fabric8.openshift.api.model.monitoring.v1alpha1.EmailConfigFluentImpl.TlsConfigNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.monitoring.v1alpha1.EmailConfigFluent.TlsConfigNested<A> editTlsConfig() {
        return withNewTlsConfigLike(getTlsConfig());
    }

    public io.fabric8.openshift.api.model.monitoring.v1alpha1.EmailConfigFluent.TlsConfigNested<A> editOrNewTlsConfig() {
        return withNewTlsConfigLike(getTlsConfig() != null ? getTlsConfig(): new io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfigBuilder().build());
    }

    public io.fabric8.openshift.api.model.monitoring.v1alpha1.EmailConfigFluent.TlsConfigNested<A> editOrNewTlsConfigLike(io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfig item) {
        return withNewTlsConfigLike(getTlsConfig() != null ? getTlsConfig(): item);
    }

    public java.lang.String getTo() {
        return this.to;
    }

    public A withTo(java.lang.String to) {
        this.to=to; return (A) this;
    }

    public java.lang.Boolean hasTo() {
        return this.to != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withTo instead.
     */
        public A withNewTo(java.lang.String arg0) {
        return (A)withTo(new String(arg0));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        EmailConfigFluentImpl that = (EmailConfigFluentImpl) o;
        if (authIdentity != null ? !authIdentity.equals(that.authIdentity) :that.authIdentity != null) return false;
        if (authPassword != null ? !authPassword.equals(that.authPassword) :that.authPassword != null) return false;
        if (authSecret != null ? !authSecret.equals(that.authSecret) :that.authSecret != null) return false;
        if (authUsername != null ? !authUsername.equals(that.authUsername) :that.authUsername != null) return false;
        if (from != null ? !from.equals(that.from) :that.from != null) return false;
        if (headers != null ? !headers.equals(that.headers) :that.headers != null) return false;
        if (hello != null ? !hello.equals(that.hello) :that.hello != null) return false;
        if (html != null ? !html.equals(that.html) :that.html != null) return false;
        if (requireTLS != null ? !requireTLS.equals(that.requireTLS) :that.requireTLS != null) return false;
        if (sendResolved != null ? !sendResolved.equals(that.sendResolved) :that.sendResolved != null) return false;
        if (smarthost != null ? !smarthost.equals(that.smarthost) :that.smarthost != null) return false;
        if (text != null ? !text.equals(that.text) :that.text != null) return false;
        if (tlsConfig != null ? !tlsConfig.equals(that.tlsConfig) :that.tlsConfig != null) return false;
        if (to != null ? !to.equals(that.to) :that.to != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(authIdentity,  authPassword,  authSecret,  authUsername,  from,  headers,  hello,  html,  requireTLS,  sendResolved,  smarthost,  text,  tlsConfig,  to,  super.hashCode());
    }

    public class HeadersNestedImpl<N> extends io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueFluentImpl<io.fabric8.openshift.api.model.monitoring.v1alpha1.EmailConfigFluent.HeadersNested<N>> implements io.fabric8.openshift.api.model.monitoring.v1alpha1.EmailConfigFluent.HeadersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueBuilder builder;
        private final int index;

            HeadersNestedImpl(int index,io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue item) {
                this.index = index;
                this.builder = new io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueBuilder(this, item);
                        
            }

            HeadersNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueBuilder(this);
                        
            }

            public N and() {
                return (N) EmailConfigFluentImpl.this.setToHeaders(index,builder.build());
            }

            public N endHeader() {
                return and();
            }
    }


    public class TlsConfigNestedImpl<N> extends io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfigFluentImpl<io.fabric8.openshift.api.model.monitoring.v1alpha1.EmailConfigFluent.TlsConfigNested<N>> implements io.fabric8.openshift.api.model.monitoring.v1alpha1.EmailConfigFluent.TlsConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfigBuilder builder;

            TlsConfigNestedImpl(io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfig item) {
                this.builder = new io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfigBuilder(this, item);
                        
            }

            TlsConfigNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfigBuilder(this);
                        
            }

            public N and() {
                return (N) EmailConfigFluentImpl.this.withTlsConfig(builder.build());
            }

            public N endTlsConfig() {
                return and();
            }
    }


}
