package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class QuerySpecBuilder extends io.fabric8.openshift.api.model.monitoring.v1.QuerySpecFluentImpl<io.fabric8.openshift.api.model.monitoring.v1.QuerySpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.monitoring.v1.QuerySpec,io.fabric8.openshift.api.model.monitoring.v1.QuerySpecBuilder> {

    io.fabric8.openshift.api.model.monitoring.v1.QuerySpecFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public QuerySpecBuilder() {
        this(true);
    }

    public QuerySpecBuilder(java.lang.Boolean validationEnabled) {
        this(new QuerySpec(), validationEnabled);
    }

    public QuerySpecBuilder(io.fabric8.openshift.api.model.monitoring.v1.QuerySpecFluent<?> fluent) {
        this(fluent, true);
    }

    public QuerySpecBuilder(io.fabric8.openshift.api.model.monitoring.v1.QuerySpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new QuerySpec(), validationEnabled);
    }

    public QuerySpecBuilder(io.fabric8.openshift.api.model.monitoring.v1.QuerySpecFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.QuerySpec instance) {
        this(fluent, instance, true);
    }

    public QuerySpecBuilder(io.fabric8.openshift.api.model.monitoring.v1.QuerySpecFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.QuerySpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withLookbackDelta(instance.getLookbackDelta()); 
        fluent.withMaxConcurrency(instance.getMaxConcurrency()); 
        fluent.withMaxSamples(instance.getMaxSamples()); 
        fluent.withTimeout(instance.getTimeout()); 
        this.validationEnabled = validationEnabled; 
    }

    public QuerySpecBuilder(io.fabric8.openshift.api.model.monitoring.v1.QuerySpec instance) {
        this(instance,true);
    }

    public QuerySpecBuilder(io.fabric8.openshift.api.model.monitoring.v1.QuerySpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withLookbackDelta(instance.getLookbackDelta()); 
        this.withMaxConcurrency(instance.getMaxConcurrency()); 
        this.withMaxSamples(instance.getMaxSamples()); 
        this.withTimeout(instance.getTimeout()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.monitoring.v1.QuerySpec build() {
        QuerySpec buildable = new QuerySpec(fluent.getLookbackDelta(),fluent.getMaxConcurrency(),fluent.getMaxSamples(),fluent.getTimeout());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        QuerySpecBuilder that = (QuerySpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
