package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ServiceMonitorBuilder extends io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorFluentImpl<io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitor,io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorBuilder> {

    io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ServiceMonitorBuilder() {
        this(true);
    }

    public ServiceMonitorBuilder(java.lang.Boolean validationEnabled) {
        this(new ServiceMonitor(), validationEnabled);
    }

    public ServiceMonitorBuilder(io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorFluent<?> fluent) {
        this(fluent, true);
    }

    public ServiceMonitorBuilder(io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ServiceMonitor(), validationEnabled);
    }

    public ServiceMonitorBuilder(io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitor instance) {
        this(fluent, instance, true);
    }

    public ServiceMonitorBuilder(io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitorFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitor instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        this.validationEnabled = validationEnabled; 
    }

    public ServiceMonitorBuilder(io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitor instance) {
        this(instance,true);
    }

    public ServiceMonitorBuilder(io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitor instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.monitoring.v1.ServiceMonitor build() {
        ServiceMonitor buildable = new ServiceMonitor(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ServiceMonitorBuilder that = (ServiceMonitorBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
