package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SecretOrConfigMapBuilder extends io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMapFluentImpl<io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMapBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMap,io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMapBuilder> {

    io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMapFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public SecretOrConfigMapBuilder() {
        this(true);
    }

    public SecretOrConfigMapBuilder(java.lang.Boolean validationEnabled) {
        this(new SecretOrConfigMap(), validationEnabled);
    }

    public SecretOrConfigMapBuilder(io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMapFluent<?> fluent) {
        this(fluent, true);
    }

    public SecretOrConfigMapBuilder(io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMapFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new SecretOrConfigMap(), validationEnabled);
    }

    public SecretOrConfigMapBuilder(io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMapFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMap instance) {
        this(fluent, instance, true);
    }

    public SecretOrConfigMapBuilder(io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMapFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMap instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withConfigMap(instance.getConfigMap()); 
        fluent.withSecret(instance.getSecret()); 
        this.validationEnabled = validationEnabled; 
    }

    public SecretOrConfigMapBuilder(io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMap instance) {
        this(instance,true);
    }

    public SecretOrConfigMapBuilder(io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMap instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withConfigMap(instance.getConfigMap()); 
        this.withSecret(instance.getSecret()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMap build() {
        SecretOrConfigMap buildable = new SecretOrConfigMap(fluent.getConfigMap(),fluent.getSecret());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        SecretOrConfigMapBuilder that = (SecretOrConfigMapBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
