package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RuleGroupBuilder extends io.fabric8.openshift.api.model.monitoring.v1.RuleGroupFluentImpl<io.fabric8.openshift.api.model.monitoring.v1.RuleGroupBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.monitoring.v1.RuleGroup,io.fabric8.openshift.api.model.monitoring.v1.RuleGroupBuilder> {

    io.fabric8.openshift.api.model.monitoring.v1.RuleGroupFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public RuleGroupBuilder() {
        this(true);
    }

    public RuleGroupBuilder(java.lang.Boolean validationEnabled) {
        this(new RuleGroup(), validationEnabled);
    }

    public RuleGroupBuilder(io.fabric8.openshift.api.model.monitoring.v1.RuleGroupFluent<?> fluent) {
        this(fluent, true);
    }

    public RuleGroupBuilder(io.fabric8.openshift.api.model.monitoring.v1.RuleGroupFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new RuleGroup(), validationEnabled);
    }

    public RuleGroupBuilder(io.fabric8.openshift.api.model.monitoring.v1.RuleGroupFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.RuleGroup instance) {
        this(fluent, instance, true);
    }

    public RuleGroupBuilder(io.fabric8.openshift.api.model.monitoring.v1.RuleGroupFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.RuleGroup instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withInterval(instance.getInterval()); 
        fluent.withName(instance.getName()); 
        fluent.withPartialResponseStrategy(instance.getPartialResponseStrategy()); 
        fluent.withRules(instance.getRules()); 
        this.validationEnabled = validationEnabled; 
    }

    public RuleGroupBuilder(io.fabric8.openshift.api.model.monitoring.v1.RuleGroup instance) {
        this(instance,true);
    }

    public RuleGroupBuilder(io.fabric8.openshift.api.model.monitoring.v1.RuleGroup instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withInterval(instance.getInterval()); 
        this.withName(instance.getName()); 
        this.withPartialResponseStrategy(instance.getPartialResponseStrategy()); 
        this.withRules(instance.getRules()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.monitoring.v1.RuleGroup build() {
        RuleGroup buildable = new RuleGroup(fluent.getInterval(),fluent.getName(),fluent.getPartialResponseStrategy(),fluent.getRules());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        RuleGroupBuilder that = (RuleGroupBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
