package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ProbeBuilder extends io.fabric8.openshift.api.model.monitoring.v1.ProbeFluentImpl<io.fabric8.openshift.api.model.monitoring.v1.ProbeBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.monitoring.v1.Probe,io.fabric8.openshift.api.model.monitoring.v1.ProbeBuilder> {

    io.fabric8.openshift.api.model.monitoring.v1.ProbeFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ProbeBuilder() {
        this(true);
    }

    public ProbeBuilder(java.lang.Boolean validationEnabled) {
        this(new Probe(), validationEnabled);
    }

    public ProbeBuilder(io.fabric8.openshift.api.model.monitoring.v1.ProbeFluent<?> fluent) {
        this(fluent, true);
    }

    public ProbeBuilder(io.fabric8.openshift.api.model.monitoring.v1.ProbeFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new Probe(), validationEnabled);
    }

    public ProbeBuilder(io.fabric8.openshift.api.model.monitoring.v1.ProbeFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.Probe instance) {
        this(fluent, instance, true);
    }

    public ProbeBuilder(io.fabric8.openshift.api.model.monitoring.v1.ProbeFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.Probe instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        this.validationEnabled = validationEnabled; 
    }

    public ProbeBuilder(io.fabric8.openshift.api.model.monitoring.v1.Probe instance) {
        this(instance,true);
    }

    public ProbeBuilder(io.fabric8.openshift.api.model.monitoring.v1.Probe instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.monitoring.v1.Probe build() {
        Probe buildable = new Probe(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ProbeBuilder that = (ProbeBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
