package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.util.Map;

public interface PodMonitorSpecFluent<A extends io.fabric8.openshift.api.model.monitoring.v1.PodMonitorSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public java.lang.String getJobLabel();
    public A withJobLabel(java.lang.String jobLabel);
    public java.lang.Boolean hasJobLabel();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withJobLabel instead.
     */
        public A withNewJobLabel(java.lang.String arg0);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildNamespaceSelector instead.
     * @return The buildable object.
     */
        public io.fabric8.openshift.api.model.monitoring.v1.NamespaceSelector getNamespaceSelector();
    public io.fabric8.openshift.api.model.monitoring.v1.NamespaceSelector buildNamespaceSelector();
    public A withNamespaceSelector(io.fabric8.openshift.api.model.monitoring.v1.NamespaceSelector namespaceSelector);
    public java.lang.Boolean hasNamespaceSelector();
    public io.fabric8.openshift.api.model.monitoring.v1.PodMonitorSpecFluent.NamespaceSelectorNested<A> withNewNamespaceSelector();
    public io.fabric8.openshift.api.model.monitoring.v1.PodMonitorSpecFluent.NamespaceSelectorNested<A> withNewNamespaceSelectorLike(io.fabric8.openshift.api.model.monitoring.v1.NamespaceSelector item);
    public io.fabric8.openshift.api.model.monitoring.v1.PodMonitorSpecFluent.NamespaceSelectorNested<A> editNamespaceSelector();
    public io.fabric8.openshift.api.model.monitoring.v1.PodMonitorSpecFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelector();
    public io.fabric8.openshift.api.model.monitoring.v1.PodMonitorSpecFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(io.fabric8.openshift.api.model.monitoring.v1.NamespaceSelector item);
    public A addToPodMetricsEndpoints(int index,io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpoint item);
    public A setToPodMetricsEndpoints(int index,io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpoint item);
    public A addToPodMetricsEndpoints(io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpoint... items);
    public A addAllToPodMetricsEndpoints(java.util.Collection<io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpoint> items);
    public A removeFromPodMetricsEndpoints(io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpoint... items);
    public A removeAllFromPodMetricsEndpoints(java.util.Collection<io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpoint> items);
    public A removeMatchingFromPodMetricsEndpoints(java.util.function.Predicate<io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointBuilder> predicate);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildPodMetricsEndpoints instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpoint> getPodMetricsEndpoints();
    public java.util.List<io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpoint> buildPodMetricsEndpoints();
    public io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpoint buildPodMetricsEndpoint(int index);
    public io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpoint buildFirstPodMetricsEndpoint();
    public io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpoint buildLastPodMetricsEndpoint();
    public io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpoint buildMatchingPodMetricsEndpoint(java.util.function.Predicate<io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointBuilder> predicate);
    public java.lang.Boolean hasMatchingPodMetricsEndpoint(java.util.function.Predicate<io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointBuilder> predicate);
    public A withPodMetricsEndpoints(java.util.List<io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpoint> podMetricsEndpoints);
    public A withPodMetricsEndpoints(io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpoint... podMetricsEndpoints);
    public java.lang.Boolean hasPodMetricsEndpoints();
    public io.fabric8.openshift.api.model.monitoring.v1.PodMonitorSpecFluent.PodMetricsEndpointsNested<A> addNewPodMetricsEndpoint();
    public io.fabric8.openshift.api.model.monitoring.v1.PodMonitorSpecFluent.PodMetricsEndpointsNested<A> addNewPodMetricsEndpointLike(io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpoint item);
    public io.fabric8.openshift.api.model.monitoring.v1.PodMonitorSpecFluent.PodMetricsEndpointsNested<A> setNewPodMetricsEndpointLike(int index,io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpoint item);
    public io.fabric8.openshift.api.model.monitoring.v1.PodMonitorSpecFluent.PodMetricsEndpointsNested<A> editPodMetricsEndpoint(int index);
    public io.fabric8.openshift.api.model.monitoring.v1.PodMonitorSpecFluent.PodMetricsEndpointsNested<A> editFirstPodMetricsEndpoint();
    public io.fabric8.openshift.api.model.monitoring.v1.PodMonitorSpecFluent.PodMetricsEndpointsNested<A> editLastPodMetricsEndpoint();
    public io.fabric8.openshift.api.model.monitoring.v1.PodMonitorSpecFluent.PodMetricsEndpointsNested<A> editMatchingPodMetricsEndpoint(java.util.function.Predicate<io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointBuilder> predicate);
    public A addToPodTargetLabels(int index,java.lang.String item);
    public A setToPodTargetLabels(int index,java.lang.String item);
    public A addToPodTargetLabels(java.lang.String... items);
    public A addAllToPodTargetLabels(java.util.Collection<java.lang.String> items);
    public A removeFromPodTargetLabels(java.lang.String... items);
    public A removeAllFromPodTargetLabels(java.util.Collection<java.lang.String> items);
    public java.util.List<java.lang.String> getPodTargetLabels();
    public java.lang.String getPodTargetLabel(int index);
    public java.lang.String getFirstPodTargetLabel();
    public java.lang.String getLastPodTargetLabel();
    public java.lang.String getMatchingPodTargetLabel(java.util.function.Predicate<java.lang.String> predicate);
    public java.lang.Boolean hasMatchingPodTargetLabel(java.util.function.Predicate<java.lang.String> predicate);
    public A withPodTargetLabels(java.util.List<java.lang.String> podTargetLabels);
    public A withPodTargetLabels(java.lang.String... podTargetLabels);
    public java.lang.Boolean hasPodTargetLabels();
    public A addNewPodTargetLabel(java.lang.String arg0);
    public java.lang.Long getSampleLimit();
    public A withSampleLimit(java.lang.Long sampleLimit);
    public java.lang.Boolean hasSampleLimit();
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildSelector instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.LabelSelector getSelector();
    public io.fabric8.kubernetes.api.model.LabelSelector buildSelector();
    public A withSelector(io.fabric8.kubernetes.api.model.LabelSelector selector);
    public java.lang.Boolean hasSelector();
    public io.fabric8.openshift.api.model.monitoring.v1.PodMonitorSpecFluent.SelectorNested<A> withNewSelector();
    public io.fabric8.openshift.api.model.monitoring.v1.PodMonitorSpecFluent.SelectorNested<A> withNewSelectorLike(io.fabric8.kubernetes.api.model.LabelSelector item);
    public io.fabric8.openshift.api.model.monitoring.v1.PodMonitorSpecFluent.SelectorNested<A> editSelector();
    public io.fabric8.openshift.api.model.monitoring.v1.PodMonitorSpecFluent.SelectorNested<A> editOrNewSelector();
    public io.fabric8.openshift.api.model.monitoring.v1.PodMonitorSpecFluent.SelectorNested<A> editOrNewSelectorLike(io.fabric8.kubernetes.api.model.LabelSelector item);
    public java.lang.Long getTargetLimit();
    public A withTargetLimit(java.lang.Long targetLimit);
    public java.lang.Boolean hasTargetLimit();
    public interface NamespaceSelectorNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.monitoring.v1.NamespaceSelectorFluent<io.fabric8.openshift.api.model.monitoring.v1.PodMonitorSpecFluent.NamespaceSelectorNested<N>> {

            public N and();
            public N endNamespaceSelector();    }


    public interface PodMetricsEndpointsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent<io.fabric8.openshift.api.model.monitoring.v1.PodMonitorSpecFluent.PodMetricsEndpointsNested<N>> {

            public N and();
            public N endPodMetricsEndpoint();    }


    public interface SelectorNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.kubernetes.api.model.LabelSelectorFluent<io.fabric8.openshift.api.model.monitoring.v1.PodMonitorSpecFluent.SelectorNested<N>> {

            public N and();
            public N endSelector();    }


}
