package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PodMonitorSpecBuilder extends io.fabric8.openshift.api.model.monitoring.v1.PodMonitorSpecFluentImpl<io.fabric8.openshift.api.model.monitoring.v1.PodMonitorSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.monitoring.v1.PodMonitorSpec,io.fabric8.openshift.api.model.monitoring.v1.PodMonitorSpecBuilder> {

    io.fabric8.openshift.api.model.monitoring.v1.PodMonitorSpecFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public PodMonitorSpecBuilder() {
        this(true);
    }

    public PodMonitorSpecBuilder(java.lang.Boolean validationEnabled) {
        this(new PodMonitorSpec(), validationEnabled);
    }

    public PodMonitorSpecBuilder(io.fabric8.openshift.api.model.monitoring.v1.PodMonitorSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public PodMonitorSpecBuilder(io.fabric8.openshift.api.model.monitoring.v1.PodMonitorSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new PodMonitorSpec(), validationEnabled);
    }

    public PodMonitorSpecBuilder(io.fabric8.openshift.api.model.monitoring.v1.PodMonitorSpecFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.PodMonitorSpec instance) {
        this(fluent, instance, true);
    }

    public PodMonitorSpecBuilder(io.fabric8.openshift.api.model.monitoring.v1.PodMonitorSpecFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.PodMonitorSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withJobLabel(instance.getJobLabel()); 
        fluent.withNamespaceSelector(instance.getNamespaceSelector()); 
        fluent.withPodMetricsEndpoints(instance.getPodMetricsEndpoints()); 
        fluent.withPodTargetLabels(instance.getPodTargetLabels()); 
        fluent.withSampleLimit(instance.getSampleLimit()); 
        fluent.withSelector(instance.getSelector()); 
        fluent.withTargetLimit(instance.getTargetLimit()); 
        this.validationEnabled = validationEnabled; 
    }

    public PodMonitorSpecBuilder(io.fabric8.openshift.api.model.monitoring.v1.PodMonitorSpec instance) {
        this(instance,true);
    }

    public PodMonitorSpecBuilder(io.fabric8.openshift.api.model.monitoring.v1.PodMonitorSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withJobLabel(instance.getJobLabel()); 
        this.withNamespaceSelector(instance.getNamespaceSelector()); 
        this.withPodMetricsEndpoints(instance.getPodMetricsEndpoints()); 
        this.withPodTargetLabels(instance.getPodTargetLabels()); 
        this.withSampleLimit(instance.getSampleLimit()); 
        this.withSelector(instance.getSelector()); 
        this.withTargetLimit(instance.getTargetLimit()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.monitoring.v1.PodMonitorSpec build() {
        PodMonitorSpec buildable = new PodMonitorSpec(fluent.getJobLabel(),fluent.getNamespaceSelector(),fluent.getPodMetricsEndpoints(),fluent.getPodTargetLabels(),fluent.getSampleLimit(),fluent.getSelector(),fluent.getTargetLimit());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PodMonitorSpecBuilder that = (PodMonitorSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
