package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.IntOrStringFluentImpl;
import java.lang.Boolean;

public class AlertmanagerEndpointsFluentImpl<A extends io.fabric8.openshift.api.model.monitoring.v1.AlertmanagerEndpointsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.monitoring.v1.AlertmanagerEndpointsFluent<A> {

    private java.lang.String apiVersion;
    private java.lang.String bearerTokenFile;
    private java.lang.String name;
    private java.lang.String namespace;
    private java.lang.String pathPrefix;
    private io.fabric8.kubernetes.api.model.IntOrStringBuilder port;
    private java.lang.String scheme;
    private java.lang.String timeout;
    private io.fabric8.openshift.api.model.monitoring.v1.TLSConfigBuilder tlsConfig;

    public AlertmanagerEndpointsFluentImpl() {
    }

    public AlertmanagerEndpointsFluentImpl(io.fabric8.openshift.api.model.monitoring.v1.AlertmanagerEndpoints instance) {
        this.withApiVersion(instance.getApiVersion()); 
        this.withBearerTokenFile(instance.getBearerTokenFile()); 
        this.withName(instance.getName()); 
        this.withNamespace(instance.getNamespace()); 
        this.withPathPrefix(instance.getPathPrefix()); 
        this.withPort(instance.getPort()); 
        this.withScheme(instance.getScheme()); 
        this.withTimeout(instance.getTimeout()); 
        this.withTlsConfig(instance.getTlsConfig()); 
    }

    public java.lang.String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(java.lang.String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public java.lang.Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withApiVersion instead.
     */
        public A withNewApiVersion(java.lang.String arg0) {
        return (A)withApiVersion(new String(arg0));
    }

    public java.lang.String getBearerTokenFile() {
        return this.bearerTokenFile;
    }

    public A withBearerTokenFile(java.lang.String bearerTokenFile) {
        this.bearerTokenFile=bearerTokenFile; return (A) this;
    }

    public java.lang.Boolean hasBearerTokenFile() {
        return this.bearerTokenFile != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withBearerTokenFile instead.
     */
        public A withNewBearerTokenFile(java.lang.String arg0) {
        return (A)withBearerTokenFile(new String(arg0));
    }

    public java.lang.String getName() {
        return this.name;
    }

    public A withName(java.lang.String name) {
        this.name=name; return (A) this;
    }

    public java.lang.Boolean hasName() {
        return this.name != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withName instead.
     */
        public A withNewName(java.lang.String arg0) {
        return (A)withName(new String(arg0));
    }

    public java.lang.String getNamespace() {
        return this.namespace;
    }

    public A withNamespace(java.lang.String namespace) {
        this.namespace=namespace; return (A) this;
    }

    public java.lang.Boolean hasNamespace() {
        return this.namespace != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withNamespace instead.
     */
        public A withNewNamespace(java.lang.String arg0) {
        return (A)withNamespace(new String(arg0));
    }

    public java.lang.String getPathPrefix() {
        return this.pathPrefix;
    }

    public A withPathPrefix(java.lang.String pathPrefix) {
        this.pathPrefix=pathPrefix; return (A) this;
    }

    public java.lang.Boolean hasPathPrefix() {
        return this.pathPrefix != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withPathPrefix instead.
     */
        public A withNewPathPrefix(java.lang.String arg0) {
        return (A)withPathPrefix(new String(arg0));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildPort instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.IntOrString getPort() {
        return this.port!=null?this.port.build():null;
    }

    public io.fabric8.kubernetes.api.model.IntOrString buildPort() {
        return this.port!=null?this.port.build():null;
    }

    public A withPort(io.fabric8.kubernetes.api.model.IntOrString port) {
        _visitables.get("port").remove(this.port);
        if (port!=null){ this.port= new io.fabric8.kubernetes.api.model.IntOrStringBuilder(port); _visitables.get("port").add(this.port);} return (A) this;
    }

    public java.lang.Boolean hasPort() {
        return this.port != null;
    }

    public A withNewPort(java.lang.Integer intVal) {
        return (A)withPort(new IntOrString(intVal));
    }

    public A withNewPort(java.lang.String strVal) {
        return (A)withPort(new IntOrString(strVal));
    }

    public io.fabric8.openshift.api.model.monitoring.v1.AlertmanagerEndpointsFluent.PortNested<A> withNewPort() {
        return new io.fabric8.openshift.api.model.monitoring.v1.AlertmanagerEndpointsFluentImpl.PortNestedImpl();
    }

    public io.fabric8.openshift.api.model.monitoring.v1.AlertmanagerEndpointsFluent.PortNested<A> withNewPortLike(io.fabric8.kubernetes.api.model.IntOrString item) {
        return new io.fabric8.openshift.api.model.monitoring.v1.AlertmanagerEndpointsFluentImpl.PortNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.monitoring.v1.AlertmanagerEndpointsFluent.PortNested<A> editPort() {
        return withNewPortLike(getPort());
    }

    public io.fabric8.openshift.api.model.monitoring.v1.AlertmanagerEndpointsFluent.PortNested<A> editOrNewPort() {
        return withNewPortLike(getPort() != null ? getPort(): new io.fabric8.kubernetes.api.model.IntOrStringBuilder().build());
    }

    public io.fabric8.openshift.api.model.monitoring.v1.AlertmanagerEndpointsFluent.PortNested<A> editOrNewPortLike(io.fabric8.kubernetes.api.model.IntOrString item) {
        return withNewPortLike(getPort() != null ? getPort(): item);
    }

    public java.lang.String getScheme() {
        return this.scheme;
    }

    public A withScheme(java.lang.String scheme) {
        this.scheme=scheme; return (A) this;
    }

    public java.lang.Boolean hasScheme() {
        return this.scheme != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withScheme instead.
     */
        public A withNewScheme(java.lang.String arg0) {
        return (A)withScheme(new String(arg0));
    }

    public java.lang.String getTimeout() {
        return this.timeout;
    }

    public A withTimeout(java.lang.String timeout) {
        this.timeout=timeout; return (A) this;
    }

    public java.lang.Boolean hasTimeout() {
        return this.timeout != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withTimeout instead.
     */
        public A withNewTimeout(java.lang.String arg0) {
        return (A)withTimeout(new String(arg0));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildTlsConfig instead.
     * @return The buildable object.
     */
        public io.fabric8.openshift.api.model.monitoring.v1.TLSConfig getTlsConfig() {
        return this.tlsConfig!=null?this.tlsConfig.build():null;
    }

    public io.fabric8.openshift.api.model.monitoring.v1.TLSConfig buildTlsConfig() {
        return this.tlsConfig!=null?this.tlsConfig.build():null;
    }

    public A withTlsConfig(io.fabric8.openshift.api.model.monitoring.v1.TLSConfig tlsConfig) {
        _visitables.get("tlsConfig").remove(this.tlsConfig);
        if (tlsConfig!=null){ this.tlsConfig= new io.fabric8.openshift.api.model.monitoring.v1.TLSConfigBuilder(tlsConfig); _visitables.get("tlsConfig").add(this.tlsConfig);} return (A) this;
    }

    public java.lang.Boolean hasTlsConfig() {
        return this.tlsConfig != null;
    }

    public io.fabric8.openshift.api.model.monitoring.v1.AlertmanagerEndpointsFluent.TlsConfigNested<A> withNewTlsConfig() {
        return new io.fabric8.openshift.api.model.monitoring.v1.AlertmanagerEndpointsFluentImpl.TlsConfigNestedImpl();
    }

    public io.fabric8.openshift.api.model.monitoring.v1.AlertmanagerEndpointsFluent.TlsConfigNested<A> withNewTlsConfigLike(io.fabric8.openshift.api.model.monitoring.v1.TLSConfig item) {
        return new io.fabric8.openshift.api.model.monitoring.v1.AlertmanagerEndpointsFluentImpl.TlsConfigNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.monitoring.v1.AlertmanagerEndpointsFluent.TlsConfigNested<A> editTlsConfig() {
        return withNewTlsConfigLike(getTlsConfig());
    }

    public io.fabric8.openshift.api.model.monitoring.v1.AlertmanagerEndpointsFluent.TlsConfigNested<A> editOrNewTlsConfig() {
        return withNewTlsConfigLike(getTlsConfig() != null ? getTlsConfig(): new io.fabric8.openshift.api.model.monitoring.v1.TLSConfigBuilder().build());
    }

    public io.fabric8.openshift.api.model.monitoring.v1.AlertmanagerEndpointsFluent.TlsConfigNested<A> editOrNewTlsConfigLike(io.fabric8.openshift.api.model.monitoring.v1.TLSConfig item) {
        return withNewTlsConfigLike(getTlsConfig() != null ? getTlsConfig(): item);
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AlertmanagerEndpointsFluentImpl that = (AlertmanagerEndpointsFluentImpl) o;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (bearerTokenFile != null ? !bearerTokenFile.equals(that.bearerTokenFile) :that.bearerTokenFile != null) return false;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        if (namespace != null ? !namespace.equals(that.namespace) :that.namespace != null) return false;
        if (pathPrefix != null ? !pathPrefix.equals(that.pathPrefix) :that.pathPrefix != null) return false;
        if (port != null ? !port.equals(that.port) :that.port != null) return false;
        if (scheme != null ? !scheme.equals(that.scheme) :that.scheme != null) return false;
        if (timeout != null ? !timeout.equals(that.timeout) :that.timeout != null) return false;
        if (tlsConfig != null ? !tlsConfig.equals(that.tlsConfig) :that.tlsConfig != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiVersion,  bearerTokenFile,  name,  namespace,  pathPrefix,  port,  scheme,  timeout,  tlsConfig,  super.hashCode());
    }

    public class PortNestedImpl<N> extends io.fabric8.kubernetes.api.model.IntOrStringFluentImpl<io.fabric8.openshift.api.model.monitoring.v1.AlertmanagerEndpointsFluent.PortNested<N>> implements io.fabric8.openshift.api.model.monitoring.v1.AlertmanagerEndpointsFluent.PortNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.IntOrStringBuilder builder;

            PortNestedImpl(io.fabric8.kubernetes.api.model.IntOrString item) {
                this.builder = new io.fabric8.kubernetes.api.model.IntOrStringBuilder(this, item);
                        
            }

            PortNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.IntOrStringBuilder(this);
                        
            }

            public N and() {
                return (N) AlertmanagerEndpointsFluentImpl.this.withPort(builder.build());
            }

            public N endPort() {
                return and();
            }
    }


    public class TlsConfigNestedImpl<N> extends io.fabric8.openshift.api.model.monitoring.v1.TLSConfigFluentImpl<io.fabric8.openshift.api.model.monitoring.v1.AlertmanagerEndpointsFluent.TlsConfigNested<N>> implements io.fabric8.openshift.api.model.monitoring.v1.AlertmanagerEndpointsFluent.TlsConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.monitoring.v1.TLSConfigBuilder builder;

            TlsConfigNestedImpl(io.fabric8.openshift.api.model.monitoring.v1.TLSConfig item) {
                this.builder = new io.fabric8.openshift.api.model.monitoring.v1.TLSConfigBuilder(this, item);
                        
            }

            TlsConfigNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.monitoring.v1.TLSConfigBuilder(this);
                        
            }

            public N and() {
                return (N) AlertmanagerEndpointsFluentImpl.this.withTlsConfig(builder.build());
            }

            public N endTlsConfig() {
                return and();
            }
    }


}
