package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PodMetricsEndpointBuilder extends io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluentImpl<io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpoint,io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointBuilder> {

    io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public PodMetricsEndpointBuilder() {
        this(true);
    }

    public PodMetricsEndpointBuilder(java.lang.Boolean validationEnabled) {
        this(new PodMetricsEndpoint(), validationEnabled);
    }

    public PodMetricsEndpointBuilder(io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent<?> fluent) {
        this(fluent, true);
    }

    public PodMetricsEndpointBuilder(io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new PodMetricsEndpoint(), validationEnabled);
    }

    public PodMetricsEndpointBuilder(io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpoint instance) {
        this(fluent, instance, true);
    }

    public PodMetricsEndpointBuilder(io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpoint instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withHonorLabels(instance.getHonorLabels()); 
        fluent.withHonorTimestamps(instance.getHonorTimestamps()); 
        fluent.withInterval(instance.getInterval()); 
        fluent.withMetricRelabelings(instance.getMetricRelabelings()); 
        fluent.withParams(instance.getParams()); 
        fluent.withPath(instance.getPath()); 
        fluent.withPort(instance.getPort()); 
        fluent.withProxyUrl(instance.getProxyUrl()); 
        fluent.withRelabelings(instance.getRelabelings()); 
        fluent.withScheme(instance.getScheme()); 
        fluent.withScrapeTimeout(instance.getScrapeTimeout()); 
        fluent.withTargetPort(instance.getTargetPort()); 
        this.validationEnabled = validationEnabled; 
    }

    public PodMetricsEndpointBuilder(io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpoint instance) {
        this(instance,true);
    }

    public PodMetricsEndpointBuilder(io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpoint instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withHonorLabels(instance.getHonorLabels()); 
        this.withHonorTimestamps(instance.getHonorTimestamps()); 
        this.withInterval(instance.getInterval()); 
        this.withMetricRelabelings(instance.getMetricRelabelings()); 
        this.withParams(instance.getParams()); 
        this.withPath(instance.getPath()); 
        this.withPort(instance.getPort()); 
        this.withProxyUrl(instance.getProxyUrl()); 
        this.withRelabelings(instance.getRelabelings()); 
        this.withScheme(instance.getScheme()); 
        this.withScrapeTimeout(instance.getScrapeTimeout()); 
        this.withTargetPort(instance.getTargetPort()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpoint build() {
        PodMetricsEndpoint buildable = new PodMetricsEndpoint(fluent.getHonorLabels(),fluent.getHonorTimestamps(),fluent.getInterval(),fluent.getMetricRelabelings(),fluent.getParams(),fluent.getPath(),fluent.getPort(),fluent.getProxyUrl(),fluent.getRelabelings(),fluent.getScheme(),fluent.getScrapeTimeout(),fluent.getTargetPort());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PodMetricsEndpointBuilder that = (PodMetricsEndpointBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
