package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class TLSConfigFluentImpl<A extends io.fabric8.openshift.api.model.monitoring.v1.TLSConfigFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.monitoring.v1.TLSConfigFluent<A> {

    private io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMapBuilder ca;
    private java.lang.String caFile;
    private io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMapBuilder cert;
    private java.lang.String certFile;
    private java.lang.Boolean insecureSkipVerify;
    private java.lang.String keyFile;
    private io.fabric8.kubernetes.api.model.SecretKeySelector keySecret;
    private java.lang.String serverName;

    public TLSConfigFluentImpl() {
    }

    public TLSConfigFluentImpl(io.fabric8.openshift.api.model.monitoring.v1.TLSConfig instance) {
        this.withCa(instance.getCa()); 
        this.withCaFile(instance.getCaFile()); 
        this.withCert(instance.getCert()); 
        this.withCertFile(instance.getCertFile()); 
        this.withInsecureSkipVerify(instance.getInsecureSkipVerify()); 
        this.withKeyFile(instance.getKeyFile()); 
        this.withKeySecret(instance.getKeySecret()); 
        this.withServerName(instance.getServerName()); 
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildCa instead.
     * @return The buildable object.
     */
        public io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMap getCa() {
        return this.ca!=null?this.ca.build():null;
    }

    public io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMap buildCa() {
        return this.ca!=null?this.ca.build():null;
    }

    public A withCa(io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMap ca) {
        _visitables.get("ca").remove(this.ca);
        if (ca!=null){ this.ca= new io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMapBuilder(ca); _visitables.get("ca").add(this.ca);} return (A) this;
    }

    public java.lang.Boolean hasCa() {
        return this.ca != null;
    }

    public io.fabric8.openshift.api.model.monitoring.v1.TLSConfigFluent.CaNested<A> withNewCa() {
        return new io.fabric8.openshift.api.model.monitoring.v1.TLSConfigFluentImpl.CaNestedImpl();
    }

    public io.fabric8.openshift.api.model.monitoring.v1.TLSConfigFluent.CaNested<A> withNewCaLike(io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMap item) {
        return new io.fabric8.openshift.api.model.monitoring.v1.TLSConfigFluentImpl.CaNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.monitoring.v1.TLSConfigFluent.CaNested<A> editCa() {
        return withNewCaLike(getCa());
    }

    public io.fabric8.openshift.api.model.monitoring.v1.TLSConfigFluent.CaNested<A> editOrNewCa() {
        return withNewCaLike(getCa() != null ? getCa(): new io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMapBuilder().build());
    }

    public io.fabric8.openshift.api.model.monitoring.v1.TLSConfigFluent.CaNested<A> editOrNewCaLike(io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMap item) {
        return withNewCaLike(getCa() != null ? getCa(): item);
    }

    public java.lang.String getCaFile() {
        return this.caFile;
    }

    public A withCaFile(java.lang.String caFile) {
        this.caFile=caFile; return (A) this;
    }

    public java.lang.Boolean hasCaFile() {
        return this.caFile != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withCaFile instead.
     */
        public A withNewCaFile(java.lang.String arg0) {
        return (A)withCaFile(new String(arg0));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildCert instead.
     * @return The buildable object.
     */
        public io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMap getCert() {
        return this.cert!=null?this.cert.build():null;
    }

    public io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMap buildCert() {
        return this.cert!=null?this.cert.build():null;
    }

    public A withCert(io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMap cert) {
        _visitables.get("cert").remove(this.cert);
        if (cert!=null){ this.cert= new io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMapBuilder(cert); _visitables.get("cert").add(this.cert);} return (A) this;
    }

    public java.lang.Boolean hasCert() {
        return this.cert != null;
    }

    public io.fabric8.openshift.api.model.monitoring.v1.TLSConfigFluent.CertNested<A> withNewCert() {
        return new io.fabric8.openshift.api.model.monitoring.v1.TLSConfigFluentImpl.CertNestedImpl();
    }

    public io.fabric8.openshift.api.model.monitoring.v1.TLSConfigFluent.CertNested<A> withNewCertLike(io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMap item) {
        return new io.fabric8.openshift.api.model.monitoring.v1.TLSConfigFluentImpl.CertNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.monitoring.v1.TLSConfigFluent.CertNested<A> editCert() {
        return withNewCertLike(getCert());
    }

    public io.fabric8.openshift.api.model.monitoring.v1.TLSConfigFluent.CertNested<A> editOrNewCert() {
        return withNewCertLike(getCert() != null ? getCert(): new io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMapBuilder().build());
    }

    public io.fabric8.openshift.api.model.monitoring.v1.TLSConfigFluent.CertNested<A> editOrNewCertLike(io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMap item) {
        return withNewCertLike(getCert() != null ? getCert(): item);
    }

    public java.lang.String getCertFile() {
        return this.certFile;
    }

    public A withCertFile(java.lang.String certFile) {
        this.certFile=certFile; return (A) this;
    }

    public java.lang.Boolean hasCertFile() {
        return this.certFile != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withCertFile instead.
     */
        public A withNewCertFile(java.lang.String arg0) {
        return (A)withCertFile(new String(arg0));
    }

    public java.lang.Boolean getInsecureSkipVerify() {
        return this.insecureSkipVerify;
    }

    public A withInsecureSkipVerify(java.lang.Boolean insecureSkipVerify) {
        this.insecureSkipVerify=insecureSkipVerify; return (A) this;
    }

    public java.lang.Boolean hasInsecureSkipVerify() {
        return this.insecureSkipVerify != null;
    }

    public java.lang.String getKeyFile() {
        return this.keyFile;
    }

    public A withKeyFile(java.lang.String keyFile) {
        this.keyFile=keyFile; return (A) this;
    }

    public java.lang.Boolean hasKeyFile() {
        return this.keyFile != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withKeyFile instead.
     */
        public A withNewKeyFile(java.lang.String arg0) {
        return (A)withKeyFile(new String(arg0));
    }

    public io.fabric8.kubernetes.api.model.SecretKeySelector getKeySecret() {
        return this.keySecret;
    }

    public A withKeySecret(io.fabric8.kubernetes.api.model.SecretKeySelector keySecret) {
        this.keySecret=keySecret; return (A) this;
    }

    public java.lang.Boolean hasKeySecret() {
        return this.keySecret != null;
    }

    public A withNewKeySecret(java.lang.String key,java.lang.String name,java.lang.Boolean optional) {
        return (A)withKeySecret(new SecretKeySelector(key, name, optional));
    }

    public java.lang.String getServerName() {
        return this.serverName;
    }

    public A withServerName(java.lang.String serverName) {
        this.serverName=serverName; return (A) this;
    }

    public java.lang.Boolean hasServerName() {
        return this.serverName != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withServerName instead.
     */
        public A withNewServerName(java.lang.String arg0) {
        return (A)withServerName(new String(arg0));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        TLSConfigFluentImpl that = (TLSConfigFluentImpl) o;
        if (ca != null ? !ca.equals(that.ca) :that.ca != null) return false;
        if (caFile != null ? !caFile.equals(that.caFile) :that.caFile != null) return false;
        if (cert != null ? !cert.equals(that.cert) :that.cert != null) return false;
        if (certFile != null ? !certFile.equals(that.certFile) :that.certFile != null) return false;
        if (insecureSkipVerify != null ? !insecureSkipVerify.equals(that.insecureSkipVerify) :that.insecureSkipVerify != null) return false;
        if (keyFile != null ? !keyFile.equals(that.keyFile) :that.keyFile != null) return false;
        if (keySecret != null ? !keySecret.equals(that.keySecret) :that.keySecret != null) return false;
        if (serverName != null ? !serverName.equals(that.serverName) :that.serverName != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(ca,  caFile,  cert,  certFile,  insecureSkipVerify,  keyFile,  keySecret,  serverName,  super.hashCode());
    }

    public class CaNestedImpl<N> extends io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMapFluentImpl<io.fabric8.openshift.api.model.monitoring.v1.TLSConfigFluent.CaNested<N>> implements io.fabric8.openshift.api.model.monitoring.v1.TLSConfigFluent.CaNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMapBuilder builder;

            CaNestedImpl(io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMap item) {
                this.builder = new io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMapBuilder(this, item);
                        
            }

            CaNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMapBuilder(this);
                        
            }

            public N and() {
                return (N) TLSConfigFluentImpl.this.withCa(builder.build());
            }

            public N endCa() {
                return and();
            }
    }


    public class CertNestedImpl<N> extends io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMapFluentImpl<io.fabric8.openshift.api.model.monitoring.v1.TLSConfigFluent.CertNested<N>> implements io.fabric8.openshift.api.model.monitoring.v1.TLSConfigFluent.CertNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMapBuilder builder;

            CertNestedImpl(io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMap item) {
                this.builder = new io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMapBuilder(this, item);
                        
            }

            CertNestedImpl() {
                this.builder = new io.fabric8.openshift.api.model.monitoring.v1.SecretOrConfigMapBuilder(this);
                        
            }

            public N and() {
                return (N) TLSConfigFluentImpl.this.withCert(builder.build());
            }

            public N endCert() {
                return and();
            }
    }


}
