package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PodMonitorListBuilder extends io.fabric8.openshift.api.model.monitoring.v1.PodMonitorListFluentImpl<io.fabric8.openshift.api.model.monitoring.v1.PodMonitorListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.monitoring.v1.PodMonitorList,io.fabric8.openshift.api.model.monitoring.v1.PodMonitorListBuilder> {

    io.fabric8.openshift.api.model.monitoring.v1.PodMonitorListFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public PodMonitorListBuilder() {
        this(true);
    }

    public PodMonitorListBuilder(java.lang.Boolean validationEnabled) {
        this(new PodMonitorList(), validationEnabled);
    }

    public PodMonitorListBuilder(io.fabric8.openshift.api.model.monitoring.v1.PodMonitorListFluent<?> fluent) {
        this(fluent, true);
    }

    public PodMonitorListBuilder(io.fabric8.openshift.api.model.monitoring.v1.PodMonitorListFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new PodMonitorList(), validationEnabled);
    }

    public PodMonitorListBuilder(io.fabric8.openshift.api.model.monitoring.v1.PodMonitorListFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.PodMonitorList instance) {
        this(fluent, instance, true);
    }

    public PodMonitorListBuilder(io.fabric8.openshift.api.model.monitoring.v1.PodMonitorListFluent<?> fluent,io.fabric8.openshift.api.model.monitoring.v1.PodMonitorList instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public PodMonitorListBuilder(io.fabric8.openshift.api.model.monitoring.v1.PodMonitorList instance) {
        this(instance,true);
    }

    public PodMonitorListBuilder(io.fabric8.openshift.api.model.monitoring.v1.PodMonitorList instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.monitoring.v1.PodMonitorList build() {
        PodMonitorList buildable = new PodMonitorList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PodMonitorListBuilder that = (PodMonitorListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
