package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.IntOrStringFluentImpl;
import java.util.Map;

public class PodMetricsEndpointFluentImpl<A extends io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent<A> {

    private java.lang.Boolean honorLabels;
    private java.lang.Boolean honorTimestamps;
    private java.lang.String interval;
    private java.util.List<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder> metricRelabelings =  new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder>();
    private java.util.Map<java.lang.String,java.util.ArrayList<java.lang.String>> params;
    private java.lang.String path;
    private java.lang.String port;
    private java.lang.String proxyUrl;
    private java.util.List<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder> relabelings =  new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder>();
    private java.lang.String scheme;
    private java.lang.String scrapeTimeout;
    private io.fabric8.kubernetes.api.model.IntOrStringBuilder targetPort;

    public PodMetricsEndpointFluentImpl() {
    }

    public PodMetricsEndpointFluentImpl(io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpoint instance) {
        this.withHonorLabels(instance.getHonorLabels()); 
        this.withHonorTimestamps(instance.getHonorTimestamps()); 
        this.withInterval(instance.getInterval()); 
        this.withMetricRelabelings(instance.getMetricRelabelings()); 
        this.withParams(instance.getParams()); 
        this.withPath(instance.getPath()); 
        this.withPort(instance.getPort()); 
        this.withProxyUrl(instance.getProxyUrl()); 
        this.withRelabelings(instance.getRelabelings()); 
        this.withScheme(instance.getScheme()); 
        this.withScrapeTimeout(instance.getScrapeTimeout()); 
        this.withTargetPort(instance.getTargetPort()); 
    }

    public java.lang.Boolean getHonorLabels() {
        return this.honorLabels;
    }

    public A withHonorLabels(java.lang.Boolean honorLabels) {
        this.honorLabels=honorLabels; return (A) this;
    }

    public java.lang.Boolean hasHonorLabels() {
        return this.honorLabels != null;
    }

    public java.lang.Boolean getHonorTimestamps() {
        return this.honorTimestamps;
    }

    public A withHonorTimestamps(java.lang.Boolean honorTimestamps) {
        this.honorTimestamps=honorTimestamps; return (A) this;
    }

    public java.lang.Boolean hasHonorTimestamps() {
        return this.honorTimestamps != null;
    }

    public java.lang.String getInterval() {
        return this.interval;
    }

    public A withInterval(java.lang.String interval) {
        this.interval=interval; return (A) this;
    }

    public java.lang.Boolean hasInterval() {
        return this.interval != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withInterval instead.
     */
        public A withNewInterval(java.lang.String arg0) {
        return (A)withInterval(new String(arg0));
    }

    public A addToMetricRelabelings(int index,io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item) {
        if (this.metricRelabelings == null) {this.metricRelabelings = new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder>();}
        io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder(item);_visitables.get("metricRelabelings").add(index >= 0 ? index : _visitables.get("metricRelabelings").size(), builder);this.metricRelabelings.add(index >= 0 ? index : metricRelabelings.size(), builder); return (A)this;
    }

    public A setToMetricRelabelings(int index,io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item) {
        if (this.metricRelabelings == null) {this.metricRelabelings = new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder>();}
        io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder(item);
        if (index < 0 || index >= _visitables.get("metricRelabelings").size()) { _visitables.get("metricRelabelings").add(builder); } else { _visitables.get("metricRelabelings").set(index, builder);}
        if (index < 0 || index >= metricRelabelings.size()) { metricRelabelings.add(builder); } else { metricRelabelings.set(index, builder);}
         return (A)this;
    }

    public A addToMetricRelabelings(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... items) {
        if (this.metricRelabelings == null) {this.metricRelabelings = new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder>();}
        for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item : items) {io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder(item);_visitables.get("metricRelabelings").add(builder);this.metricRelabelings.add(builder);} return (A)this;
    }

    public A addAllToMetricRelabelings(java.util.Collection<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig> items) {
        if (this.metricRelabelings == null) {this.metricRelabelings = new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder>();}
        for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item : items) {io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder(item);_visitables.get("metricRelabelings").add(builder);this.metricRelabelings.add(builder);} return (A)this;
    }

    public A removeFromMetricRelabelings(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... items) {
        for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item : items) {io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder(item);_visitables.get("metricRelabelings").remove(builder);if (this.metricRelabelings != null) {this.metricRelabelings.remove(builder);}} return (A)this;
    }

    public A removeAllFromMetricRelabelings(java.util.Collection<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig> items) {
        for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item : items) {io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder(item);_visitables.get("metricRelabelings").remove(builder);if (this.metricRelabelings != null) {this.metricRelabelings.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromMetricRelabelings(java.util.function.Predicate<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder> predicate) {
        if (metricRelabelings == null) return (A) this;
        final Iterator<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder> each = metricRelabelings.iterator();
        final List visitables = _visitables.get("metricRelabelings");
        while (each.hasNext()) {
          io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildMetricRelabelings instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig> getMetricRelabelings() {
        return build(metricRelabelings);
    }

    public java.util.List<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig> buildMetricRelabelings() {
        return build(metricRelabelings);
    }

    public io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig buildMetricRelabeling(int index) {
        return this.metricRelabelings.get(index).build();
    }

    public io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig buildFirstMetricRelabeling() {
        return this.metricRelabelings.get(0).build();
    }

    public io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig buildLastMetricRelabeling() {
        return this.metricRelabelings.get(metricRelabelings.size() - 1).build();
    }

    public io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig buildMatchingMetricRelabeling(java.util.function.Predicate<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder> predicate) {
        for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder item: metricRelabelings) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingMetricRelabeling(java.util.function.Predicate<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder> predicate) {
        for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder item: metricRelabelings) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withMetricRelabelings(java.util.List<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig> metricRelabelings) {
        if (this.metricRelabelings != null) { _visitables.get("metricRelabelings").removeAll(this.metricRelabelings);}
        if (metricRelabelings != null) {this.metricRelabelings = new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder>(); for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item : metricRelabelings){this.addToMetricRelabelings(item);}} else { this.metricRelabelings = null;} return (A) this;
    }

    public A withMetricRelabelings(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... metricRelabelings) {
        if (this.metricRelabelings != null) {this.metricRelabelings.clear();}
        if (metricRelabelings != null) {for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item :metricRelabelings){ this.addToMetricRelabelings(item);}} return (A) this;
    }

    public java.lang.Boolean hasMetricRelabelings() {
        return metricRelabelings != null && !metricRelabelings.isEmpty();
    }

    public io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.MetricRelabelingsNested<A> addNewMetricRelabeling() {
        return new io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluentImpl.MetricRelabelingsNestedImpl();
    }

    public io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.MetricRelabelingsNested<A> addNewMetricRelabelingLike(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item) {
        return new io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluentImpl.MetricRelabelingsNestedImpl(-1, item);
    }

    public io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.MetricRelabelingsNested<A> setNewMetricRelabelingLike(int index,io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item) {
        return new io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluentImpl.MetricRelabelingsNestedImpl(index, item);
    }

    public io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.MetricRelabelingsNested<A> editMetricRelabeling(int index) {
        if (metricRelabelings.size() <= index) throw new RuntimeException("Can't edit metricRelabelings. Index exceeds size.");
        return setNewMetricRelabelingLike(index, buildMetricRelabeling(index));
    }

    public io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.MetricRelabelingsNested<A> editFirstMetricRelabeling() {
        if (metricRelabelings.size() == 0) throw new RuntimeException("Can't edit first metricRelabelings. The list is empty.");
        return setNewMetricRelabelingLike(0, buildMetricRelabeling(0));
    }

    public io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.MetricRelabelingsNested<A> editLastMetricRelabeling() {
        int index = metricRelabelings.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last metricRelabelings. The list is empty.");
        return setNewMetricRelabelingLike(index, buildMetricRelabeling(index));
    }

    public io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.MetricRelabelingsNested<A> editMatchingMetricRelabeling(java.util.function.Predicate<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder> predicate) {
        int index = -1;
        for (int i=0;i<metricRelabelings.size();i++) { 
        if (predicate.test(metricRelabelings.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching metricRelabelings. No match found.");
        return setNewMetricRelabelingLike(index, buildMetricRelabeling(index));
    }

    public A addToParams(java.lang.String key,java.util.ArrayList<java.lang.String> value) {
        if(this.params == null && key != null && value != null) { this.params = new java.util.LinkedHashMap<java.lang.String,java.util.ArrayList<java.lang.String>>(); }
        if(key != null && value != null) {this.params.put(key, value);} return (A)this;
    }

    public A addToParams(java.util.Map<java.lang.String,java.util.ArrayList<java.lang.String>> map) {
        if(this.params == null && map != null) { this.params = new java.util.LinkedHashMap<java.lang.String,java.util.ArrayList<java.lang.String>>(); }
        if(map != null) { this.params.putAll(map);} return (A)this;
    }

    public A removeFromParams(java.lang.String key) {
        if(this.params == null) { return (A) this; }
        if(key != null && this.params != null) {this.params.remove(key);} return (A)this;
    }

    public A removeFromParams(java.util.Map<java.lang.String,java.util.ArrayList<java.lang.String>> map) {
        if(this.params == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.params != null){this.params.remove(key);}}} return (A)this;
    }

    public java.util.Map<java.lang.String,java.util.ArrayList<java.lang.String>> getParams() {
        return this.params;
    }

    public <K,V>A withParams(java.util.Map<java.lang.String,java.util.ArrayList<java.lang.String>> params) {
        if (params == null) { this.params =  null;} else {this.params = new java.util.LinkedHashMap<java.lang.String,java.util.ArrayList<java.lang.String>>(params);} return (A) this;
    }

    public java.lang.Boolean hasParams() {
        return this.params != null;
    }

    public java.lang.String getPath() {
        return this.path;
    }

    public A withPath(java.lang.String path) {
        this.path=path; return (A) this;
    }

    public java.lang.Boolean hasPath() {
        return this.path != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withPath instead.
     */
        public A withNewPath(java.lang.String arg0) {
        return (A)withPath(new String(arg0));
    }

    public java.lang.String getPort() {
        return this.port;
    }

    public A withPort(java.lang.String port) {
        this.port=port; return (A) this;
    }

    public java.lang.Boolean hasPort() {
        return this.port != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withPort instead.
     */
        public A withNewPort(java.lang.String arg0) {
        return (A)withPort(new String(arg0));
    }

    public java.lang.String getProxyUrl() {
        return this.proxyUrl;
    }

    public A withProxyUrl(java.lang.String proxyUrl) {
        this.proxyUrl=proxyUrl; return (A) this;
    }

    public java.lang.Boolean hasProxyUrl() {
        return this.proxyUrl != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withProxyUrl instead.
     */
        public A withNewProxyUrl(java.lang.String arg0) {
        return (A)withProxyUrl(new String(arg0));
    }

    public A addToRelabelings(int index,io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item) {
        if (this.relabelings == null) {this.relabelings = new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder>();}
        io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder(item);_visitables.get("relabelings").add(index >= 0 ? index : _visitables.get("relabelings").size(), builder);this.relabelings.add(index >= 0 ? index : relabelings.size(), builder); return (A)this;
    }

    public A setToRelabelings(int index,io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item) {
        if (this.relabelings == null) {this.relabelings = new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder>();}
        io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder(item);
        if (index < 0 || index >= _visitables.get("relabelings").size()) { _visitables.get("relabelings").add(builder); } else { _visitables.get("relabelings").set(index, builder);}
        if (index < 0 || index >= relabelings.size()) { relabelings.add(builder); } else { relabelings.set(index, builder);}
         return (A)this;
    }

    public A addToRelabelings(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... items) {
        if (this.relabelings == null) {this.relabelings = new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder>();}
        for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item : items) {io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder(item);_visitables.get("relabelings").add(builder);this.relabelings.add(builder);} return (A)this;
    }

    public A addAllToRelabelings(java.util.Collection<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig> items) {
        if (this.relabelings == null) {this.relabelings = new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder>();}
        for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item : items) {io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder(item);_visitables.get("relabelings").add(builder);this.relabelings.add(builder);} return (A)this;
    }

    public A removeFromRelabelings(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... items) {
        for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item : items) {io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder(item);_visitables.get("relabelings").remove(builder);if (this.relabelings != null) {this.relabelings.remove(builder);}} return (A)this;
    }

    public A removeAllFromRelabelings(java.util.Collection<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig> items) {
        for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item : items) {io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder = new io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder(item);_visitables.get("relabelings").remove(builder);if (this.relabelings != null) {this.relabelings.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromRelabelings(java.util.function.Predicate<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder> predicate) {
        if (relabelings == null) return (A) this;
        final Iterator<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder> each = relabelings.iterator();
        final List visitables = _visitables.get("relabelings");
        while (each.hasNext()) {
          io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildRelabelings instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig> getRelabelings() {
        return build(relabelings);
    }

    public java.util.List<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig> buildRelabelings() {
        return build(relabelings);
    }

    public io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig buildRelabeling(int index) {
        return this.relabelings.get(index).build();
    }

    public io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig buildFirstRelabeling() {
        return this.relabelings.get(0).build();
    }

    public io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig buildLastRelabeling() {
        return this.relabelings.get(relabelings.size() - 1).build();
    }

    public io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig buildMatchingRelabeling(java.util.function.Predicate<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder> predicate) {
        for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder item: relabelings) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingRelabeling(java.util.function.Predicate<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder> predicate) {
        for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder item: relabelings) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withRelabelings(java.util.List<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig> relabelings) {
        if (this.relabelings != null) { _visitables.get("relabelings").removeAll(this.relabelings);}
        if (relabelings != null) {this.relabelings = new java.util.ArrayList<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder>(); for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item : relabelings){this.addToRelabelings(item);}} else { this.relabelings = null;} return (A) this;
    }

    public A withRelabelings(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig... relabelings) {
        if (this.relabelings != null) {this.relabelings.clear();}
        if (relabelings != null) {for (io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item :relabelings){ this.addToRelabelings(item);}} return (A) this;
    }

    public java.lang.Boolean hasRelabelings() {
        return relabelings != null && !relabelings.isEmpty();
    }

    public io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.RelabelingsNested<A> addNewRelabeling() {
        return new io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluentImpl.RelabelingsNestedImpl();
    }

    public io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.RelabelingsNested<A> addNewRelabelingLike(io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item) {
        return new io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluentImpl.RelabelingsNestedImpl(-1, item);
    }

    public io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.RelabelingsNested<A> setNewRelabelingLike(int index,io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item) {
        return new io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluentImpl.RelabelingsNestedImpl(index, item);
    }

    public io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.RelabelingsNested<A> editRelabeling(int index) {
        if (relabelings.size() <= index) throw new RuntimeException("Can't edit relabelings. Index exceeds size.");
        return setNewRelabelingLike(index, buildRelabeling(index));
    }

    public io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.RelabelingsNested<A> editFirstRelabeling() {
        if (relabelings.size() == 0) throw new RuntimeException("Can't edit first relabelings. The list is empty.");
        return setNewRelabelingLike(0, buildRelabeling(0));
    }

    public io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.RelabelingsNested<A> editLastRelabeling() {
        int index = relabelings.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last relabelings. The list is empty.");
        return setNewRelabelingLike(index, buildRelabeling(index));
    }

    public io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.RelabelingsNested<A> editMatchingRelabeling(java.util.function.Predicate<io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder> predicate) {
        int index = -1;
        for (int i=0;i<relabelings.size();i++) { 
        if (predicate.test(relabelings.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching relabelings. No match found.");
        return setNewRelabelingLike(index, buildRelabeling(index));
    }

    public java.lang.String getScheme() {
        return this.scheme;
    }

    public A withScheme(java.lang.String scheme) {
        this.scheme=scheme; return (A) this;
    }

    public java.lang.Boolean hasScheme() {
        return this.scheme != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withScheme instead.
     */
        public A withNewScheme(java.lang.String arg0) {
        return (A)withScheme(new String(arg0));
    }

    public java.lang.String getScrapeTimeout() {
        return this.scrapeTimeout;
    }

    public A withScrapeTimeout(java.lang.String scrapeTimeout) {
        this.scrapeTimeout=scrapeTimeout; return (A) this;
    }

    public java.lang.Boolean hasScrapeTimeout() {
        return this.scrapeTimeout != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withScrapeTimeout instead.
     */
        public A withNewScrapeTimeout(java.lang.String arg0) {
        return (A)withScrapeTimeout(new String(arg0));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildTargetPort instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.IntOrString getTargetPort() {
        return this.targetPort!=null?this.targetPort.build():null;
    }

    public io.fabric8.kubernetes.api.model.IntOrString buildTargetPort() {
        return this.targetPort!=null?this.targetPort.build():null;
    }

    public A withTargetPort(io.fabric8.kubernetes.api.model.IntOrString targetPort) {
        _visitables.get("targetPort").remove(this.targetPort);
        if (targetPort!=null){ this.targetPort= new io.fabric8.kubernetes.api.model.IntOrStringBuilder(targetPort); _visitables.get("targetPort").add(this.targetPort);} return (A) this;
    }

    public java.lang.Boolean hasTargetPort() {
        return this.targetPort != null;
    }

    public A withNewTargetPort(java.lang.Integer intVal) {
        return (A)withTargetPort(new IntOrString(intVal));
    }

    public A withNewTargetPort(java.lang.String strVal) {
        return (A)withTargetPort(new IntOrString(strVal));
    }

    public io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.TargetPortNested<A> withNewTargetPort() {
        return new io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluentImpl.TargetPortNestedImpl();
    }

    public io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.TargetPortNested<A> withNewTargetPortLike(io.fabric8.kubernetes.api.model.IntOrString item) {
        return new io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluentImpl.TargetPortNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.TargetPortNested<A> editTargetPort() {
        return withNewTargetPortLike(getTargetPort());
    }

    public io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.TargetPortNested<A> editOrNewTargetPort() {
        return withNewTargetPortLike(getTargetPort() != null ? getTargetPort(): new io.fabric8.kubernetes.api.model.IntOrStringBuilder().build());
    }

    public io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.TargetPortNested<A> editOrNewTargetPortLike(io.fabric8.kubernetes.api.model.IntOrString item) {
        return withNewTargetPortLike(getTargetPort() != null ? getTargetPort(): item);
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PodMetricsEndpointFluentImpl that = (PodMetricsEndpointFluentImpl) o;
        if (honorLabels != null ? !honorLabels.equals(that.honorLabels) :that.honorLabels != null) return false;
        if (honorTimestamps != null ? !honorTimestamps.equals(that.honorTimestamps) :that.honorTimestamps != null) return false;
        if (interval != null ? !interval.equals(that.interval) :that.interval != null) return false;
        if (metricRelabelings != null ? !metricRelabelings.equals(that.metricRelabelings) :that.metricRelabelings != null) return false;
        if (params != null ? !params.equals(that.params) :that.params != null) return false;
        if (path != null ? !path.equals(that.path) :that.path != null) return false;
        if (port != null ? !port.equals(that.port) :that.port != null) return false;
        if (proxyUrl != null ? !proxyUrl.equals(that.proxyUrl) :that.proxyUrl != null) return false;
        if (relabelings != null ? !relabelings.equals(that.relabelings) :that.relabelings != null) return false;
        if (scheme != null ? !scheme.equals(that.scheme) :that.scheme != null) return false;
        if (scrapeTimeout != null ? !scrapeTimeout.equals(that.scrapeTimeout) :that.scrapeTimeout != null) return false;
        if (targetPort != null ? !targetPort.equals(that.targetPort) :that.targetPort != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(honorLabels,  honorTimestamps,  interval,  metricRelabelings,  params,  path,  port,  proxyUrl,  relabelings,  scheme,  scrapeTimeout,  targetPort,  super.hashCode());
    }

    public class MetricRelabelingsNestedImpl<N> extends io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigFluentImpl<io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.MetricRelabelingsNested<N>> implements io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.MetricRelabelingsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder;
        private final int index;

            MetricRelabelingsNestedImpl(int index,io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item) {
                this.index = index;
                this.builder = new io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder(this, item);
                        
            }

            MetricRelabelingsNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder(this);
                        
            }

            public N and() {
                return (N) PodMetricsEndpointFluentImpl.this.setToMetricRelabelings(index,builder.build());
            }

            public N endMetricRelabeling() {
                return and();
            }
    }


    public class RelabelingsNestedImpl<N> extends io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigFluentImpl<io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.RelabelingsNested<N>> implements io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.RelabelingsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder builder;
        private final int index;

            RelabelingsNestedImpl(int index,io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig item) {
                this.index = index;
                this.builder = new io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder(this, item);
                        
            }

            RelabelingsNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder(this);
                        
            }

            public N and() {
                return (N) PodMetricsEndpointFluentImpl.this.setToRelabelings(index,builder.build());
            }

            public N endRelabeling() {
                return and();
            }
    }


    public class TargetPortNestedImpl<N> extends io.fabric8.kubernetes.api.model.IntOrStringFluentImpl<io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.TargetPortNested<N>> implements io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent.TargetPortNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.IntOrStringBuilder builder;

            TargetPortNestedImpl(io.fabric8.kubernetes.api.model.IntOrString item) {
                this.builder = new io.fabric8.kubernetes.api.model.IntOrStringBuilder(this, item);
                        
            }

            TargetPortNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.IntOrStringBuilder(this);
                        
            }

            public N and() {
                return (N) PodMetricsEndpointFluentImpl.this.withTargetPort(builder.build());
            }

            public N endTargetPort() {
                return and();
            }
    }


}
