package io.fabric8.openshift.api.model.monitoring.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluentImpl;

public class ThanosSpecFluentImpl<A extends ThanosSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ThanosSpecFluent<A> {

    private String baseImage;
    private TLSConfigBuilder grpcServerTlsConfig;
    private String image;
    private Boolean listenLocal;
    private String logFormat;
    private String logLevel;
    private String minTime;
    private SecretKeySelector objectStorageConfig;
    private ResourceRequirementsBuilder resources;
    private String sha;
    private String tag;
    private SecretKeySelector tracingConfig;
    private String version;

    public ThanosSpecFluentImpl() {
    }

    public ThanosSpecFluentImpl(ThanosSpec instance) {
        this.withBaseImage(instance.getBaseImage()); 
        this.withGrpcServerTlsConfig(instance.getGrpcServerTlsConfig()); 
        this.withImage(instance.getImage()); 
        this.withListenLocal(instance.getListenLocal()); 
        this.withLogFormat(instance.getLogFormat()); 
        this.withLogLevel(instance.getLogLevel()); 
        this.withMinTime(instance.getMinTime()); 
        this.withObjectStorageConfig(instance.getObjectStorageConfig()); 
        this.withResources(instance.getResources()); 
        this.withSha(instance.getSha()); 
        this.withTag(instance.getTag()); 
        this.withTracingConfig(instance.getTracingConfig()); 
        this.withVersion(instance.getVersion()); 
    }

    public String getBaseImage() {
        return this.baseImage;
    }

    public A withBaseImage(String baseImage) {
        this.baseImage=baseImage; return (A) this;
    }

    public Boolean hasBaseImage() {
        return this.baseImage != null;
    }

    public A withNewBaseImage(StringBuilder arg1) {
        return (A)withBaseImage(new String(arg1));
    }

    public A withNewBaseImage(int[] arg1,int arg2,int arg3) {
        return (A)withBaseImage(new String(arg1, arg2, arg3));
    }

    public A withNewBaseImage(char[] arg1) {
        return (A)withBaseImage(new String(arg1));
    }

    public A withNewBaseImage(StringBuffer arg1) {
        return (A)withBaseImage(new String(arg1));
    }

    public A withNewBaseImage(byte[] arg1,int arg2) {
        return (A)withBaseImage(new String(arg1, arg2));
    }

    public A withNewBaseImage(byte[] arg1) {
        return (A)withBaseImage(new String(arg1));
    }

    public A withNewBaseImage(char[] arg1,int arg2,int arg3) {
        return (A)withBaseImage(new String(arg1, arg2, arg3));
    }

    public A withNewBaseImage(byte[] arg1,int arg2,int arg3) {
        return (A)withBaseImage(new String(arg1, arg2, arg3));
    }

    public A withNewBaseImage(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withBaseImage(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewBaseImage(String arg1) {
        return (A)withBaseImage(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildGrpcServerTlsConfig instead.
 * @return The buildable object.
 */
@Deprecated public TLSConfig getGrpcServerTlsConfig() {
        return this.grpcServerTlsConfig!=null?this.grpcServerTlsConfig.build():null;
    }

    public TLSConfig buildGrpcServerTlsConfig() {
        return this.grpcServerTlsConfig!=null?this.grpcServerTlsConfig.build():null;
    }

    public A withGrpcServerTlsConfig(TLSConfig grpcServerTlsConfig) {
        _visitables.get("grpcServerTlsConfig").remove(this.grpcServerTlsConfig);
        if (grpcServerTlsConfig!=null){ this.grpcServerTlsConfig= new TLSConfigBuilder(grpcServerTlsConfig); _visitables.get("grpcServerTlsConfig").add(this.grpcServerTlsConfig);} return (A) this;
    }

    public Boolean hasGrpcServerTlsConfig() {
        return this.grpcServerTlsConfig != null;
    }

    public ThanosSpecFluent.GrpcServerTlsConfigNested<A> withNewGrpcServerTlsConfig() {
        return new GrpcServerTlsConfigNestedImpl();
    }

    public ThanosSpecFluent.GrpcServerTlsConfigNested<A> withNewGrpcServerTlsConfigLike(TLSConfig item) {
        return new GrpcServerTlsConfigNestedImpl(item);
    }

    public ThanosSpecFluent.GrpcServerTlsConfigNested<A> editGrpcServerTlsConfig() {
        return withNewGrpcServerTlsConfigLike(getGrpcServerTlsConfig());
    }

    public ThanosSpecFluent.GrpcServerTlsConfigNested<A> editOrNewGrpcServerTlsConfig() {
        return withNewGrpcServerTlsConfigLike(getGrpcServerTlsConfig() != null ? getGrpcServerTlsConfig(): new TLSConfigBuilder().build());
    }

    public ThanosSpecFluent.GrpcServerTlsConfigNested<A> editOrNewGrpcServerTlsConfigLike(TLSConfig item) {
        return withNewGrpcServerTlsConfigLike(getGrpcServerTlsConfig() != null ? getGrpcServerTlsConfig(): item);
    }

    public String getImage() {
        return this.image;
    }

    public A withImage(String image) {
        this.image=image; return (A) this;
    }

    public Boolean hasImage() {
        return this.image != null;
    }

    public A withNewImage(StringBuilder arg1) {
        return (A)withImage(new String(arg1));
    }

    public A withNewImage(int[] arg1,int arg2,int arg3) {
        return (A)withImage(new String(arg1, arg2, arg3));
    }

    public A withNewImage(char[] arg1) {
        return (A)withImage(new String(arg1));
    }

    public A withNewImage(StringBuffer arg1) {
        return (A)withImage(new String(arg1));
    }

    public A withNewImage(byte[] arg1,int arg2) {
        return (A)withImage(new String(arg1, arg2));
    }

    public A withNewImage(byte[] arg1) {
        return (A)withImage(new String(arg1));
    }

    public A withNewImage(char[] arg1,int arg2,int arg3) {
        return (A)withImage(new String(arg1, arg2, arg3));
    }

    public A withNewImage(byte[] arg1,int arg2,int arg3) {
        return (A)withImage(new String(arg1, arg2, arg3));
    }

    public A withNewImage(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withImage(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewImage(String arg1) {
        return (A)withImage(new String(arg1));
    }

    public Boolean getListenLocal() {
        return this.listenLocal;
    }

    public A withListenLocal(Boolean listenLocal) {
        this.listenLocal=listenLocal; return (A) this;
    }

    public Boolean hasListenLocal() {
        return this.listenLocal != null;
    }

    public A withNewListenLocal(String arg1) {
        return (A)withListenLocal(new Boolean(arg1));
    }

    public A withNewListenLocal(boolean arg1) {
        return (A)withListenLocal(new Boolean(arg1));
    }

    public String getLogFormat() {
        return this.logFormat;
    }

    public A withLogFormat(String logFormat) {
        this.logFormat=logFormat; return (A) this;
    }

    public Boolean hasLogFormat() {
        return this.logFormat != null;
    }

    public A withNewLogFormat(StringBuilder arg1) {
        return (A)withLogFormat(new String(arg1));
    }

    public A withNewLogFormat(int[] arg1,int arg2,int arg3) {
        return (A)withLogFormat(new String(arg1, arg2, arg3));
    }

    public A withNewLogFormat(char[] arg1) {
        return (A)withLogFormat(new String(arg1));
    }

    public A withNewLogFormat(StringBuffer arg1) {
        return (A)withLogFormat(new String(arg1));
    }

    public A withNewLogFormat(byte[] arg1,int arg2) {
        return (A)withLogFormat(new String(arg1, arg2));
    }

    public A withNewLogFormat(byte[] arg1) {
        return (A)withLogFormat(new String(arg1));
    }

    public A withNewLogFormat(char[] arg1,int arg2,int arg3) {
        return (A)withLogFormat(new String(arg1, arg2, arg3));
    }

    public A withNewLogFormat(byte[] arg1,int arg2,int arg3) {
        return (A)withLogFormat(new String(arg1, arg2, arg3));
    }

    public A withNewLogFormat(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withLogFormat(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewLogFormat(String arg1) {
        return (A)withLogFormat(new String(arg1));
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public A withLogLevel(String logLevel) {
        this.logLevel=logLevel; return (A) this;
    }

    public Boolean hasLogLevel() {
        return this.logLevel != null;
    }

    public A withNewLogLevel(StringBuilder arg1) {
        return (A)withLogLevel(new String(arg1));
    }

    public A withNewLogLevel(int[] arg1,int arg2,int arg3) {
        return (A)withLogLevel(new String(arg1, arg2, arg3));
    }

    public A withNewLogLevel(char[] arg1) {
        return (A)withLogLevel(new String(arg1));
    }

    public A withNewLogLevel(StringBuffer arg1) {
        return (A)withLogLevel(new String(arg1));
    }

    public A withNewLogLevel(byte[] arg1,int arg2) {
        return (A)withLogLevel(new String(arg1, arg2));
    }

    public A withNewLogLevel(byte[] arg1) {
        return (A)withLogLevel(new String(arg1));
    }

    public A withNewLogLevel(char[] arg1,int arg2,int arg3) {
        return (A)withLogLevel(new String(arg1, arg2, arg3));
    }

    public A withNewLogLevel(byte[] arg1,int arg2,int arg3) {
        return (A)withLogLevel(new String(arg1, arg2, arg3));
    }

    public A withNewLogLevel(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withLogLevel(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewLogLevel(String arg1) {
        return (A)withLogLevel(new String(arg1));
    }

    public String getMinTime() {
        return this.minTime;
    }

    public A withMinTime(String minTime) {
        this.minTime=minTime; return (A) this;
    }

    public Boolean hasMinTime() {
        return this.minTime != null;
    }

    public A withNewMinTime(StringBuilder arg1) {
        return (A)withMinTime(new String(arg1));
    }

    public A withNewMinTime(int[] arg1,int arg2,int arg3) {
        return (A)withMinTime(new String(arg1, arg2, arg3));
    }

    public A withNewMinTime(char[] arg1) {
        return (A)withMinTime(new String(arg1));
    }

    public A withNewMinTime(StringBuffer arg1) {
        return (A)withMinTime(new String(arg1));
    }

    public A withNewMinTime(byte[] arg1,int arg2) {
        return (A)withMinTime(new String(arg1, arg2));
    }

    public A withNewMinTime(byte[] arg1) {
        return (A)withMinTime(new String(arg1));
    }

    public A withNewMinTime(char[] arg1,int arg2,int arg3) {
        return (A)withMinTime(new String(arg1, arg2, arg3));
    }

    public A withNewMinTime(byte[] arg1,int arg2,int arg3) {
        return (A)withMinTime(new String(arg1, arg2, arg3));
    }

    public A withNewMinTime(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withMinTime(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewMinTime(String arg1) {
        return (A)withMinTime(new String(arg1));
    }

    public SecretKeySelector getObjectStorageConfig() {
        return this.objectStorageConfig;
    }

    public A withObjectStorageConfig(SecretKeySelector objectStorageConfig) {
        this.objectStorageConfig=objectStorageConfig; return (A) this;
    }

    public Boolean hasObjectStorageConfig() {
        return this.objectStorageConfig != null;
    }

    public A withNewObjectStorageConfig(String key,String name,Boolean optional) {
        return (A)withObjectStorageConfig(new SecretKeySelector(key, name, optional));
    }

    
/**
 * This method has been deprecated, please use method buildResources instead.
 * @return The buildable object.
 */
@Deprecated public ResourceRequirements getResources() {
        return this.resources!=null?this.resources.build():null;
    }

    public ResourceRequirements buildResources() {
        return this.resources!=null?this.resources.build():null;
    }

    public A withResources(ResourceRequirements resources) {
        _visitables.get("resources").remove(this.resources);
        if (resources!=null){ this.resources= new ResourceRequirementsBuilder(resources); _visitables.get("resources").add(this.resources);} return (A) this;
    }

    public Boolean hasResources() {
        return this.resources != null;
    }

    public ThanosSpecFluent.ResourcesNested<A> withNewResources() {
        return new ResourcesNestedImpl();
    }

    public ThanosSpecFluent.ResourcesNested<A> withNewResourcesLike(ResourceRequirements item) {
        return new ResourcesNestedImpl(item);
    }

    public ThanosSpecFluent.ResourcesNested<A> editResources() {
        return withNewResourcesLike(getResources());
    }

    public ThanosSpecFluent.ResourcesNested<A> editOrNewResources() {
        return withNewResourcesLike(getResources() != null ? getResources(): new ResourceRequirementsBuilder().build());
    }

    public ThanosSpecFluent.ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item) {
        return withNewResourcesLike(getResources() != null ? getResources(): item);
    }

    public String getSha() {
        return this.sha;
    }

    public A withSha(String sha) {
        this.sha=sha; return (A) this;
    }

    public Boolean hasSha() {
        return this.sha != null;
    }

    public A withNewSha(StringBuilder arg1) {
        return (A)withSha(new String(arg1));
    }

    public A withNewSha(int[] arg1,int arg2,int arg3) {
        return (A)withSha(new String(arg1, arg2, arg3));
    }

    public A withNewSha(char[] arg1) {
        return (A)withSha(new String(arg1));
    }

    public A withNewSha(StringBuffer arg1) {
        return (A)withSha(new String(arg1));
    }

    public A withNewSha(byte[] arg1,int arg2) {
        return (A)withSha(new String(arg1, arg2));
    }

    public A withNewSha(byte[] arg1) {
        return (A)withSha(new String(arg1));
    }

    public A withNewSha(char[] arg1,int arg2,int arg3) {
        return (A)withSha(new String(arg1, arg2, arg3));
    }

    public A withNewSha(byte[] arg1,int arg2,int arg3) {
        return (A)withSha(new String(arg1, arg2, arg3));
    }

    public A withNewSha(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withSha(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewSha(String arg1) {
        return (A)withSha(new String(arg1));
    }

    public String getTag() {
        return this.tag;
    }

    public A withTag(String tag) {
        this.tag=tag; return (A) this;
    }

    public Boolean hasTag() {
        return this.tag != null;
    }

    public A withNewTag(StringBuilder arg1) {
        return (A)withTag(new String(arg1));
    }

    public A withNewTag(int[] arg1,int arg2,int arg3) {
        return (A)withTag(new String(arg1, arg2, arg3));
    }

    public A withNewTag(char[] arg1) {
        return (A)withTag(new String(arg1));
    }

    public A withNewTag(StringBuffer arg1) {
        return (A)withTag(new String(arg1));
    }

    public A withNewTag(byte[] arg1,int arg2) {
        return (A)withTag(new String(arg1, arg2));
    }

    public A withNewTag(byte[] arg1) {
        return (A)withTag(new String(arg1));
    }

    public A withNewTag(char[] arg1,int arg2,int arg3) {
        return (A)withTag(new String(arg1, arg2, arg3));
    }

    public A withNewTag(byte[] arg1,int arg2,int arg3) {
        return (A)withTag(new String(arg1, arg2, arg3));
    }

    public A withNewTag(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withTag(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewTag(String arg1) {
        return (A)withTag(new String(arg1));
    }

    public SecretKeySelector getTracingConfig() {
        return this.tracingConfig;
    }

    public A withTracingConfig(SecretKeySelector tracingConfig) {
        this.tracingConfig=tracingConfig; return (A) this;
    }

    public Boolean hasTracingConfig() {
        return this.tracingConfig != null;
    }

    public A withNewTracingConfig(String key,String name,Boolean optional) {
        return (A)withTracingConfig(new SecretKeySelector(key, name, optional));
    }

    public String getVersion() {
        return this.version;
    }

    public A withVersion(String version) {
        this.version=version; return (A) this;
    }

    public Boolean hasVersion() {
        return this.version != null;
    }

    public A withNewVersion(StringBuilder arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(int[] arg1,int arg2,int arg3) {
        return (A)withVersion(new String(arg1, arg2, arg3));
    }

    public A withNewVersion(char[] arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(StringBuffer arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(byte[] arg1,int arg2) {
        return (A)withVersion(new String(arg1, arg2));
    }

    public A withNewVersion(byte[] arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(char[] arg1,int arg2,int arg3) {
        return (A)withVersion(new String(arg1, arg2, arg3));
    }

    public A withNewVersion(byte[] arg1,int arg2,int arg3) {
        return (A)withVersion(new String(arg1, arg2, arg3));
    }

    public A withNewVersion(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withVersion(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewVersion(String arg1) {
        return (A)withVersion(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ThanosSpecFluentImpl that = (ThanosSpecFluentImpl) o;
        if (baseImage != null ? !baseImage.equals(that.baseImage) :that.baseImage != null) return false;
        if (grpcServerTlsConfig != null ? !grpcServerTlsConfig.equals(that.grpcServerTlsConfig) :that.grpcServerTlsConfig != null) return false;
        if (image != null ? !image.equals(that.image) :that.image != null) return false;
        if (listenLocal != null ? !listenLocal.equals(that.listenLocal) :that.listenLocal != null) return false;
        if (logFormat != null ? !logFormat.equals(that.logFormat) :that.logFormat != null) return false;
        if (logLevel != null ? !logLevel.equals(that.logLevel) :that.logLevel != null) return false;
        if (minTime != null ? !minTime.equals(that.minTime) :that.minTime != null) return false;
        if (objectStorageConfig != null ? !objectStorageConfig.equals(that.objectStorageConfig) :that.objectStorageConfig != null) return false;
        if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
        if (sha != null ? !sha.equals(that.sha) :that.sha != null) return false;
        if (tag != null ? !tag.equals(that.tag) :that.tag != null) return false;
        if (tracingConfig != null ? !tracingConfig.equals(that.tracingConfig) :that.tracingConfig != null) return false;
        if (version != null ? !version.equals(that.version) :that.version != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(baseImage,  grpcServerTlsConfig,  image,  listenLocal,  logFormat,  logLevel,  minTime,  objectStorageConfig,  resources,  sha,  tag,  tracingConfig,  version,  super.hashCode());
    }

    public class GrpcServerTlsConfigNestedImpl<N> extends TLSConfigFluentImpl<ThanosSpecFluent.GrpcServerTlsConfigNested<N>> implements ThanosSpecFluent.GrpcServerTlsConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final TLSConfigBuilder builder;

            GrpcServerTlsConfigNestedImpl(TLSConfig item) {
                this.builder = new TLSConfigBuilder(this, item);
                        
            }

            GrpcServerTlsConfigNestedImpl() {
                this.builder = new TLSConfigBuilder(this);
                        
            }

            public N and() {
                return (N) ThanosSpecFluentImpl.this.withGrpcServerTlsConfig(builder.build());
            }

            public N endGrpcServerTlsConfig() {
                return and();
            }
    }


    public class ResourcesNestedImpl<N> extends ResourceRequirementsFluentImpl<ThanosSpecFluent.ResourcesNested<N>> implements ThanosSpecFluent.ResourcesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ResourceRequirementsBuilder builder;

            ResourcesNestedImpl(ResourceRequirements item) {
                this.builder = new ResourceRequirementsBuilder(this, item);
                        
            }

            ResourcesNestedImpl() {
                this.builder = new ResourceRequirementsBuilder(this);
                        
            }

            public N and() {
                return (N) ThanosSpecFluentImpl.this.withResources(builder.build());
            }

            public N endResources() {
                return and();
            }
    }


}
