package io.fabric8.openshift.api.model.monitoring.v1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface ThanosSpecFluent<A extends ThanosSpecFluent<A>> extends Fluent<A> {


    public String getBaseImage();
    public A withBaseImage(String baseImage);
    public Boolean hasBaseImage();
    public A withNewBaseImage(StringBuilder arg1);
    public A withNewBaseImage(int[] arg1,int arg2,int arg3);
    public A withNewBaseImage(char[] arg1);
    public A withNewBaseImage(StringBuffer arg1);
    public A withNewBaseImage(byte[] arg1,int arg2);
    public A withNewBaseImage(byte[] arg1);
    public A withNewBaseImage(char[] arg1,int arg2,int arg3);
    public A withNewBaseImage(byte[] arg1,int arg2,int arg3);
    public A withNewBaseImage(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewBaseImage(String arg1);
    
/**
 * This method has been deprecated, please use method buildGrpcServerTlsConfig instead.
 * @return The buildable object.
 */
@Deprecated public TLSConfig getGrpcServerTlsConfig();
    public TLSConfig buildGrpcServerTlsConfig();
    public A withGrpcServerTlsConfig(TLSConfig grpcServerTlsConfig);
    public Boolean hasGrpcServerTlsConfig();
    public ThanosSpecFluent.GrpcServerTlsConfigNested<A> withNewGrpcServerTlsConfig();
    public ThanosSpecFluent.GrpcServerTlsConfigNested<A> withNewGrpcServerTlsConfigLike(TLSConfig item);
    public ThanosSpecFluent.GrpcServerTlsConfigNested<A> editGrpcServerTlsConfig();
    public ThanosSpecFluent.GrpcServerTlsConfigNested<A> editOrNewGrpcServerTlsConfig();
    public ThanosSpecFluent.GrpcServerTlsConfigNested<A> editOrNewGrpcServerTlsConfigLike(TLSConfig item);
    public String getImage();
    public A withImage(String image);
    public Boolean hasImage();
    public A withNewImage(StringBuilder arg1);
    public A withNewImage(int[] arg1,int arg2,int arg3);
    public A withNewImage(char[] arg1);
    public A withNewImage(StringBuffer arg1);
    public A withNewImage(byte[] arg1,int arg2);
    public A withNewImage(byte[] arg1);
    public A withNewImage(char[] arg1,int arg2,int arg3);
    public A withNewImage(byte[] arg1,int arg2,int arg3);
    public A withNewImage(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewImage(String arg1);
    public Boolean getListenLocal();
    public A withListenLocal(Boolean listenLocal);
    public Boolean hasListenLocal();
    public A withNewListenLocal(String arg1);
    public A withNewListenLocal(boolean arg1);
    public String getLogFormat();
    public A withLogFormat(String logFormat);
    public Boolean hasLogFormat();
    public A withNewLogFormat(StringBuilder arg1);
    public A withNewLogFormat(int[] arg1,int arg2,int arg3);
    public A withNewLogFormat(char[] arg1);
    public A withNewLogFormat(StringBuffer arg1);
    public A withNewLogFormat(byte[] arg1,int arg2);
    public A withNewLogFormat(byte[] arg1);
    public A withNewLogFormat(char[] arg1,int arg2,int arg3);
    public A withNewLogFormat(byte[] arg1,int arg2,int arg3);
    public A withNewLogFormat(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewLogFormat(String arg1);
    public String getLogLevel();
    public A withLogLevel(String logLevel);
    public Boolean hasLogLevel();
    public A withNewLogLevel(StringBuilder arg1);
    public A withNewLogLevel(int[] arg1,int arg2,int arg3);
    public A withNewLogLevel(char[] arg1);
    public A withNewLogLevel(StringBuffer arg1);
    public A withNewLogLevel(byte[] arg1,int arg2);
    public A withNewLogLevel(byte[] arg1);
    public A withNewLogLevel(char[] arg1,int arg2,int arg3);
    public A withNewLogLevel(byte[] arg1,int arg2,int arg3);
    public A withNewLogLevel(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewLogLevel(String arg1);
    public String getMinTime();
    public A withMinTime(String minTime);
    public Boolean hasMinTime();
    public A withNewMinTime(StringBuilder arg1);
    public A withNewMinTime(int[] arg1,int arg2,int arg3);
    public A withNewMinTime(char[] arg1);
    public A withNewMinTime(StringBuffer arg1);
    public A withNewMinTime(byte[] arg1,int arg2);
    public A withNewMinTime(byte[] arg1);
    public A withNewMinTime(char[] arg1,int arg2,int arg3);
    public A withNewMinTime(byte[] arg1,int arg2,int arg3);
    public A withNewMinTime(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewMinTime(String arg1);
    public SecretKeySelector getObjectStorageConfig();
    public A withObjectStorageConfig(SecretKeySelector objectStorageConfig);
    public Boolean hasObjectStorageConfig();
    public A withNewObjectStorageConfig(String key,String name,Boolean optional);
    
/**
 * This method has been deprecated, please use method buildResources instead.
 * @return The buildable object.
 */
@Deprecated public ResourceRequirements getResources();
    public ResourceRequirements buildResources();
    public A withResources(ResourceRequirements resources);
    public Boolean hasResources();
    public ThanosSpecFluent.ResourcesNested<A> withNewResources();
    public ThanosSpecFluent.ResourcesNested<A> withNewResourcesLike(ResourceRequirements item);
    public ThanosSpecFluent.ResourcesNested<A> editResources();
    public ThanosSpecFluent.ResourcesNested<A> editOrNewResources();
    public ThanosSpecFluent.ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item);
    public String getSha();
    public A withSha(String sha);
    public Boolean hasSha();
    public A withNewSha(StringBuilder arg1);
    public A withNewSha(int[] arg1,int arg2,int arg3);
    public A withNewSha(char[] arg1);
    public A withNewSha(StringBuffer arg1);
    public A withNewSha(byte[] arg1,int arg2);
    public A withNewSha(byte[] arg1);
    public A withNewSha(char[] arg1,int arg2,int arg3);
    public A withNewSha(byte[] arg1,int arg2,int arg3);
    public A withNewSha(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewSha(String arg1);
    public String getTag();
    public A withTag(String tag);
    public Boolean hasTag();
    public A withNewTag(StringBuilder arg1);
    public A withNewTag(int[] arg1,int arg2,int arg3);
    public A withNewTag(char[] arg1);
    public A withNewTag(StringBuffer arg1);
    public A withNewTag(byte[] arg1,int arg2);
    public A withNewTag(byte[] arg1);
    public A withNewTag(char[] arg1,int arg2,int arg3);
    public A withNewTag(byte[] arg1,int arg2,int arg3);
    public A withNewTag(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewTag(String arg1);
    public SecretKeySelector getTracingConfig();
    public A withTracingConfig(SecretKeySelector tracingConfig);
    public Boolean hasTracingConfig();
    public A withNewTracingConfig(String key,String name,Boolean optional);
    public String getVersion();
    public A withVersion(String version);
    public Boolean hasVersion();
    public A withNewVersion(StringBuilder arg1);
    public A withNewVersion(int[] arg1,int arg2,int arg3);
    public A withNewVersion(char[] arg1);
    public A withNewVersion(StringBuffer arg1);
    public A withNewVersion(byte[] arg1,int arg2);
    public A withNewVersion(byte[] arg1);
    public A withNewVersion(char[] arg1,int arg2,int arg3);
    public A withNewVersion(byte[] arg1,int arg2,int arg3);
    public A withNewVersion(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewVersion(String arg1);
    public interface GrpcServerTlsConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TLSConfigFluent<ThanosSpecFluent.GrpcServerTlsConfigNested<N>> {

            public N and();
            public N endGrpcServerTlsConfig();    }


    public interface ResourcesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ResourceRequirementsFluent<ThanosSpecFluent.ResourcesNested<N>> {

            public N and();
            public N endResources();    }


}
