package io.fabric8.openshift.api.model.monitoring.v1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.EmptyDirVolumeSource;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface StorageSpecFluent<A extends StorageSpecFluent<A>> extends Fluent<A> {


    public Boolean getDisableMountSubPath();
    public A withDisableMountSubPath(Boolean disableMountSubPath);
    public Boolean hasDisableMountSubPath();
    public A withNewDisableMountSubPath(String arg1);
    public A withNewDisableMountSubPath(boolean arg1);
    public EmptyDirVolumeSource getEmptyDir();
    public A withEmptyDir(EmptyDirVolumeSource emptyDir);
    public Boolean hasEmptyDir();
    
/**
 * This method has been deprecated, please use method buildVolumeClaimTemplate instead.
 * @return The buildable object.
 */
@Deprecated public EmbeddedPersistentVolumeClaim getVolumeClaimTemplate();
    public EmbeddedPersistentVolumeClaim buildVolumeClaimTemplate();
    public A withVolumeClaimTemplate(EmbeddedPersistentVolumeClaim volumeClaimTemplate);
    public Boolean hasVolumeClaimTemplate();
    public StorageSpecFluent.VolumeClaimTemplateNested<A> withNewVolumeClaimTemplate();
    public StorageSpecFluent.VolumeClaimTemplateNested<A> withNewVolumeClaimTemplateLike(EmbeddedPersistentVolumeClaim item);
    public StorageSpecFluent.VolumeClaimTemplateNested<A> editVolumeClaimTemplate();
    public StorageSpecFluent.VolumeClaimTemplateNested<A> editOrNewVolumeClaimTemplate();
    public StorageSpecFluent.VolumeClaimTemplateNested<A> editOrNewVolumeClaimTemplateLike(EmbeddedPersistentVolumeClaim item);
    public interface VolumeClaimTemplateNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EmbeddedPersistentVolumeClaimFluent<StorageSpecFluent.VolumeClaimTemplateNested<N>> {

            public N and();
            public N endVolumeClaimTemplate();    }


}
