package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface RuleGroupFluent<A extends RuleGroupFluent<A>> extends Fluent<A> {


    public String getInterval();
    public A withInterval(String interval);
    public Boolean hasInterval();
    public A withNewInterval(StringBuilder arg1);
    public A withNewInterval(int[] arg1,int arg2,int arg3);
    public A withNewInterval(char[] arg1);
    public A withNewInterval(StringBuffer arg1);
    public A withNewInterval(byte[] arg1,int arg2);
    public A withNewInterval(byte[] arg1);
    public A withNewInterval(char[] arg1,int arg2,int arg3);
    public A withNewInterval(byte[] arg1,int arg2,int arg3);
    public A withNewInterval(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewInterval(String arg1);
    public String getName();
    public A withName(String name);
    public Boolean hasName();
    public A withNewName(StringBuilder arg1);
    public A withNewName(int[] arg1,int arg2,int arg3);
    public A withNewName(char[] arg1);
    public A withNewName(StringBuffer arg1);
    public A withNewName(byte[] arg1,int arg2);
    public A withNewName(byte[] arg1);
    public A withNewName(char[] arg1,int arg2,int arg3);
    public A withNewName(byte[] arg1,int arg2,int arg3);
    public A withNewName(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewName(String arg1);
    public String getPartialResponseStrategy();
    public A withPartialResponseStrategy(String partialResponseStrategy);
    public Boolean hasPartialResponseStrategy();
    public A withNewPartialResponseStrategy(StringBuilder arg1);
    public A withNewPartialResponseStrategy(int[] arg1,int arg2,int arg3);
    public A withNewPartialResponseStrategy(char[] arg1);
    public A withNewPartialResponseStrategy(StringBuffer arg1);
    public A withNewPartialResponseStrategy(byte[] arg1,int arg2);
    public A withNewPartialResponseStrategy(byte[] arg1);
    public A withNewPartialResponseStrategy(char[] arg1,int arg2,int arg3);
    public A withNewPartialResponseStrategy(byte[] arg1,int arg2,int arg3);
    public A withNewPartialResponseStrategy(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewPartialResponseStrategy(String arg1);
    public A addToRules(int index,Rule item);
    public A setToRules(int index,Rule item);
    public A addToRules(Rule... items);
    public A addAllToRules(Collection<Rule> items);
    public A removeFromRules(Rule... items);
    public A removeAllFromRules(Collection<Rule> items);
    public A removeMatchingFromRules(Predicate<RuleBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildRules instead.
 * @return The buildable object.
 */
@Deprecated public List<Rule> getRules();
    public List<Rule> buildRules();
    public Rule buildRule(int index);
    public Rule buildFirstRule();
    public Rule buildLastRule();
    public Rule buildMatchingRule(Predicate<RuleBuilder> predicate);
    public Boolean hasMatchingRule(Predicate<RuleBuilder> predicate);
    public A withRules(List<Rule> rules);
    public A withRules(Rule... rules);
    public Boolean hasRules();
    public RuleGroupFluent.RulesNested<A> addNewRule();
    public RuleGroupFluent.RulesNested<A> addNewRuleLike(Rule item);
    public RuleGroupFluent.RulesNested<A> setNewRuleLike(int index,Rule item);
    public RuleGroupFluent.RulesNested<A> editRule(int index);
    public RuleGroupFluent.RulesNested<A> editFirstRule();
    public RuleGroupFluent.RulesNested<A> editLastRule();
    public RuleGroupFluent.RulesNested<A> editMatchingRule(Predicate<RuleBuilder> predicate);
    public interface RulesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RuleFluent<RuleGroupFluent.RulesNested<N>> {

            public N and();
            public N endRule();    }


}
