package io.fabric8.openshift.api.model.monitoring.v1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface RelabelConfigFluent<A extends RelabelConfigFluent<A>> extends Fluent<A> {


    public String getAction();
    public A withAction(String action);
    public Boolean hasAction();
    public A withNewAction(StringBuilder arg1);
    public A withNewAction(int[] arg1,int arg2,int arg3);
    public A withNewAction(char[] arg1);
    public A withNewAction(StringBuffer arg1);
    public A withNewAction(byte[] arg1,int arg2);
    public A withNewAction(byte[] arg1);
    public A withNewAction(char[] arg1,int arg2,int arg3);
    public A withNewAction(byte[] arg1,int arg2,int arg3);
    public A withNewAction(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewAction(String arg1);
    public Long getModulus();
    public A withModulus(Long modulus);
    public Boolean hasModulus();
    public A withNewModulus(long arg1);
    public String getRegex();
    public A withRegex(String regex);
    public Boolean hasRegex();
    public A withNewRegex(StringBuilder arg1);
    public A withNewRegex(int[] arg1,int arg2,int arg3);
    public A withNewRegex(char[] arg1);
    public A withNewRegex(StringBuffer arg1);
    public A withNewRegex(byte[] arg1,int arg2);
    public A withNewRegex(byte[] arg1);
    public A withNewRegex(char[] arg1,int arg2,int arg3);
    public A withNewRegex(byte[] arg1,int arg2,int arg3);
    public A withNewRegex(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewRegex(String arg1);
    public String getReplacement();
    public A withReplacement(String replacement);
    public Boolean hasReplacement();
    public A withNewReplacement(StringBuilder arg1);
    public A withNewReplacement(int[] arg1,int arg2,int arg3);
    public A withNewReplacement(char[] arg1);
    public A withNewReplacement(StringBuffer arg1);
    public A withNewReplacement(byte[] arg1,int arg2);
    public A withNewReplacement(byte[] arg1);
    public A withNewReplacement(char[] arg1,int arg2,int arg3);
    public A withNewReplacement(byte[] arg1,int arg2,int arg3);
    public A withNewReplacement(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewReplacement(String arg1);
    public String getSeparator();
    public A withSeparator(String separator);
    public Boolean hasSeparator();
    public A withNewSeparator(StringBuilder arg1);
    public A withNewSeparator(int[] arg1,int arg2,int arg3);
    public A withNewSeparator(char[] arg1);
    public A withNewSeparator(StringBuffer arg1);
    public A withNewSeparator(byte[] arg1,int arg2);
    public A withNewSeparator(byte[] arg1);
    public A withNewSeparator(char[] arg1,int arg2,int arg3);
    public A withNewSeparator(byte[] arg1,int arg2,int arg3);
    public A withNewSeparator(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewSeparator(String arg1);
    public A addToSourceLabels(int index,String item);
    public A setToSourceLabels(int index,String item);
    public A addToSourceLabels(String... items);
    public A addAllToSourceLabels(Collection<String> items);
    public A removeFromSourceLabels(String... items);
    public A removeAllFromSourceLabels(Collection<String> items);
    public List<String> getSourceLabels();
    public String getSourceLabel(int index);
    public String getFirstSourceLabel();
    public String getLastSourceLabel();
    public String getMatchingSourceLabel(Predicate<String> predicate);
    public Boolean hasMatchingSourceLabel(Predicate<String> predicate);
    public A withSourceLabels(List<String> sourceLabels);
    public A withSourceLabels(String... sourceLabels);
    public Boolean hasSourceLabels();
    public A addNewSourceLabel(StringBuilder arg1);
    public A addNewSourceLabel(int[] arg1,int arg2,int arg3);
    public A addNewSourceLabel(char[] arg1);
    public A addNewSourceLabel(StringBuffer arg1);
    public A addNewSourceLabel(byte[] arg1,int arg2);
    public A addNewSourceLabel(byte[] arg1);
    public A addNewSourceLabel(char[] arg1,int arg2,int arg3);
    public A addNewSourceLabel(byte[] arg1,int arg2,int arg3);
    public A addNewSourceLabel(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewSourceLabel(String arg1);
    public String getTargetLabel();
    public A withTargetLabel(String targetLabel);
    public Boolean hasTargetLabel();
    public A withNewTargetLabel(StringBuilder arg1);
    public A withNewTargetLabel(int[] arg1,int arg2,int arg3);
    public A withNewTargetLabel(char[] arg1);
    public A withNewTargetLabel(StringBuffer arg1);
    public A withNewTargetLabel(byte[] arg1,int arg2);
    public A withNewTargetLabel(byte[] arg1);
    public A withNewTargetLabel(char[] arg1,int arg2,int arg3);
    public A withNewTargetLabel(byte[] arg1,int arg2,int arg3);
    public A withNewTargetLabel(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewTargetLabel(String arg1);
}
