package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface PrometheusListFluent<A extends PrometheusListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(int[] arg1,int arg2,int arg3);
    public A withNewApiVersion(char[] arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A withNewApiVersion(byte[] arg1,int arg2);
    public A withNewApiVersion(byte[] arg1);
    public A withNewApiVersion(char[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewApiVersion(String arg1);
    public A addToItems(int index,Prometheus item);
    public A setToItems(int index,Prometheus item);
    public A addToItems(Prometheus... items);
    public A addAllToItems(Collection<Prometheus> items);
    public A removeFromItems(Prometheus... items);
    public A removeAllFromItems(Collection<Prometheus> items);
    public A removeMatchingFromItems(Predicate<PrometheusBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<Prometheus> getItems();
    public List<Prometheus> buildItems();
    public Prometheus buildItem(int index);
    public Prometheus buildFirstItem();
    public Prometheus buildLastItem();
    public Prometheus buildMatchingItem(Predicate<PrometheusBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<PrometheusBuilder> predicate);
    public A withItems(List<Prometheus> items);
    public A withItems(Prometheus... items);
    public Boolean hasItems();
    public PrometheusListFluent.ItemsNested<A> addNewItem();
    public PrometheusListFluent.ItemsNested<A> addNewItemLike(Prometheus item);
    public PrometheusListFluent.ItemsNested<A> setNewItemLike(int index,Prometheus item);
    public PrometheusListFluent.ItemsNested<A> editItem(int index);
    public PrometheusListFluent.ItemsNested<A> editFirstItem();
    public PrometheusListFluent.ItemsNested<A> editLastItem();
    public PrometheusListFluent.ItemsNested<A> editMatchingItem(Predicate<PrometheusBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(int[] arg1,int arg2,int arg3);
    public A withNewKind(char[] arg1);
    public A withNewKind(StringBuffer arg1);
    public A withNewKind(byte[] arg1,int arg2);
    public A withNewKind(byte[] arg1);
    public A withNewKind(char[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewKind(String arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PrometheusFluent<PrometheusListFluent.ItemsNested<N>> {

            public N and();
            public N endItem();    }


}
