package io.fabric8.openshift.api.model.monitoring.v1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Object;
import java.util.Map;

public interface PrometheusFluent<A extends PrometheusFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(int[] arg1,int arg2,int arg3);
    public A withNewApiVersion(char[] arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A withNewApiVersion(byte[] arg1,int arg2);
    public A withNewApiVersion(byte[] arg1);
    public A withNewApiVersion(char[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewApiVersion(String arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(int[] arg1,int arg2,int arg3);
    public A withNewKind(char[] arg1);
    public A withNewKind(StringBuffer arg1);
    public A withNewKind(byte[] arg1,int arg2);
    public A withNewKind(byte[] arg1);
    public A withNewKind(char[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewKind(String arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public PrometheusFluent.MetadataNested<A> withNewMetadata();
    public PrometheusFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public PrometheusFluent.MetadataNested<A> editMetadata();
    public PrometheusFluent.MetadataNested<A> editOrNewMetadata();
    public PrometheusFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public PrometheusSpec getSpec();
    public PrometheusSpec buildSpec();
    public A withSpec(PrometheusSpec spec);
    public Boolean hasSpec();
    public PrometheusFluent.SpecNested<A> withNewSpec();
    public PrometheusFluent.SpecNested<A> withNewSpecLike(PrometheusSpec item);
    public PrometheusFluent.SpecNested<A> editSpec();
    public PrometheusFluent.SpecNested<A> editOrNewSpec();
    public PrometheusFluent.SpecNested<A> editOrNewSpecLike(PrometheusSpec item);
    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public PrometheusStatus getStatus();
    public PrometheusStatus buildStatus();
    public A withStatus(PrometheusStatus status);
    public Boolean hasStatus();
    public A withNewStatus(Integer availableReplicas,Boolean paused,Integer replicas,Integer unavailableReplicas,Integer updatedReplicas);
    public PrometheusFluent.StatusNested<A> withNewStatus();
    public PrometheusFluent.StatusNested<A> withNewStatusLike(PrometheusStatus item);
    public PrometheusFluent.StatusNested<A> editStatus();
    public PrometheusFluent.StatusNested<A> editOrNewStatus();
    public PrometheusFluent.StatusNested<A> editOrNewStatusLike(PrometheusStatus item);
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<PrometheusFluent.MetadataNested<N>> {

            public N and();
            public N endMetadata();    }


    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PrometheusSpecFluent<PrometheusFluent.SpecNested<N>> {

            public N and();
            public N endSpec();    }


    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PrometheusStatusFluent<PrometheusFluent.StatusNested<N>> {

            public N and();
            public N endStatus();    }


}
