package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.StringBuffer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.util.Map;

public interface PodMonitorSpecFluent<A extends PodMonitorSpecFluent<A>> extends Fluent<A> {


    public String getJobLabel();
    public A withJobLabel(String jobLabel);
    public Boolean hasJobLabel();
    public A withNewJobLabel(StringBuilder arg1);
    public A withNewJobLabel(int[] arg1,int arg2,int arg3);
    public A withNewJobLabel(char[] arg1);
    public A withNewJobLabel(StringBuffer arg1);
    public A withNewJobLabel(byte[] arg1,int arg2);
    public A withNewJobLabel(byte[] arg1);
    public A withNewJobLabel(char[] arg1,int arg2,int arg3);
    public A withNewJobLabel(byte[] arg1,int arg2,int arg3);
    public A withNewJobLabel(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewJobLabel(String arg1);
    
/**
 * This method has been deprecated, please use method buildNamespaceSelector instead.
 * @return The buildable object.
 */
@Deprecated public NamespaceSelector getNamespaceSelector();
    public NamespaceSelector buildNamespaceSelector();
    public A withNamespaceSelector(NamespaceSelector namespaceSelector);
    public Boolean hasNamespaceSelector();
    public PodMonitorSpecFluent.NamespaceSelectorNested<A> withNewNamespaceSelector();
    public PodMonitorSpecFluent.NamespaceSelectorNested<A> withNewNamespaceSelectorLike(NamespaceSelector item);
    public PodMonitorSpecFluent.NamespaceSelectorNested<A> editNamespaceSelector();
    public PodMonitorSpecFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelector();
    public PodMonitorSpecFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(NamespaceSelector item);
    public A addToPodMetricsEndpoints(int index,PodMetricsEndpoint item);
    public A setToPodMetricsEndpoints(int index,PodMetricsEndpoint item);
    public A addToPodMetricsEndpoints(PodMetricsEndpoint... items);
    public A addAllToPodMetricsEndpoints(Collection<PodMetricsEndpoint> items);
    public A removeFromPodMetricsEndpoints(PodMetricsEndpoint... items);
    public A removeAllFromPodMetricsEndpoints(Collection<PodMetricsEndpoint> items);
    public A removeMatchingFromPodMetricsEndpoints(Predicate<PodMetricsEndpointBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildPodMetricsEndpoints instead.
 * @return The buildable object.
 */
@Deprecated public List<PodMetricsEndpoint> getPodMetricsEndpoints();
    public List<PodMetricsEndpoint> buildPodMetricsEndpoints();
    public PodMetricsEndpoint buildPodMetricsEndpoint(int index);
    public PodMetricsEndpoint buildFirstPodMetricsEndpoint();
    public PodMetricsEndpoint buildLastPodMetricsEndpoint();
    public PodMetricsEndpoint buildMatchingPodMetricsEndpoint(Predicate<PodMetricsEndpointBuilder> predicate);
    public Boolean hasMatchingPodMetricsEndpoint(Predicate<PodMetricsEndpointBuilder> predicate);
    public A withPodMetricsEndpoints(List<PodMetricsEndpoint> podMetricsEndpoints);
    public A withPodMetricsEndpoints(PodMetricsEndpoint... podMetricsEndpoints);
    public Boolean hasPodMetricsEndpoints();
    public PodMonitorSpecFluent.PodMetricsEndpointsNested<A> addNewPodMetricsEndpoint();
    public PodMonitorSpecFluent.PodMetricsEndpointsNested<A> addNewPodMetricsEndpointLike(PodMetricsEndpoint item);
    public PodMonitorSpecFluent.PodMetricsEndpointsNested<A> setNewPodMetricsEndpointLike(int index,PodMetricsEndpoint item);
    public PodMonitorSpecFluent.PodMetricsEndpointsNested<A> editPodMetricsEndpoint(int index);
    public PodMonitorSpecFluent.PodMetricsEndpointsNested<A> editFirstPodMetricsEndpoint();
    public PodMonitorSpecFluent.PodMetricsEndpointsNested<A> editLastPodMetricsEndpoint();
    public PodMonitorSpecFluent.PodMetricsEndpointsNested<A> editMatchingPodMetricsEndpoint(Predicate<PodMetricsEndpointBuilder> predicate);
    public A addToPodTargetLabels(int index,String item);
    public A setToPodTargetLabels(int index,String item);
    public A addToPodTargetLabels(String... items);
    public A addAllToPodTargetLabels(Collection<String> items);
    public A removeFromPodTargetLabels(String... items);
    public A removeAllFromPodTargetLabels(Collection<String> items);
    public List<String> getPodTargetLabels();
    public String getPodTargetLabel(int index);
    public String getFirstPodTargetLabel();
    public String getLastPodTargetLabel();
    public String getMatchingPodTargetLabel(Predicate<String> predicate);
    public Boolean hasMatchingPodTargetLabel(Predicate<String> predicate);
    public A withPodTargetLabels(List<String> podTargetLabels);
    public A withPodTargetLabels(String... podTargetLabels);
    public Boolean hasPodTargetLabels();
    public A addNewPodTargetLabel(StringBuilder arg1);
    public A addNewPodTargetLabel(int[] arg1,int arg2,int arg3);
    public A addNewPodTargetLabel(char[] arg1);
    public A addNewPodTargetLabel(StringBuffer arg1);
    public A addNewPodTargetLabel(byte[] arg1,int arg2);
    public A addNewPodTargetLabel(byte[] arg1);
    public A addNewPodTargetLabel(char[] arg1,int arg2,int arg3);
    public A addNewPodTargetLabel(byte[] arg1,int arg2,int arg3);
    public A addNewPodTargetLabel(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewPodTargetLabel(String arg1);
    public Long getSampleLimit();
    public A withSampleLimit(Long sampleLimit);
    public Boolean hasSampleLimit();
    public A withNewSampleLimit(long arg1);
    
/**
 * This method has been deprecated, please use method buildSelector instead.
 * @return The buildable object.
 */
@Deprecated public LabelSelector getSelector();
    public LabelSelector buildSelector();
    public A withSelector(LabelSelector selector);
    public Boolean hasSelector();
    public PodMonitorSpecFluent.SelectorNested<A> withNewSelector();
    public PodMonitorSpecFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item);
    public PodMonitorSpecFluent.SelectorNested<A> editSelector();
    public PodMonitorSpecFluent.SelectorNested<A> editOrNewSelector();
    public PodMonitorSpecFluent.SelectorNested<A> editOrNewSelectorLike(LabelSelector item);
    public interface NamespaceSelectorNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NamespaceSelectorFluent<PodMonitorSpecFluent.NamespaceSelectorNested<N>> {

            public N and();
            public N endNamespaceSelector();    }


    public interface PodMetricsEndpointsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PodMetricsEndpointFluent<PodMonitorSpecFluent.PodMetricsEndpointsNested<N>> {

            public N and();
            public N endPodMetricsEndpoint();    }


    public interface SelectorNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,LabelSelectorFluent<PodMonitorSpecFluent.SelectorNested<N>> {

            public N and();
            public N endSelector();    }


}
