package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface PodMonitorListFluent<A extends PodMonitorListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(int[] arg1,int arg2,int arg3);
    public A withNewApiVersion(char[] arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A withNewApiVersion(byte[] arg1,int arg2);
    public A withNewApiVersion(byte[] arg1);
    public A withNewApiVersion(char[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewApiVersion(String arg1);
    public A addToItems(int index,PodMonitor item);
    public A setToItems(int index,PodMonitor item);
    public A addToItems(PodMonitor... items);
    public A addAllToItems(Collection<PodMonitor> items);
    public A removeFromItems(PodMonitor... items);
    public A removeAllFromItems(Collection<PodMonitor> items);
    public A removeMatchingFromItems(Predicate<PodMonitorBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<PodMonitor> getItems();
    public List<PodMonitor> buildItems();
    public PodMonitor buildItem(int index);
    public PodMonitor buildFirstItem();
    public PodMonitor buildLastItem();
    public PodMonitor buildMatchingItem(Predicate<PodMonitorBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<PodMonitorBuilder> predicate);
    public A withItems(List<PodMonitor> items);
    public A withItems(PodMonitor... items);
    public Boolean hasItems();
    public PodMonitorListFluent.ItemsNested<A> addNewItem();
    public PodMonitorListFluent.ItemsNested<A> addNewItemLike(PodMonitor item);
    public PodMonitorListFluent.ItemsNested<A> setNewItemLike(int index,PodMonitor item);
    public PodMonitorListFluent.ItemsNested<A> editItem(int index);
    public PodMonitorListFluent.ItemsNested<A> editFirstItem();
    public PodMonitorListFluent.ItemsNested<A> editLastItem();
    public PodMonitorListFluent.ItemsNested<A> editMatchingItem(Predicate<PodMonitorBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(int[] arg1,int arg2,int arg3);
    public A withNewKind(char[] arg1);
    public A withNewKind(StringBuffer arg1);
    public A withNewKind(byte[] arg1,int arg2);
    public A withNewKind(byte[] arg1);
    public A withNewKind(char[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3);
    public A withNewKind(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewKind(String arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PodMonitorFluent<PodMonitorListFluent.ItemsNested<N>> {

            public N and();
            public N endItem();    }


}
