package io.fabric8.openshift.api.model.monitoring.v1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.builder.Nested;
import com.fasterxml.jackson.databind.JsonSerializer;
import java.lang.String;
import com.fasterxml.jackson.databind.JsonDeserializer;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Boolean;
import com.fasterxml.jackson.core.JsonParser;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.IntOrStringFluent;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Object;
import java.util.Map;

public interface RuleFluent<A extends RuleFluent<A>> extends Fluent<A> {


    public String getAlert();
    public A withAlert(String alert);
    public Boolean hasAlert();
    public A withNewAlert(StringBuilder arg1);
    public A withNewAlert(int[] arg1,int arg2,int arg3);
    public A withNewAlert(char[] arg1);
    public A withNewAlert(StringBuffer arg1);
    public A withNewAlert(byte[] arg1,int arg2);
    public A withNewAlert(byte[] arg1);
    public A withNewAlert(char[] arg1,int arg2,int arg3);
    public A withNewAlert(byte[] arg1,int arg2,int arg3);
    public A withNewAlert(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewAlert(String arg1);
    public A addToAnnotations(String key,String value);
    public A addToAnnotations(Map<String,String> map);
    public A removeFromAnnotations(String key);
    public A removeFromAnnotations(Map<String,String> map);
    public Map<String,String> getAnnotations();
    public <K extends Object,V extends Object>A withAnnotations(Map<String,String> annotations);
    public Boolean hasAnnotations();
    
/**
 * This method has been deprecated, please use method buildExpr instead.
 * @return The buildable object.
 */
@Deprecated public IntOrString getExpr();
    public IntOrString buildExpr();
    public A withExpr(IntOrString expr);
    public Boolean hasExpr();
    public A withNewExpr(String strVal);
    public A withNewExpr(Integer intVal);
    public RuleFluent.ExprNested<A> withNewExpr();
    public RuleFluent.ExprNested<A> withNewExprLike(IntOrString item);
    public RuleFluent.ExprNested<A> editExpr();
    public RuleFluent.ExprNested<A> editOrNewExpr();
    public RuleFluent.ExprNested<A> editOrNewExprLike(IntOrString item);
    public String getFor();
    public A withFor(String _for);
    public Boolean hasFor();
    public A withNewFor(StringBuilder arg1);
    public A withNewFor(int[] arg1,int arg2,int arg3);
    public A withNewFor(char[] arg1);
    public A withNewFor(StringBuffer arg1);
    public A withNewFor(byte[] arg1,int arg2);
    public A withNewFor(byte[] arg1);
    public A withNewFor(char[] arg1,int arg2,int arg3);
    public A withNewFor(byte[] arg1,int arg2,int arg3);
    public A withNewFor(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewFor(String arg1);
    public A addToLabels(String key,String value);
    public A addToLabels(Map<String,String> map);
    public A removeFromLabels(String key);
    public A removeFromLabels(Map<String,String> map);
    public Map<String,String> getLabels();
    public <K extends Object,V extends Object>A withLabels(Map<String,String> labels);
    public Boolean hasLabels();
    public String getRecord();
    public A withRecord(String record);
    public Boolean hasRecord();
    public A withNewRecord(StringBuilder arg1);
    public A withNewRecord(int[] arg1,int arg2,int arg3);
    public A withNewRecord(char[] arg1);
    public A withNewRecord(StringBuffer arg1);
    public A withNewRecord(byte[] arg1,int arg2);
    public A withNewRecord(byte[] arg1);
    public A withNewRecord(char[] arg1,int arg2,int arg3);
    public A withNewRecord(byte[] arg1,int arg2,int arg3);
    public A withNewRecord(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewRecord(String arg1);
    public interface ExprNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,IntOrStringFluent<RuleFluent.ExprNested<N>> {

            public N and();
            public N endExpr();    }


}
