package io.fabric8.openshift.api.model.monitoring.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluentImpl;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.lang.Object;
import java.util.Map;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.PodSecurityContext;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.Container;
import java.util.List;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.ContainerFluentImpl;
import io.fabric8.kubernetes.api.model.Toleration;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.Affinity;
import io.fabric8.kubernetes.api.model.VolumeMount;
import java.util.Collection;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.util.Iterator;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import java.lang.Integer;

public class PrometheusSpecFluentImpl<A extends PrometheusSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PrometheusSpecFluent<A> {

    private SecretKeySelector additionalAlertManagerConfigs;
    private SecretKeySelector additionalAlertRelabelConfigs;
    private SecretKeySelector additionalScrapeConfigs;
    private Affinity affinity;
    private AlertingSpecBuilder alerting;
    private Boolean allowOverlappingBlocks;
    private APIServerConfigBuilder apiserverConfig;
    private ArbitraryFSAccessThroughSMsConfigBuilder arbitraryFSAccessThroughSMs;
    private String baseImage;
    private List<String> configMaps = new ArrayList<String>();
    private List<ContainerBuilder> containers =  new ArrayList<ContainerBuilder>();
    private Boolean disableCompaction;
    private Boolean enableAdminAPI;
    private String enforcedNamespaceLabel;
    private Long enforcedSampleLimit;
    private String evaluationInterval;
    private Map<String,String> externalLabels;
    private String externalUrl;
    private Boolean ignoreNamespaceSelectors;
    private String image;
    private List<LocalObjectReferenceBuilder> imagePullSecrets =  new ArrayList<LocalObjectReferenceBuilder>();
    private List<ContainerBuilder> initContainers =  new ArrayList<ContainerBuilder>();
    private Boolean listenLocal;
    private String logFormat;
    private String logLevel;
    private Map<String,String> nodeSelector;
    private Boolean overrideHonorLabels;
    private Boolean overrideHonorTimestamps;
    private Boolean paused;
    private EmbeddedObjectMetadataBuilder podMetadata;
    private LabelSelectorBuilder podMonitorNamespaceSelector;
    private LabelSelectorBuilder podMonitorSelector;
    private String portName;
    private String priorityClassName;
    private LabelSelectorBuilder probeNamespaceSelector;
    private LabelSelectorBuilder probeSelector;
    private String prometheusExternalLabelName;
    private List<PrometheusRuleExcludeConfigBuilder> prometheusRulesExcludedFromEnforce =  new ArrayList<PrometheusRuleExcludeConfigBuilder>();
    private QuerySpecBuilder query;
    private String queryLogFile;
    private List<RemoteReadSpecBuilder> remoteRead =  new ArrayList<RemoteReadSpecBuilder>();
    private List<RemoteWriteSpecBuilder> remoteWrite =  new ArrayList<RemoteWriteSpecBuilder>();
    private String replicaExternalLabelName;
    private Integer replicas;
    private ResourceRequirementsBuilder resources;
    private String retention;
    private String retentionSize;
    private String routePrefix;
    private LabelSelectorBuilder ruleNamespaceSelector;
    private LabelSelectorBuilder ruleSelector;
    private RulesBuilder rules;
    private String scrapeInterval;
    private String scrapeTimeout;
    private List<String> secrets = new ArrayList<String>();
    private PodSecurityContext securityContext;
    private String serviceAccountName;
    private LabelSelectorBuilder serviceMonitorNamespaceSelector;
    private LabelSelectorBuilder serviceMonitorSelector;
    private String sha;
    private StorageSpecBuilder storage;
    private String tag;
    private ThanosSpecBuilder thanos;
    private List<Toleration> tolerations = new ArrayList<Toleration>();
    private String version;
    private List<VolumeMount> volumeMounts = new ArrayList<VolumeMount>();
    private List<Volume> volumes = new ArrayList<Volume>();
    private Boolean walCompression;

    public PrometheusSpecFluentImpl() {
    }

    public PrometheusSpecFluentImpl(PrometheusSpec instance) {
        this.withAdditionalAlertManagerConfigs(instance.getAdditionalAlertManagerConfigs()); 
        this.withAdditionalAlertRelabelConfigs(instance.getAdditionalAlertRelabelConfigs()); 
        this.withAdditionalScrapeConfigs(instance.getAdditionalScrapeConfigs()); 
        this.withAffinity(instance.getAffinity()); 
        this.withAlerting(instance.getAlerting()); 
        this.withAllowOverlappingBlocks(instance.getAllowOverlappingBlocks()); 
        this.withApiserverConfig(instance.getApiserverConfig()); 
        this.withArbitraryFSAccessThroughSMs(instance.getArbitraryFSAccessThroughSMs()); 
        this.withBaseImage(instance.getBaseImage()); 
        this.withConfigMaps(instance.getConfigMaps()); 
        this.withContainers(instance.getContainers()); 
        this.withDisableCompaction(instance.getDisableCompaction()); 
        this.withEnableAdminAPI(instance.getEnableAdminAPI()); 
        this.withEnforcedNamespaceLabel(instance.getEnforcedNamespaceLabel()); 
        this.withEnforcedSampleLimit(instance.getEnforcedSampleLimit()); 
        this.withEvaluationInterval(instance.getEvaluationInterval()); 
        this.withExternalLabels(instance.getExternalLabels()); 
        this.withExternalUrl(instance.getExternalUrl()); 
        this.withIgnoreNamespaceSelectors(instance.getIgnoreNamespaceSelectors()); 
        this.withImage(instance.getImage()); 
        this.withImagePullSecrets(instance.getImagePullSecrets()); 
        this.withInitContainers(instance.getInitContainers()); 
        this.withListenLocal(instance.getListenLocal()); 
        this.withLogFormat(instance.getLogFormat()); 
        this.withLogLevel(instance.getLogLevel()); 
        this.withNodeSelector(instance.getNodeSelector()); 
        this.withOverrideHonorLabels(instance.getOverrideHonorLabels()); 
        this.withOverrideHonorTimestamps(instance.getOverrideHonorTimestamps()); 
        this.withPaused(instance.getPaused()); 
        this.withPodMetadata(instance.getPodMetadata()); 
        this.withPodMonitorNamespaceSelector(instance.getPodMonitorNamespaceSelector()); 
        this.withPodMonitorSelector(instance.getPodMonitorSelector()); 
        this.withPortName(instance.getPortName()); 
        this.withPriorityClassName(instance.getPriorityClassName()); 
        this.withProbeNamespaceSelector(instance.getProbeNamespaceSelector()); 
        this.withProbeSelector(instance.getProbeSelector()); 
        this.withPrometheusExternalLabelName(instance.getPrometheusExternalLabelName()); 
        this.withPrometheusRulesExcludedFromEnforce(instance.getPrometheusRulesExcludedFromEnforce()); 
        this.withQuery(instance.getQuery()); 
        this.withQueryLogFile(instance.getQueryLogFile()); 
        this.withRemoteRead(instance.getRemoteRead()); 
        this.withRemoteWrite(instance.getRemoteWrite()); 
        this.withReplicaExternalLabelName(instance.getReplicaExternalLabelName()); 
        this.withReplicas(instance.getReplicas()); 
        this.withResources(instance.getResources()); 
        this.withRetention(instance.getRetention()); 
        this.withRetentionSize(instance.getRetentionSize()); 
        this.withRoutePrefix(instance.getRoutePrefix()); 
        this.withRuleNamespaceSelector(instance.getRuleNamespaceSelector()); 
        this.withRuleSelector(instance.getRuleSelector()); 
        this.withRules(instance.getRules()); 
        this.withScrapeInterval(instance.getScrapeInterval()); 
        this.withScrapeTimeout(instance.getScrapeTimeout()); 
        this.withSecrets(instance.getSecrets()); 
        this.withSecurityContext(instance.getSecurityContext()); 
        this.withServiceAccountName(instance.getServiceAccountName()); 
        this.withServiceMonitorNamespaceSelector(instance.getServiceMonitorNamespaceSelector()); 
        this.withServiceMonitorSelector(instance.getServiceMonitorSelector()); 
        this.withSha(instance.getSha()); 
        this.withStorage(instance.getStorage()); 
        this.withTag(instance.getTag()); 
        this.withThanos(instance.getThanos()); 
        this.withTolerations(instance.getTolerations()); 
        this.withVersion(instance.getVersion()); 
        this.withVolumeMounts(instance.getVolumeMounts()); 
        this.withVolumes(instance.getVolumes()); 
        this.withWalCompression(instance.getWalCompression()); 
    }

    public SecretKeySelector getAdditionalAlertManagerConfigs() {
        return this.additionalAlertManagerConfigs;
    }

    public A withAdditionalAlertManagerConfigs(SecretKeySelector additionalAlertManagerConfigs) {
        this.additionalAlertManagerConfigs=additionalAlertManagerConfigs; return (A) this;
    }

    public Boolean hasAdditionalAlertManagerConfigs() {
        return this.additionalAlertManagerConfigs != null;
    }

    public A withNewAdditionalAlertManagerConfigs(String key,String name,Boolean optional) {
        return (A)withAdditionalAlertManagerConfigs(new SecretKeySelector(key, name, optional));
    }

    public SecretKeySelector getAdditionalAlertRelabelConfigs() {
        return this.additionalAlertRelabelConfigs;
    }

    public A withAdditionalAlertRelabelConfigs(SecretKeySelector additionalAlertRelabelConfigs) {
        this.additionalAlertRelabelConfigs=additionalAlertRelabelConfigs; return (A) this;
    }

    public Boolean hasAdditionalAlertRelabelConfigs() {
        return this.additionalAlertRelabelConfigs != null;
    }

    public A withNewAdditionalAlertRelabelConfigs(String key,String name,Boolean optional) {
        return (A)withAdditionalAlertRelabelConfigs(new SecretKeySelector(key, name, optional));
    }

    public SecretKeySelector getAdditionalScrapeConfigs() {
        return this.additionalScrapeConfigs;
    }

    public A withAdditionalScrapeConfigs(SecretKeySelector additionalScrapeConfigs) {
        this.additionalScrapeConfigs=additionalScrapeConfigs; return (A) this;
    }

    public Boolean hasAdditionalScrapeConfigs() {
        return this.additionalScrapeConfigs != null;
    }

    public A withNewAdditionalScrapeConfigs(String key,String name,Boolean optional) {
        return (A)withAdditionalScrapeConfigs(new SecretKeySelector(key, name, optional));
    }

    public Affinity getAffinity() {
        return this.affinity;
    }

    public A withAffinity(Affinity affinity) {
        this.affinity=affinity; return (A) this;
    }

    public Boolean hasAffinity() {
        return this.affinity != null;
    }

    
/**
 * This method has been deprecated, please use method buildAlerting instead.
 * @return The buildable object.
 */
@Deprecated public AlertingSpec getAlerting() {
        return this.alerting!=null?this.alerting.build():null;
    }

    public AlertingSpec buildAlerting() {
        return this.alerting!=null?this.alerting.build():null;
    }

    public A withAlerting(AlertingSpec alerting) {
        _visitables.get("alerting").remove(this.alerting);
        if (alerting!=null){ this.alerting= new AlertingSpecBuilder(alerting); _visitables.get("alerting").add(this.alerting);} return (A) this;
    }

    public Boolean hasAlerting() {
        return this.alerting != null;
    }

    public PrometheusSpecFluent.AlertingNested<A> withNewAlerting() {
        return new AlertingNestedImpl();
    }

    public PrometheusSpecFluent.AlertingNested<A> withNewAlertingLike(AlertingSpec item) {
        return new AlertingNestedImpl(item);
    }

    public PrometheusSpecFluent.AlertingNested<A> editAlerting() {
        return withNewAlertingLike(getAlerting());
    }

    public PrometheusSpecFluent.AlertingNested<A> editOrNewAlerting() {
        return withNewAlertingLike(getAlerting() != null ? getAlerting(): new AlertingSpecBuilder().build());
    }

    public PrometheusSpecFluent.AlertingNested<A> editOrNewAlertingLike(AlertingSpec item) {
        return withNewAlertingLike(getAlerting() != null ? getAlerting(): item);
    }

    public Boolean getAllowOverlappingBlocks() {
        return this.allowOverlappingBlocks;
    }

    public A withAllowOverlappingBlocks(Boolean allowOverlappingBlocks) {
        this.allowOverlappingBlocks=allowOverlappingBlocks; return (A) this;
    }

    public Boolean hasAllowOverlappingBlocks() {
        return this.allowOverlappingBlocks != null;
    }

    public A withNewAllowOverlappingBlocks(String arg1) {
        return (A)withAllowOverlappingBlocks(new Boolean(arg1));
    }

    public A withNewAllowOverlappingBlocks(boolean arg1) {
        return (A)withAllowOverlappingBlocks(new Boolean(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildApiserverConfig instead.
 * @return The buildable object.
 */
@Deprecated public APIServerConfig getApiserverConfig() {
        return this.apiserverConfig!=null?this.apiserverConfig.build():null;
    }

    public APIServerConfig buildApiserverConfig() {
        return this.apiserverConfig!=null?this.apiserverConfig.build():null;
    }

    public A withApiserverConfig(APIServerConfig apiserverConfig) {
        _visitables.get("apiserverConfig").remove(this.apiserverConfig);
        if (apiserverConfig!=null){ this.apiserverConfig= new APIServerConfigBuilder(apiserverConfig); _visitables.get("apiserverConfig").add(this.apiserverConfig);} return (A) this;
    }

    public Boolean hasApiserverConfig() {
        return this.apiserverConfig != null;
    }

    public PrometheusSpecFluent.ApiserverConfigNested<A> withNewApiserverConfig() {
        return new ApiserverConfigNestedImpl();
    }

    public PrometheusSpecFluent.ApiserverConfigNested<A> withNewApiserverConfigLike(APIServerConfig item) {
        return new ApiserverConfigNestedImpl(item);
    }

    public PrometheusSpecFluent.ApiserverConfigNested<A> editApiserverConfig() {
        return withNewApiserverConfigLike(getApiserverConfig());
    }

    public PrometheusSpecFluent.ApiserverConfigNested<A> editOrNewApiserverConfig() {
        return withNewApiserverConfigLike(getApiserverConfig() != null ? getApiserverConfig(): new APIServerConfigBuilder().build());
    }

    public PrometheusSpecFluent.ApiserverConfigNested<A> editOrNewApiserverConfigLike(APIServerConfig item) {
        return withNewApiserverConfigLike(getApiserverConfig() != null ? getApiserverConfig(): item);
    }

    
/**
 * This method has been deprecated, please use method buildArbitraryFSAccessThroughSMs instead.
 * @return The buildable object.
 */
@Deprecated public ArbitraryFSAccessThroughSMsConfig getArbitraryFSAccessThroughSMs() {
        return this.arbitraryFSAccessThroughSMs!=null?this.arbitraryFSAccessThroughSMs.build():null;
    }

    public ArbitraryFSAccessThroughSMsConfig buildArbitraryFSAccessThroughSMs() {
        return this.arbitraryFSAccessThroughSMs!=null?this.arbitraryFSAccessThroughSMs.build():null;
    }

    public A withArbitraryFSAccessThroughSMs(ArbitraryFSAccessThroughSMsConfig arbitraryFSAccessThroughSMs) {
        _visitables.get("arbitraryFSAccessThroughSMs").remove(this.arbitraryFSAccessThroughSMs);
        if (arbitraryFSAccessThroughSMs!=null){ this.arbitraryFSAccessThroughSMs= new ArbitraryFSAccessThroughSMsConfigBuilder(arbitraryFSAccessThroughSMs); _visitables.get("arbitraryFSAccessThroughSMs").add(this.arbitraryFSAccessThroughSMs);} return (A) this;
    }

    public Boolean hasArbitraryFSAccessThroughSMs() {
        return this.arbitraryFSAccessThroughSMs != null;
    }

    public A withNewArbitraryFSAccessThroughSMs(Boolean deny) {
        return (A)withArbitraryFSAccessThroughSMs(new ArbitraryFSAccessThroughSMsConfig(deny));
    }

    public PrometheusSpecFluent.ArbitraryFSAccessThroughSMsNested<A> withNewArbitraryFSAccessThroughSMs() {
        return new ArbitraryFSAccessThroughSMsNestedImpl();
    }

    public PrometheusSpecFluent.ArbitraryFSAccessThroughSMsNested<A> withNewArbitraryFSAccessThroughSMsLike(ArbitraryFSAccessThroughSMsConfig item) {
        return new ArbitraryFSAccessThroughSMsNestedImpl(item);
    }

    public PrometheusSpecFluent.ArbitraryFSAccessThroughSMsNested<A> editArbitraryFSAccessThroughSMs() {
        return withNewArbitraryFSAccessThroughSMsLike(getArbitraryFSAccessThroughSMs());
    }

    public PrometheusSpecFluent.ArbitraryFSAccessThroughSMsNested<A> editOrNewArbitraryFSAccessThroughSMs() {
        return withNewArbitraryFSAccessThroughSMsLike(getArbitraryFSAccessThroughSMs() != null ? getArbitraryFSAccessThroughSMs(): new ArbitraryFSAccessThroughSMsConfigBuilder().build());
    }

    public PrometheusSpecFluent.ArbitraryFSAccessThroughSMsNested<A> editOrNewArbitraryFSAccessThroughSMsLike(ArbitraryFSAccessThroughSMsConfig item) {
        return withNewArbitraryFSAccessThroughSMsLike(getArbitraryFSAccessThroughSMs() != null ? getArbitraryFSAccessThroughSMs(): item);
    }

    public String getBaseImage() {
        return this.baseImage;
    }

    public A withBaseImage(String baseImage) {
        this.baseImage=baseImage; return (A) this;
    }

    public Boolean hasBaseImage() {
        return this.baseImage != null;
    }

    public A withNewBaseImage(StringBuilder arg1) {
        return (A)withBaseImage(new String(arg1));
    }

    public A withNewBaseImage(int[] arg1,int arg2,int arg3) {
        return (A)withBaseImage(new String(arg1, arg2, arg3));
    }

    public A withNewBaseImage(char[] arg1) {
        return (A)withBaseImage(new String(arg1));
    }

    public A withNewBaseImage(StringBuffer arg1) {
        return (A)withBaseImage(new String(arg1));
    }

    public A withNewBaseImage(byte[] arg1,int arg2) {
        return (A)withBaseImage(new String(arg1, arg2));
    }

    public A withNewBaseImage(byte[] arg1) {
        return (A)withBaseImage(new String(arg1));
    }

    public A withNewBaseImage(char[] arg1,int arg2,int arg3) {
        return (A)withBaseImage(new String(arg1, arg2, arg3));
    }

    public A withNewBaseImage(byte[] arg1,int arg2,int arg3) {
        return (A)withBaseImage(new String(arg1, arg2, arg3));
    }

    public A withNewBaseImage(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withBaseImage(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewBaseImage(String arg1) {
        return (A)withBaseImage(new String(arg1));
    }

    public A addToConfigMaps(int index,String item) {
        if (this.configMaps == null) {this.configMaps = new ArrayList<String>();}
        this.configMaps.add(index, item);
        return (A)this;
    }

    public A setToConfigMaps(int index,String item) {
        if (this.configMaps == null) {this.configMaps = new ArrayList<String>();}
        this.configMaps.set(index, item); return (A)this;
    }

    public A addToConfigMaps(String... items) {
        if (this.configMaps == null) {this.configMaps = new ArrayList<String>();}
        for (String item : items) {this.configMaps.add(item);} return (A)this;
    }

    public A addAllToConfigMaps(Collection<String> items) {
        if (this.configMaps == null) {this.configMaps = new ArrayList<String>();}
        for (String item : items) {this.configMaps.add(item);} return (A)this;
    }

    public A removeFromConfigMaps(String... items) {
        for (String item : items) {if (this.configMaps!= null){ this.configMaps.remove(item);}} return (A)this;
    }

    public A removeAllFromConfigMaps(Collection<String> items) {
        for (String item : items) {if (this.configMaps!= null){ this.configMaps.remove(item);}} return (A)this;
    }

    public List<String> getConfigMaps() {
        return this.configMaps;
    }

    public String getConfigMap(int index) {
        return this.configMaps.get(index);
    }

    public String getFirstConfigMap() {
        return this.configMaps.get(0);
    }

    public String getLastConfigMap() {
        return this.configMaps.get(configMaps.size() - 1);
    }

    public String getMatchingConfigMap(Predicate<String> predicate) {
        for (String item: configMaps) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingConfigMap(Predicate<String> predicate) {
        for (String item: configMaps) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withConfigMaps(List<String> configMaps) {
        if (this.configMaps != null) { _visitables.get("configMaps").removeAll(this.configMaps);}
        if (configMaps != null) {this.configMaps = new ArrayList<String>(); for (String item : configMaps){this.addToConfigMaps(item);}} else { this.configMaps = null;} return (A) this;
    }

    public A withConfigMaps(String... configMaps) {
        if (this.configMaps != null) {this.configMaps.clear();}
        if (configMaps != null) {for (String item :configMaps){ this.addToConfigMaps(item);}} return (A) this;
    }

    public Boolean hasConfigMaps() {
        return configMaps != null && !configMaps.isEmpty();
    }

    public A addNewConfigMap(StringBuilder arg1) {
        return (A)addToConfigMaps(new String(arg1));
    }

    public A addNewConfigMap(int[] arg1,int arg2,int arg3) {
        return (A)addToConfigMaps(new String(arg1, arg2, arg3));
    }

    public A addNewConfigMap(char[] arg1) {
        return (A)addToConfigMaps(new String(arg1));
    }

    public A addNewConfigMap(StringBuffer arg1) {
        return (A)addToConfigMaps(new String(arg1));
    }

    public A addNewConfigMap(byte[] arg1,int arg2) {
        return (A)addToConfigMaps(new String(arg1, arg2));
    }

    public A addNewConfigMap(byte[] arg1) {
        return (A)addToConfigMaps(new String(arg1));
    }

    public A addNewConfigMap(char[] arg1,int arg2,int arg3) {
        return (A)addToConfigMaps(new String(arg1, arg2, arg3));
    }

    public A addNewConfigMap(byte[] arg1,int arg2,int arg3) {
        return (A)addToConfigMaps(new String(arg1, arg2, arg3));
    }

    public A addNewConfigMap(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)addToConfigMaps(new String(arg1, arg2, arg3, arg4));
    }

    public A addNewConfigMap(String arg1) {
        return (A)addToConfigMaps(new String(arg1));
    }

    public A addToContainers(int index,Container item) {
        if (this.containers == null) {this.containers = new ArrayList<ContainerBuilder>();}
        ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("containers").add(index >= 0 ? index : _visitables.get("containers").size(), builder);this.containers.add(index >= 0 ? index : containers.size(), builder); return (A)this;
    }

    public A setToContainers(int index,Container item) {
        if (this.containers == null) {this.containers = new ArrayList<ContainerBuilder>();}
        ContainerBuilder builder = new ContainerBuilder(item);
        if (index < 0 || index >= _visitables.get("containers").size()) { _visitables.get("containers").add(builder); } else { _visitables.get("containers").set(index, builder);}
        if (index < 0 || index >= containers.size()) { containers.add(builder); } else { containers.set(index, builder);}
         return (A)this;
    }

    public A addToContainers(Container... items) {
        if (this.containers == null) {this.containers = new ArrayList<ContainerBuilder>();}
        for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("containers").add(builder);this.containers.add(builder);} return (A)this;
    }

    public A addAllToContainers(Collection<Container> items) {
        if (this.containers == null) {this.containers = new ArrayList<ContainerBuilder>();}
        for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("containers").add(builder);this.containers.add(builder);} return (A)this;
    }

    public A removeFromContainers(Container... items) {
        for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("containers").remove(builder);if (this.containers != null) {this.containers.remove(builder);}} return (A)this;
    }

    public A removeAllFromContainers(Collection<Container> items) {
        for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("containers").remove(builder);if (this.containers != null) {this.containers.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromContainers(Predicate<ContainerBuilder> predicate) {
        if (containers == null) return (A) this;
        final Iterator<ContainerBuilder> each = containers.iterator();
        final List visitables = _visitables.get("containers");
        while (each.hasNext()) {
          ContainerBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildContainers instead.
 * @return The buildable object.
 */
@Deprecated public List<Container> getContainers() {
        return build(containers);
    }

    public List<Container> buildContainers() {
        return build(containers);
    }

    public Container buildContainer(int index) {
        return this.containers.get(index).build();
    }

    public Container buildFirstContainer() {
        return this.containers.get(0).build();
    }

    public Container buildLastContainer() {
        return this.containers.get(containers.size() - 1).build();
    }

    public Container buildMatchingContainer(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item: containers) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingContainer(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item: containers) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withContainers(List<Container> containers) {
        if (this.containers != null) { _visitables.get("containers").removeAll(this.containers);}
        if (containers != null) {this.containers = new ArrayList<ContainerBuilder>(); for (Container item : containers){this.addToContainers(item);}} else { this.containers = null;} return (A) this;
    }

    public A withContainers(Container... containers) {
        if (this.containers != null) {this.containers.clear();}
        if (containers != null) {for (Container item :containers){ this.addToContainers(item);}} return (A) this;
    }

    public Boolean hasContainers() {
        return containers != null && !containers.isEmpty();
    }

    public PrometheusSpecFluent.ContainersNested<A> addNewContainer() {
        return new ContainersNestedImpl();
    }

    public PrometheusSpecFluent.ContainersNested<A> addNewContainerLike(Container item) {
        return new ContainersNestedImpl(-1, item);
    }

    public PrometheusSpecFluent.ContainersNested<A> setNewContainerLike(int index,Container item) {
        return new ContainersNestedImpl(index, item);
    }

    public PrometheusSpecFluent.ContainersNested<A> editContainer(int index) {
        if (containers.size() <= index) throw new RuntimeException("Can't edit containers. Index exceeds size.");
        return setNewContainerLike(index, buildContainer(index));
    }

    public PrometheusSpecFluent.ContainersNested<A> editFirstContainer() {
        if (containers.size() == 0) throw new RuntimeException("Can't edit first containers. The list is empty.");
        return setNewContainerLike(0, buildContainer(0));
    }

    public PrometheusSpecFluent.ContainersNested<A> editLastContainer() {
        int index = containers.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last containers. The list is empty.");
        return setNewContainerLike(index, buildContainer(index));
    }

    public PrometheusSpecFluent.ContainersNested<A> editMatchingContainer(Predicate<ContainerBuilder> predicate) {
        int index = -1;
        for (int i=0;i<containers.size();i++) { 
        if (predicate.test(containers.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching containers. No match found.");
        return setNewContainerLike(index, buildContainer(index));
    }

    public Boolean getDisableCompaction() {
        return this.disableCompaction;
    }

    public A withDisableCompaction(Boolean disableCompaction) {
        this.disableCompaction=disableCompaction; return (A) this;
    }

    public Boolean hasDisableCompaction() {
        return this.disableCompaction != null;
    }

    public A withNewDisableCompaction(String arg1) {
        return (A)withDisableCompaction(new Boolean(arg1));
    }

    public A withNewDisableCompaction(boolean arg1) {
        return (A)withDisableCompaction(new Boolean(arg1));
    }

    public Boolean getEnableAdminAPI() {
        return this.enableAdminAPI;
    }

    public A withEnableAdminAPI(Boolean enableAdminAPI) {
        this.enableAdminAPI=enableAdminAPI; return (A) this;
    }

    public Boolean hasEnableAdminAPI() {
        return this.enableAdminAPI != null;
    }

    public A withNewEnableAdminAPI(String arg1) {
        return (A)withEnableAdminAPI(new Boolean(arg1));
    }

    public A withNewEnableAdminAPI(boolean arg1) {
        return (A)withEnableAdminAPI(new Boolean(arg1));
    }

    public String getEnforcedNamespaceLabel() {
        return this.enforcedNamespaceLabel;
    }

    public A withEnforcedNamespaceLabel(String enforcedNamespaceLabel) {
        this.enforcedNamespaceLabel=enforcedNamespaceLabel; return (A) this;
    }

    public Boolean hasEnforcedNamespaceLabel() {
        return this.enforcedNamespaceLabel != null;
    }

    public A withNewEnforcedNamespaceLabel(StringBuilder arg1) {
        return (A)withEnforcedNamespaceLabel(new String(arg1));
    }

    public A withNewEnforcedNamespaceLabel(int[] arg1,int arg2,int arg3) {
        return (A)withEnforcedNamespaceLabel(new String(arg1, arg2, arg3));
    }

    public A withNewEnforcedNamespaceLabel(char[] arg1) {
        return (A)withEnforcedNamespaceLabel(new String(arg1));
    }

    public A withNewEnforcedNamespaceLabel(StringBuffer arg1) {
        return (A)withEnforcedNamespaceLabel(new String(arg1));
    }

    public A withNewEnforcedNamespaceLabel(byte[] arg1,int arg2) {
        return (A)withEnforcedNamespaceLabel(new String(arg1, arg2));
    }

    public A withNewEnforcedNamespaceLabel(byte[] arg1) {
        return (A)withEnforcedNamespaceLabel(new String(arg1));
    }

    public A withNewEnforcedNamespaceLabel(char[] arg1,int arg2,int arg3) {
        return (A)withEnforcedNamespaceLabel(new String(arg1, arg2, arg3));
    }

    public A withNewEnforcedNamespaceLabel(byte[] arg1,int arg2,int arg3) {
        return (A)withEnforcedNamespaceLabel(new String(arg1, arg2, arg3));
    }

    public A withNewEnforcedNamespaceLabel(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withEnforcedNamespaceLabel(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewEnforcedNamespaceLabel(String arg1) {
        return (A)withEnforcedNamespaceLabel(new String(arg1));
    }

    public Long getEnforcedSampleLimit() {
        return this.enforcedSampleLimit;
    }

    public A withEnforcedSampleLimit(Long enforcedSampleLimit) {
        this.enforcedSampleLimit=enforcedSampleLimit; return (A) this;
    }

    public Boolean hasEnforcedSampleLimit() {
        return this.enforcedSampleLimit != null;
    }

    public A withNewEnforcedSampleLimit(long arg1) {
        return (A)withEnforcedSampleLimit(new Long(arg1));
    }

    public String getEvaluationInterval() {
        return this.evaluationInterval;
    }

    public A withEvaluationInterval(String evaluationInterval) {
        this.evaluationInterval=evaluationInterval; return (A) this;
    }

    public Boolean hasEvaluationInterval() {
        return this.evaluationInterval != null;
    }

    public A withNewEvaluationInterval(StringBuilder arg1) {
        return (A)withEvaluationInterval(new String(arg1));
    }

    public A withNewEvaluationInterval(int[] arg1,int arg2,int arg3) {
        return (A)withEvaluationInterval(new String(arg1, arg2, arg3));
    }

    public A withNewEvaluationInterval(char[] arg1) {
        return (A)withEvaluationInterval(new String(arg1));
    }

    public A withNewEvaluationInterval(StringBuffer arg1) {
        return (A)withEvaluationInterval(new String(arg1));
    }

    public A withNewEvaluationInterval(byte[] arg1,int arg2) {
        return (A)withEvaluationInterval(new String(arg1, arg2));
    }

    public A withNewEvaluationInterval(byte[] arg1) {
        return (A)withEvaluationInterval(new String(arg1));
    }

    public A withNewEvaluationInterval(char[] arg1,int arg2,int arg3) {
        return (A)withEvaluationInterval(new String(arg1, arg2, arg3));
    }

    public A withNewEvaluationInterval(byte[] arg1,int arg2,int arg3) {
        return (A)withEvaluationInterval(new String(arg1, arg2, arg3));
    }

    public A withNewEvaluationInterval(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withEvaluationInterval(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewEvaluationInterval(String arg1) {
        return (A)withEvaluationInterval(new String(arg1));
    }

    public A addToExternalLabels(String key,String value) {
        if(this.externalLabels == null && key != null && value != null) { this.externalLabels = new LinkedHashMap<String,String>(); }
        if(key != null && value != null) {this.externalLabels.put(key, value);} return (A)this;
    }

    public A addToExternalLabels(Map<String,String> map) {
        if(this.externalLabels == null && map != null) { this.externalLabels = new LinkedHashMap<String,String>(); }
        if(map != null) { this.externalLabels.putAll(map);} return (A)this;
    }

    public A removeFromExternalLabels(String key) {
        if(this.externalLabels == null) { return (A) this; }
        if(key != null && this.externalLabels != null) {this.externalLabels.remove(key);} return (A)this;
    }

    public A removeFromExternalLabels(Map<String,String> map) {
        if(this.externalLabels == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.externalLabels != null){this.externalLabels.remove(key);}}} return (A)this;
    }

    public Map<String,String> getExternalLabels() {
        return this.externalLabels;
    }

    public <K extends Object,V extends Object>A withExternalLabels(Map<String,String> externalLabels) {
        if (externalLabels == null) { this.externalLabels =  null;} else {this.externalLabels = new LinkedHashMap<String,String>(externalLabels);} return (A) this;
    }

    public Boolean hasExternalLabels() {
        return this.externalLabels != null;
    }

    public String getExternalUrl() {
        return this.externalUrl;
    }

    public A withExternalUrl(String externalUrl) {
        this.externalUrl=externalUrl; return (A) this;
    }

    public Boolean hasExternalUrl() {
        return this.externalUrl != null;
    }

    public A withNewExternalUrl(StringBuilder arg1) {
        return (A)withExternalUrl(new String(arg1));
    }

    public A withNewExternalUrl(int[] arg1,int arg2,int arg3) {
        return (A)withExternalUrl(new String(arg1, arg2, arg3));
    }

    public A withNewExternalUrl(char[] arg1) {
        return (A)withExternalUrl(new String(arg1));
    }

    public A withNewExternalUrl(StringBuffer arg1) {
        return (A)withExternalUrl(new String(arg1));
    }

    public A withNewExternalUrl(byte[] arg1,int arg2) {
        return (A)withExternalUrl(new String(arg1, arg2));
    }

    public A withNewExternalUrl(byte[] arg1) {
        return (A)withExternalUrl(new String(arg1));
    }

    public A withNewExternalUrl(char[] arg1,int arg2,int arg3) {
        return (A)withExternalUrl(new String(arg1, arg2, arg3));
    }

    public A withNewExternalUrl(byte[] arg1,int arg2,int arg3) {
        return (A)withExternalUrl(new String(arg1, arg2, arg3));
    }

    public A withNewExternalUrl(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withExternalUrl(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewExternalUrl(String arg1) {
        return (A)withExternalUrl(new String(arg1));
    }

    public Boolean getIgnoreNamespaceSelectors() {
        return this.ignoreNamespaceSelectors;
    }

    public A withIgnoreNamespaceSelectors(Boolean ignoreNamespaceSelectors) {
        this.ignoreNamespaceSelectors=ignoreNamespaceSelectors; return (A) this;
    }

    public Boolean hasIgnoreNamespaceSelectors() {
        return this.ignoreNamespaceSelectors != null;
    }

    public A withNewIgnoreNamespaceSelectors(String arg1) {
        return (A)withIgnoreNamespaceSelectors(new Boolean(arg1));
    }

    public A withNewIgnoreNamespaceSelectors(boolean arg1) {
        return (A)withIgnoreNamespaceSelectors(new Boolean(arg1));
    }

    public String getImage() {
        return this.image;
    }

    public A withImage(String image) {
        this.image=image; return (A) this;
    }

    public Boolean hasImage() {
        return this.image != null;
    }

    public A withNewImage(StringBuilder arg1) {
        return (A)withImage(new String(arg1));
    }

    public A withNewImage(int[] arg1,int arg2,int arg3) {
        return (A)withImage(new String(arg1, arg2, arg3));
    }

    public A withNewImage(char[] arg1) {
        return (A)withImage(new String(arg1));
    }

    public A withNewImage(StringBuffer arg1) {
        return (A)withImage(new String(arg1));
    }

    public A withNewImage(byte[] arg1,int arg2) {
        return (A)withImage(new String(arg1, arg2));
    }

    public A withNewImage(byte[] arg1) {
        return (A)withImage(new String(arg1));
    }

    public A withNewImage(char[] arg1,int arg2,int arg3) {
        return (A)withImage(new String(arg1, arg2, arg3));
    }

    public A withNewImage(byte[] arg1,int arg2,int arg3) {
        return (A)withImage(new String(arg1, arg2, arg3));
    }

    public A withNewImage(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withImage(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewImage(String arg1) {
        return (A)withImage(new String(arg1));
    }

    public A addToImagePullSecrets(int index,LocalObjectReference item) {
        if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();}
        LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("imagePullSecrets").add(index >= 0 ? index : _visitables.get("imagePullSecrets").size(), builder);this.imagePullSecrets.add(index >= 0 ? index : imagePullSecrets.size(), builder); return (A)this;
    }

    public A setToImagePullSecrets(int index,LocalObjectReference item) {
        if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();}
        LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
        if (index < 0 || index >= _visitables.get("imagePullSecrets").size()) { _visitables.get("imagePullSecrets").add(builder); } else { _visitables.get("imagePullSecrets").set(index, builder);}
        if (index < 0 || index >= imagePullSecrets.size()) { imagePullSecrets.add(builder); } else { imagePullSecrets.set(index, builder);}
         return (A)this;
    }

    public A addToImagePullSecrets(LocalObjectReference... items) {
        if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();}
        for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("imagePullSecrets").add(builder);this.imagePullSecrets.add(builder);} return (A)this;
    }

    public A addAllToImagePullSecrets(Collection<LocalObjectReference> items) {
        if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();}
        for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("imagePullSecrets").add(builder);this.imagePullSecrets.add(builder);} return (A)this;
    }

    public A removeFromImagePullSecrets(LocalObjectReference... items) {
        for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("imagePullSecrets").remove(builder);if (this.imagePullSecrets != null) {this.imagePullSecrets.remove(builder);}} return (A)this;
    }

    public A removeAllFromImagePullSecrets(Collection<LocalObjectReference> items) {
        for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("imagePullSecrets").remove(builder);if (this.imagePullSecrets != null) {this.imagePullSecrets.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromImagePullSecrets(Predicate<LocalObjectReferenceBuilder> predicate) {
        if (imagePullSecrets == null) return (A) this;
        final Iterator<LocalObjectReferenceBuilder> each = imagePullSecrets.iterator();
        final List visitables = _visitables.get("imagePullSecrets");
        while (each.hasNext()) {
          LocalObjectReferenceBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildImagePullSecrets instead.
 * @return The buildable object.
 */
@Deprecated public List<LocalObjectReference> getImagePullSecrets() {
        return build(imagePullSecrets);
    }

    public List<LocalObjectReference> buildImagePullSecrets() {
        return build(imagePullSecrets);
    }

    public LocalObjectReference buildImagePullSecret(int index) {
        return this.imagePullSecrets.get(index).build();
    }

    public LocalObjectReference buildFirstImagePullSecret() {
        return this.imagePullSecrets.get(0).build();
    }

    public LocalObjectReference buildLastImagePullSecret() {
        return this.imagePullSecrets.get(imagePullSecrets.size() - 1).build();
    }

    public LocalObjectReference buildMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate) {
        for (LocalObjectReferenceBuilder item: imagePullSecrets) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate) {
        for (LocalObjectReferenceBuilder item: imagePullSecrets) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withImagePullSecrets(List<LocalObjectReference> imagePullSecrets) {
        if (this.imagePullSecrets != null) { _visitables.get("imagePullSecrets").removeAll(this.imagePullSecrets);}
        if (imagePullSecrets != null) {this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>(); for (LocalObjectReference item : imagePullSecrets){this.addToImagePullSecrets(item);}} else { this.imagePullSecrets = null;} return (A) this;
    }

    public A withImagePullSecrets(LocalObjectReference... imagePullSecrets) {
        if (this.imagePullSecrets != null) {this.imagePullSecrets.clear();}
        if (imagePullSecrets != null) {for (LocalObjectReference item :imagePullSecrets){ this.addToImagePullSecrets(item);}} return (A) this;
    }

    public Boolean hasImagePullSecrets() {
        return imagePullSecrets != null && !imagePullSecrets.isEmpty();
    }

    public A addNewImagePullSecret(String name) {
        return (A)addToImagePullSecrets(new LocalObjectReference(name));
    }

    public PrometheusSpecFluent.ImagePullSecretsNested<A> addNewImagePullSecret() {
        return new ImagePullSecretsNestedImpl();
    }

    public PrometheusSpecFluent.ImagePullSecretsNested<A> addNewImagePullSecretLike(LocalObjectReference item) {
        return new ImagePullSecretsNestedImpl(-1, item);
    }

    public PrometheusSpecFluent.ImagePullSecretsNested<A> setNewImagePullSecretLike(int index,LocalObjectReference item) {
        return new ImagePullSecretsNestedImpl(index, item);
    }

    public PrometheusSpecFluent.ImagePullSecretsNested<A> editImagePullSecret(int index) {
        if (imagePullSecrets.size() <= index) throw new RuntimeException("Can't edit imagePullSecrets. Index exceeds size.");
        return setNewImagePullSecretLike(index, buildImagePullSecret(index));
    }

    public PrometheusSpecFluent.ImagePullSecretsNested<A> editFirstImagePullSecret() {
        if (imagePullSecrets.size() == 0) throw new RuntimeException("Can't edit first imagePullSecrets. The list is empty.");
        return setNewImagePullSecretLike(0, buildImagePullSecret(0));
    }

    public PrometheusSpecFluent.ImagePullSecretsNested<A> editLastImagePullSecret() {
        int index = imagePullSecrets.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last imagePullSecrets. The list is empty.");
        return setNewImagePullSecretLike(index, buildImagePullSecret(index));
    }

    public PrometheusSpecFluent.ImagePullSecretsNested<A> editMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate) {
        int index = -1;
        for (int i=0;i<imagePullSecrets.size();i++) { 
        if (predicate.test(imagePullSecrets.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching imagePullSecrets. No match found.");
        return setNewImagePullSecretLike(index, buildImagePullSecret(index));
    }

    public A addToInitContainers(int index,Container item) {
        if (this.initContainers == null) {this.initContainers = new ArrayList<ContainerBuilder>();}
        ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("initContainers").add(index >= 0 ? index : _visitables.get("initContainers").size(), builder);this.initContainers.add(index >= 0 ? index : initContainers.size(), builder); return (A)this;
    }

    public A setToInitContainers(int index,Container item) {
        if (this.initContainers == null) {this.initContainers = new ArrayList<ContainerBuilder>();}
        ContainerBuilder builder = new ContainerBuilder(item);
        if (index < 0 || index >= _visitables.get("initContainers").size()) { _visitables.get("initContainers").add(builder); } else { _visitables.get("initContainers").set(index, builder);}
        if (index < 0 || index >= initContainers.size()) { initContainers.add(builder); } else { initContainers.set(index, builder);}
         return (A)this;
    }

    public A addToInitContainers(Container... items) {
        if (this.initContainers == null) {this.initContainers = new ArrayList<ContainerBuilder>();}
        for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("initContainers").add(builder);this.initContainers.add(builder);} return (A)this;
    }

    public A addAllToInitContainers(Collection<Container> items) {
        if (this.initContainers == null) {this.initContainers = new ArrayList<ContainerBuilder>();}
        for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("initContainers").add(builder);this.initContainers.add(builder);} return (A)this;
    }

    public A removeFromInitContainers(Container... items) {
        for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("initContainers").remove(builder);if (this.initContainers != null) {this.initContainers.remove(builder);}} return (A)this;
    }

    public A removeAllFromInitContainers(Collection<Container> items) {
        for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("initContainers").remove(builder);if (this.initContainers != null) {this.initContainers.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromInitContainers(Predicate<ContainerBuilder> predicate) {
        if (initContainers == null) return (A) this;
        final Iterator<ContainerBuilder> each = initContainers.iterator();
        final List visitables = _visitables.get("initContainers");
        while (each.hasNext()) {
          ContainerBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildInitContainers instead.
 * @return The buildable object.
 */
@Deprecated public List<Container> getInitContainers() {
        return build(initContainers);
    }

    public List<Container> buildInitContainers() {
        return build(initContainers);
    }

    public Container buildInitContainer(int index) {
        return this.initContainers.get(index).build();
    }

    public Container buildFirstInitContainer() {
        return this.initContainers.get(0).build();
    }

    public Container buildLastInitContainer() {
        return this.initContainers.get(initContainers.size() - 1).build();
    }

    public Container buildMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item: initContainers) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item: initContainers) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withInitContainers(List<Container> initContainers) {
        if (this.initContainers != null) { _visitables.get("initContainers").removeAll(this.initContainers);}
        if (initContainers != null) {this.initContainers = new ArrayList<ContainerBuilder>(); for (Container item : initContainers){this.addToInitContainers(item);}} else { this.initContainers = null;} return (A) this;
    }

    public A withInitContainers(Container... initContainers) {
        if (this.initContainers != null) {this.initContainers.clear();}
        if (initContainers != null) {for (Container item :initContainers){ this.addToInitContainers(item);}} return (A) this;
    }

    public Boolean hasInitContainers() {
        return initContainers != null && !initContainers.isEmpty();
    }

    public PrometheusSpecFluent.InitContainersNested<A> addNewInitContainer() {
        return new InitContainersNestedImpl();
    }

    public PrometheusSpecFluent.InitContainersNested<A> addNewInitContainerLike(Container item) {
        return new InitContainersNestedImpl(-1, item);
    }

    public PrometheusSpecFluent.InitContainersNested<A> setNewInitContainerLike(int index,Container item) {
        return new InitContainersNestedImpl(index, item);
    }

    public PrometheusSpecFluent.InitContainersNested<A> editInitContainer(int index) {
        if (initContainers.size() <= index) throw new RuntimeException("Can't edit initContainers. Index exceeds size.");
        return setNewInitContainerLike(index, buildInitContainer(index));
    }

    public PrometheusSpecFluent.InitContainersNested<A> editFirstInitContainer() {
        if (initContainers.size() == 0) throw new RuntimeException("Can't edit first initContainers. The list is empty.");
        return setNewInitContainerLike(0, buildInitContainer(0));
    }

    public PrometheusSpecFluent.InitContainersNested<A> editLastInitContainer() {
        int index = initContainers.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last initContainers. The list is empty.");
        return setNewInitContainerLike(index, buildInitContainer(index));
    }

    public PrometheusSpecFluent.InitContainersNested<A> editMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
        int index = -1;
        for (int i=0;i<initContainers.size();i++) { 
        if (predicate.test(initContainers.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching initContainers. No match found.");
        return setNewInitContainerLike(index, buildInitContainer(index));
    }

    public Boolean getListenLocal() {
        return this.listenLocal;
    }

    public A withListenLocal(Boolean listenLocal) {
        this.listenLocal=listenLocal; return (A) this;
    }

    public Boolean hasListenLocal() {
        return this.listenLocal != null;
    }

    public A withNewListenLocal(String arg1) {
        return (A)withListenLocal(new Boolean(arg1));
    }

    public A withNewListenLocal(boolean arg1) {
        return (A)withListenLocal(new Boolean(arg1));
    }

    public String getLogFormat() {
        return this.logFormat;
    }

    public A withLogFormat(String logFormat) {
        this.logFormat=logFormat; return (A) this;
    }

    public Boolean hasLogFormat() {
        return this.logFormat != null;
    }

    public A withNewLogFormat(StringBuilder arg1) {
        return (A)withLogFormat(new String(arg1));
    }

    public A withNewLogFormat(int[] arg1,int arg2,int arg3) {
        return (A)withLogFormat(new String(arg1, arg2, arg3));
    }

    public A withNewLogFormat(char[] arg1) {
        return (A)withLogFormat(new String(arg1));
    }

    public A withNewLogFormat(StringBuffer arg1) {
        return (A)withLogFormat(new String(arg1));
    }

    public A withNewLogFormat(byte[] arg1,int arg2) {
        return (A)withLogFormat(new String(arg1, arg2));
    }

    public A withNewLogFormat(byte[] arg1) {
        return (A)withLogFormat(new String(arg1));
    }

    public A withNewLogFormat(char[] arg1,int arg2,int arg3) {
        return (A)withLogFormat(new String(arg1, arg2, arg3));
    }

    public A withNewLogFormat(byte[] arg1,int arg2,int arg3) {
        return (A)withLogFormat(new String(arg1, arg2, arg3));
    }

    public A withNewLogFormat(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withLogFormat(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewLogFormat(String arg1) {
        return (A)withLogFormat(new String(arg1));
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public A withLogLevel(String logLevel) {
        this.logLevel=logLevel; return (A) this;
    }

    public Boolean hasLogLevel() {
        return this.logLevel != null;
    }

    public A withNewLogLevel(StringBuilder arg1) {
        return (A)withLogLevel(new String(arg1));
    }

    public A withNewLogLevel(int[] arg1,int arg2,int arg3) {
        return (A)withLogLevel(new String(arg1, arg2, arg3));
    }

    public A withNewLogLevel(char[] arg1) {
        return (A)withLogLevel(new String(arg1));
    }

    public A withNewLogLevel(StringBuffer arg1) {
        return (A)withLogLevel(new String(arg1));
    }

    public A withNewLogLevel(byte[] arg1,int arg2) {
        return (A)withLogLevel(new String(arg1, arg2));
    }

    public A withNewLogLevel(byte[] arg1) {
        return (A)withLogLevel(new String(arg1));
    }

    public A withNewLogLevel(char[] arg1,int arg2,int arg3) {
        return (A)withLogLevel(new String(arg1, arg2, arg3));
    }

    public A withNewLogLevel(byte[] arg1,int arg2,int arg3) {
        return (A)withLogLevel(new String(arg1, arg2, arg3));
    }

    public A withNewLogLevel(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withLogLevel(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewLogLevel(String arg1) {
        return (A)withLogLevel(new String(arg1));
    }

    public A addToNodeSelector(String key,String value) {
        if(this.nodeSelector == null && key != null && value != null) { this.nodeSelector = new LinkedHashMap<String,String>(); }
        if(key != null && value != null) {this.nodeSelector.put(key, value);} return (A)this;
    }

    public A addToNodeSelector(Map<String,String> map) {
        if(this.nodeSelector == null && map != null) { this.nodeSelector = new LinkedHashMap<String,String>(); }
        if(map != null) { this.nodeSelector.putAll(map);} return (A)this;
    }

    public A removeFromNodeSelector(String key) {
        if(this.nodeSelector == null) { return (A) this; }
        if(key != null && this.nodeSelector != null) {this.nodeSelector.remove(key);} return (A)this;
    }

    public A removeFromNodeSelector(Map<String,String> map) {
        if(this.nodeSelector == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.nodeSelector != null){this.nodeSelector.remove(key);}}} return (A)this;
    }

    public Map<String,String> getNodeSelector() {
        return this.nodeSelector;
    }

    public <K extends Object,V extends Object>A withNodeSelector(Map<String,String> nodeSelector) {
        if (nodeSelector == null) { this.nodeSelector =  null;} else {this.nodeSelector = new LinkedHashMap<String,String>(nodeSelector);} return (A) this;
    }

    public Boolean hasNodeSelector() {
        return this.nodeSelector != null;
    }

    public Boolean getOverrideHonorLabels() {
        return this.overrideHonorLabels;
    }

    public A withOverrideHonorLabels(Boolean overrideHonorLabels) {
        this.overrideHonorLabels=overrideHonorLabels; return (A) this;
    }

    public Boolean hasOverrideHonorLabels() {
        return this.overrideHonorLabels != null;
    }

    public A withNewOverrideHonorLabels(String arg1) {
        return (A)withOverrideHonorLabels(new Boolean(arg1));
    }

    public A withNewOverrideHonorLabels(boolean arg1) {
        return (A)withOverrideHonorLabels(new Boolean(arg1));
    }

    public Boolean getOverrideHonorTimestamps() {
        return this.overrideHonorTimestamps;
    }

    public A withOverrideHonorTimestamps(Boolean overrideHonorTimestamps) {
        this.overrideHonorTimestamps=overrideHonorTimestamps; return (A) this;
    }

    public Boolean hasOverrideHonorTimestamps() {
        return this.overrideHonorTimestamps != null;
    }

    public A withNewOverrideHonorTimestamps(String arg1) {
        return (A)withOverrideHonorTimestamps(new Boolean(arg1));
    }

    public A withNewOverrideHonorTimestamps(boolean arg1) {
        return (A)withOverrideHonorTimestamps(new Boolean(arg1));
    }

    public Boolean getPaused() {
        return this.paused;
    }

    public A withPaused(Boolean paused) {
        this.paused=paused; return (A) this;
    }

    public Boolean hasPaused() {
        return this.paused != null;
    }

    public A withNewPaused(String arg1) {
        return (A)withPaused(new Boolean(arg1));
    }

    public A withNewPaused(boolean arg1) {
        return (A)withPaused(new Boolean(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildPodMetadata instead.
 * @return The buildable object.
 */
@Deprecated public EmbeddedObjectMetadata getPodMetadata() {
        return this.podMetadata!=null?this.podMetadata.build():null;
    }

    public EmbeddedObjectMetadata buildPodMetadata() {
        return this.podMetadata!=null?this.podMetadata.build():null;
    }

    public A withPodMetadata(EmbeddedObjectMetadata podMetadata) {
        _visitables.get("podMetadata").remove(this.podMetadata);
        if (podMetadata!=null){ this.podMetadata= new EmbeddedObjectMetadataBuilder(podMetadata); _visitables.get("podMetadata").add(this.podMetadata);} return (A) this;
    }

    public Boolean hasPodMetadata() {
        return this.podMetadata != null;
    }

    public PrometheusSpecFluent.PodMetadataNested<A> withNewPodMetadata() {
        return new PodMetadataNestedImpl();
    }

    public PrometheusSpecFluent.PodMetadataNested<A> withNewPodMetadataLike(EmbeddedObjectMetadata item) {
        return new PodMetadataNestedImpl(item);
    }

    public PrometheusSpecFluent.PodMetadataNested<A> editPodMetadata() {
        return withNewPodMetadataLike(getPodMetadata());
    }

    public PrometheusSpecFluent.PodMetadataNested<A> editOrNewPodMetadata() {
        return withNewPodMetadataLike(getPodMetadata() != null ? getPodMetadata(): new EmbeddedObjectMetadataBuilder().build());
    }

    public PrometheusSpecFluent.PodMetadataNested<A> editOrNewPodMetadataLike(EmbeddedObjectMetadata item) {
        return withNewPodMetadataLike(getPodMetadata() != null ? getPodMetadata(): item);
    }

    
/**
 * This method has been deprecated, please use method buildPodMonitorNamespaceSelector instead.
 * @return The buildable object.
 */
@Deprecated public LabelSelector getPodMonitorNamespaceSelector() {
        return this.podMonitorNamespaceSelector!=null?this.podMonitorNamespaceSelector.build():null;
    }

    public LabelSelector buildPodMonitorNamespaceSelector() {
        return this.podMonitorNamespaceSelector!=null?this.podMonitorNamespaceSelector.build():null;
    }

    public A withPodMonitorNamespaceSelector(LabelSelector podMonitorNamespaceSelector) {
        _visitables.get("podMonitorNamespaceSelector").remove(this.podMonitorNamespaceSelector);
        if (podMonitorNamespaceSelector!=null){ this.podMonitorNamespaceSelector= new LabelSelectorBuilder(podMonitorNamespaceSelector); _visitables.get("podMonitorNamespaceSelector").add(this.podMonitorNamespaceSelector);} return (A) this;
    }

    public Boolean hasPodMonitorNamespaceSelector() {
        return this.podMonitorNamespaceSelector != null;
    }

    public PrometheusSpecFluent.PodMonitorNamespaceSelectorNested<A> withNewPodMonitorNamespaceSelector() {
        return new PodMonitorNamespaceSelectorNestedImpl();
    }

    public PrometheusSpecFluent.PodMonitorNamespaceSelectorNested<A> withNewPodMonitorNamespaceSelectorLike(LabelSelector item) {
        return new PodMonitorNamespaceSelectorNestedImpl(item);
    }

    public PrometheusSpecFluent.PodMonitorNamespaceSelectorNested<A> editPodMonitorNamespaceSelector() {
        return withNewPodMonitorNamespaceSelectorLike(getPodMonitorNamespaceSelector());
    }

    public PrometheusSpecFluent.PodMonitorNamespaceSelectorNested<A> editOrNewPodMonitorNamespaceSelector() {
        return withNewPodMonitorNamespaceSelectorLike(getPodMonitorNamespaceSelector() != null ? getPodMonitorNamespaceSelector(): new LabelSelectorBuilder().build());
    }

    public PrometheusSpecFluent.PodMonitorNamespaceSelectorNested<A> editOrNewPodMonitorNamespaceSelectorLike(LabelSelector item) {
        return withNewPodMonitorNamespaceSelectorLike(getPodMonitorNamespaceSelector() != null ? getPodMonitorNamespaceSelector(): item);
    }

    
/**
 * This method has been deprecated, please use method buildPodMonitorSelector instead.
 * @return The buildable object.
 */
@Deprecated public LabelSelector getPodMonitorSelector() {
        return this.podMonitorSelector!=null?this.podMonitorSelector.build():null;
    }

    public LabelSelector buildPodMonitorSelector() {
        return this.podMonitorSelector!=null?this.podMonitorSelector.build():null;
    }

    public A withPodMonitorSelector(LabelSelector podMonitorSelector) {
        _visitables.get("podMonitorSelector").remove(this.podMonitorSelector);
        if (podMonitorSelector!=null){ this.podMonitorSelector= new LabelSelectorBuilder(podMonitorSelector); _visitables.get("podMonitorSelector").add(this.podMonitorSelector);} return (A) this;
    }

    public Boolean hasPodMonitorSelector() {
        return this.podMonitorSelector != null;
    }

    public PrometheusSpecFluent.PodMonitorSelectorNested<A> withNewPodMonitorSelector() {
        return new PodMonitorSelectorNestedImpl();
    }

    public PrometheusSpecFluent.PodMonitorSelectorNested<A> withNewPodMonitorSelectorLike(LabelSelector item) {
        return new PodMonitorSelectorNestedImpl(item);
    }

    public PrometheusSpecFluent.PodMonitorSelectorNested<A> editPodMonitorSelector() {
        return withNewPodMonitorSelectorLike(getPodMonitorSelector());
    }

    public PrometheusSpecFluent.PodMonitorSelectorNested<A> editOrNewPodMonitorSelector() {
        return withNewPodMonitorSelectorLike(getPodMonitorSelector() != null ? getPodMonitorSelector(): new LabelSelectorBuilder().build());
    }

    public PrometheusSpecFluent.PodMonitorSelectorNested<A> editOrNewPodMonitorSelectorLike(LabelSelector item) {
        return withNewPodMonitorSelectorLike(getPodMonitorSelector() != null ? getPodMonitorSelector(): item);
    }

    public String getPortName() {
        return this.portName;
    }

    public A withPortName(String portName) {
        this.portName=portName; return (A) this;
    }

    public Boolean hasPortName() {
        return this.portName != null;
    }

    public A withNewPortName(StringBuilder arg1) {
        return (A)withPortName(new String(arg1));
    }

    public A withNewPortName(int[] arg1,int arg2,int arg3) {
        return (A)withPortName(new String(arg1, arg2, arg3));
    }

    public A withNewPortName(char[] arg1) {
        return (A)withPortName(new String(arg1));
    }

    public A withNewPortName(StringBuffer arg1) {
        return (A)withPortName(new String(arg1));
    }

    public A withNewPortName(byte[] arg1,int arg2) {
        return (A)withPortName(new String(arg1, arg2));
    }

    public A withNewPortName(byte[] arg1) {
        return (A)withPortName(new String(arg1));
    }

    public A withNewPortName(char[] arg1,int arg2,int arg3) {
        return (A)withPortName(new String(arg1, arg2, arg3));
    }

    public A withNewPortName(byte[] arg1,int arg2,int arg3) {
        return (A)withPortName(new String(arg1, arg2, arg3));
    }

    public A withNewPortName(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withPortName(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewPortName(String arg1) {
        return (A)withPortName(new String(arg1));
    }

    public String getPriorityClassName() {
        return this.priorityClassName;
    }

    public A withPriorityClassName(String priorityClassName) {
        this.priorityClassName=priorityClassName; return (A) this;
    }

    public Boolean hasPriorityClassName() {
        return this.priorityClassName != null;
    }

    public A withNewPriorityClassName(StringBuilder arg1) {
        return (A)withPriorityClassName(new String(arg1));
    }

    public A withNewPriorityClassName(int[] arg1,int arg2,int arg3) {
        return (A)withPriorityClassName(new String(arg1, arg2, arg3));
    }

    public A withNewPriorityClassName(char[] arg1) {
        return (A)withPriorityClassName(new String(arg1));
    }

    public A withNewPriorityClassName(StringBuffer arg1) {
        return (A)withPriorityClassName(new String(arg1));
    }

    public A withNewPriorityClassName(byte[] arg1,int arg2) {
        return (A)withPriorityClassName(new String(arg1, arg2));
    }

    public A withNewPriorityClassName(byte[] arg1) {
        return (A)withPriorityClassName(new String(arg1));
    }

    public A withNewPriorityClassName(char[] arg1,int arg2,int arg3) {
        return (A)withPriorityClassName(new String(arg1, arg2, arg3));
    }

    public A withNewPriorityClassName(byte[] arg1,int arg2,int arg3) {
        return (A)withPriorityClassName(new String(arg1, arg2, arg3));
    }

    public A withNewPriorityClassName(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withPriorityClassName(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewPriorityClassName(String arg1) {
        return (A)withPriorityClassName(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildProbeNamespaceSelector instead.
 * @return The buildable object.
 */
@Deprecated public LabelSelector getProbeNamespaceSelector() {
        return this.probeNamespaceSelector!=null?this.probeNamespaceSelector.build():null;
    }

    public LabelSelector buildProbeNamespaceSelector() {
        return this.probeNamespaceSelector!=null?this.probeNamespaceSelector.build():null;
    }

    public A withProbeNamespaceSelector(LabelSelector probeNamespaceSelector) {
        _visitables.get("probeNamespaceSelector").remove(this.probeNamespaceSelector);
        if (probeNamespaceSelector!=null){ this.probeNamespaceSelector= new LabelSelectorBuilder(probeNamespaceSelector); _visitables.get("probeNamespaceSelector").add(this.probeNamespaceSelector);} return (A) this;
    }

    public Boolean hasProbeNamespaceSelector() {
        return this.probeNamespaceSelector != null;
    }

    public PrometheusSpecFluent.ProbeNamespaceSelectorNested<A> withNewProbeNamespaceSelector() {
        return new ProbeNamespaceSelectorNestedImpl();
    }

    public PrometheusSpecFluent.ProbeNamespaceSelectorNested<A> withNewProbeNamespaceSelectorLike(LabelSelector item) {
        return new ProbeNamespaceSelectorNestedImpl(item);
    }

    public PrometheusSpecFluent.ProbeNamespaceSelectorNested<A> editProbeNamespaceSelector() {
        return withNewProbeNamespaceSelectorLike(getProbeNamespaceSelector());
    }

    public PrometheusSpecFluent.ProbeNamespaceSelectorNested<A> editOrNewProbeNamespaceSelector() {
        return withNewProbeNamespaceSelectorLike(getProbeNamespaceSelector() != null ? getProbeNamespaceSelector(): new LabelSelectorBuilder().build());
    }

    public PrometheusSpecFluent.ProbeNamespaceSelectorNested<A> editOrNewProbeNamespaceSelectorLike(LabelSelector item) {
        return withNewProbeNamespaceSelectorLike(getProbeNamespaceSelector() != null ? getProbeNamespaceSelector(): item);
    }

    
/**
 * This method has been deprecated, please use method buildProbeSelector instead.
 * @return The buildable object.
 */
@Deprecated public LabelSelector getProbeSelector() {
        return this.probeSelector!=null?this.probeSelector.build():null;
    }

    public LabelSelector buildProbeSelector() {
        return this.probeSelector!=null?this.probeSelector.build():null;
    }

    public A withProbeSelector(LabelSelector probeSelector) {
        _visitables.get("probeSelector").remove(this.probeSelector);
        if (probeSelector!=null){ this.probeSelector= new LabelSelectorBuilder(probeSelector); _visitables.get("probeSelector").add(this.probeSelector);} return (A) this;
    }

    public Boolean hasProbeSelector() {
        return this.probeSelector != null;
    }

    public PrometheusSpecFluent.ProbeSelectorNested<A> withNewProbeSelector() {
        return new ProbeSelectorNestedImpl();
    }

    public PrometheusSpecFluent.ProbeSelectorNested<A> withNewProbeSelectorLike(LabelSelector item) {
        return new ProbeSelectorNestedImpl(item);
    }

    public PrometheusSpecFluent.ProbeSelectorNested<A> editProbeSelector() {
        return withNewProbeSelectorLike(getProbeSelector());
    }

    public PrometheusSpecFluent.ProbeSelectorNested<A> editOrNewProbeSelector() {
        return withNewProbeSelectorLike(getProbeSelector() != null ? getProbeSelector(): new LabelSelectorBuilder().build());
    }

    public PrometheusSpecFluent.ProbeSelectorNested<A> editOrNewProbeSelectorLike(LabelSelector item) {
        return withNewProbeSelectorLike(getProbeSelector() != null ? getProbeSelector(): item);
    }

    public String getPrometheusExternalLabelName() {
        return this.prometheusExternalLabelName;
    }

    public A withPrometheusExternalLabelName(String prometheusExternalLabelName) {
        this.prometheusExternalLabelName=prometheusExternalLabelName; return (A) this;
    }

    public Boolean hasPrometheusExternalLabelName() {
        return this.prometheusExternalLabelName != null;
    }

    public A withNewPrometheusExternalLabelName(StringBuilder arg1) {
        return (A)withPrometheusExternalLabelName(new String(arg1));
    }

    public A withNewPrometheusExternalLabelName(int[] arg1,int arg2,int arg3) {
        return (A)withPrometheusExternalLabelName(new String(arg1, arg2, arg3));
    }

    public A withNewPrometheusExternalLabelName(char[] arg1) {
        return (A)withPrometheusExternalLabelName(new String(arg1));
    }

    public A withNewPrometheusExternalLabelName(StringBuffer arg1) {
        return (A)withPrometheusExternalLabelName(new String(arg1));
    }

    public A withNewPrometheusExternalLabelName(byte[] arg1,int arg2) {
        return (A)withPrometheusExternalLabelName(new String(arg1, arg2));
    }

    public A withNewPrometheusExternalLabelName(byte[] arg1) {
        return (A)withPrometheusExternalLabelName(new String(arg1));
    }

    public A withNewPrometheusExternalLabelName(char[] arg1,int arg2,int arg3) {
        return (A)withPrometheusExternalLabelName(new String(arg1, arg2, arg3));
    }

    public A withNewPrometheusExternalLabelName(byte[] arg1,int arg2,int arg3) {
        return (A)withPrometheusExternalLabelName(new String(arg1, arg2, arg3));
    }

    public A withNewPrometheusExternalLabelName(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withPrometheusExternalLabelName(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewPrometheusExternalLabelName(String arg1) {
        return (A)withPrometheusExternalLabelName(new String(arg1));
    }

    public A addToPrometheusRulesExcludedFromEnforce(int index,PrometheusRuleExcludeConfig item) {
        if (this.prometheusRulesExcludedFromEnforce == null) {this.prometheusRulesExcludedFromEnforce = new ArrayList<PrometheusRuleExcludeConfigBuilder>();}
        PrometheusRuleExcludeConfigBuilder builder = new PrometheusRuleExcludeConfigBuilder(item);_visitables.get("prometheusRulesExcludedFromEnforce").add(index >= 0 ? index : _visitables.get("prometheusRulesExcludedFromEnforce").size(), builder);this.prometheusRulesExcludedFromEnforce.add(index >= 0 ? index : prometheusRulesExcludedFromEnforce.size(), builder); return (A)this;
    }

    public A setToPrometheusRulesExcludedFromEnforce(int index,PrometheusRuleExcludeConfig item) {
        if (this.prometheusRulesExcludedFromEnforce == null) {this.prometheusRulesExcludedFromEnforce = new ArrayList<PrometheusRuleExcludeConfigBuilder>();}
        PrometheusRuleExcludeConfigBuilder builder = new PrometheusRuleExcludeConfigBuilder(item);
        if (index < 0 || index >= _visitables.get("prometheusRulesExcludedFromEnforce").size()) { _visitables.get("prometheusRulesExcludedFromEnforce").add(builder); } else { _visitables.get("prometheusRulesExcludedFromEnforce").set(index, builder);}
        if (index < 0 || index >= prometheusRulesExcludedFromEnforce.size()) { prometheusRulesExcludedFromEnforce.add(builder); } else { prometheusRulesExcludedFromEnforce.set(index, builder);}
         return (A)this;
    }

    public A addToPrometheusRulesExcludedFromEnforce(PrometheusRuleExcludeConfig... items) {
        if (this.prometheusRulesExcludedFromEnforce == null) {this.prometheusRulesExcludedFromEnforce = new ArrayList<PrometheusRuleExcludeConfigBuilder>();}
        for (PrometheusRuleExcludeConfig item : items) {PrometheusRuleExcludeConfigBuilder builder = new PrometheusRuleExcludeConfigBuilder(item);_visitables.get("prometheusRulesExcludedFromEnforce").add(builder);this.prometheusRulesExcludedFromEnforce.add(builder);} return (A)this;
    }

    public A addAllToPrometheusRulesExcludedFromEnforce(Collection<PrometheusRuleExcludeConfig> items) {
        if (this.prometheusRulesExcludedFromEnforce == null) {this.prometheusRulesExcludedFromEnforce = new ArrayList<PrometheusRuleExcludeConfigBuilder>();}
        for (PrometheusRuleExcludeConfig item : items) {PrometheusRuleExcludeConfigBuilder builder = new PrometheusRuleExcludeConfigBuilder(item);_visitables.get("prometheusRulesExcludedFromEnforce").add(builder);this.prometheusRulesExcludedFromEnforce.add(builder);} return (A)this;
    }

    public A removeFromPrometheusRulesExcludedFromEnforce(PrometheusRuleExcludeConfig... items) {
        for (PrometheusRuleExcludeConfig item : items) {PrometheusRuleExcludeConfigBuilder builder = new PrometheusRuleExcludeConfigBuilder(item);_visitables.get("prometheusRulesExcludedFromEnforce").remove(builder);if (this.prometheusRulesExcludedFromEnforce != null) {this.prometheusRulesExcludedFromEnforce.remove(builder);}} return (A)this;
    }

    public A removeAllFromPrometheusRulesExcludedFromEnforce(Collection<PrometheusRuleExcludeConfig> items) {
        for (PrometheusRuleExcludeConfig item : items) {PrometheusRuleExcludeConfigBuilder builder = new PrometheusRuleExcludeConfigBuilder(item);_visitables.get("prometheusRulesExcludedFromEnforce").remove(builder);if (this.prometheusRulesExcludedFromEnforce != null) {this.prometheusRulesExcludedFromEnforce.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromPrometheusRulesExcludedFromEnforce(Predicate<PrometheusRuleExcludeConfigBuilder> predicate) {
        if (prometheusRulesExcludedFromEnforce == null) return (A) this;
        final Iterator<PrometheusRuleExcludeConfigBuilder> each = prometheusRulesExcludedFromEnforce.iterator();
        final List visitables = _visitables.get("prometheusRulesExcludedFromEnforce");
        while (each.hasNext()) {
          PrometheusRuleExcludeConfigBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildPrometheusRulesExcludedFromEnforce instead.
 * @return The buildable object.
 */
@Deprecated public List<PrometheusRuleExcludeConfig> getPrometheusRulesExcludedFromEnforce() {
        return build(prometheusRulesExcludedFromEnforce);
    }

    public List<PrometheusRuleExcludeConfig> buildPrometheusRulesExcludedFromEnforce() {
        return build(prometheusRulesExcludedFromEnforce);
    }

    public PrometheusRuleExcludeConfig buildPrometheusRulesExcludedFromEnforce(int index) {
        return this.prometheusRulesExcludedFromEnforce.get(index).build();
    }

    public PrometheusRuleExcludeConfig buildFirstPrometheusRulesExcludedFromEnforce() {
        return this.prometheusRulesExcludedFromEnforce.get(0).build();
    }

    public PrometheusRuleExcludeConfig buildLastPrometheusRulesExcludedFromEnforce() {
        return this.prometheusRulesExcludedFromEnforce.get(prometheusRulesExcludedFromEnforce.size() - 1).build();
    }

    public PrometheusRuleExcludeConfig buildMatchingPrometheusRulesExcludedFromEnforce(Predicate<PrometheusRuleExcludeConfigBuilder> predicate) {
        for (PrometheusRuleExcludeConfigBuilder item: prometheusRulesExcludedFromEnforce) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingPrometheusRulesExcludedFromEnforce(Predicate<PrometheusRuleExcludeConfigBuilder> predicate) {
        for (PrometheusRuleExcludeConfigBuilder item: prometheusRulesExcludedFromEnforce) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withPrometheusRulesExcludedFromEnforce(List<PrometheusRuleExcludeConfig> prometheusRulesExcludedFromEnforce) {
        if (this.prometheusRulesExcludedFromEnforce != null) { _visitables.get("prometheusRulesExcludedFromEnforce").removeAll(this.prometheusRulesExcludedFromEnforce);}
        if (prometheusRulesExcludedFromEnforce != null) {this.prometheusRulesExcludedFromEnforce = new ArrayList<PrometheusRuleExcludeConfigBuilder>(); for (PrometheusRuleExcludeConfig item : prometheusRulesExcludedFromEnforce){this.addToPrometheusRulesExcludedFromEnforce(item);}} else { this.prometheusRulesExcludedFromEnforce = null;} return (A) this;
    }

    public A withPrometheusRulesExcludedFromEnforce(PrometheusRuleExcludeConfig... prometheusRulesExcludedFromEnforce) {
        if (this.prometheusRulesExcludedFromEnforce != null) {this.prometheusRulesExcludedFromEnforce.clear();}
        if (prometheusRulesExcludedFromEnforce != null) {for (PrometheusRuleExcludeConfig item :prometheusRulesExcludedFromEnforce){ this.addToPrometheusRulesExcludedFromEnforce(item);}} return (A) this;
    }

    public Boolean hasPrometheusRulesExcludedFromEnforce() {
        return prometheusRulesExcludedFromEnforce != null && !prometheusRulesExcludedFromEnforce.isEmpty();
    }

    public A addNewPrometheusRulesExcludedFromEnforce(String ruleName,String ruleNamespace) {
        return (A)addToPrometheusRulesExcludedFromEnforce(new PrometheusRuleExcludeConfig(ruleName, ruleNamespace));
    }

    public PrometheusSpecFluent.PrometheusRulesExcludedFromEnforceNested<A> addNewPrometheusRulesExcludedFromEnforce() {
        return new PrometheusRulesExcludedFromEnforceNestedImpl();
    }

    public PrometheusSpecFluent.PrometheusRulesExcludedFromEnforceNested<A> addNewPrometheusRulesExcludedFromEnforceLike(PrometheusRuleExcludeConfig item) {
        return new PrometheusRulesExcludedFromEnforceNestedImpl(-1, item);
    }

    public PrometheusSpecFluent.PrometheusRulesExcludedFromEnforceNested<A> setNewPrometheusRulesExcludedFromEnforceLike(int index,PrometheusRuleExcludeConfig item) {
        return new PrometheusRulesExcludedFromEnforceNestedImpl(index, item);
    }

    public PrometheusSpecFluent.PrometheusRulesExcludedFromEnforceNested<A> editPrometheusRulesExcludedFromEnforce(int index) {
        if (prometheusRulesExcludedFromEnforce.size() <= index) throw new RuntimeException("Can't edit prometheusRulesExcludedFromEnforce. Index exceeds size.");
        return setNewPrometheusRulesExcludedFromEnforceLike(index, buildPrometheusRulesExcludedFromEnforce(index));
    }

    public PrometheusSpecFluent.PrometheusRulesExcludedFromEnforceNested<A> editFirstPrometheusRulesExcludedFromEnforce() {
        if (prometheusRulesExcludedFromEnforce.size() == 0) throw new RuntimeException("Can't edit first prometheusRulesExcludedFromEnforce. The list is empty.");
        return setNewPrometheusRulesExcludedFromEnforceLike(0, buildPrometheusRulesExcludedFromEnforce(0));
    }

    public PrometheusSpecFluent.PrometheusRulesExcludedFromEnforceNested<A> editLastPrometheusRulesExcludedFromEnforce() {
        int index = prometheusRulesExcludedFromEnforce.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last prometheusRulesExcludedFromEnforce. The list is empty.");
        return setNewPrometheusRulesExcludedFromEnforceLike(index, buildPrometheusRulesExcludedFromEnforce(index));
    }

    public PrometheusSpecFluent.PrometheusRulesExcludedFromEnforceNested<A> editMatchingPrometheusRulesExcludedFromEnforce(Predicate<PrometheusRuleExcludeConfigBuilder> predicate) {
        int index = -1;
        for (int i=0;i<prometheusRulesExcludedFromEnforce.size();i++) { 
        if (predicate.test(prometheusRulesExcludedFromEnforce.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching prometheusRulesExcludedFromEnforce. No match found.");
        return setNewPrometheusRulesExcludedFromEnforceLike(index, buildPrometheusRulesExcludedFromEnforce(index));
    }

    
/**
 * This method has been deprecated, please use method buildQuery instead.
 * @return The buildable object.
 */
@Deprecated public QuerySpec getQuery() {
        return this.query!=null?this.query.build():null;
    }

    public QuerySpec buildQuery() {
        return this.query!=null?this.query.build():null;
    }

    public A withQuery(QuerySpec query) {
        _visitables.get("query").remove(this.query);
        if (query!=null){ this.query= new QuerySpecBuilder(query); _visitables.get("query").add(this.query);} return (A) this;
    }

    public Boolean hasQuery() {
        return this.query != null;
    }

    public A withNewQuery(String lookbackDelta,Integer maxConcurrency,Integer maxSamples,String timeout) {
        return (A)withQuery(new QuerySpec(lookbackDelta, maxConcurrency, maxSamples, timeout));
    }

    public PrometheusSpecFluent.QueryNested<A> withNewQuery() {
        return new QueryNestedImpl();
    }

    public PrometheusSpecFluent.QueryNested<A> withNewQueryLike(QuerySpec item) {
        return new QueryNestedImpl(item);
    }

    public PrometheusSpecFluent.QueryNested<A> editQuery() {
        return withNewQueryLike(getQuery());
    }

    public PrometheusSpecFluent.QueryNested<A> editOrNewQuery() {
        return withNewQueryLike(getQuery() != null ? getQuery(): new QuerySpecBuilder().build());
    }

    public PrometheusSpecFluent.QueryNested<A> editOrNewQueryLike(QuerySpec item) {
        return withNewQueryLike(getQuery() != null ? getQuery(): item);
    }

    public String getQueryLogFile() {
        return this.queryLogFile;
    }

    public A withQueryLogFile(String queryLogFile) {
        this.queryLogFile=queryLogFile; return (A) this;
    }

    public Boolean hasQueryLogFile() {
        return this.queryLogFile != null;
    }

    public A withNewQueryLogFile(StringBuilder arg1) {
        return (A)withQueryLogFile(new String(arg1));
    }

    public A withNewQueryLogFile(int[] arg1,int arg2,int arg3) {
        return (A)withQueryLogFile(new String(arg1, arg2, arg3));
    }

    public A withNewQueryLogFile(char[] arg1) {
        return (A)withQueryLogFile(new String(arg1));
    }

    public A withNewQueryLogFile(StringBuffer arg1) {
        return (A)withQueryLogFile(new String(arg1));
    }

    public A withNewQueryLogFile(byte[] arg1,int arg2) {
        return (A)withQueryLogFile(new String(arg1, arg2));
    }

    public A withNewQueryLogFile(byte[] arg1) {
        return (A)withQueryLogFile(new String(arg1));
    }

    public A withNewQueryLogFile(char[] arg1,int arg2,int arg3) {
        return (A)withQueryLogFile(new String(arg1, arg2, arg3));
    }

    public A withNewQueryLogFile(byte[] arg1,int arg2,int arg3) {
        return (A)withQueryLogFile(new String(arg1, arg2, arg3));
    }

    public A withNewQueryLogFile(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withQueryLogFile(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewQueryLogFile(String arg1) {
        return (A)withQueryLogFile(new String(arg1));
    }

    public A addToRemoteRead(int index,RemoteReadSpec item) {
        if (this.remoteRead == null) {this.remoteRead = new ArrayList<RemoteReadSpecBuilder>();}
        RemoteReadSpecBuilder builder = new RemoteReadSpecBuilder(item);_visitables.get("remoteRead").add(index >= 0 ? index : _visitables.get("remoteRead").size(), builder);this.remoteRead.add(index >= 0 ? index : remoteRead.size(), builder); return (A)this;
    }

    public A setToRemoteRead(int index,RemoteReadSpec item) {
        if (this.remoteRead == null) {this.remoteRead = new ArrayList<RemoteReadSpecBuilder>();}
        RemoteReadSpecBuilder builder = new RemoteReadSpecBuilder(item);
        if (index < 0 || index >= _visitables.get("remoteRead").size()) { _visitables.get("remoteRead").add(builder); } else { _visitables.get("remoteRead").set(index, builder);}
        if (index < 0 || index >= remoteRead.size()) { remoteRead.add(builder); } else { remoteRead.set(index, builder);}
         return (A)this;
    }

    public A addToRemoteRead(RemoteReadSpec... items) {
        if (this.remoteRead == null) {this.remoteRead = new ArrayList<RemoteReadSpecBuilder>();}
        for (RemoteReadSpec item : items) {RemoteReadSpecBuilder builder = new RemoteReadSpecBuilder(item);_visitables.get("remoteRead").add(builder);this.remoteRead.add(builder);} return (A)this;
    }

    public A addAllToRemoteRead(Collection<RemoteReadSpec> items) {
        if (this.remoteRead == null) {this.remoteRead = new ArrayList<RemoteReadSpecBuilder>();}
        for (RemoteReadSpec item : items) {RemoteReadSpecBuilder builder = new RemoteReadSpecBuilder(item);_visitables.get("remoteRead").add(builder);this.remoteRead.add(builder);} return (A)this;
    }

    public A removeFromRemoteRead(RemoteReadSpec... items) {
        for (RemoteReadSpec item : items) {RemoteReadSpecBuilder builder = new RemoteReadSpecBuilder(item);_visitables.get("remoteRead").remove(builder);if (this.remoteRead != null) {this.remoteRead.remove(builder);}} return (A)this;
    }

    public A removeAllFromRemoteRead(Collection<RemoteReadSpec> items) {
        for (RemoteReadSpec item : items) {RemoteReadSpecBuilder builder = new RemoteReadSpecBuilder(item);_visitables.get("remoteRead").remove(builder);if (this.remoteRead != null) {this.remoteRead.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromRemoteRead(Predicate<RemoteReadSpecBuilder> predicate) {
        if (remoteRead == null) return (A) this;
        final Iterator<RemoteReadSpecBuilder> each = remoteRead.iterator();
        final List visitables = _visitables.get("remoteRead");
        while (each.hasNext()) {
          RemoteReadSpecBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildRemoteRead instead.
 * @return The buildable object.
 */
@Deprecated public List<RemoteReadSpec> getRemoteRead() {
        return build(remoteRead);
    }

    public List<RemoteReadSpec> buildRemoteRead() {
        return build(remoteRead);
    }

    public RemoteReadSpec buildRemoteRead(int index) {
        return this.remoteRead.get(index).build();
    }

    public RemoteReadSpec buildFirstRemoteRead() {
        return this.remoteRead.get(0).build();
    }

    public RemoteReadSpec buildLastRemoteRead() {
        return this.remoteRead.get(remoteRead.size() - 1).build();
    }

    public RemoteReadSpec buildMatchingRemoteRead(Predicate<RemoteReadSpecBuilder> predicate) {
        for (RemoteReadSpecBuilder item: remoteRead) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingRemoteRead(Predicate<RemoteReadSpecBuilder> predicate) {
        for (RemoteReadSpecBuilder item: remoteRead) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withRemoteRead(List<RemoteReadSpec> remoteRead) {
        if (this.remoteRead != null) { _visitables.get("remoteRead").removeAll(this.remoteRead);}
        if (remoteRead != null) {this.remoteRead = new ArrayList<RemoteReadSpecBuilder>(); for (RemoteReadSpec item : remoteRead){this.addToRemoteRead(item);}} else { this.remoteRead = null;} return (A) this;
    }

    public A withRemoteRead(RemoteReadSpec... remoteRead) {
        if (this.remoteRead != null) {this.remoteRead.clear();}
        if (remoteRead != null) {for (RemoteReadSpec item :remoteRead){ this.addToRemoteRead(item);}} return (A) this;
    }

    public Boolean hasRemoteRead() {
        return remoteRead != null && !remoteRead.isEmpty();
    }

    public PrometheusSpecFluent.RemoteReadNested<A> addNewRemoteRead() {
        return new RemoteReadNestedImpl();
    }

    public PrometheusSpecFluent.RemoteReadNested<A> addNewRemoteReadLike(RemoteReadSpec item) {
        return new RemoteReadNestedImpl(-1, item);
    }

    public PrometheusSpecFluent.RemoteReadNested<A> setNewRemoteReadLike(int index,RemoteReadSpec item) {
        return new RemoteReadNestedImpl(index, item);
    }

    public PrometheusSpecFluent.RemoteReadNested<A> editRemoteRead(int index) {
        if (remoteRead.size() <= index) throw new RuntimeException("Can't edit remoteRead. Index exceeds size.");
        return setNewRemoteReadLike(index, buildRemoteRead(index));
    }

    public PrometheusSpecFluent.RemoteReadNested<A> editFirstRemoteRead() {
        if (remoteRead.size() == 0) throw new RuntimeException("Can't edit first remoteRead. The list is empty.");
        return setNewRemoteReadLike(0, buildRemoteRead(0));
    }

    public PrometheusSpecFluent.RemoteReadNested<A> editLastRemoteRead() {
        int index = remoteRead.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last remoteRead. The list is empty.");
        return setNewRemoteReadLike(index, buildRemoteRead(index));
    }

    public PrometheusSpecFluent.RemoteReadNested<A> editMatchingRemoteRead(Predicate<RemoteReadSpecBuilder> predicate) {
        int index = -1;
        for (int i=0;i<remoteRead.size();i++) { 
        if (predicate.test(remoteRead.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching remoteRead. No match found.");
        return setNewRemoteReadLike(index, buildRemoteRead(index));
    }

    public A addToRemoteWrite(int index,RemoteWriteSpec item) {
        if (this.remoteWrite == null) {this.remoteWrite = new ArrayList<RemoteWriteSpecBuilder>();}
        RemoteWriteSpecBuilder builder = new RemoteWriteSpecBuilder(item);_visitables.get("remoteWrite").add(index >= 0 ? index : _visitables.get("remoteWrite").size(), builder);this.remoteWrite.add(index >= 0 ? index : remoteWrite.size(), builder); return (A)this;
    }

    public A setToRemoteWrite(int index,RemoteWriteSpec item) {
        if (this.remoteWrite == null) {this.remoteWrite = new ArrayList<RemoteWriteSpecBuilder>();}
        RemoteWriteSpecBuilder builder = new RemoteWriteSpecBuilder(item);
        if (index < 0 || index >= _visitables.get("remoteWrite").size()) { _visitables.get("remoteWrite").add(builder); } else { _visitables.get("remoteWrite").set(index, builder);}
        if (index < 0 || index >= remoteWrite.size()) { remoteWrite.add(builder); } else { remoteWrite.set(index, builder);}
         return (A)this;
    }

    public A addToRemoteWrite(RemoteWriteSpec... items) {
        if (this.remoteWrite == null) {this.remoteWrite = new ArrayList<RemoteWriteSpecBuilder>();}
        for (RemoteWriteSpec item : items) {RemoteWriteSpecBuilder builder = new RemoteWriteSpecBuilder(item);_visitables.get("remoteWrite").add(builder);this.remoteWrite.add(builder);} return (A)this;
    }

    public A addAllToRemoteWrite(Collection<RemoteWriteSpec> items) {
        if (this.remoteWrite == null) {this.remoteWrite = new ArrayList<RemoteWriteSpecBuilder>();}
        for (RemoteWriteSpec item : items) {RemoteWriteSpecBuilder builder = new RemoteWriteSpecBuilder(item);_visitables.get("remoteWrite").add(builder);this.remoteWrite.add(builder);} return (A)this;
    }

    public A removeFromRemoteWrite(RemoteWriteSpec... items) {
        for (RemoteWriteSpec item : items) {RemoteWriteSpecBuilder builder = new RemoteWriteSpecBuilder(item);_visitables.get("remoteWrite").remove(builder);if (this.remoteWrite != null) {this.remoteWrite.remove(builder);}} return (A)this;
    }

    public A removeAllFromRemoteWrite(Collection<RemoteWriteSpec> items) {
        for (RemoteWriteSpec item : items) {RemoteWriteSpecBuilder builder = new RemoteWriteSpecBuilder(item);_visitables.get("remoteWrite").remove(builder);if (this.remoteWrite != null) {this.remoteWrite.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromRemoteWrite(Predicate<RemoteWriteSpecBuilder> predicate) {
        if (remoteWrite == null) return (A) this;
        final Iterator<RemoteWriteSpecBuilder> each = remoteWrite.iterator();
        final List visitables = _visitables.get("remoteWrite");
        while (each.hasNext()) {
          RemoteWriteSpecBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildRemoteWrite instead.
 * @return The buildable object.
 */
@Deprecated public List<RemoteWriteSpec> getRemoteWrite() {
        return build(remoteWrite);
    }

    public List<RemoteWriteSpec> buildRemoteWrite() {
        return build(remoteWrite);
    }

    public RemoteWriteSpec buildRemoteWrite(int index) {
        return this.remoteWrite.get(index).build();
    }

    public RemoteWriteSpec buildFirstRemoteWrite() {
        return this.remoteWrite.get(0).build();
    }

    public RemoteWriteSpec buildLastRemoteWrite() {
        return this.remoteWrite.get(remoteWrite.size() - 1).build();
    }

    public RemoteWriteSpec buildMatchingRemoteWrite(Predicate<RemoteWriteSpecBuilder> predicate) {
        for (RemoteWriteSpecBuilder item: remoteWrite) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingRemoteWrite(Predicate<RemoteWriteSpecBuilder> predicate) {
        for (RemoteWriteSpecBuilder item: remoteWrite) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withRemoteWrite(List<RemoteWriteSpec> remoteWrite) {
        if (this.remoteWrite != null) { _visitables.get("remoteWrite").removeAll(this.remoteWrite);}
        if (remoteWrite != null) {this.remoteWrite = new ArrayList<RemoteWriteSpecBuilder>(); for (RemoteWriteSpec item : remoteWrite){this.addToRemoteWrite(item);}} else { this.remoteWrite = null;} return (A) this;
    }

    public A withRemoteWrite(RemoteWriteSpec... remoteWrite) {
        if (this.remoteWrite != null) {this.remoteWrite.clear();}
        if (remoteWrite != null) {for (RemoteWriteSpec item :remoteWrite){ this.addToRemoteWrite(item);}} return (A) this;
    }

    public Boolean hasRemoteWrite() {
        return remoteWrite != null && !remoteWrite.isEmpty();
    }

    public PrometheusSpecFluent.RemoteWriteNested<A> addNewRemoteWrite() {
        return new RemoteWriteNestedImpl();
    }

    public PrometheusSpecFluent.RemoteWriteNested<A> addNewRemoteWriteLike(RemoteWriteSpec item) {
        return new RemoteWriteNestedImpl(-1, item);
    }

    public PrometheusSpecFluent.RemoteWriteNested<A> setNewRemoteWriteLike(int index,RemoteWriteSpec item) {
        return new RemoteWriteNestedImpl(index, item);
    }

    public PrometheusSpecFluent.RemoteWriteNested<A> editRemoteWrite(int index) {
        if (remoteWrite.size() <= index) throw new RuntimeException("Can't edit remoteWrite. Index exceeds size.");
        return setNewRemoteWriteLike(index, buildRemoteWrite(index));
    }

    public PrometheusSpecFluent.RemoteWriteNested<A> editFirstRemoteWrite() {
        if (remoteWrite.size() == 0) throw new RuntimeException("Can't edit first remoteWrite. The list is empty.");
        return setNewRemoteWriteLike(0, buildRemoteWrite(0));
    }

    public PrometheusSpecFluent.RemoteWriteNested<A> editLastRemoteWrite() {
        int index = remoteWrite.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last remoteWrite. The list is empty.");
        return setNewRemoteWriteLike(index, buildRemoteWrite(index));
    }

    public PrometheusSpecFluent.RemoteWriteNested<A> editMatchingRemoteWrite(Predicate<RemoteWriteSpecBuilder> predicate) {
        int index = -1;
        for (int i=0;i<remoteWrite.size();i++) { 
        if (predicate.test(remoteWrite.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching remoteWrite. No match found.");
        return setNewRemoteWriteLike(index, buildRemoteWrite(index));
    }

    public String getReplicaExternalLabelName() {
        return this.replicaExternalLabelName;
    }

    public A withReplicaExternalLabelName(String replicaExternalLabelName) {
        this.replicaExternalLabelName=replicaExternalLabelName; return (A) this;
    }

    public Boolean hasReplicaExternalLabelName() {
        return this.replicaExternalLabelName != null;
    }

    public A withNewReplicaExternalLabelName(StringBuilder arg1) {
        return (A)withReplicaExternalLabelName(new String(arg1));
    }

    public A withNewReplicaExternalLabelName(int[] arg1,int arg2,int arg3) {
        return (A)withReplicaExternalLabelName(new String(arg1, arg2, arg3));
    }

    public A withNewReplicaExternalLabelName(char[] arg1) {
        return (A)withReplicaExternalLabelName(new String(arg1));
    }

    public A withNewReplicaExternalLabelName(StringBuffer arg1) {
        return (A)withReplicaExternalLabelName(new String(arg1));
    }

    public A withNewReplicaExternalLabelName(byte[] arg1,int arg2) {
        return (A)withReplicaExternalLabelName(new String(arg1, arg2));
    }

    public A withNewReplicaExternalLabelName(byte[] arg1) {
        return (A)withReplicaExternalLabelName(new String(arg1));
    }

    public A withNewReplicaExternalLabelName(char[] arg1,int arg2,int arg3) {
        return (A)withReplicaExternalLabelName(new String(arg1, arg2, arg3));
    }

    public A withNewReplicaExternalLabelName(byte[] arg1,int arg2,int arg3) {
        return (A)withReplicaExternalLabelName(new String(arg1, arg2, arg3));
    }

    public A withNewReplicaExternalLabelName(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withReplicaExternalLabelName(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewReplicaExternalLabelName(String arg1) {
        return (A)withReplicaExternalLabelName(new String(arg1));
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public A withReplicas(Integer replicas) {
        this.replicas=replicas; return (A) this;
    }

    public Boolean hasReplicas() {
        return this.replicas != null;
    }

    public A withNewReplicas(int arg1) {
        return (A)withReplicas(new Integer(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildResources instead.
 * @return The buildable object.
 */
@Deprecated public ResourceRequirements getResources() {
        return this.resources!=null?this.resources.build():null;
    }

    public ResourceRequirements buildResources() {
        return this.resources!=null?this.resources.build():null;
    }

    public A withResources(ResourceRequirements resources) {
        _visitables.get("resources").remove(this.resources);
        if (resources!=null){ this.resources= new ResourceRequirementsBuilder(resources); _visitables.get("resources").add(this.resources);} return (A) this;
    }

    public Boolean hasResources() {
        return this.resources != null;
    }

    public PrometheusSpecFluent.ResourcesNested<A> withNewResources() {
        return new ResourcesNestedImpl();
    }

    public PrometheusSpecFluent.ResourcesNested<A> withNewResourcesLike(ResourceRequirements item) {
        return new ResourcesNestedImpl(item);
    }

    public PrometheusSpecFluent.ResourcesNested<A> editResources() {
        return withNewResourcesLike(getResources());
    }

    public PrometheusSpecFluent.ResourcesNested<A> editOrNewResources() {
        return withNewResourcesLike(getResources() != null ? getResources(): new ResourceRequirementsBuilder().build());
    }

    public PrometheusSpecFluent.ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item) {
        return withNewResourcesLike(getResources() != null ? getResources(): item);
    }

    public String getRetention() {
        return this.retention;
    }

    public A withRetention(String retention) {
        this.retention=retention; return (A) this;
    }

    public Boolean hasRetention() {
        return this.retention != null;
    }

    public A withNewRetention(StringBuilder arg1) {
        return (A)withRetention(new String(arg1));
    }

    public A withNewRetention(int[] arg1,int arg2,int arg3) {
        return (A)withRetention(new String(arg1, arg2, arg3));
    }

    public A withNewRetention(char[] arg1) {
        return (A)withRetention(new String(arg1));
    }

    public A withNewRetention(StringBuffer arg1) {
        return (A)withRetention(new String(arg1));
    }

    public A withNewRetention(byte[] arg1,int arg2) {
        return (A)withRetention(new String(arg1, arg2));
    }

    public A withNewRetention(byte[] arg1) {
        return (A)withRetention(new String(arg1));
    }

    public A withNewRetention(char[] arg1,int arg2,int arg3) {
        return (A)withRetention(new String(arg1, arg2, arg3));
    }

    public A withNewRetention(byte[] arg1,int arg2,int arg3) {
        return (A)withRetention(new String(arg1, arg2, arg3));
    }

    public A withNewRetention(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withRetention(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewRetention(String arg1) {
        return (A)withRetention(new String(arg1));
    }

    public String getRetentionSize() {
        return this.retentionSize;
    }

    public A withRetentionSize(String retentionSize) {
        this.retentionSize=retentionSize; return (A) this;
    }

    public Boolean hasRetentionSize() {
        return this.retentionSize != null;
    }

    public A withNewRetentionSize(StringBuilder arg1) {
        return (A)withRetentionSize(new String(arg1));
    }

    public A withNewRetentionSize(int[] arg1,int arg2,int arg3) {
        return (A)withRetentionSize(new String(arg1, arg2, arg3));
    }

    public A withNewRetentionSize(char[] arg1) {
        return (A)withRetentionSize(new String(arg1));
    }

    public A withNewRetentionSize(StringBuffer arg1) {
        return (A)withRetentionSize(new String(arg1));
    }

    public A withNewRetentionSize(byte[] arg1,int arg2) {
        return (A)withRetentionSize(new String(arg1, arg2));
    }

    public A withNewRetentionSize(byte[] arg1) {
        return (A)withRetentionSize(new String(arg1));
    }

    public A withNewRetentionSize(char[] arg1,int arg2,int arg3) {
        return (A)withRetentionSize(new String(arg1, arg2, arg3));
    }

    public A withNewRetentionSize(byte[] arg1,int arg2,int arg3) {
        return (A)withRetentionSize(new String(arg1, arg2, arg3));
    }

    public A withNewRetentionSize(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withRetentionSize(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewRetentionSize(String arg1) {
        return (A)withRetentionSize(new String(arg1));
    }

    public String getRoutePrefix() {
        return this.routePrefix;
    }

    public A withRoutePrefix(String routePrefix) {
        this.routePrefix=routePrefix; return (A) this;
    }

    public Boolean hasRoutePrefix() {
        return this.routePrefix != null;
    }

    public A withNewRoutePrefix(StringBuilder arg1) {
        return (A)withRoutePrefix(new String(arg1));
    }

    public A withNewRoutePrefix(int[] arg1,int arg2,int arg3) {
        return (A)withRoutePrefix(new String(arg1, arg2, arg3));
    }

    public A withNewRoutePrefix(char[] arg1) {
        return (A)withRoutePrefix(new String(arg1));
    }

    public A withNewRoutePrefix(StringBuffer arg1) {
        return (A)withRoutePrefix(new String(arg1));
    }

    public A withNewRoutePrefix(byte[] arg1,int arg2) {
        return (A)withRoutePrefix(new String(arg1, arg2));
    }

    public A withNewRoutePrefix(byte[] arg1) {
        return (A)withRoutePrefix(new String(arg1));
    }

    public A withNewRoutePrefix(char[] arg1,int arg2,int arg3) {
        return (A)withRoutePrefix(new String(arg1, arg2, arg3));
    }

    public A withNewRoutePrefix(byte[] arg1,int arg2,int arg3) {
        return (A)withRoutePrefix(new String(arg1, arg2, arg3));
    }

    public A withNewRoutePrefix(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withRoutePrefix(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewRoutePrefix(String arg1) {
        return (A)withRoutePrefix(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildRuleNamespaceSelector instead.
 * @return The buildable object.
 */
@Deprecated public LabelSelector getRuleNamespaceSelector() {
        return this.ruleNamespaceSelector!=null?this.ruleNamespaceSelector.build():null;
    }

    public LabelSelector buildRuleNamespaceSelector() {
        return this.ruleNamespaceSelector!=null?this.ruleNamespaceSelector.build():null;
    }

    public A withRuleNamespaceSelector(LabelSelector ruleNamespaceSelector) {
        _visitables.get("ruleNamespaceSelector").remove(this.ruleNamespaceSelector);
        if (ruleNamespaceSelector!=null){ this.ruleNamespaceSelector= new LabelSelectorBuilder(ruleNamespaceSelector); _visitables.get("ruleNamespaceSelector").add(this.ruleNamespaceSelector);} return (A) this;
    }

    public Boolean hasRuleNamespaceSelector() {
        return this.ruleNamespaceSelector != null;
    }

    public PrometheusSpecFluent.RuleNamespaceSelectorNested<A> withNewRuleNamespaceSelector() {
        return new RuleNamespaceSelectorNestedImpl();
    }

    public PrometheusSpecFluent.RuleNamespaceSelectorNested<A> withNewRuleNamespaceSelectorLike(LabelSelector item) {
        return new RuleNamespaceSelectorNestedImpl(item);
    }

    public PrometheusSpecFluent.RuleNamespaceSelectorNested<A> editRuleNamespaceSelector() {
        return withNewRuleNamespaceSelectorLike(getRuleNamespaceSelector());
    }

    public PrometheusSpecFluent.RuleNamespaceSelectorNested<A> editOrNewRuleNamespaceSelector() {
        return withNewRuleNamespaceSelectorLike(getRuleNamespaceSelector() != null ? getRuleNamespaceSelector(): new LabelSelectorBuilder().build());
    }

    public PrometheusSpecFluent.RuleNamespaceSelectorNested<A> editOrNewRuleNamespaceSelectorLike(LabelSelector item) {
        return withNewRuleNamespaceSelectorLike(getRuleNamespaceSelector() != null ? getRuleNamespaceSelector(): item);
    }

    
/**
 * This method has been deprecated, please use method buildRuleSelector instead.
 * @return The buildable object.
 */
@Deprecated public LabelSelector getRuleSelector() {
        return this.ruleSelector!=null?this.ruleSelector.build():null;
    }

    public LabelSelector buildRuleSelector() {
        return this.ruleSelector!=null?this.ruleSelector.build():null;
    }

    public A withRuleSelector(LabelSelector ruleSelector) {
        _visitables.get("ruleSelector").remove(this.ruleSelector);
        if (ruleSelector!=null){ this.ruleSelector= new LabelSelectorBuilder(ruleSelector); _visitables.get("ruleSelector").add(this.ruleSelector);} return (A) this;
    }

    public Boolean hasRuleSelector() {
        return this.ruleSelector != null;
    }

    public PrometheusSpecFluent.RuleSelectorNested<A> withNewRuleSelector() {
        return new RuleSelectorNestedImpl();
    }

    public PrometheusSpecFluent.RuleSelectorNested<A> withNewRuleSelectorLike(LabelSelector item) {
        return new RuleSelectorNestedImpl(item);
    }

    public PrometheusSpecFluent.RuleSelectorNested<A> editRuleSelector() {
        return withNewRuleSelectorLike(getRuleSelector());
    }

    public PrometheusSpecFluent.RuleSelectorNested<A> editOrNewRuleSelector() {
        return withNewRuleSelectorLike(getRuleSelector() != null ? getRuleSelector(): new LabelSelectorBuilder().build());
    }

    public PrometheusSpecFluent.RuleSelectorNested<A> editOrNewRuleSelectorLike(LabelSelector item) {
        return withNewRuleSelectorLike(getRuleSelector() != null ? getRuleSelector(): item);
    }

    
/**
 * This method has been deprecated, please use method buildRules instead.
 * @return The buildable object.
 */
@Deprecated public Rules getRules() {
        return this.rules!=null?this.rules.build():null;
    }

    public Rules buildRules() {
        return this.rules!=null?this.rules.build():null;
    }

    public A withRules(Rules rules) {
        _visitables.get("rules").remove(this.rules);
        if (rules!=null){ this.rules= new RulesBuilder(rules); _visitables.get("rules").add(this.rules);} return (A) this;
    }

    public Boolean hasRules() {
        return this.rules != null;
    }

    public PrometheusSpecFluent.RulesNested<A> withNewRules() {
        return new RulesNestedImpl();
    }

    public PrometheusSpecFluent.RulesNested<A> withNewRulesLike(Rules item) {
        return new RulesNestedImpl(item);
    }

    public PrometheusSpecFluent.RulesNested<A> editRules() {
        return withNewRulesLike(getRules());
    }

    public PrometheusSpecFluent.RulesNested<A> editOrNewRules() {
        return withNewRulesLike(getRules() != null ? getRules(): new RulesBuilder().build());
    }

    public PrometheusSpecFluent.RulesNested<A> editOrNewRulesLike(Rules item) {
        return withNewRulesLike(getRules() != null ? getRules(): item);
    }

    public String getScrapeInterval() {
        return this.scrapeInterval;
    }

    public A withScrapeInterval(String scrapeInterval) {
        this.scrapeInterval=scrapeInterval; return (A) this;
    }

    public Boolean hasScrapeInterval() {
        return this.scrapeInterval != null;
    }

    public A withNewScrapeInterval(StringBuilder arg1) {
        return (A)withScrapeInterval(new String(arg1));
    }

    public A withNewScrapeInterval(int[] arg1,int arg2,int arg3) {
        return (A)withScrapeInterval(new String(arg1, arg2, arg3));
    }

    public A withNewScrapeInterval(char[] arg1) {
        return (A)withScrapeInterval(new String(arg1));
    }

    public A withNewScrapeInterval(StringBuffer arg1) {
        return (A)withScrapeInterval(new String(arg1));
    }

    public A withNewScrapeInterval(byte[] arg1,int arg2) {
        return (A)withScrapeInterval(new String(arg1, arg2));
    }

    public A withNewScrapeInterval(byte[] arg1) {
        return (A)withScrapeInterval(new String(arg1));
    }

    public A withNewScrapeInterval(char[] arg1,int arg2,int arg3) {
        return (A)withScrapeInterval(new String(arg1, arg2, arg3));
    }

    public A withNewScrapeInterval(byte[] arg1,int arg2,int arg3) {
        return (A)withScrapeInterval(new String(arg1, arg2, arg3));
    }

    public A withNewScrapeInterval(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withScrapeInterval(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewScrapeInterval(String arg1) {
        return (A)withScrapeInterval(new String(arg1));
    }

    public String getScrapeTimeout() {
        return this.scrapeTimeout;
    }

    public A withScrapeTimeout(String scrapeTimeout) {
        this.scrapeTimeout=scrapeTimeout; return (A) this;
    }

    public Boolean hasScrapeTimeout() {
        return this.scrapeTimeout != null;
    }

    public A withNewScrapeTimeout(StringBuilder arg1) {
        return (A)withScrapeTimeout(new String(arg1));
    }

    public A withNewScrapeTimeout(int[] arg1,int arg2,int arg3) {
        return (A)withScrapeTimeout(new String(arg1, arg2, arg3));
    }

    public A withNewScrapeTimeout(char[] arg1) {
        return (A)withScrapeTimeout(new String(arg1));
    }

    public A withNewScrapeTimeout(StringBuffer arg1) {
        return (A)withScrapeTimeout(new String(arg1));
    }

    public A withNewScrapeTimeout(byte[] arg1,int arg2) {
        return (A)withScrapeTimeout(new String(arg1, arg2));
    }

    public A withNewScrapeTimeout(byte[] arg1) {
        return (A)withScrapeTimeout(new String(arg1));
    }

    public A withNewScrapeTimeout(char[] arg1,int arg2,int arg3) {
        return (A)withScrapeTimeout(new String(arg1, arg2, arg3));
    }

    public A withNewScrapeTimeout(byte[] arg1,int arg2,int arg3) {
        return (A)withScrapeTimeout(new String(arg1, arg2, arg3));
    }

    public A withNewScrapeTimeout(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withScrapeTimeout(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewScrapeTimeout(String arg1) {
        return (A)withScrapeTimeout(new String(arg1));
    }

    public A addToSecrets(int index,String item) {
        if (this.secrets == null) {this.secrets = new ArrayList<String>();}
        this.secrets.add(index, item);
        return (A)this;
    }

    public A setToSecrets(int index,String item) {
        if (this.secrets == null) {this.secrets = new ArrayList<String>();}
        this.secrets.set(index, item); return (A)this;
    }

    public A addToSecrets(String... items) {
        if (this.secrets == null) {this.secrets = new ArrayList<String>();}
        for (String item : items) {this.secrets.add(item);} return (A)this;
    }

    public A addAllToSecrets(Collection<String> items) {
        if (this.secrets == null) {this.secrets = new ArrayList<String>();}
        for (String item : items) {this.secrets.add(item);} return (A)this;
    }

    public A removeFromSecrets(String... items) {
        for (String item : items) {if (this.secrets!= null){ this.secrets.remove(item);}} return (A)this;
    }

    public A removeAllFromSecrets(Collection<String> items) {
        for (String item : items) {if (this.secrets!= null){ this.secrets.remove(item);}} return (A)this;
    }

    public List<String> getSecrets() {
        return this.secrets;
    }

    public String getSecret(int index) {
        return this.secrets.get(index);
    }

    public String getFirstSecret() {
        return this.secrets.get(0);
    }

    public String getLastSecret() {
        return this.secrets.get(secrets.size() - 1);
    }

    public String getMatchingSecret(Predicate<String> predicate) {
        for (String item: secrets) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingSecret(Predicate<String> predicate) {
        for (String item: secrets) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withSecrets(List<String> secrets) {
        if (this.secrets != null) { _visitables.get("secrets").removeAll(this.secrets);}
        if (secrets != null) {this.secrets = new ArrayList<String>(); for (String item : secrets){this.addToSecrets(item);}} else { this.secrets = null;} return (A) this;
    }

    public A withSecrets(String... secrets) {
        if (this.secrets != null) {this.secrets.clear();}
        if (secrets != null) {for (String item :secrets){ this.addToSecrets(item);}} return (A) this;
    }

    public Boolean hasSecrets() {
        return secrets != null && !secrets.isEmpty();
    }

    public A addNewSecret(StringBuilder arg1) {
        return (A)addToSecrets(new String(arg1));
    }

    public A addNewSecret(int[] arg1,int arg2,int arg3) {
        return (A)addToSecrets(new String(arg1, arg2, arg3));
    }

    public A addNewSecret(char[] arg1) {
        return (A)addToSecrets(new String(arg1));
    }

    public A addNewSecret(StringBuffer arg1) {
        return (A)addToSecrets(new String(arg1));
    }

    public A addNewSecret(byte[] arg1,int arg2) {
        return (A)addToSecrets(new String(arg1, arg2));
    }

    public A addNewSecret(byte[] arg1) {
        return (A)addToSecrets(new String(arg1));
    }

    public A addNewSecret(char[] arg1,int arg2,int arg3) {
        return (A)addToSecrets(new String(arg1, arg2, arg3));
    }

    public A addNewSecret(byte[] arg1,int arg2,int arg3) {
        return (A)addToSecrets(new String(arg1, arg2, arg3));
    }

    public A addNewSecret(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)addToSecrets(new String(arg1, arg2, arg3, arg4));
    }

    public A addNewSecret(String arg1) {
        return (A)addToSecrets(new String(arg1));
    }

    public PodSecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public A withSecurityContext(PodSecurityContext securityContext) {
        this.securityContext=securityContext; return (A) this;
    }

    public Boolean hasSecurityContext() {
        return this.securityContext != null;
    }

    public String getServiceAccountName() {
        return this.serviceAccountName;
    }

    public A withServiceAccountName(String serviceAccountName) {
        this.serviceAccountName=serviceAccountName; return (A) this;
    }

    public Boolean hasServiceAccountName() {
        return this.serviceAccountName != null;
    }

    public A withNewServiceAccountName(StringBuilder arg1) {
        return (A)withServiceAccountName(new String(arg1));
    }

    public A withNewServiceAccountName(int[] arg1,int arg2,int arg3) {
        return (A)withServiceAccountName(new String(arg1, arg2, arg3));
    }

    public A withNewServiceAccountName(char[] arg1) {
        return (A)withServiceAccountName(new String(arg1));
    }

    public A withNewServiceAccountName(StringBuffer arg1) {
        return (A)withServiceAccountName(new String(arg1));
    }

    public A withNewServiceAccountName(byte[] arg1,int arg2) {
        return (A)withServiceAccountName(new String(arg1, arg2));
    }

    public A withNewServiceAccountName(byte[] arg1) {
        return (A)withServiceAccountName(new String(arg1));
    }

    public A withNewServiceAccountName(char[] arg1,int arg2,int arg3) {
        return (A)withServiceAccountName(new String(arg1, arg2, arg3));
    }

    public A withNewServiceAccountName(byte[] arg1,int arg2,int arg3) {
        return (A)withServiceAccountName(new String(arg1, arg2, arg3));
    }

    public A withNewServiceAccountName(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withServiceAccountName(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewServiceAccountName(String arg1) {
        return (A)withServiceAccountName(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildServiceMonitorNamespaceSelector instead.
 * @return The buildable object.
 */
@Deprecated public LabelSelector getServiceMonitorNamespaceSelector() {
        return this.serviceMonitorNamespaceSelector!=null?this.serviceMonitorNamespaceSelector.build():null;
    }

    public LabelSelector buildServiceMonitorNamespaceSelector() {
        return this.serviceMonitorNamespaceSelector!=null?this.serviceMonitorNamespaceSelector.build():null;
    }

    public A withServiceMonitorNamespaceSelector(LabelSelector serviceMonitorNamespaceSelector) {
        _visitables.get("serviceMonitorNamespaceSelector").remove(this.serviceMonitorNamespaceSelector);
        if (serviceMonitorNamespaceSelector!=null){ this.serviceMonitorNamespaceSelector= new LabelSelectorBuilder(serviceMonitorNamespaceSelector); _visitables.get("serviceMonitorNamespaceSelector").add(this.serviceMonitorNamespaceSelector);} return (A) this;
    }

    public Boolean hasServiceMonitorNamespaceSelector() {
        return this.serviceMonitorNamespaceSelector != null;
    }

    public PrometheusSpecFluent.ServiceMonitorNamespaceSelectorNested<A> withNewServiceMonitorNamespaceSelector() {
        return new ServiceMonitorNamespaceSelectorNestedImpl();
    }

    public PrometheusSpecFluent.ServiceMonitorNamespaceSelectorNested<A> withNewServiceMonitorNamespaceSelectorLike(LabelSelector item) {
        return new ServiceMonitorNamespaceSelectorNestedImpl(item);
    }

    public PrometheusSpecFluent.ServiceMonitorNamespaceSelectorNested<A> editServiceMonitorNamespaceSelector() {
        return withNewServiceMonitorNamespaceSelectorLike(getServiceMonitorNamespaceSelector());
    }

    public PrometheusSpecFluent.ServiceMonitorNamespaceSelectorNested<A> editOrNewServiceMonitorNamespaceSelector() {
        return withNewServiceMonitorNamespaceSelectorLike(getServiceMonitorNamespaceSelector() != null ? getServiceMonitorNamespaceSelector(): new LabelSelectorBuilder().build());
    }

    public PrometheusSpecFluent.ServiceMonitorNamespaceSelectorNested<A> editOrNewServiceMonitorNamespaceSelectorLike(LabelSelector item) {
        return withNewServiceMonitorNamespaceSelectorLike(getServiceMonitorNamespaceSelector() != null ? getServiceMonitorNamespaceSelector(): item);
    }

    
/**
 * This method has been deprecated, please use method buildServiceMonitorSelector instead.
 * @return The buildable object.
 */
@Deprecated public LabelSelector getServiceMonitorSelector() {
        return this.serviceMonitorSelector!=null?this.serviceMonitorSelector.build():null;
    }

    public LabelSelector buildServiceMonitorSelector() {
        return this.serviceMonitorSelector!=null?this.serviceMonitorSelector.build():null;
    }

    public A withServiceMonitorSelector(LabelSelector serviceMonitorSelector) {
        _visitables.get("serviceMonitorSelector").remove(this.serviceMonitorSelector);
        if (serviceMonitorSelector!=null){ this.serviceMonitorSelector= new LabelSelectorBuilder(serviceMonitorSelector); _visitables.get("serviceMonitorSelector").add(this.serviceMonitorSelector);} return (A) this;
    }

    public Boolean hasServiceMonitorSelector() {
        return this.serviceMonitorSelector != null;
    }

    public PrometheusSpecFluent.ServiceMonitorSelectorNested<A> withNewServiceMonitorSelector() {
        return new ServiceMonitorSelectorNestedImpl();
    }

    public PrometheusSpecFluent.ServiceMonitorSelectorNested<A> withNewServiceMonitorSelectorLike(LabelSelector item) {
        return new ServiceMonitorSelectorNestedImpl(item);
    }

    public PrometheusSpecFluent.ServiceMonitorSelectorNested<A> editServiceMonitorSelector() {
        return withNewServiceMonitorSelectorLike(getServiceMonitorSelector());
    }

    public PrometheusSpecFluent.ServiceMonitorSelectorNested<A> editOrNewServiceMonitorSelector() {
        return withNewServiceMonitorSelectorLike(getServiceMonitorSelector() != null ? getServiceMonitorSelector(): new LabelSelectorBuilder().build());
    }

    public PrometheusSpecFluent.ServiceMonitorSelectorNested<A> editOrNewServiceMonitorSelectorLike(LabelSelector item) {
        return withNewServiceMonitorSelectorLike(getServiceMonitorSelector() != null ? getServiceMonitorSelector(): item);
    }

    public String getSha() {
        return this.sha;
    }

    public A withSha(String sha) {
        this.sha=sha; return (A) this;
    }

    public Boolean hasSha() {
        return this.sha != null;
    }

    public A withNewSha(StringBuilder arg1) {
        return (A)withSha(new String(arg1));
    }

    public A withNewSha(int[] arg1,int arg2,int arg3) {
        return (A)withSha(new String(arg1, arg2, arg3));
    }

    public A withNewSha(char[] arg1) {
        return (A)withSha(new String(arg1));
    }

    public A withNewSha(StringBuffer arg1) {
        return (A)withSha(new String(arg1));
    }

    public A withNewSha(byte[] arg1,int arg2) {
        return (A)withSha(new String(arg1, arg2));
    }

    public A withNewSha(byte[] arg1) {
        return (A)withSha(new String(arg1));
    }

    public A withNewSha(char[] arg1,int arg2,int arg3) {
        return (A)withSha(new String(arg1, arg2, arg3));
    }

    public A withNewSha(byte[] arg1,int arg2,int arg3) {
        return (A)withSha(new String(arg1, arg2, arg3));
    }

    public A withNewSha(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withSha(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewSha(String arg1) {
        return (A)withSha(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildStorage instead.
 * @return The buildable object.
 */
@Deprecated public StorageSpec getStorage() {
        return this.storage!=null?this.storage.build():null;
    }

    public StorageSpec buildStorage() {
        return this.storage!=null?this.storage.build():null;
    }

    public A withStorage(StorageSpec storage) {
        _visitables.get("storage").remove(this.storage);
        if (storage!=null){ this.storage= new StorageSpecBuilder(storage); _visitables.get("storage").add(this.storage);} return (A) this;
    }

    public Boolean hasStorage() {
        return this.storage != null;
    }

    public PrometheusSpecFluent.StorageNested<A> withNewStorage() {
        return new StorageNestedImpl();
    }

    public PrometheusSpecFluent.StorageNested<A> withNewStorageLike(StorageSpec item) {
        return new StorageNestedImpl(item);
    }

    public PrometheusSpecFluent.StorageNested<A> editStorage() {
        return withNewStorageLike(getStorage());
    }

    public PrometheusSpecFluent.StorageNested<A> editOrNewStorage() {
        return withNewStorageLike(getStorage() != null ? getStorage(): new StorageSpecBuilder().build());
    }

    public PrometheusSpecFluent.StorageNested<A> editOrNewStorageLike(StorageSpec item) {
        return withNewStorageLike(getStorage() != null ? getStorage(): item);
    }

    public String getTag() {
        return this.tag;
    }

    public A withTag(String tag) {
        this.tag=tag; return (A) this;
    }

    public Boolean hasTag() {
        return this.tag != null;
    }

    public A withNewTag(StringBuilder arg1) {
        return (A)withTag(new String(arg1));
    }

    public A withNewTag(int[] arg1,int arg2,int arg3) {
        return (A)withTag(new String(arg1, arg2, arg3));
    }

    public A withNewTag(char[] arg1) {
        return (A)withTag(new String(arg1));
    }

    public A withNewTag(StringBuffer arg1) {
        return (A)withTag(new String(arg1));
    }

    public A withNewTag(byte[] arg1,int arg2) {
        return (A)withTag(new String(arg1, arg2));
    }

    public A withNewTag(byte[] arg1) {
        return (A)withTag(new String(arg1));
    }

    public A withNewTag(char[] arg1,int arg2,int arg3) {
        return (A)withTag(new String(arg1, arg2, arg3));
    }

    public A withNewTag(byte[] arg1,int arg2,int arg3) {
        return (A)withTag(new String(arg1, arg2, arg3));
    }

    public A withNewTag(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withTag(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewTag(String arg1) {
        return (A)withTag(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildThanos instead.
 * @return The buildable object.
 */
@Deprecated public ThanosSpec getThanos() {
        return this.thanos!=null?this.thanos.build():null;
    }

    public ThanosSpec buildThanos() {
        return this.thanos!=null?this.thanos.build():null;
    }

    public A withThanos(ThanosSpec thanos) {
        _visitables.get("thanos").remove(this.thanos);
        if (thanos!=null){ this.thanos= new ThanosSpecBuilder(thanos); _visitables.get("thanos").add(this.thanos);} return (A) this;
    }

    public Boolean hasThanos() {
        return this.thanos != null;
    }

    public PrometheusSpecFluent.ThanosNested<A> withNewThanos() {
        return new ThanosNestedImpl();
    }

    public PrometheusSpecFluent.ThanosNested<A> withNewThanosLike(ThanosSpec item) {
        return new ThanosNestedImpl(item);
    }

    public PrometheusSpecFluent.ThanosNested<A> editThanos() {
        return withNewThanosLike(getThanos());
    }

    public PrometheusSpecFluent.ThanosNested<A> editOrNewThanos() {
        return withNewThanosLike(getThanos() != null ? getThanos(): new ThanosSpecBuilder().build());
    }

    public PrometheusSpecFluent.ThanosNested<A> editOrNewThanosLike(ThanosSpec item) {
        return withNewThanosLike(getThanos() != null ? getThanos(): item);
    }

    public A addToTolerations(int index,Toleration item) {
        if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
        this.tolerations.add(index, item);
        return (A)this;
    }

    public A setToTolerations(int index,Toleration item) {
        if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
        this.tolerations.set(index, item); return (A)this;
    }

    public A addToTolerations(Toleration... items) {
        if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
        for (Toleration item : items) {this.tolerations.add(item);} return (A)this;
    }

    public A addAllToTolerations(Collection<Toleration> items) {
        if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
        for (Toleration item : items) {this.tolerations.add(item);} return (A)this;
    }

    public A removeFromTolerations(Toleration... items) {
        for (Toleration item : items) {if (this.tolerations!= null){ this.tolerations.remove(item);}} return (A)this;
    }

    public A removeAllFromTolerations(Collection<Toleration> items) {
        for (Toleration item : items) {if (this.tolerations!= null){ this.tolerations.remove(item);}} return (A)this;
    }

    public List<Toleration> getTolerations() {
        return this.tolerations;
    }

    public Toleration getToleration(int index) {
        return this.tolerations.get(index);
    }

    public Toleration getFirstToleration() {
        return this.tolerations.get(0);
    }

    public Toleration getLastToleration() {
        return this.tolerations.get(tolerations.size() - 1);
    }

    public Toleration getMatchingToleration(Predicate<Toleration> predicate) {
        for (Toleration item: tolerations) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingToleration(Predicate<Toleration> predicate) {
        for (Toleration item: tolerations) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withTolerations(List<Toleration> tolerations) {
        if (this.tolerations != null) { _visitables.get("tolerations").removeAll(this.tolerations);}
        if (tolerations != null) {this.tolerations = new ArrayList<Toleration>(); for (Toleration item : tolerations){this.addToTolerations(item);}} else { this.tolerations = null;} return (A) this;
    }

    public A withTolerations(Toleration... tolerations) {
        if (this.tolerations != null) {this.tolerations.clear();}
        if (tolerations != null) {for (Toleration item :tolerations){ this.addToTolerations(item);}} return (A) this;
    }

    public Boolean hasTolerations() {
        return tolerations != null && !tolerations.isEmpty();
    }

    public A addNewToleration(String effect,String key,String operator,Long tolerationSeconds,String value) {
        return (A)addToTolerations(new Toleration(effect, key, operator, tolerationSeconds, value));
    }

    public String getVersion() {
        return this.version;
    }

    public A withVersion(String version) {
        this.version=version; return (A) this;
    }

    public Boolean hasVersion() {
        return this.version != null;
    }

    public A withNewVersion(StringBuilder arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(int[] arg1,int arg2,int arg3) {
        return (A)withVersion(new String(arg1, arg2, arg3));
    }

    public A withNewVersion(char[] arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(StringBuffer arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(byte[] arg1,int arg2) {
        return (A)withVersion(new String(arg1, arg2));
    }

    public A withNewVersion(byte[] arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(char[] arg1,int arg2,int arg3) {
        return (A)withVersion(new String(arg1, arg2, arg3));
    }

    public A withNewVersion(byte[] arg1,int arg2,int arg3) {
        return (A)withVersion(new String(arg1, arg2, arg3));
    }

    public A withNewVersion(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withVersion(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewVersion(String arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A addToVolumeMounts(int index,VolumeMount item) {
        if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<VolumeMount>();}
        this.volumeMounts.add(index, item);
        return (A)this;
    }

    public A setToVolumeMounts(int index,VolumeMount item) {
        if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<VolumeMount>();}
        this.volumeMounts.set(index, item); return (A)this;
    }

    public A addToVolumeMounts(VolumeMount... items) {
        if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<VolumeMount>();}
        for (VolumeMount item : items) {this.volumeMounts.add(item);} return (A)this;
    }

    public A addAllToVolumeMounts(Collection<VolumeMount> items) {
        if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<VolumeMount>();}
        for (VolumeMount item : items) {this.volumeMounts.add(item);} return (A)this;
    }

    public A removeFromVolumeMounts(VolumeMount... items) {
        for (VolumeMount item : items) {if (this.volumeMounts!= null){ this.volumeMounts.remove(item);}} return (A)this;
    }

    public A removeAllFromVolumeMounts(Collection<VolumeMount> items) {
        for (VolumeMount item : items) {if (this.volumeMounts!= null){ this.volumeMounts.remove(item);}} return (A)this;
    }

    public List<VolumeMount> getVolumeMounts() {
        return this.volumeMounts;
    }

    public VolumeMount getVolumeMount(int index) {
        return this.volumeMounts.get(index);
    }

    public VolumeMount getFirstVolumeMount() {
        return this.volumeMounts.get(0);
    }

    public VolumeMount getLastVolumeMount() {
        return this.volumeMounts.get(volumeMounts.size() - 1);
    }

    public VolumeMount getMatchingVolumeMount(Predicate<VolumeMount> predicate) {
        for (VolumeMount item: volumeMounts) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingVolumeMount(Predicate<VolumeMount> predicate) {
        for (VolumeMount item: volumeMounts) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withVolumeMounts(List<VolumeMount> volumeMounts) {
        if (this.volumeMounts != null) { _visitables.get("volumeMounts").removeAll(this.volumeMounts);}
        if (volumeMounts != null) {this.volumeMounts = new ArrayList<VolumeMount>(); for (VolumeMount item : volumeMounts){this.addToVolumeMounts(item);}} else { this.volumeMounts = null;} return (A) this;
    }

    public A withVolumeMounts(VolumeMount... volumeMounts) {
        if (this.volumeMounts != null) {this.volumeMounts.clear();}
        if (volumeMounts != null) {for (VolumeMount item :volumeMounts){ this.addToVolumeMounts(item);}} return (A) this;
    }

    public Boolean hasVolumeMounts() {
        return volumeMounts != null && !volumeMounts.isEmpty();
    }

    public A addToVolumes(int index,Volume item) {
        if (this.volumes == null) {this.volumes = new ArrayList<Volume>();}
        this.volumes.add(index, item);
        return (A)this;
    }

    public A setToVolumes(int index,Volume item) {
        if (this.volumes == null) {this.volumes = new ArrayList<Volume>();}
        this.volumes.set(index, item); return (A)this;
    }

    public A addToVolumes(Volume... items) {
        if (this.volumes == null) {this.volumes = new ArrayList<Volume>();}
        for (Volume item : items) {this.volumes.add(item);} return (A)this;
    }

    public A addAllToVolumes(Collection<Volume> items) {
        if (this.volumes == null) {this.volumes = new ArrayList<Volume>();}
        for (Volume item : items) {this.volumes.add(item);} return (A)this;
    }

    public A removeFromVolumes(Volume... items) {
        for (Volume item : items) {if (this.volumes!= null){ this.volumes.remove(item);}} return (A)this;
    }

    public A removeAllFromVolumes(Collection<Volume> items) {
        for (Volume item : items) {if (this.volumes!= null){ this.volumes.remove(item);}} return (A)this;
    }

    public List<Volume> getVolumes() {
        return this.volumes;
    }

    public Volume getVolume(int index) {
        return this.volumes.get(index);
    }

    public Volume getFirstVolume() {
        return this.volumes.get(0);
    }

    public Volume getLastVolume() {
        return this.volumes.get(volumes.size() - 1);
    }

    public Volume getMatchingVolume(Predicate<Volume> predicate) {
        for (Volume item: volumes) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingVolume(Predicate<Volume> predicate) {
        for (Volume item: volumes) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withVolumes(List<Volume> volumes) {
        if (this.volumes != null) { _visitables.get("volumes").removeAll(this.volumes);}
        if (volumes != null) {this.volumes = new ArrayList<Volume>(); for (Volume item : volumes){this.addToVolumes(item);}} else { this.volumes = null;} return (A) this;
    }

    public A withVolumes(Volume... volumes) {
        if (this.volumes != null) {this.volumes.clear();}
        if (volumes != null) {for (Volume item :volumes){ this.addToVolumes(item);}} return (A) this;
    }

    public Boolean hasVolumes() {
        return volumes != null && !volumes.isEmpty();
    }

    public Boolean getWalCompression() {
        return this.walCompression;
    }

    public A withWalCompression(Boolean walCompression) {
        this.walCompression=walCompression; return (A) this;
    }

    public Boolean hasWalCompression() {
        return this.walCompression != null;
    }

    public A withNewWalCompression(String arg1) {
        return (A)withWalCompression(new Boolean(arg1));
    }

    public A withNewWalCompression(boolean arg1) {
        return (A)withWalCompression(new Boolean(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PrometheusSpecFluentImpl that = (PrometheusSpecFluentImpl) o;
        if (additionalAlertManagerConfigs != null ? !additionalAlertManagerConfigs.equals(that.additionalAlertManagerConfigs) :that.additionalAlertManagerConfigs != null) return false;
        if (additionalAlertRelabelConfigs != null ? !additionalAlertRelabelConfigs.equals(that.additionalAlertRelabelConfigs) :that.additionalAlertRelabelConfigs != null) return false;
        if (additionalScrapeConfigs != null ? !additionalScrapeConfigs.equals(that.additionalScrapeConfigs) :that.additionalScrapeConfigs != null) return false;
        if (affinity != null ? !affinity.equals(that.affinity) :that.affinity != null) return false;
        if (alerting != null ? !alerting.equals(that.alerting) :that.alerting != null) return false;
        if (allowOverlappingBlocks != null ? !allowOverlappingBlocks.equals(that.allowOverlappingBlocks) :that.allowOverlappingBlocks != null) return false;
        if (apiserverConfig != null ? !apiserverConfig.equals(that.apiserverConfig) :that.apiserverConfig != null) return false;
        if (arbitraryFSAccessThroughSMs != null ? !arbitraryFSAccessThroughSMs.equals(that.arbitraryFSAccessThroughSMs) :that.arbitraryFSAccessThroughSMs != null) return false;
        if (baseImage != null ? !baseImage.equals(that.baseImage) :that.baseImage != null) return false;
        if (configMaps != null ? !configMaps.equals(that.configMaps) :that.configMaps != null) return false;
        if (containers != null ? !containers.equals(that.containers) :that.containers != null) return false;
        if (disableCompaction != null ? !disableCompaction.equals(that.disableCompaction) :that.disableCompaction != null) return false;
        if (enableAdminAPI != null ? !enableAdminAPI.equals(that.enableAdminAPI) :that.enableAdminAPI != null) return false;
        if (enforcedNamespaceLabel != null ? !enforcedNamespaceLabel.equals(that.enforcedNamespaceLabel) :that.enforcedNamespaceLabel != null) return false;
        if (enforcedSampleLimit != null ? !enforcedSampleLimit.equals(that.enforcedSampleLimit) :that.enforcedSampleLimit != null) return false;
        if (evaluationInterval != null ? !evaluationInterval.equals(that.evaluationInterval) :that.evaluationInterval != null) return false;
        if (externalLabels != null ? !externalLabels.equals(that.externalLabels) :that.externalLabels != null) return false;
        if (externalUrl != null ? !externalUrl.equals(that.externalUrl) :that.externalUrl != null) return false;
        if (ignoreNamespaceSelectors != null ? !ignoreNamespaceSelectors.equals(that.ignoreNamespaceSelectors) :that.ignoreNamespaceSelectors != null) return false;
        if (image != null ? !image.equals(that.image) :that.image != null) return false;
        if (imagePullSecrets != null ? !imagePullSecrets.equals(that.imagePullSecrets) :that.imagePullSecrets != null) return false;
        if (initContainers != null ? !initContainers.equals(that.initContainers) :that.initContainers != null) return false;
        if (listenLocal != null ? !listenLocal.equals(that.listenLocal) :that.listenLocal != null) return false;
        if (logFormat != null ? !logFormat.equals(that.logFormat) :that.logFormat != null) return false;
        if (logLevel != null ? !logLevel.equals(that.logLevel) :that.logLevel != null) return false;
        if (nodeSelector != null ? !nodeSelector.equals(that.nodeSelector) :that.nodeSelector != null) return false;
        if (overrideHonorLabels != null ? !overrideHonorLabels.equals(that.overrideHonorLabels) :that.overrideHonorLabels != null) return false;
        if (overrideHonorTimestamps != null ? !overrideHonorTimestamps.equals(that.overrideHonorTimestamps) :that.overrideHonorTimestamps != null) return false;
        if (paused != null ? !paused.equals(that.paused) :that.paused != null) return false;
        if (podMetadata != null ? !podMetadata.equals(that.podMetadata) :that.podMetadata != null) return false;
        if (podMonitorNamespaceSelector != null ? !podMonitorNamespaceSelector.equals(that.podMonitorNamespaceSelector) :that.podMonitorNamespaceSelector != null) return false;
        if (podMonitorSelector != null ? !podMonitorSelector.equals(that.podMonitorSelector) :that.podMonitorSelector != null) return false;
        if (portName != null ? !portName.equals(that.portName) :that.portName != null) return false;
        if (priorityClassName != null ? !priorityClassName.equals(that.priorityClassName) :that.priorityClassName != null) return false;
        if (probeNamespaceSelector != null ? !probeNamespaceSelector.equals(that.probeNamespaceSelector) :that.probeNamespaceSelector != null) return false;
        if (probeSelector != null ? !probeSelector.equals(that.probeSelector) :that.probeSelector != null) return false;
        if (prometheusExternalLabelName != null ? !prometheusExternalLabelName.equals(that.prometheusExternalLabelName) :that.prometheusExternalLabelName != null) return false;
        if (prometheusRulesExcludedFromEnforce != null ? !prometheusRulesExcludedFromEnforce.equals(that.prometheusRulesExcludedFromEnforce) :that.prometheusRulesExcludedFromEnforce != null) return false;
        if (query != null ? !query.equals(that.query) :that.query != null) return false;
        if (queryLogFile != null ? !queryLogFile.equals(that.queryLogFile) :that.queryLogFile != null) return false;
        if (remoteRead != null ? !remoteRead.equals(that.remoteRead) :that.remoteRead != null) return false;
        if (remoteWrite != null ? !remoteWrite.equals(that.remoteWrite) :that.remoteWrite != null) return false;
        if (replicaExternalLabelName != null ? !replicaExternalLabelName.equals(that.replicaExternalLabelName) :that.replicaExternalLabelName != null) return false;
        if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
        if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
        if (retention != null ? !retention.equals(that.retention) :that.retention != null) return false;
        if (retentionSize != null ? !retentionSize.equals(that.retentionSize) :that.retentionSize != null) return false;
        if (routePrefix != null ? !routePrefix.equals(that.routePrefix) :that.routePrefix != null) return false;
        if (ruleNamespaceSelector != null ? !ruleNamespaceSelector.equals(that.ruleNamespaceSelector) :that.ruleNamespaceSelector != null) return false;
        if (ruleSelector != null ? !ruleSelector.equals(that.ruleSelector) :that.ruleSelector != null) return false;
        if (rules != null ? !rules.equals(that.rules) :that.rules != null) return false;
        if (scrapeInterval != null ? !scrapeInterval.equals(that.scrapeInterval) :that.scrapeInterval != null) return false;
        if (scrapeTimeout != null ? !scrapeTimeout.equals(that.scrapeTimeout) :that.scrapeTimeout != null) return false;
        if (secrets != null ? !secrets.equals(that.secrets) :that.secrets != null) return false;
        if (securityContext != null ? !securityContext.equals(that.securityContext) :that.securityContext != null) return false;
        if (serviceAccountName != null ? !serviceAccountName.equals(that.serviceAccountName) :that.serviceAccountName != null) return false;
        if (serviceMonitorNamespaceSelector != null ? !serviceMonitorNamespaceSelector.equals(that.serviceMonitorNamespaceSelector) :that.serviceMonitorNamespaceSelector != null) return false;
        if (serviceMonitorSelector != null ? !serviceMonitorSelector.equals(that.serviceMonitorSelector) :that.serviceMonitorSelector != null) return false;
        if (sha != null ? !sha.equals(that.sha) :that.sha != null) return false;
        if (storage != null ? !storage.equals(that.storage) :that.storage != null) return false;
        if (tag != null ? !tag.equals(that.tag) :that.tag != null) return false;
        if (thanos != null ? !thanos.equals(that.thanos) :that.thanos != null) return false;
        if (tolerations != null ? !tolerations.equals(that.tolerations) :that.tolerations != null) return false;
        if (version != null ? !version.equals(that.version) :that.version != null) return false;
        if (volumeMounts != null ? !volumeMounts.equals(that.volumeMounts) :that.volumeMounts != null) return false;
        if (volumes != null ? !volumes.equals(that.volumes) :that.volumes != null) return false;
        if (walCompression != null ? !walCompression.equals(that.walCompression) :that.walCompression != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(additionalAlertManagerConfigs,  additionalAlertRelabelConfigs,  additionalScrapeConfigs,  affinity,  alerting,  allowOverlappingBlocks,  apiserverConfig,  arbitraryFSAccessThroughSMs,  baseImage,  configMaps,  containers,  disableCompaction,  enableAdminAPI,  enforcedNamespaceLabel,  enforcedSampleLimit,  evaluationInterval,  externalLabels,  externalUrl,  ignoreNamespaceSelectors,  image,  imagePullSecrets,  initContainers,  listenLocal,  logFormat,  logLevel,  nodeSelector,  overrideHonorLabels,  overrideHonorTimestamps,  paused,  podMetadata,  podMonitorNamespaceSelector,  podMonitorSelector,  portName,  priorityClassName,  probeNamespaceSelector,  probeSelector,  prometheusExternalLabelName,  prometheusRulesExcludedFromEnforce,  query,  queryLogFile,  remoteRead,  remoteWrite,  replicaExternalLabelName,  replicas,  resources,  retention,  retentionSize,  routePrefix,  ruleNamespaceSelector,  ruleSelector,  rules,  scrapeInterval,  scrapeTimeout,  secrets,  securityContext,  serviceAccountName,  serviceMonitorNamespaceSelector,  serviceMonitorSelector,  sha,  storage,  tag,  thanos,  tolerations,  version,  volumeMounts,  volumes,  walCompression,  super.hashCode());
    }

    public class AlertingNestedImpl<N> extends AlertingSpecFluentImpl<PrometheusSpecFluent.AlertingNested<N>> implements PrometheusSpecFluent.AlertingNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final AlertingSpecBuilder builder;

            AlertingNestedImpl(AlertingSpec item) {
                this.builder = new AlertingSpecBuilder(this, item);
                        
            }

            AlertingNestedImpl() {
                this.builder = new AlertingSpecBuilder(this);
                        
            }

            public N and() {
                return (N) PrometheusSpecFluentImpl.this.withAlerting(builder.build());
            }

            public N endAlerting() {
                return and();
            }
    }


    public class ApiserverConfigNestedImpl<N> extends APIServerConfigFluentImpl<PrometheusSpecFluent.ApiserverConfigNested<N>> implements PrometheusSpecFluent.ApiserverConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final APIServerConfigBuilder builder;

            ApiserverConfigNestedImpl(APIServerConfig item) {
                this.builder = new APIServerConfigBuilder(this, item);
                        
            }

            ApiserverConfigNestedImpl() {
                this.builder = new APIServerConfigBuilder(this);
                        
            }

            public N and() {
                return (N) PrometheusSpecFluentImpl.this.withApiserverConfig(builder.build());
            }

            public N endApiserverConfig() {
                return and();
            }
    }


    public class ArbitraryFSAccessThroughSMsNestedImpl<N> extends ArbitraryFSAccessThroughSMsConfigFluentImpl<PrometheusSpecFluent.ArbitraryFSAccessThroughSMsNested<N>> implements PrometheusSpecFluent.ArbitraryFSAccessThroughSMsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ArbitraryFSAccessThroughSMsConfigBuilder builder;

            ArbitraryFSAccessThroughSMsNestedImpl(ArbitraryFSAccessThroughSMsConfig item) {
                this.builder = new ArbitraryFSAccessThroughSMsConfigBuilder(this, item);
                        
            }

            ArbitraryFSAccessThroughSMsNestedImpl() {
                this.builder = new ArbitraryFSAccessThroughSMsConfigBuilder(this);
                        
            }

            public N and() {
                return (N) PrometheusSpecFluentImpl.this.withArbitraryFSAccessThroughSMs(builder.build());
            }

            public N endArbitraryFSAccessThroughSMs() {
                return and();
            }
    }


    public class ContainersNestedImpl<N> extends ContainerFluentImpl<PrometheusSpecFluent.ContainersNested<N>> implements PrometheusSpecFluent.ContainersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ContainerBuilder builder;
        private final int index;

            ContainersNestedImpl(int index,Container item) {
                this.index = index;
                this.builder = new ContainerBuilder(this, item);
                        
            }

            ContainersNestedImpl() {
                this.index = -1;
                this.builder = new ContainerBuilder(this);
                        
            }

            public N and() {
                return (N) PrometheusSpecFluentImpl.this.setToContainers(index,builder.build());
            }

            public N endContainer() {
                return and();
            }
    }


    public class ImagePullSecretsNestedImpl<N> extends LocalObjectReferenceFluentImpl<PrometheusSpecFluent.ImagePullSecretsNested<N>> implements PrometheusSpecFluent.ImagePullSecretsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final LocalObjectReferenceBuilder builder;
        private final int index;

            ImagePullSecretsNestedImpl(int index,LocalObjectReference item) {
                this.index = index;
                this.builder = new LocalObjectReferenceBuilder(this, item);
                        
            }

            ImagePullSecretsNestedImpl() {
                this.index = -1;
                this.builder = new LocalObjectReferenceBuilder(this);
                        
            }

            public N and() {
                return (N) PrometheusSpecFluentImpl.this.setToImagePullSecrets(index,builder.build());
            }

            public N endImagePullSecret() {
                return and();
            }
    }


    public class InitContainersNestedImpl<N> extends ContainerFluentImpl<PrometheusSpecFluent.InitContainersNested<N>> implements PrometheusSpecFluent.InitContainersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ContainerBuilder builder;
        private final int index;

            InitContainersNestedImpl(int index,Container item) {
                this.index = index;
                this.builder = new ContainerBuilder(this, item);
                        
            }

            InitContainersNestedImpl() {
                this.index = -1;
                this.builder = new ContainerBuilder(this);
                        
            }

            public N and() {
                return (N) PrometheusSpecFluentImpl.this.setToInitContainers(index,builder.build());
            }

            public N endInitContainer() {
                return and();
            }
    }


    public class PodMetadataNestedImpl<N> extends EmbeddedObjectMetadataFluentImpl<PrometheusSpecFluent.PodMetadataNested<N>> implements PrometheusSpecFluent.PodMetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final EmbeddedObjectMetadataBuilder builder;

            PodMetadataNestedImpl(EmbeddedObjectMetadata item) {
                this.builder = new EmbeddedObjectMetadataBuilder(this, item);
                        
            }

            PodMetadataNestedImpl() {
                this.builder = new EmbeddedObjectMetadataBuilder(this);
                        
            }

            public N and() {
                return (N) PrometheusSpecFluentImpl.this.withPodMetadata(builder.build());
            }

            public N endPodMetadata() {
                return and();
            }
    }


    public class PodMonitorNamespaceSelectorNestedImpl<N> extends LabelSelectorFluentImpl<PrometheusSpecFluent.PodMonitorNamespaceSelectorNested<N>> implements PrometheusSpecFluent.PodMonitorNamespaceSelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final LabelSelectorBuilder builder;

            PodMonitorNamespaceSelectorNestedImpl(LabelSelector item) {
                this.builder = new LabelSelectorBuilder(this, item);
                        
            }

            PodMonitorNamespaceSelectorNestedImpl() {
                this.builder = new LabelSelectorBuilder(this);
                        
            }

            public N and() {
                return (N) PrometheusSpecFluentImpl.this.withPodMonitorNamespaceSelector(builder.build());
            }

            public N endPodMonitorNamespaceSelector() {
                return and();
            }
    }


    public class PodMonitorSelectorNestedImpl<N> extends LabelSelectorFluentImpl<PrometheusSpecFluent.PodMonitorSelectorNested<N>> implements PrometheusSpecFluent.PodMonitorSelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final LabelSelectorBuilder builder;

            PodMonitorSelectorNestedImpl(LabelSelector item) {
                this.builder = new LabelSelectorBuilder(this, item);
                        
            }

            PodMonitorSelectorNestedImpl() {
                this.builder = new LabelSelectorBuilder(this);
                        
            }

            public N and() {
                return (N) PrometheusSpecFluentImpl.this.withPodMonitorSelector(builder.build());
            }

            public N endPodMonitorSelector() {
                return and();
            }
    }


    public class ProbeNamespaceSelectorNestedImpl<N> extends LabelSelectorFluentImpl<PrometheusSpecFluent.ProbeNamespaceSelectorNested<N>> implements PrometheusSpecFluent.ProbeNamespaceSelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final LabelSelectorBuilder builder;

            ProbeNamespaceSelectorNestedImpl(LabelSelector item) {
                this.builder = new LabelSelectorBuilder(this, item);
                        
            }

            ProbeNamespaceSelectorNestedImpl() {
                this.builder = new LabelSelectorBuilder(this);
                        
            }

            public N and() {
                return (N) PrometheusSpecFluentImpl.this.withProbeNamespaceSelector(builder.build());
            }

            public N endProbeNamespaceSelector() {
                return and();
            }
    }


    public class ProbeSelectorNestedImpl<N> extends LabelSelectorFluentImpl<PrometheusSpecFluent.ProbeSelectorNested<N>> implements PrometheusSpecFluent.ProbeSelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final LabelSelectorBuilder builder;

            ProbeSelectorNestedImpl(LabelSelector item) {
                this.builder = new LabelSelectorBuilder(this, item);
                        
            }

            ProbeSelectorNestedImpl() {
                this.builder = new LabelSelectorBuilder(this);
                        
            }

            public N and() {
                return (N) PrometheusSpecFluentImpl.this.withProbeSelector(builder.build());
            }

            public N endProbeSelector() {
                return and();
            }
    }


    public class PrometheusRulesExcludedFromEnforceNestedImpl<N> extends PrometheusRuleExcludeConfigFluentImpl<PrometheusSpecFluent.PrometheusRulesExcludedFromEnforceNested<N>> implements PrometheusSpecFluent.PrometheusRulesExcludedFromEnforceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PrometheusRuleExcludeConfigBuilder builder;
        private final int index;

            PrometheusRulesExcludedFromEnforceNestedImpl(int index,PrometheusRuleExcludeConfig item) {
                this.index = index;
                this.builder = new PrometheusRuleExcludeConfigBuilder(this, item);
                        
            }

            PrometheusRulesExcludedFromEnforceNestedImpl() {
                this.index = -1;
                this.builder = new PrometheusRuleExcludeConfigBuilder(this);
                        
            }

            public N and() {
                return (N) PrometheusSpecFluentImpl.this.setToPrometheusRulesExcludedFromEnforce(index,builder.build());
            }

            public N endPrometheusRulesExcludedFromEnforce() {
                return and();
            }
    }


    public class QueryNestedImpl<N> extends QuerySpecFluentImpl<PrometheusSpecFluent.QueryNested<N>> implements PrometheusSpecFluent.QueryNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final QuerySpecBuilder builder;

            QueryNestedImpl(QuerySpec item) {
                this.builder = new QuerySpecBuilder(this, item);
                        
            }

            QueryNestedImpl() {
                this.builder = new QuerySpecBuilder(this);
                        
            }

            public N and() {
                return (N) PrometheusSpecFluentImpl.this.withQuery(builder.build());
            }

            public N endQuery() {
                return and();
            }
    }


    public class RemoteReadNestedImpl<N> extends RemoteReadSpecFluentImpl<PrometheusSpecFluent.RemoteReadNested<N>> implements PrometheusSpecFluent.RemoteReadNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final RemoteReadSpecBuilder builder;
        private final int index;

            RemoteReadNestedImpl(int index,RemoteReadSpec item) {
                this.index = index;
                this.builder = new RemoteReadSpecBuilder(this, item);
                        
            }

            RemoteReadNestedImpl() {
                this.index = -1;
                this.builder = new RemoteReadSpecBuilder(this);
                        
            }

            public N and() {
                return (N) PrometheusSpecFluentImpl.this.setToRemoteRead(index,builder.build());
            }

            public N endRemoteRead() {
                return and();
            }
    }


    public class RemoteWriteNestedImpl<N> extends RemoteWriteSpecFluentImpl<PrometheusSpecFluent.RemoteWriteNested<N>> implements PrometheusSpecFluent.RemoteWriteNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final RemoteWriteSpecBuilder builder;
        private final int index;

            RemoteWriteNestedImpl(int index,RemoteWriteSpec item) {
                this.index = index;
                this.builder = new RemoteWriteSpecBuilder(this, item);
                        
            }

            RemoteWriteNestedImpl() {
                this.index = -1;
                this.builder = new RemoteWriteSpecBuilder(this);
                        
            }

            public N and() {
                return (N) PrometheusSpecFluentImpl.this.setToRemoteWrite(index,builder.build());
            }

            public N endRemoteWrite() {
                return and();
            }
    }


    public class ResourcesNestedImpl<N> extends ResourceRequirementsFluentImpl<PrometheusSpecFluent.ResourcesNested<N>> implements PrometheusSpecFluent.ResourcesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ResourceRequirementsBuilder builder;

            ResourcesNestedImpl(ResourceRequirements item) {
                this.builder = new ResourceRequirementsBuilder(this, item);
                        
            }

            ResourcesNestedImpl() {
                this.builder = new ResourceRequirementsBuilder(this);
                        
            }

            public N and() {
                return (N) PrometheusSpecFluentImpl.this.withResources(builder.build());
            }

            public N endResources() {
                return and();
            }
    }


    public class RuleNamespaceSelectorNestedImpl<N> extends LabelSelectorFluentImpl<PrometheusSpecFluent.RuleNamespaceSelectorNested<N>> implements PrometheusSpecFluent.RuleNamespaceSelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final LabelSelectorBuilder builder;

            RuleNamespaceSelectorNestedImpl(LabelSelector item) {
                this.builder = new LabelSelectorBuilder(this, item);
                        
            }

            RuleNamespaceSelectorNestedImpl() {
                this.builder = new LabelSelectorBuilder(this);
                        
            }

            public N and() {
                return (N) PrometheusSpecFluentImpl.this.withRuleNamespaceSelector(builder.build());
            }

            public N endRuleNamespaceSelector() {
                return and();
            }
    }


    public class RuleSelectorNestedImpl<N> extends LabelSelectorFluentImpl<PrometheusSpecFluent.RuleSelectorNested<N>> implements PrometheusSpecFluent.RuleSelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final LabelSelectorBuilder builder;

            RuleSelectorNestedImpl(LabelSelector item) {
                this.builder = new LabelSelectorBuilder(this, item);
                        
            }

            RuleSelectorNestedImpl() {
                this.builder = new LabelSelectorBuilder(this);
                        
            }

            public N and() {
                return (N) PrometheusSpecFluentImpl.this.withRuleSelector(builder.build());
            }

            public N endRuleSelector() {
                return and();
            }
    }


    public class RulesNestedImpl<N> extends RulesFluentImpl<PrometheusSpecFluent.RulesNested<N>> implements PrometheusSpecFluent.RulesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final RulesBuilder builder;

            RulesNestedImpl(Rules item) {
                this.builder = new RulesBuilder(this, item);
                        
            }

            RulesNestedImpl() {
                this.builder = new RulesBuilder(this);
                        
            }

            public N and() {
                return (N) PrometheusSpecFluentImpl.this.withRules(builder.build());
            }

            public N endRules() {
                return and();
            }
    }


    public class ServiceMonitorNamespaceSelectorNestedImpl<N> extends LabelSelectorFluentImpl<PrometheusSpecFluent.ServiceMonitorNamespaceSelectorNested<N>> implements PrometheusSpecFluent.ServiceMonitorNamespaceSelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final LabelSelectorBuilder builder;

            ServiceMonitorNamespaceSelectorNestedImpl(LabelSelector item) {
                this.builder = new LabelSelectorBuilder(this, item);
                        
            }

            ServiceMonitorNamespaceSelectorNestedImpl() {
                this.builder = new LabelSelectorBuilder(this);
                        
            }

            public N and() {
                return (N) PrometheusSpecFluentImpl.this.withServiceMonitorNamespaceSelector(builder.build());
            }

            public N endServiceMonitorNamespaceSelector() {
                return and();
            }
    }


    public class ServiceMonitorSelectorNestedImpl<N> extends LabelSelectorFluentImpl<PrometheusSpecFluent.ServiceMonitorSelectorNested<N>> implements PrometheusSpecFluent.ServiceMonitorSelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final LabelSelectorBuilder builder;

            ServiceMonitorSelectorNestedImpl(LabelSelector item) {
                this.builder = new LabelSelectorBuilder(this, item);
                        
            }

            ServiceMonitorSelectorNestedImpl() {
                this.builder = new LabelSelectorBuilder(this);
                        
            }

            public N and() {
                return (N) PrometheusSpecFluentImpl.this.withServiceMonitorSelector(builder.build());
            }

            public N endServiceMonitorSelector() {
                return and();
            }
    }


    public class StorageNestedImpl<N> extends StorageSpecFluentImpl<PrometheusSpecFluent.StorageNested<N>> implements PrometheusSpecFluent.StorageNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final StorageSpecBuilder builder;

            StorageNestedImpl(StorageSpec item) {
                this.builder = new StorageSpecBuilder(this, item);
                        
            }

            StorageNestedImpl() {
                this.builder = new StorageSpecBuilder(this);
                        
            }

            public N and() {
                return (N) PrometheusSpecFluentImpl.this.withStorage(builder.build());
            }

            public N endStorage() {
                return and();
            }
    }


    public class ThanosNestedImpl<N> extends ThanosSpecFluentImpl<PrometheusSpecFluent.ThanosNested<N>> implements PrometheusSpecFluent.ThanosNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ThanosSpecBuilder builder;

            ThanosNestedImpl(ThanosSpec item) {
                this.builder = new ThanosSpecBuilder(this, item);
                        
            }

            ThanosNestedImpl() {
                this.builder = new ThanosSpecBuilder(this);
                        
            }

            public N and() {
                return (N) PrometheusSpecFluentImpl.this.withThanos(builder.build());
            }

            public N endThanos() {
                return and();
            }
    }


}
