package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.StringBuffer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;

public class PodMonitorSpecFluentImpl<A extends PodMonitorSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PodMonitorSpecFluent<A> {

    private String jobLabel;
    private NamespaceSelectorBuilder namespaceSelector;
    private List<PodMetricsEndpointBuilder> podMetricsEndpoints =  new ArrayList<PodMetricsEndpointBuilder>();
    private List<String> podTargetLabels = new ArrayList<String>();
    private Long sampleLimit;
    private LabelSelectorBuilder selector;

    public PodMonitorSpecFluentImpl() {
    }

    public PodMonitorSpecFluentImpl(PodMonitorSpec instance) {
        this.withJobLabel(instance.getJobLabel()); 
        this.withNamespaceSelector(instance.getNamespaceSelector()); 
        this.withPodMetricsEndpoints(instance.getPodMetricsEndpoints()); 
        this.withPodTargetLabels(instance.getPodTargetLabels()); 
        this.withSampleLimit(instance.getSampleLimit()); 
        this.withSelector(instance.getSelector()); 
    }

    public String getJobLabel() {
        return this.jobLabel;
    }

    public A withJobLabel(String jobLabel) {
        this.jobLabel=jobLabel; return (A) this;
    }

    public Boolean hasJobLabel() {
        return this.jobLabel != null;
    }

    public A withNewJobLabel(StringBuilder arg1) {
        return (A)withJobLabel(new String(arg1));
    }

    public A withNewJobLabel(int[] arg1,int arg2,int arg3) {
        return (A)withJobLabel(new String(arg1, arg2, arg3));
    }

    public A withNewJobLabel(char[] arg1) {
        return (A)withJobLabel(new String(arg1));
    }

    public A withNewJobLabel(StringBuffer arg1) {
        return (A)withJobLabel(new String(arg1));
    }

    public A withNewJobLabel(byte[] arg1,int arg2) {
        return (A)withJobLabel(new String(arg1, arg2));
    }

    public A withNewJobLabel(byte[] arg1) {
        return (A)withJobLabel(new String(arg1));
    }

    public A withNewJobLabel(char[] arg1,int arg2,int arg3) {
        return (A)withJobLabel(new String(arg1, arg2, arg3));
    }

    public A withNewJobLabel(byte[] arg1,int arg2,int arg3) {
        return (A)withJobLabel(new String(arg1, arg2, arg3));
    }

    public A withNewJobLabel(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withJobLabel(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewJobLabel(String arg1) {
        return (A)withJobLabel(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildNamespaceSelector instead.
 * @return The buildable object.
 */
@Deprecated public NamespaceSelector getNamespaceSelector() {
        return this.namespaceSelector!=null?this.namespaceSelector.build():null;
    }

    public NamespaceSelector buildNamespaceSelector() {
        return this.namespaceSelector!=null?this.namespaceSelector.build():null;
    }

    public A withNamespaceSelector(NamespaceSelector namespaceSelector) {
        _visitables.get("namespaceSelector").remove(this.namespaceSelector);
        if (namespaceSelector!=null){ this.namespaceSelector= new NamespaceSelectorBuilder(namespaceSelector); _visitables.get("namespaceSelector").add(this.namespaceSelector);} return (A) this;
    }

    public Boolean hasNamespaceSelector() {
        return this.namespaceSelector != null;
    }

    public PodMonitorSpecFluent.NamespaceSelectorNested<A> withNewNamespaceSelector() {
        return new NamespaceSelectorNestedImpl();
    }

    public PodMonitorSpecFluent.NamespaceSelectorNested<A> withNewNamespaceSelectorLike(NamespaceSelector item) {
        return new NamespaceSelectorNestedImpl(item);
    }

    public PodMonitorSpecFluent.NamespaceSelectorNested<A> editNamespaceSelector() {
        return withNewNamespaceSelectorLike(getNamespaceSelector());
    }

    public PodMonitorSpecFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelector() {
        return withNewNamespaceSelectorLike(getNamespaceSelector() != null ? getNamespaceSelector(): new NamespaceSelectorBuilder().build());
    }

    public PodMonitorSpecFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(NamespaceSelector item) {
        return withNewNamespaceSelectorLike(getNamespaceSelector() != null ? getNamespaceSelector(): item);
    }

    public A addToPodMetricsEndpoints(int index,PodMetricsEndpoint item) {
        if (this.podMetricsEndpoints == null) {this.podMetricsEndpoints = new ArrayList<PodMetricsEndpointBuilder>();}
        PodMetricsEndpointBuilder builder = new PodMetricsEndpointBuilder(item);_visitables.get("podMetricsEndpoints").add(index >= 0 ? index : _visitables.get("podMetricsEndpoints").size(), builder);this.podMetricsEndpoints.add(index >= 0 ? index : podMetricsEndpoints.size(), builder); return (A)this;
    }

    public A setToPodMetricsEndpoints(int index,PodMetricsEndpoint item) {
        if (this.podMetricsEndpoints == null) {this.podMetricsEndpoints = new ArrayList<PodMetricsEndpointBuilder>();}
        PodMetricsEndpointBuilder builder = new PodMetricsEndpointBuilder(item);
        if (index < 0 || index >= _visitables.get("podMetricsEndpoints").size()) { _visitables.get("podMetricsEndpoints").add(builder); } else { _visitables.get("podMetricsEndpoints").set(index, builder);}
        if (index < 0 || index >= podMetricsEndpoints.size()) { podMetricsEndpoints.add(builder); } else { podMetricsEndpoints.set(index, builder);}
         return (A)this;
    }

    public A addToPodMetricsEndpoints(PodMetricsEndpoint... items) {
        if (this.podMetricsEndpoints == null) {this.podMetricsEndpoints = new ArrayList<PodMetricsEndpointBuilder>();}
        for (PodMetricsEndpoint item : items) {PodMetricsEndpointBuilder builder = new PodMetricsEndpointBuilder(item);_visitables.get("podMetricsEndpoints").add(builder);this.podMetricsEndpoints.add(builder);} return (A)this;
    }

    public A addAllToPodMetricsEndpoints(Collection<PodMetricsEndpoint> items) {
        if (this.podMetricsEndpoints == null) {this.podMetricsEndpoints = new ArrayList<PodMetricsEndpointBuilder>();}
        for (PodMetricsEndpoint item : items) {PodMetricsEndpointBuilder builder = new PodMetricsEndpointBuilder(item);_visitables.get("podMetricsEndpoints").add(builder);this.podMetricsEndpoints.add(builder);} return (A)this;
    }

    public A removeFromPodMetricsEndpoints(PodMetricsEndpoint... items) {
        for (PodMetricsEndpoint item : items) {PodMetricsEndpointBuilder builder = new PodMetricsEndpointBuilder(item);_visitables.get("podMetricsEndpoints").remove(builder);if (this.podMetricsEndpoints != null) {this.podMetricsEndpoints.remove(builder);}} return (A)this;
    }

    public A removeAllFromPodMetricsEndpoints(Collection<PodMetricsEndpoint> items) {
        for (PodMetricsEndpoint item : items) {PodMetricsEndpointBuilder builder = new PodMetricsEndpointBuilder(item);_visitables.get("podMetricsEndpoints").remove(builder);if (this.podMetricsEndpoints != null) {this.podMetricsEndpoints.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromPodMetricsEndpoints(Predicate<PodMetricsEndpointBuilder> predicate) {
        if (podMetricsEndpoints == null) return (A) this;
        final Iterator<PodMetricsEndpointBuilder> each = podMetricsEndpoints.iterator();
        final List visitables = _visitables.get("podMetricsEndpoints");
        while (each.hasNext()) {
          PodMetricsEndpointBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildPodMetricsEndpoints instead.
 * @return The buildable object.
 */
@Deprecated public List<PodMetricsEndpoint> getPodMetricsEndpoints() {
        return build(podMetricsEndpoints);
    }

    public List<PodMetricsEndpoint> buildPodMetricsEndpoints() {
        return build(podMetricsEndpoints);
    }

    public PodMetricsEndpoint buildPodMetricsEndpoint(int index) {
        return this.podMetricsEndpoints.get(index).build();
    }

    public PodMetricsEndpoint buildFirstPodMetricsEndpoint() {
        return this.podMetricsEndpoints.get(0).build();
    }

    public PodMetricsEndpoint buildLastPodMetricsEndpoint() {
        return this.podMetricsEndpoints.get(podMetricsEndpoints.size() - 1).build();
    }

    public PodMetricsEndpoint buildMatchingPodMetricsEndpoint(Predicate<PodMetricsEndpointBuilder> predicate) {
        for (PodMetricsEndpointBuilder item: podMetricsEndpoints) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingPodMetricsEndpoint(Predicate<PodMetricsEndpointBuilder> predicate) {
        for (PodMetricsEndpointBuilder item: podMetricsEndpoints) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withPodMetricsEndpoints(List<PodMetricsEndpoint> podMetricsEndpoints) {
        if (this.podMetricsEndpoints != null) { _visitables.get("podMetricsEndpoints").removeAll(this.podMetricsEndpoints);}
        if (podMetricsEndpoints != null) {this.podMetricsEndpoints = new ArrayList<PodMetricsEndpointBuilder>(); for (PodMetricsEndpoint item : podMetricsEndpoints){this.addToPodMetricsEndpoints(item);}} else { this.podMetricsEndpoints = null;} return (A) this;
    }

    public A withPodMetricsEndpoints(PodMetricsEndpoint... podMetricsEndpoints) {
        if (this.podMetricsEndpoints != null) {this.podMetricsEndpoints.clear();}
        if (podMetricsEndpoints != null) {for (PodMetricsEndpoint item :podMetricsEndpoints){ this.addToPodMetricsEndpoints(item);}} return (A) this;
    }

    public Boolean hasPodMetricsEndpoints() {
        return podMetricsEndpoints != null && !podMetricsEndpoints.isEmpty();
    }

    public PodMonitorSpecFluent.PodMetricsEndpointsNested<A> addNewPodMetricsEndpoint() {
        return new PodMetricsEndpointsNestedImpl();
    }

    public PodMonitorSpecFluent.PodMetricsEndpointsNested<A> addNewPodMetricsEndpointLike(PodMetricsEndpoint item) {
        return new PodMetricsEndpointsNestedImpl(-1, item);
    }

    public PodMonitorSpecFluent.PodMetricsEndpointsNested<A> setNewPodMetricsEndpointLike(int index,PodMetricsEndpoint item) {
        return new PodMetricsEndpointsNestedImpl(index, item);
    }

    public PodMonitorSpecFluent.PodMetricsEndpointsNested<A> editPodMetricsEndpoint(int index) {
        if (podMetricsEndpoints.size() <= index) throw new RuntimeException("Can't edit podMetricsEndpoints. Index exceeds size.");
        return setNewPodMetricsEndpointLike(index, buildPodMetricsEndpoint(index));
    }

    public PodMonitorSpecFluent.PodMetricsEndpointsNested<A> editFirstPodMetricsEndpoint() {
        if (podMetricsEndpoints.size() == 0) throw new RuntimeException("Can't edit first podMetricsEndpoints. The list is empty.");
        return setNewPodMetricsEndpointLike(0, buildPodMetricsEndpoint(0));
    }

    public PodMonitorSpecFluent.PodMetricsEndpointsNested<A> editLastPodMetricsEndpoint() {
        int index = podMetricsEndpoints.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last podMetricsEndpoints. The list is empty.");
        return setNewPodMetricsEndpointLike(index, buildPodMetricsEndpoint(index));
    }

    public PodMonitorSpecFluent.PodMetricsEndpointsNested<A> editMatchingPodMetricsEndpoint(Predicate<PodMetricsEndpointBuilder> predicate) {
        int index = -1;
        for (int i=0;i<podMetricsEndpoints.size();i++) { 
        if (predicate.test(podMetricsEndpoints.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching podMetricsEndpoints. No match found.");
        return setNewPodMetricsEndpointLike(index, buildPodMetricsEndpoint(index));
    }

    public A addToPodTargetLabels(int index,String item) {
        if (this.podTargetLabels == null) {this.podTargetLabels = new ArrayList<String>();}
        this.podTargetLabels.add(index, item);
        return (A)this;
    }

    public A setToPodTargetLabels(int index,String item) {
        if (this.podTargetLabels == null) {this.podTargetLabels = new ArrayList<String>();}
        this.podTargetLabels.set(index, item); return (A)this;
    }

    public A addToPodTargetLabels(String... items) {
        if (this.podTargetLabels == null) {this.podTargetLabels = new ArrayList<String>();}
        for (String item : items) {this.podTargetLabels.add(item);} return (A)this;
    }

    public A addAllToPodTargetLabels(Collection<String> items) {
        if (this.podTargetLabels == null) {this.podTargetLabels = new ArrayList<String>();}
        for (String item : items) {this.podTargetLabels.add(item);} return (A)this;
    }

    public A removeFromPodTargetLabels(String... items) {
        for (String item : items) {if (this.podTargetLabels!= null){ this.podTargetLabels.remove(item);}} return (A)this;
    }

    public A removeAllFromPodTargetLabels(Collection<String> items) {
        for (String item : items) {if (this.podTargetLabels!= null){ this.podTargetLabels.remove(item);}} return (A)this;
    }

    public List<String> getPodTargetLabels() {
        return this.podTargetLabels;
    }

    public String getPodTargetLabel(int index) {
        return this.podTargetLabels.get(index);
    }

    public String getFirstPodTargetLabel() {
        return this.podTargetLabels.get(0);
    }

    public String getLastPodTargetLabel() {
        return this.podTargetLabels.get(podTargetLabels.size() - 1);
    }

    public String getMatchingPodTargetLabel(Predicate<String> predicate) {
        for (String item: podTargetLabels) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingPodTargetLabel(Predicate<String> predicate) {
        for (String item: podTargetLabels) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withPodTargetLabels(List<String> podTargetLabels) {
        if (this.podTargetLabels != null) { _visitables.get("podTargetLabels").removeAll(this.podTargetLabels);}
        if (podTargetLabels != null) {this.podTargetLabels = new ArrayList<String>(); for (String item : podTargetLabels){this.addToPodTargetLabels(item);}} else { this.podTargetLabels = null;} return (A) this;
    }

    public A withPodTargetLabels(String... podTargetLabels) {
        if (this.podTargetLabels != null) {this.podTargetLabels.clear();}
        if (podTargetLabels != null) {for (String item :podTargetLabels){ this.addToPodTargetLabels(item);}} return (A) this;
    }

    public Boolean hasPodTargetLabels() {
        return podTargetLabels != null && !podTargetLabels.isEmpty();
    }

    public A addNewPodTargetLabel(StringBuilder arg1) {
        return (A)addToPodTargetLabels(new String(arg1));
    }

    public A addNewPodTargetLabel(int[] arg1,int arg2,int arg3) {
        return (A)addToPodTargetLabels(new String(arg1, arg2, arg3));
    }

    public A addNewPodTargetLabel(char[] arg1) {
        return (A)addToPodTargetLabels(new String(arg1));
    }

    public A addNewPodTargetLabel(StringBuffer arg1) {
        return (A)addToPodTargetLabels(new String(arg1));
    }

    public A addNewPodTargetLabel(byte[] arg1,int arg2) {
        return (A)addToPodTargetLabels(new String(arg1, arg2));
    }

    public A addNewPodTargetLabel(byte[] arg1) {
        return (A)addToPodTargetLabels(new String(arg1));
    }

    public A addNewPodTargetLabel(char[] arg1,int arg2,int arg3) {
        return (A)addToPodTargetLabels(new String(arg1, arg2, arg3));
    }

    public A addNewPodTargetLabel(byte[] arg1,int arg2,int arg3) {
        return (A)addToPodTargetLabels(new String(arg1, arg2, arg3));
    }

    public A addNewPodTargetLabel(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)addToPodTargetLabels(new String(arg1, arg2, arg3, arg4));
    }

    public A addNewPodTargetLabel(String arg1) {
        return (A)addToPodTargetLabels(new String(arg1));
    }

    public Long getSampleLimit() {
        return this.sampleLimit;
    }

    public A withSampleLimit(Long sampleLimit) {
        this.sampleLimit=sampleLimit; return (A) this;
    }

    public Boolean hasSampleLimit() {
        return this.sampleLimit != null;
    }

    public A withNewSampleLimit(long arg1) {
        return (A)withSampleLimit(new Long(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildSelector instead.
 * @return The buildable object.
 */
@Deprecated public LabelSelector getSelector() {
        return this.selector!=null?this.selector.build():null;
    }

    public LabelSelector buildSelector() {
        return this.selector!=null?this.selector.build():null;
    }

    public A withSelector(LabelSelector selector) {
        _visitables.get("selector").remove(this.selector);
        if (selector!=null){ this.selector= new LabelSelectorBuilder(selector); _visitables.get("selector").add(this.selector);} return (A) this;
    }

    public Boolean hasSelector() {
        return this.selector != null;
    }

    public PodMonitorSpecFluent.SelectorNested<A> withNewSelector() {
        return new SelectorNestedImpl();
    }

    public PodMonitorSpecFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item) {
        return new SelectorNestedImpl(item);
    }

    public PodMonitorSpecFluent.SelectorNested<A> editSelector() {
        return withNewSelectorLike(getSelector());
    }

    public PodMonitorSpecFluent.SelectorNested<A> editOrNewSelector() {
        return withNewSelectorLike(getSelector() != null ? getSelector(): new LabelSelectorBuilder().build());
    }

    public PodMonitorSpecFluent.SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
        return withNewSelectorLike(getSelector() != null ? getSelector(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PodMonitorSpecFluentImpl that = (PodMonitorSpecFluentImpl) o;
        if (jobLabel != null ? !jobLabel.equals(that.jobLabel) :that.jobLabel != null) return false;
        if (namespaceSelector != null ? !namespaceSelector.equals(that.namespaceSelector) :that.namespaceSelector != null) return false;
        if (podMetricsEndpoints != null ? !podMetricsEndpoints.equals(that.podMetricsEndpoints) :that.podMetricsEndpoints != null) return false;
        if (podTargetLabels != null ? !podTargetLabels.equals(that.podTargetLabels) :that.podTargetLabels != null) return false;
        if (sampleLimit != null ? !sampleLimit.equals(that.sampleLimit) :that.sampleLimit != null) return false;
        if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(jobLabel,  namespaceSelector,  podMetricsEndpoints,  podTargetLabels,  sampleLimit,  selector,  super.hashCode());
    }

    public class NamespaceSelectorNestedImpl<N> extends NamespaceSelectorFluentImpl<PodMonitorSpecFluent.NamespaceSelectorNested<N>> implements PodMonitorSpecFluent.NamespaceSelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final NamespaceSelectorBuilder builder;

            NamespaceSelectorNestedImpl(NamespaceSelector item) {
                this.builder = new NamespaceSelectorBuilder(this, item);
                        
            }

            NamespaceSelectorNestedImpl() {
                this.builder = new NamespaceSelectorBuilder(this);
                        
            }

            public N and() {
                return (N) PodMonitorSpecFluentImpl.this.withNamespaceSelector(builder.build());
            }

            public N endNamespaceSelector() {
                return and();
            }
    }


    public class PodMetricsEndpointsNestedImpl<N> extends PodMetricsEndpointFluentImpl<PodMonitorSpecFluent.PodMetricsEndpointsNested<N>> implements PodMonitorSpecFluent.PodMetricsEndpointsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PodMetricsEndpointBuilder builder;
        private final int index;

            PodMetricsEndpointsNestedImpl(int index,PodMetricsEndpoint item) {
                this.index = index;
                this.builder = new PodMetricsEndpointBuilder(this, item);
                        
            }

            PodMetricsEndpointsNestedImpl() {
                this.index = -1;
                this.builder = new PodMetricsEndpointBuilder(this);
                        
            }

            public N and() {
                return (N) PodMonitorSpecFluentImpl.this.setToPodMetricsEndpoints(index,builder.build());
            }

            public N endPodMetricsEndpoint() {
                return and();
            }
    }


    public class SelectorNestedImpl<N> extends LabelSelectorFluentImpl<PodMonitorSpecFluent.SelectorNested<N>> implements PodMonitorSpecFluent.SelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final LabelSelectorBuilder builder;

            SelectorNestedImpl(LabelSelector item) {
                this.builder = new LabelSelectorBuilder(this, item);
                        
            }

            SelectorNestedImpl() {
                this.builder = new LabelSelectorBuilder(this);
                        
            }

            public N and() {
                return (N) PodMonitorSpecFluentImpl.this.withSelector(builder.build());
            }

            public N endSelector() {
                return and();
            }
    }


}
