package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.model.IntOrString;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import com.fasterxml.jackson.databind.JsonSerializer;
import java.lang.String;
import com.fasterxml.jackson.databind.JsonDeserializer;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import java.util.List;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Boolean;
import com.fasterxml.jackson.core.JsonParser;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.IntOrStringFluent;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface PodMetricsEndpointFluent<A extends PodMetricsEndpointFluent<A>> extends Fluent<A> {


    public Boolean getHonorLabels();
    public A withHonorLabels(Boolean honorLabels);
    public Boolean hasHonorLabels();
    public A withNewHonorLabels(String arg1);
    public A withNewHonorLabels(boolean arg1);
    public Boolean getHonorTimestamps();
    public A withHonorTimestamps(Boolean honorTimestamps);
    public Boolean hasHonorTimestamps();
    public A withNewHonorTimestamps(String arg1);
    public A withNewHonorTimestamps(boolean arg1);
    public String getInterval();
    public A withInterval(String interval);
    public Boolean hasInterval();
    public A withNewInterval(StringBuilder arg1);
    public A withNewInterval(int[] arg1,int arg2,int arg3);
    public A withNewInterval(char[] arg1);
    public A withNewInterval(StringBuffer arg1);
    public A withNewInterval(byte[] arg1,int arg2);
    public A withNewInterval(byte[] arg1);
    public A withNewInterval(char[] arg1,int arg2,int arg3);
    public A withNewInterval(byte[] arg1,int arg2,int arg3);
    public A withNewInterval(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewInterval(String arg1);
    public A addToMetricRelabelings(int index,RelabelConfig item);
    public A setToMetricRelabelings(int index,RelabelConfig item);
    public A addToMetricRelabelings(RelabelConfig... items);
    public A addAllToMetricRelabelings(Collection<RelabelConfig> items);
    public A removeFromMetricRelabelings(RelabelConfig... items);
    public A removeAllFromMetricRelabelings(Collection<RelabelConfig> items);
    public A removeMatchingFromMetricRelabelings(Predicate<RelabelConfigBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildMetricRelabelings instead.
 * @return The buildable object.
 */
@Deprecated public List<RelabelConfig> getMetricRelabelings();
    public List<RelabelConfig> buildMetricRelabelings();
    public RelabelConfig buildMetricRelabeling(int index);
    public RelabelConfig buildFirstMetricRelabeling();
    public RelabelConfig buildLastMetricRelabeling();
    public RelabelConfig buildMatchingMetricRelabeling(Predicate<RelabelConfigBuilder> predicate);
    public Boolean hasMatchingMetricRelabeling(Predicate<RelabelConfigBuilder> predicate);
    public A withMetricRelabelings(List<RelabelConfig> metricRelabelings);
    public A withMetricRelabelings(RelabelConfig... metricRelabelings);
    public Boolean hasMetricRelabelings();
    public PodMetricsEndpointFluent.MetricRelabelingsNested<A> addNewMetricRelabeling();
    public PodMetricsEndpointFluent.MetricRelabelingsNested<A> addNewMetricRelabelingLike(RelabelConfig item);
    public PodMetricsEndpointFluent.MetricRelabelingsNested<A> setNewMetricRelabelingLike(int index,RelabelConfig item);
    public PodMetricsEndpointFluent.MetricRelabelingsNested<A> editMetricRelabeling(int index);
    public PodMetricsEndpointFluent.MetricRelabelingsNested<A> editFirstMetricRelabeling();
    public PodMetricsEndpointFluent.MetricRelabelingsNested<A> editLastMetricRelabeling();
    public PodMetricsEndpointFluent.MetricRelabelingsNested<A> editMatchingMetricRelabeling(Predicate<RelabelConfigBuilder> predicate);
    public A addToParams(String key,ArrayList<String> value);
    public A addToParams(Map<String,ArrayList<String>> map);
    public A removeFromParams(String key);
    public A removeFromParams(Map<String,ArrayList<String>> map);
    public Map<String,ArrayList<String>> getParams();
    public <K extends Object,V extends Object>A withParams(Map<String,ArrayList<String>> params);
    public Boolean hasParams();
    public String getPath();
    public A withPath(String path);
    public Boolean hasPath();
    public A withNewPath(StringBuilder arg1);
    public A withNewPath(int[] arg1,int arg2,int arg3);
    public A withNewPath(char[] arg1);
    public A withNewPath(StringBuffer arg1);
    public A withNewPath(byte[] arg1,int arg2);
    public A withNewPath(byte[] arg1);
    public A withNewPath(char[] arg1,int arg2,int arg3);
    public A withNewPath(byte[] arg1,int arg2,int arg3);
    public A withNewPath(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewPath(String arg1);
    public String getPort();
    public A withPort(String port);
    public Boolean hasPort();
    public A withNewPort(StringBuilder arg1);
    public A withNewPort(int[] arg1,int arg2,int arg3);
    public A withNewPort(char[] arg1);
    public A withNewPort(StringBuffer arg1);
    public A withNewPort(byte[] arg1,int arg2);
    public A withNewPort(byte[] arg1);
    public A withNewPort(char[] arg1,int arg2,int arg3);
    public A withNewPort(byte[] arg1,int arg2,int arg3);
    public A withNewPort(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewPort(String arg1);
    public String getProxyUrl();
    public A withProxyUrl(String proxyUrl);
    public Boolean hasProxyUrl();
    public A withNewProxyUrl(StringBuilder arg1);
    public A withNewProxyUrl(int[] arg1,int arg2,int arg3);
    public A withNewProxyUrl(char[] arg1);
    public A withNewProxyUrl(StringBuffer arg1);
    public A withNewProxyUrl(byte[] arg1,int arg2);
    public A withNewProxyUrl(byte[] arg1);
    public A withNewProxyUrl(char[] arg1,int arg2,int arg3);
    public A withNewProxyUrl(byte[] arg1,int arg2,int arg3);
    public A withNewProxyUrl(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewProxyUrl(String arg1);
    public A addToRelabelings(int index,RelabelConfig item);
    public A setToRelabelings(int index,RelabelConfig item);
    public A addToRelabelings(RelabelConfig... items);
    public A addAllToRelabelings(Collection<RelabelConfig> items);
    public A removeFromRelabelings(RelabelConfig... items);
    public A removeAllFromRelabelings(Collection<RelabelConfig> items);
    public A removeMatchingFromRelabelings(Predicate<RelabelConfigBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildRelabelings instead.
 * @return The buildable object.
 */
@Deprecated public List<RelabelConfig> getRelabelings();
    public List<RelabelConfig> buildRelabelings();
    public RelabelConfig buildRelabeling(int index);
    public RelabelConfig buildFirstRelabeling();
    public RelabelConfig buildLastRelabeling();
    public RelabelConfig buildMatchingRelabeling(Predicate<RelabelConfigBuilder> predicate);
    public Boolean hasMatchingRelabeling(Predicate<RelabelConfigBuilder> predicate);
    public A withRelabelings(List<RelabelConfig> relabelings);
    public A withRelabelings(RelabelConfig... relabelings);
    public Boolean hasRelabelings();
    public PodMetricsEndpointFluent.RelabelingsNested<A> addNewRelabeling();
    public PodMetricsEndpointFluent.RelabelingsNested<A> addNewRelabelingLike(RelabelConfig item);
    public PodMetricsEndpointFluent.RelabelingsNested<A> setNewRelabelingLike(int index,RelabelConfig item);
    public PodMetricsEndpointFluent.RelabelingsNested<A> editRelabeling(int index);
    public PodMetricsEndpointFluent.RelabelingsNested<A> editFirstRelabeling();
    public PodMetricsEndpointFluent.RelabelingsNested<A> editLastRelabeling();
    public PodMetricsEndpointFluent.RelabelingsNested<A> editMatchingRelabeling(Predicate<RelabelConfigBuilder> predicate);
    public String getScheme();
    public A withScheme(String scheme);
    public Boolean hasScheme();
    public A withNewScheme(StringBuilder arg1);
    public A withNewScheme(int[] arg1,int arg2,int arg3);
    public A withNewScheme(char[] arg1);
    public A withNewScheme(StringBuffer arg1);
    public A withNewScheme(byte[] arg1,int arg2);
    public A withNewScheme(byte[] arg1);
    public A withNewScheme(char[] arg1,int arg2,int arg3);
    public A withNewScheme(byte[] arg1,int arg2,int arg3);
    public A withNewScheme(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewScheme(String arg1);
    public String getScrapeTimeout();
    public A withScrapeTimeout(String scrapeTimeout);
    public Boolean hasScrapeTimeout();
    public A withNewScrapeTimeout(StringBuilder arg1);
    public A withNewScrapeTimeout(int[] arg1,int arg2,int arg3);
    public A withNewScrapeTimeout(char[] arg1);
    public A withNewScrapeTimeout(StringBuffer arg1);
    public A withNewScrapeTimeout(byte[] arg1,int arg2);
    public A withNewScrapeTimeout(byte[] arg1);
    public A withNewScrapeTimeout(char[] arg1,int arg2,int arg3);
    public A withNewScrapeTimeout(byte[] arg1,int arg2,int arg3);
    public A withNewScrapeTimeout(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewScrapeTimeout(String arg1);
    
/**
 * This method has been deprecated, please use method buildTargetPort instead.
 * @return The buildable object.
 */
@Deprecated public IntOrString getTargetPort();
    public IntOrString buildTargetPort();
    public A withTargetPort(IntOrString targetPort);
    public Boolean hasTargetPort();
    public A withNewTargetPort(String strVal);
    public A withNewTargetPort(Integer intVal);
    public PodMetricsEndpointFluent.TargetPortNested<A> withNewTargetPort();
    public PodMetricsEndpointFluent.TargetPortNested<A> withNewTargetPortLike(IntOrString item);
    public PodMetricsEndpointFluent.TargetPortNested<A> editTargetPort();
    public PodMetricsEndpointFluent.TargetPortNested<A> editOrNewTargetPort();
    public PodMetricsEndpointFluent.TargetPortNested<A> editOrNewTargetPortLike(IntOrString item);
    public interface MetricRelabelingsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RelabelConfigFluent<PodMetricsEndpointFluent.MetricRelabelingsNested<N>> {

            public N and();
            public N endMetricRelabeling();    }


    public interface RelabelingsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RelabelConfigFluent<PodMetricsEndpointFluent.RelabelingsNested<N>> {

            public N and();
            public N endRelabeling();    }


    public interface TargetPortNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,IntOrStringFluent<PodMetricsEndpointFluent.TargetPortNested<N>> {

            public N and();
            public N endTargetPort();    }


}
